#include "CFormBatchSensorPose.h"

//(*InternalHeaders(CFormBatchSensorPose)
#include <wx/string.h>
#include <wx/intl.h>
#include <wx/font.h>
#include <wx/bitmap.h>
#include <wx/image.h>
#include <wx/artprov.h>
//*)

#include <wx/filedlg.h>
#include <wx/progdlg.h>
#include <wx/imaglist.h>
#include <wx/busyinfo.h>
#include <wx/app.h>
#include <wx/msgdlg.h>

#include "xRawLogViewerMain.h"
// General global variables:

#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::slam;
using namespace mrpt::opengl;
using namespace mrpt::system;
using namespace mrpt::math;
using namespace mrpt::utils;
using namespace std;




//(*IdInit(CFormBatchSensorPose)
const long CFormBatchSensorPose::ID_STATICTEXT1 = wxNewId();
const long CFormBatchSensorPose::ID_TEXTCTRL1 = wxNewId();
const long CFormBatchSensorPose::ID_BITMAPBUTTON1 = wxNewId();
const long CFormBatchSensorPose::ID_BUTTON1 = wxNewId();
const long CFormBatchSensorPose::ID_BUTTON2 = wxNewId();
//*)

BEGIN_EVENT_TABLE(CFormBatchSensorPose,wxDialog)
	//(*EventTable(CFormBatchSensorPose)
	//*)
END_EVENT_TABLE()

CFormBatchSensorPose::CFormBatchSensorPose(wxWindow* parent,wxWindowID id)
{
	//(*Initialize(CFormBatchSensorPose)
	wxFlexGridSizer* FlexGridSizer1;
	wxFlexGridSizer* FlexGridSizer2;
	wxFlexGridSizer* FlexGridSizer3;

	Create(parent, id, _("Batch change sensor poses"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE|wxRESIZE_BORDER|wxCLOSE_BOX, _T("id"));
	SetClientSize(wxSize(520,434));
	FlexGridSizer1 = new wxFlexGridSizer(0, 1, 0, 0);
	FlexGridSizer1->AddGrowableCol(0);
	FlexGridSizer1->AddGrowableRow(0);
	FlexGridSizer2 = new wxFlexGridSizer(0, 1, 0, 0);
	FlexGridSizer2->AddGrowableCol(0);
	FlexGridSizer2->AddGrowableRow(1);
	StaticText1 = new wxStaticText(this, ID_STATICTEXT1, _("Configuration of sensors:"), wxDefaultPosition, wxDefaultSize, 0, _T("ID_STATICTEXT1"));
	FlexGridSizer2->Add(StaticText1, 1, wxALL|wxALIGN_LEFT|wxALIGN_CENTER_VERTICAL, 5);
	edText = new wxTextCtrl(this, ID_TEXTCTRL1, _("//  Any file in the format used by rawlog-grabber can be used here\n//  The name of the sections [xxx] can be arbitrary and \n//   independent of the sensor label. \n// ----------------------------------------------------------------\n\n//  SENSOR 1\n[OneCamera]\nsensorLabel\t\t= CAMERA1\n\npose_x\t\t\t= 0    ; position on the robot (meters)\npose_y\t\t\t= 0\npose_z\t\t\t= 0.5\npose_yaw\t\t= 0\t   ; Angles in degrees\npose_pitch\t\t= 0\npose_roll\t\t= 0\n\n//  SENSOR 2\n[AnotherSensor]\nsensorLabel\t\t= SICK_LASER\n\npose_x\t\t\t= 0.2    ; position on the robot (meters)\npose_y\t\t\t= 0\npose_z\t\t\t= 0.3\npose_yaw\t\t= 0\t   ; Angles in degrees\npose_pitch\t\t= 0\npose_roll\t\t= 0\n\n"), wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE|wxHSCROLL|wxVSCROLL|wxALWAYS_SHOW_SB, wxDefaultValidator, _T("ID_TEXTCTRL1"));
	edText->SetMinSize(wxSize(500,300));
	wxFont edTextFont(9,wxTELETYPE,wxFONTSTYLE_NORMAL,wxNORMAL,false,_T("FreeMono"),wxFONTENCODING_DEFAULT);
	edText->SetFont(edTextFont);
	FlexGridSizer2->Add(edText, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(FlexGridSizer2, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
	FlexGridSizer3 = new wxFlexGridSizer(0, 5, 0, 0);
	FlexGridSizer3->AddGrowableCol(1);
	btnOpen = new wxBitmapButton(this, ID_BITMAPBUTTON1, wxArtProvider::GetBitmap(wxART_MAKE_ART_ID_FROM_STR(_T("wxART_FILE_OPEN")),wxART_BUTTON), wxDefaultPosition, wxDefaultSize, wxBU_AUTODRAW, wxDefaultValidator, _T("ID_BITMAPBUTTON1"));
	btnOpen->SetToolTip(_("Load from text file..."));
	FlexGridSizer3->Add(btnOpen, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer3->Add(-1,-1,1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	btnApply = new wxButton(this, ID_BUTTON1, _("Apply"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON1"));
	btnApply->SetDefault();
	FlexGridSizer3->Add(btnApply, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	btnCancel = new wxButton(this, ID_BUTTON2, _("Cancel"), wxDefaultPosition, wxDefaultSize, 0, wxDefaultValidator, _T("ID_BUTTON2"));
	FlexGridSizer3->Add(btnCancel, 1, wxALL|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 5);
	FlexGridSizer1->Add(FlexGridSizer3, 1, wxALL|wxEXPAND|wxALIGN_CENTER_HORIZONTAL|wxALIGN_CENTER_VERTICAL, 0);
	SetSizer(FlexGridSizer1);
	FlexGridSizer1->SetSizeHints(this);
	Center();

	Connect(ID_BITMAPBUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CFormBatchSensorPose::OnbtnOpenClick);
	Connect(ID_BUTTON1,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CFormBatchSensorPose::OnbtnApplyClick);
	Connect(ID_BUTTON2,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&CFormBatchSensorPose::OnbtnCancelClick);
	//*)
}

CFormBatchSensorPose::~CFormBatchSensorPose()
{
	//(*Destroy(CFormBatchSensorPose)
	//*)
}


void CFormBatchSensorPose::OnbtnOpenClick(wxCommandEvent& event)
{
    WX_START_TRY

    wxFileDialog dialog(
        this,
        _("Select file with sensor parameters") /* caption */,
        _U( iniFile->read_string(iniFileSect,"LastDir",".").c_str() ),
        _("*.ini") /* defaultFilename */ ,
        _("rawlog-grabber config files (*.ini)|*.ini|All files (*.*)|*.*") /* wildcard */,
        wxOPEN |  wxFILE_MUST_EXIST );

    if (dialog.ShowModal() != wxID_OK)
        return;

    // Save the path
    WX_START_TRY
    iniFile->write(iniFileSect,"LastDir",std::string(dialog.GetDirectory().mb_str()));
    WX_END_TRY

	edText->LoadFile( dialog.GetPath() );

    WX_END_TRY
}

void CFormBatchSensorPose::OnbtnApplyClick(wxCommandEvent& event)
{
    WX_START_TRY

	wxBusyCursor	busy;

	// Load the "ini-file" from the text control:
	CConfigFileMemory	cfg( CStringList( string( edText->GetValue().mb_str() ) ) );

	// make a list  "sensor_label -> sensor_pose" by parsing the ini-file:
	std::map<std::string,mrpt::poses::CPose3D>	desiredSensorPoses;

	vector_string	sections;
	cfg.getAllSections( sections );

	for (vector_string::iterator it=sections.begin();it!=sections.end();it++)
	{
		if (it->empty()) continue;

		// Get sensor label:
		string label = cfg.read_string(*it,"sensorLabel","");
		if (label.empty()) continue;

		CPose3D  the_pose(
			cfg.read_double(*it,"pose_x",0,true),
			cfg.read_double(*it,"pose_y",0,true),
			cfg.read_double(*it,"pose_z",0,true),
			DEG2RAD( cfg.read_double(*it,"pose_yaw",0 ) ),
			DEG2RAD( cfg.read_double(*it,"pose_pitch",0 ) ),
			DEG2RAD( cfg.read_double(*it,"pose_roll",0 ) ) );

		// insert:
		desiredSensorPoses[label] = the_pose;

	} // end for sections

	if (desiredSensorPoses.empty())
	{
		wxMessageBox(_("No valid 'sensorLabel' entry was found in the text"),_("Error"),wxOK,this);
		return;
	}

	// now apply the changes:
    wxProgressDialog    progDia(
        wxT("Modifying rawlog"),
        wxT("Processing..."),
        rawlog.size(), // range
        this, // parent
        wxPD_CAN_ABORT |
        wxPD_APP_MODAL |
        wxPD_SMOOTH |
        wxPD_AUTO_HIDE |
        wxPD_ELAPSED_TIME |
        wxPD_ESTIMATED_TIME |
        wxPD_REMAINING_TIME);

    wxTheApp->Yield();  // Let the app. process messages


	size_t changes = 0;
	int    countLoop = 0;
	bool   keepDoing = true;
	for (CRawlog::iterator it = rawlog.begin(); it!=rawlog.end() && keepDoing; it++,countLoop++)
	{
		CObservationPtr obs;

		// Go thru all the obs. of a SF, or just the obs. for non-SF rawlogs:
		size_t idx_in_sf = 0;
		bool  isSingleObs;
		while (true)
		{
			isSingleObs = false;

			if (it.getType()==CRawlog::etObservation)
			{
				obs = CObservationPtr(*it);
				isSingleObs = true;
			}
			else if (it.getType()==CRawlog::etSensoryFrame)
			{
				CSensoryFramePtr sf = CSensoryFramePtr(*it);

				if ( idx_in_sf>= sf->size()) break;
				obs = sf->getObservationByIndex(idx_in_sf++);
			}
			else break;

			if (obs)
			{
				// Check the sensor label:
				std::map<std::string,mrpt::poses::CPose3D>::iterator i = desiredSensorPoses.find(obs->sensorLabel);
				if (i!=desiredSensorPoses.end())
				{
					obs->setSensorPose( i->second );
					changes ++;
				}
				if (isSingleObs) break;
			}
			else break;
		}

        if (countLoop++ % 100 == 0)
        {
            if (!progDia.Update( countLoop, wxString::Format(wxT("Processing... (%i objects processed)"),countLoop) ))
                keepDoing = false;
            wxTheApp->Yield();  // Let the app. process messages
        }
	}

    progDia.Update( rawlog.size() );	// Close dialog.

	wxMessageBox( wxString::Format(_("%i entries modified for %i sensor labels."), (int)changes, (int)desiredSensorPoses.size()), _("Done"), wxOK, this );

    WX_END_TRY

	Close();
}

void CFormBatchSensorPose::OnbtnCancelClick(wxCommandEvent& event)
{
	Close();
}
