/// OutputList.cpp
/**
*/

#include <wx/file.h>
#include <wx/filename.h>
#include <string>
#include <algorithm>
#include <set>

#include "OutputList.h"

using namespace jcs;
using namespace std;

bool
IsInSeries(const OutputList::ListType::value_type list_item, const std::string& seriesUid)
{
  return list_item.second.seriesUid == seriesUid;
}

ImageFileName::ImageFileName()
{
  isRenameable = true;
}


void
ImageFileName::SetPrefix(const std::string& prefix)
{
  mPrefix = prefix.c_str();
}

void
ImageFileName::SetPostfix(const std::string& postfix)
{
  mPostfix = postfix.c_str();
}

std::string
ImageFileName::GetPrefix() const
{
  return mPrefix;
}

std::string
ImageFileName::GetPostfix() const
{
  return mPostfix;
}


void
ImageFileName::AppendDir(const std::string& uid, const std::string& dir)
{
  DirPair dirPair;
  dirPair.uid = uid;
  dirPair.dir = dir;
  mDirList.push_back(dirPair);
}

int
ImageFileName::GetDirCount() const
{
  return mDirList.size();
}

void
ImageFileName::ResetPath()
{
  mDirList.clear();
}

std::string
ImageFileName::GetPath() const
{
  std::string path;
  DirListType::const_iterator it = mDirList.begin();
  DirListType::const_iterator it_end = mDirList.end();
  for (;it != it_end; ++it) {
    path += it->dir;
    path += "/";
  }
  return path;
}

std::string
ImageFileName::GetFullName() const
{
  std::string filename = mPrefix + mPostfix;
  if (!mExt.empty()) { filename += "." + mExt; }
  return filename;
}

std::string
ImageFileName::GetFullPath() const
{
  return GetPath() + GetFullName();
}

std::string
ImageFileName::GetExt() const
{
  return mExt;
}

void
ImageFileName::SetExt(const std::string& ext)
{
  mExt = ext;
}

std::string
ImageFileName::GetDirName(int pos) const
{
  return mDirList.at(pos).dir;
}

std::string
ImageFileName::GetDirUid(int pos) const
{
  return mDirList.at(pos).uid;
}

void
ImageFileName::SetDirName(int pos, std::string name)
{
  mDirList.at(pos).dir = name;
}

wxFileName
OutputList::GetFullFileName(const std::string& key) const
{
  wxFileName name(rootDir + wxFileName::GetPathSeparator());

  ListType::const_iterator pos = fileNameList.find(key);

  if (pos != fileNameList.end()) {
    // Some tricky conversions here, path at pos->second is in UTF-8 form
	// as it comes from the file system...
    wxFileName fname(wxString(pos->second.GetPath().c_str(), wxConvLocal));
    //fname.SetPrefix, fname.SetExt, 
    // but filename comes from DICOM file, which is Unicode form (assuming CharacterSet is ISO_IR 100),
	// From8BitData conversion needed...
    fname.SetFullName(wxString(wxString::From8BitData(pos->second.GetFullName().c_str()).mb_str(), wxConvLocal));
    wxArrayString dirs = fname.GetDirs();
    for (unsigned int i = 0; i < dirs.size(); ++i) {
      name.AppendDir(dirs[i]);
    }
    name.SetFullName(fname.GetFullName());
  }
  else {
    name.SetName(_T("error"));
  }

  return name;
}
