/// jcsTree.cpp
/**
*/

#if defined(__WXGTK__) || defined(__WXMOTIF__)
        #include <wx/wx.h>
#endif

#include <wx/wxprec.h>
#include <wx/treectrl.h>
#include <wx/imaglist.h>
#include <wx/string.h>

#include "jcsTree.h"

#include "file.xpm"
#include "folder.xpm"
#include "open_folder.xpm"

jcsTreeCtrl::jcsTreeCtrl(wxWindow* parent, wxWindowID id,
						 long style, const char* root) 
: wxTreeCtrl(parent, id, wxDefaultPosition, wxDefaultSize,
			  style)
{
	CreateImageList();
	AddRoot(wxString(root, wxConvLocal), folder_icon, -1, new jcsTreeItemData(root, dtROOT));
	SetItemImage(GetRootItem(), open_folder_icon,
		wxTreeItemIcon_Expanded);
}

void
jcsTreeCtrl::CreateImageList(int size)
{

	wxImageList* images = new wxImageList(size, size, true);

	images->Add(wxIcon(folder_xpm));
	images->Add(wxIcon(open_folder_xpm));
	images->Add(wxIcon(file_xpm));

	AssignImageList(images);

}

void
jcsTreeCtrl::Reset()
{
	mTreeMap.clear();

	if (HasVisibleRoot()) Collapse(GetRootItem());

	DeleteChildren(GetRootItem());
}

bool
jcsTreeCtrl::HasVisibleRoot()
{
	return (GetFirstVisibleItem().IsOk() && 
		(GetFirstVisibleItem() == GetRootItem()));
}

void
jcsTreeCtrl::RemoveBranch(wxTreeItemId branch)
{
	if (branch == GetRootItem()) return;
	jcsTreeItemData* item = (jcsTreeItemData*) GetItemData(branch);

	if (item->GetItemType() == dtFILE)	return;

	wxTreeItemId parent = GetItemParent(branch);
	mRemoveFromMap(branch);
	Delete(branch);

	if (parent != GetRootItem() && 
		!ItemHasChildren(parent)) RemoveBranch(parent);

}

// delete items recursively from tree map
void
jcsTreeCtrl::mRemoveFromMap(wxTreeItemId branch)
{
	if (branch == GetRootItem()) return;
	jcsTreeItemData* item = (jcsTreeItemData*) GetItemData(branch);
	// remove item's children
	if (ItemHasChildren(branch)) {
		int n_children = GetChildrenCount(branch, false);
		wxTreeItemIdValue cookie;
		wxTreeItemId child = GetFirstChild(branch, cookie);
		mRemoveFromMap(child);
		for (int i = 1; i < n_children; ++i) {
			child = GetNextChild(branch, cookie);
			mRemoveFromMap(child);
		}
	}

	// remove item
	mTreeMap.erase(item->GetUid());
}

bool
jcsTreeCtrl::IsChild(const wxTreeItemId& item, 
					 const wxTreeItemId& parent) const
{
	if (!ItemHasChildren(parent)) return false;
	wxTreeItemIdValue cookie;
	wxTreeItemId child = GetFirstChild(parent, cookie);
	if (item == child || IsChild(item, child)) return true;
	for (unsigned int i = 1; i < GetChildrenCount(item, false); ++i) {
		child = GetNextChild(parent, cookie);
		if (item == child || IsChild(item, child)) return true;
	}

	return false;

}
	

int
jcsTreeCtrl::GetItemType(const wxTreeItemId& item) const
{
	if (item.IsOk()) {
		jcsTreeItemData* data = 
			dynamic_cast<jcsTreeItemData *> (GetItemData(item));
		
//		wxLogMessage(_T("%s, %s"), GetItemText(item), data->GetUid().c_str());
//		return -1;
		return data->GetItemType();

	}

	else return -1;
}

int
jcsTreeCtrl::GetSelectionType() const
{
	return GetItemType(GetSelection());
}

wxString
jcsTreeCtrl::GetStringSelection() const
{
	wxTreeItemId item = GetSelection();
	if (item.IsOk()) return GetItemText(item);
	else return _T("error");
}

const std::string
jcsTreeCtrl::GetItemUid(const wxTreeItemId& item) const
{
	if (item.IsOk()) {
		jcsTreeItemData* data =
			static_cast<jcsTreeItemData *> (GetItemData(item));

		return data->GetUid();
	}

	else return std::string();
}

const std::string
jcsTreeCtrl::GetPrefix(const wxTreeItemId& item) const
{
	if (item.IsOk()) {
		jcsTreeItemData* data =
			static_cast<jcsTreeItemData *> (GetItemData(item));

		return data->GetPrefix();
	}

	else return std::string();
}

std::string
jcsTreeCtrl::GetSelectionUid() const
{
	return GetItemUid(GetSelection());
}


wxTreeItemId
jcsTreeCtrl::GetTreeId(std::string uid) const
{
	if (mTreeMap.count(uid))
		return (*mTreeMap.find(uid)).second;
	else
		return GetRootItem();
}	

const std::string
jcsTreeCtrl::GetSeriesUid(const wxTreeItemId& item) const
{
	if (item.IsOk()) {
		jcsTreeItemData* data =
			static_cast<jcsTreeItemData *> (GetItemData(item));

		return data->GetSeriesUid();
	}

	else return std::string();
}
