/// ValueRepresentations.h
/**
*/

#ifndef VALUEREPRESENTATIONS_H_
#define VALUEREPRESENTATIONS_H_

#include <string>
#include <vector>
#include <istream>
#include <wx/wx.h>

namespace jcs {

  class DicomValue {
  public:
  friend std::istream &operator>>(std::istream &in, DicomValue &dv);
  };
  
  class VR_AE : public DicomValue {
  public:
  char ae[16];
  };
  class VR_AS : public DicomValue {
  public:
  char age[4];
  friend std::istream &operator>>(std::istream &in, VR_AS &as);
  
  };
  class VR_AT : public DicomValue {
  public:
//  DicomTag val;
  friend std::istream &operator>>(std::istream &in, VR_AT &at);
  
  };
  class VR_CS : public DicomValue {
  public:
  };
  class VR_DA : public DicomValue {
  public:
  char date[8];
  };
  class VR_DS : public DicomValue {
  public:
  };
  class VR_DT : public DicomValue {
  public:
  };
  class VR_FL : public DicomValue {
  public:
  };
  class VR_FD : public DicomValue {
  public:
  };
  class VR_IS : public DicomValue {
  public:
  };
  class VR_LO : public DicomValue {
  public:
  };
  class VR_LT : public DicomValue {
  public:
  };
  class VR_OB : public DicomValue {
  public:
  };
  class VR_OF : public DicomValue {
  public:
  };
  class VR_OW : public DicomValue {
  public:
  };
  class VR_PN : public DicomValue {
  public:
  };
  class VR_SH : public DicomValue {
  public:
  };
  class VR_SQ : public DicomValue {
  public:
  };
  class VR_ST : public DicomValue {
  public:
  };
  class VR_TM : public DicomValue {
  public:
  };
  class VR_UI : public DicomValue {
  public:
  };
  class VR_UN : public DicomValue {
  public:
  };
  class VR_UT : public DicomValue {
  public:
  };
  class NumericValue : public DicomValue {
  };
  class VR_SL : public NumericValue {
  public:
  wxInt32 value;
  };
  class VR_SS : public NumericValue {
  public:
  wxInt16 value;
  };
  
  class VR_UL : public NumericValue {
  public:
  wxUint32 value;
  };
  class VR_US : public NumericValue {
  public:
  wxUint16 value;
  };

  std::istream &
  operator>> (std::istream &in, DicomValue &dv);
  
  std::istream &
  operator>> (std::istream &in, VR_AE &at);
  
  std::istream &
  operator>> (std::istream &in, VR_AS &as);
  
  std::istream &
  operator>> (std::istream &in, VR_AT &at);
  
  std::istream &
  operator>> (std::istream &in, VR_CS &at);
  
  std::istream &
  operator>> (std::istream &in, VR_DA &at);
  
  std::istream &
  operator>> (std::istream &in, VR_DS &at);
  
  std::istream &
  operator>> (std::istream &in, VR_DT &at);
  
  std::istream &
  operator>> (std::istream &in, VR_FL &at);
  
  std::istream &
  operator>> (std::istream &in, VR_FD &at);
  
  std::istream &
  operator>> (std::istream &in, VR_IS &at);
  
  std::istream &
  operator>> (std::istream &in, VR_LO &at);
  
  std::istream &
  operator>> (std::istream &in, VR_LT &at);
  
  std::istream &
  operator>> (std::istream &in, VR_OB &at);
  
  std::istream &
  operator>> (std::istream &in, VR_OF &at);
  
  std::istream &
  operator>> (std::istream &in, VR_OW &at);
  
  std::istream &
  operator>> (std::istream &in, VR_PN &at);
  
  std::istream &
  operator>> (std::istream &in, VR_SH &at);
  
  std::istream &
  operator>> (std::istream &in, VR_SQ &at);
  
  std::istream &
  operator>> (std::istream &in, VR_SL &sl);
  
  std::istream &
  operator>> (std::istream &in, VR_SS &ss);
  
  std::istream &
  operator>> (std::istream &in, VR_ST &at);
  
  std::istream &
  operator>> (std::istream &in, VR_TM &at);
  
  std::istream &
  operator>> (std::istream &in, VR_UI &at);
  
  std::istream &
  operator>> (std::istream &in, VR_UL &at);
  
  std::istream &
  operator>> (std::istream &in, VR_UN &at);
  
  std::istream &
  operator>> (std::istream &in, VR_US &us);
  
  std::istream &
  operator>> (std::istream &in, VR_UT &at);
  
  std::istream &
  operator>> (std::istream &in, NumericValue &nv);
}

#endif
