/// OutputList.cpp
/**
*/

#include <wx/file.h>
#include <wx/filename.h>
#include <string>
#include <algorithm>
#include <set>

#include "OutputList.h"

using namespace jcs;
using namespace std;

bool
IsInSeries(const OutputList::ListType::value_type list_item, const std::string& seriesUid)
{
  return list_item.second.seriesUid == seriesUid;
}

ImageFileName::ImageFileName()
{
  isRenameable = true;
}


void
ImageFileName::SetPrefix(const std::string& prefix)
{
  mPrefix = prefix.c_str();
}

void
ImageFileName::SetPostfix(const std::string& postfix)
{
  mPostfix = postfix.c_str();
}

string
ImageFileName::GetPrefix() const
{
  return mPrefix;
}

string
ImageFileName::GetPostfix() const
{
  return mPostfix;
}


void
ImageFileName::AppendDir(const string& uid, const string& dir)
{
  DirPair dirPair;
  dirPair.uid = uid;
  dirPair.dir = dir;
  mDirList.push_back(dirPair);
}

int
ImageFileName::GetDirCount() const
{
  return mDirList.size();
}

void
ImageFileName::ResetPath()
{
  mDirList.clear();
}

string
ImageFileName::GetPath() const
{
  string path;
  DirListType::const_iterator it = mDirList.begin();
  DirListType::const_iterator it_end = mDirList.end();
  while (it != it_end) {
    path += it->dir;
    path += "/";
    ++it;
  }
  return path;
}

string
ImageFileName::GetFullName() const
{
  string filename = mPrefix + mPostfix;
  if (!mExt.empty()) filename += "." + mExt;
  return filename;
}

string
ImageFileName::GetFullPath() const
{
  return GetPath() + GetFullName();
}

string
ImageFileName::GetExt() const
{
  return mExt;
}

void
ImageFileName::SetExt(const string& ext)
{
  mExt = ext;
}

string
ImageFileName::GetDirName(int pos) const
{
  return mDirList.at(pos).dir;
}

string
ImageFileName::GetDirUid(int pos) const
{
  return mDirList.at(pos).uid;
}

void
ImageFileName::SetDirName(int pos, string name)
{
  mDirList.at(pos).dir = name;
}

wxFileName
OutputList::GetFullFileName(const string& key) const
{
  wxFileName name(rootDir + wxFileName::GetPathSeparator());

  ListType::const_iterator pos = fileNameList.find(key);

  if (pos != fileNameList.end()) {

    wxFileName fname(wxString(pos->second.GetFullPath().c_str(), wxConvLocal));
    wxArrayString dirs = fname.GetDirs();
    for (unsigned int i = 0; i < dirs.size(); ++i) {
      name.AppendDir(dirs[i]);
    }
    name.SetFullName(fname.GetFullName());
  }
  else {
    name.SetName(_T("error"));
  }

  return name;
}
