/// DicomTree.cpp
/**
*/

#pragma warning( disable : 4786 )

#if defined(__WXGTK__) || defined(__WXMOTIF__)
        #include <wx/wx.h>
#endif

#include <wx/wxprec.h>
#include <wx/treectrl.h>

#include "SeriesHandler.h"
#include "StringConvert.h"
#include "DicomTree.h"

using namespace jcs;
using std::vector;
using std::string;

DicomTreeCtrl::DicomTreeCtrl(wxWindow* parent, wxWindowID id, long more_styles)
: jcsTreeCtrl(parent, id, wxTR_HIDE_ROOT | wxTR_HAS_BUTTONS | 
			 wxTR_LINES_AT_ROOT  | wxSUNKEN_BORDER | more_styles, "Dicom series")
{
}

DicomTreeCtrl::DicomTreeCtrl(wxWindow* parent, wxWindowID id) 
: jcsTreeCtrl(parent, id, wxTR_HIDE_ROOT | wxTR_HAS_BUTTONS | 
			 wxTR_LINES_AT_ROOT  | wxSUNKEN_BORDER, "Dicom series")
{
}

void
DicomTreeCtrl::AddSeries(SeriesHandler* series)
{
	std::string subject;
	if(!series->Find("PatientName", subject))
		subject = "no name";

	wxTreeItemId subjectTreeId;
	if (!mTreeMap.count(subject)) {
	
		std::string itemText("Subject name: ");
		itemText.append(subject);
		subjectTreeId = AppendItem(
			GetRootItem(), 
//			wxString(itemText.c_str(), wxConvLocal), 
			wxString(itemText.c_str(), wxConvLocal),
			folder_icon, -1, 
			new jcsTreeItemData(subject, dtSUBJECT)
		);

//		subjectTreeId = AppendItem(
//			GetRootItem(), 
//			wxString::Format(_T("Subject name: %s"), subject.c_str()), 
//			folder_icon, -1, 
//			new jcsTreeItemData(subject, dtSUBJECT)
//		);
		SetItemImage(
			subjectTreeId, 
			open_folder_icon,
			wxTreeItemIcon_Expanded
		);

		mTreeMap[subject] = subjectTreeId;
	}
	else
		subjectTreeId = mTreeMap[subject];


	std::string study_uid;
	if (!series->Find("StudyInstanceUid", study_uid))
		study_uid = "no study id";

	wxTreeItemId studyTreeId;

	if (!mTreeMap.count(study_uid)) {

		std::string number;
		series->Find("StudyId", number);
		std::string desc;
		series->Find("StudyDescription", desc);
		std::string date;
		series->Find("StudyDate", date);

		std::string itemText("Study ");
		itemText.append(number);
		itemText.append("     ");
		itemText.append(date);
		itemText.append("     ");
		itemText.append(desc);

		studyTreeId = AppendItem(
			subjectTreeId, 
			wxString(itemText.c_str(), wxConvLocal),
//			wxString::Format(
//				_T("Study %s     %s     %s"), 
//				number.c_str(), 
//				date.c_str(),
//				desc.c_str()
//			), 
			folder_icon, -1, 
			new jcsTreeItemData(study_uid, dtSTUDY)
		);
		SetItemImage(
			studyTreeId, 
			open_folder_icon,
			wxTreeItemIcon_Expanded
		);

		mTreeMap[study_uid] = studyTreeId;
	}
	else
		studyTreeId = mTreeMap[study_uid];

	std::string series_uid = series->GetSeriesUid();
//	if(!series->Find("SeriesInstanceUid", series_uid))
//		series_uid = "none";


	wxTreeItemId seriesTreeId;

	if (!mTreeMap.count(series_uid)) {

		std::string number;
		if(!series->Find("SeriesNumber", number))
			number = "0";
		number = itos(stoi(number));
		std::string protocol;
		series->Find("ProtocolName", protocol);
		std::string desc;
		series->Find("SeriesDescription", desc);
		std::string date;
		series->Find("SeriesDate", date);

		std::string itemText("Series ");
		itemText.append(number);
		itemText.append("     ");
		itemText.append(date);
		itemText.append("     ");
		itemText.append(protocol);
		if (protocol != desc) {
			itemText.append(" ");
			itemText.append(desc);
		}


		seriesTreeId = AppendItem(
			studyTreeId, 
			wxString(itemText.c_str(), wxConvLocal),
//			wxString::Format(
//				_T("Series %s     %s     %s"),
//				number.c_str(),
//				date.c_str(),
//				desc.c_str()
//			),
			folder_icon, -1, 
			new jcsTreeItemData(series_uid, dtSERIES)
		);
		SetItemImage(
			seriesTreeId, 
			open_folder_icon,
			wxTreeItemIcon_Expanded
		);

		mTreeMap[series_uid] = seriesTreeId;
	}
	else
		seriesTreeId = mTreeMap[series_uid];

	CollapseAndReset(seriesTreeId);
	
	vector<string> names = series->GetFilenames();
	vector<string>::iterator it = names.begin();
	while(it != names.end()) {
		AppendItem(
			seriesTreeId,
			wxString(it->c_str(), wxConvLocal),
			file_icon, -1,
			new jcsTreeItemData(*it, dtFILE)
		);
		++it;
	}

}

std::vector<std::string>
DicomTreeCtrl::GetChildSeries(wxTreeItemId branch)
{
	std::vector<std::string> v;

	jcsTreeItemData* item = (jcsTreeItemData*) GetItemData(branch);

	switch (item->GetItemType()) {

	case dtSERIES :

		v.push_back(item->GetUid());
		break;

	case dtSTUDY : 
	case dtSUBJECT : 
		
		if (ItemHasChildren(branch)) {
			int n_children = GetChildrenCount(branch, false);
			wxTreeItemIdValue cookie;
			wxTreeItemId child = GetFirstChild(branch, cookie);
			std::vector<std::string> v2 = GetChildSeries(child);
			v.insert(v.end(), v2.begin(), v2.end());

			for (int i = 1; i < n_children; ++i) {
				child = GetNextChild(branch, cookie);
				v2 = GetChildSeries(child);
				v.insert(v.end(), v2.begin(), v2.end());
			}
		}
		break;

	default : 
		break;
	}

	return v;
}

vector<string>
DicomTreeCtrl::GetFilenames()
{
	vector<string> filenames;

	jcsTreeMap::iterator it = mTreeMap.begin();
	jcsTreeMap::iterator end = mTreeMap.end();

	while (it != end) {
		wxTreeItemId item = (*it).second;
		if (GetItemType(item) == dtFILE) {
			filenames.push_back(static_cast<const char*>(GetItemText(item).mb_str(wxConvLocal)));
		}
		++it;
	}

	return filenames;
}

vector<wxString> 
DicomTreeCtrl::GetFilesInSeries()
{
	vector<wxString> files;
	wxTreeItemId item = GetSelection();
	if (GetItemType(item) == dtFILE) {
		wxTreeItemId parent = GetItemParent(item);
		wxTreeItemIdValue cookie;
		item = GetFirstChild(parent, cookie);
		while (item.IsOk()) {
			files.push_back(GetItemText(item));
			item = GetNextChild(parent, cookie);
		}
	}
	return files;

	
}

