/// DicomElementInstance.h
/**
*/

#ifndef DICOMELEMENTINSTANCE_H_
#define DICOMELEMENTINSTANCE_H_

#include <map>
#include <vector>
#include <string>
#include <istream>
#include <iostream>

#include <wx/defs.h>

#include "DicomTag.h"
#include "ValueRepresentations.h"
#include "Dictionary.h"

namespace jcs {
  ///
  /** Provides the relationship between a DICOM tag and text 
      description of the tag.
  */
  struct DicomElementInstance {
    
    DicomElementInstance() {}
    DicomElementInstance(wxUint8 code) : transferSyntaxCode(code) {}
    DicomElementInstance(const DicomTag& tag,
    const char* desc = "", 
    const char* vr = "UN") :
    tag(tag), description(desc), vr(vr) {}
    wxUint8 transferSyntaxCode;
    /// The DICOM group and element numbers.
    DicomTag tag;
    /// The DICOM field name.
    std::string description;
    /// The DICOM field data type identifier.
    std::string vr;
    std::string value;
    char value_buff[1024];
    char vr_buff[2];
    wxUint32 value_length;
    DicomValue *myValue;
    bool explicitVR();
    friend std::istream &operator>>(std::istream &in, DicomElementInstance &de);
  };

  std::istream &operator>>(std::istream &in, DicomElementInstance &de);
  
}

#endif
