/// DicomElementInstance.cpp
/**
*/

#include "DicomElementInstance.h"

using namespace jcs;

std::istream &
jcs::operator>> (std::istream &in, DicomElementInstance &de)
{
  in >> de.tag;
  if (de.explicitVR()) {
    in.read(de.vr_buff, 2);
    de.vr.assign(de.vr_buff);
    if ( de.vr == "OB" ||
        de.vr == "OW" ||
        de.vr == "OF" ||
        de.vr == "UT" ||
        de.vr == "SQ" ||
        de.vr == "UN" ) {
      in.ignore(2);
      in.read((char *)&(de.value_length), sizeof(de.value_length));
    }
    else {
      //explicit VR
      wxUint16 vl;
      in.read((char *)&(vl), sizeof(vl));
      de.value_length = vl;
    }
  }
  else { // implicit VR
    de.vr = "SM";   //something;
    in.read((char *)&(de.value_length), sizeof(de.value_length));
  }
  wxInt64 n_to_read = de.value_length;
  while (n_to_read > 0) {
    in.read(de.value_buff, std::min((long unsigned)sizeof(de.value_buff), (long unsigned)n_to_read));
    n_to_read -= in.gcount();
    de.value.append(de.value_buff, in.gcount());
  }
  //de.myValue = new VR_AT();
  //in >> *(de.myValue);
  //in.read(value_buff, std::min(sizeof(value_buff), de.value_length));
  //de.myValue = new VR_US();
  //in >> *(de.myValue);


  return in;
}    

bool
DicomElementInstance::explicitVR() {
  bool retval = false;
  if (transferSyntaxCode == LEE_CODE || 
      transferSyntaxCode == BEE_CODE) {
    retval = true;
  }
  return retval;
}
