// Generated by asm2c https://github.com/frranck/asm2c
#ifndef MRBOOM_H__
#include <stdint.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>
#include <setjmp.h>
#include <stddef.h>
#include <stdio.h>
#include <assert.h>
#include <stdbool.h>

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) || defined(__INTEL_COMPILER)
#define INLINE __inline
#elif defined(__STDC_VERSION__) && __STDC_VERSION__>=199901L
#define INLINE inline
#elif defined(__GNUC__)
#define INLINE __inline__
#else
#define INLINE
#endif

#define realAddress(offset,segment) ((db *)&m+(dd)offset+m.selectors[m.segment.dw.val])

#define db uint8_t
#define dw uint16_t
#define dd uint32_t

#ifdef MSB_FIRST
typedef struct dblReg {
	db v0;
	db v1;
	db v2;
	db val;
} dblReg;
typedef struct dbhReg {
	db v0;
	db v1;
	db val;
	db v2;
} dbhReg;
typedef struct dwReg {
	dw v0;
	dw val;
} dwReg;
typedef struct dblReg16 {
	db v0;
	db val;
} dblReg16;
typedef struct dbhReg16 {
	db val;
	db v0;
} dbhReg16;
#else
typedef struct dblReg {
	db val;
	db v0;
	db v1;
	db v2;
} dblReg;
typedef struct dbhReg {
	db v0;
	db val;
	db v1;
	db v2;
} dbhReg;
typedef struct dwReg {
	dw val;
	dw v0;
} dwReg;
typedef struct dblReg16 {
	db val;
	db v0;
} dblReg16;
typedef struct dbhReg16 {
	db v0;
	db val;
} dbhReg16;
#endif

typedef struct ddReg {
	dd val;
} ddReg;


typedef union registry32Bits
{
	struct dblReg dbl;
	struct dbhReg dbh;
	struct dwReg dw;
	struct ddReg dd;
} registry32Bits;


typedef struct dwReg16 {
	dw val;
} dwReg16;



typedef union registry16Bits
{
	struct dblReg16 dbl;
	struct dbhReg16 dbh;
	struct dwReg16 dw;
} registry16Bits;


#define VGARAM_SIZE 320*200
#define STACK_SIZE 1024*sizeof(dd)
#define HEAP_SIZE 1024*1024*4
#define NB_SELECTORS 128

#define PUSHAD memcpy (&m.stack[m.stackPointer], &m.eax.dd.val, sizeof (dd)*8); m.stackPointer+=sizeof(dd)*8; assert(m.stackPointer<STACK_SIZE)

#define POPAD m.stackPointer-=sizeof(dd)*8; memcpy (&m.eax.dd.val, &m.stack[m.stackPointer], sizeof (dd)*8)

#define PUSH(nbBits,a) memcpy (&m.stack[m.stackPointer], &a, sizeof (a)); m.stackPointer+=sizeof(a); assert(m.stackPointer<STACK_SIZE)

#define POP(nbBits,a) m.stackPointer-=sizeof(a); memcpy (&a, &m.stack[m.stackPointer], sizeof (a))

#define AFFECT_ZF(a) m.ZF=(a==0)
#define AFFECT_CF(a) m.CF=a
#define AFFECT_SF(nbBits, a) m.SF=(a>>(nbBits-1))
#define ISNEGATIVE(nbBits,a) (a & (1 << (nbBits-1)))

// TODO: add missings affected flags on CMP
#define CMP(nbBits,a,nbBitsSrc,b) AFFECT_ZF(a-b); AFFECT_CF(a<b); AFFECT_SF(nbBits,(a-b));
#define OR(nbBits,a,nbBitsSrc,b) a=a|b; AFFECT_ZF(a); AFFECT_SF(nbBits, a)
#define XOR(nbBits,a,nbBitsSrc,b) a=a^b; AFFECT_ZF(a); AFFECT_SF(nbBits, a)
#define AND(nbBits,a,nbBitsSrc,b) a=a&b; AFFECT_ZF(a); AFFECT_SF(nbBits, a)
#define NEG(nbBits,a) AFFECT_CF(a!=0); a=-a;
#define TEST(nbBits,a,nbBitsSrc,b) AFFECT_ZF((a&b)); AFFECT_CF(b<a); AFFECT_SF(nbBits, (a&b))

#define SHR(nbBits,a,nbBitsSrc,b) a=a>>b
#define SHL(nbBits,a,nbBitsSrc,b) a=a<<b
#define ROR(nbBits,a,nbBitsSrc,b) a=(a>>b | a<<(nbBits-b))
#define ROL(nbBits,a,nbBitsSrc,b) a=(a<<b | a>>(nbBits-b))

#define READDDp(a) ((dd *) &m.a)
#define READDWp(a) ((dw *) &m.a)
#define READDBp(a) ((db *) &m.a)

#define READDD(a) (m.a.dd.val)

#ifdef MSB_FIRST
#define READDBhW(a) (*(((db *) &m.a)+0))
#define READDBhD(a) (*(((db *) &m.a)+2))
#define READDBlW(a) (*(((db *) &m.a)+1))
#define READDBlD(a) (*(((db *) &m.a)+3))
#else
#define READDBhW(a) (*(((db *) &m.a)+1))
#define READDBhD(a) (*(((db *) &m.a)+1))
#define READDBlW(a) (*(((db *) &m.a)))
#define READDBlD(a) (*(((db *) &m.a)))
#endif

#define READDW(a) (*((dw *) &m.a.dw.val))
#define READDBh(a) (*((db *) &m.a.dbh.val))
#define READDBl(a) (*((db *) &m.a.dbl.val))

#define ADD(nbBits,a,nbBitsSrc,b) a=a+b; AFFECT_ZF(a); AFFECT_CF(a<b); AFFECT_SF(nbBits,a);
#define SUB(nbBits,a,nbBitsSrc,b) a=a-b; AFFECT_ZF(a); AFFECT_CF(b<a); AFFECT_SF(nbBits,a);

// TODO: should affects OF, SF, ZF, AF, and PF
#define INC(nbBits,a) a=a+1; AFFECT_ZF(a)
#define DEC(nbBits,a) a=a-1; AFFECT_ZF(a)

#define JE(label) if (m.ZF) GOTOLABEL(label)
#define JZ(label) JE(label)

#define JNE(label) if (!m.ZF) GOTOLABEL(label)
#define JNZ(label) JNE(label)

#define JNB(label) if (!m.CF) GOTOLABEL(label)
#define JAE(label) JNB(label)
#define JNC(label) JNB(label)

#define JB(label) if (m.CF) GOTOLABEL(label)
#define JC(label) JB(label)
#define JNAE(label) JB(label)

#define JA(label) if (!m.CF && !m.ZF) GOTOLABEL(label)
#define JNBE(label) JA(label)

#define JS(label) if (m.SF) GOTOLABEL(label)
#define JNS(label) if (!m.SF) GOTOLABEL(label)

#define JNA(label) if (m.CF || m.ZF) GOTOLABEL(label)
#define JBE(label) JNA(label)

#define MOV(nbBits,dest,nbBitsSrc,src) dest = src
#define MOVZX(nbBits,dest,nbBitsSrc,src) dest = src
#define MOVSX(nbBits,dest,nbBitsSrc,src) if (ISNEGATIVE(nbBitsSrc,src)) { dest = ((-1 ^ (( 1 <<nbBitsSrc )-1)) | src ); } else { dest = src; }

// LEA - Load Effective Address
#define LEA(nbBits,dest,nbBitsSrc,src) dest = src

// MOVSx (DF FLAG not implemented)
#define MOVS(a,ecx) src=realAddress(m.esi.dd.val,ds); dest=realAddress(m.edi.dd.val,es); \
	if (labs(((char *)dest)-((char *)src))<=a) { \
		for(i=0; i<ecx; i++) {  \
			src=realAddress(m.esi.dd.val,ds); dest=realAddress(m.edi.dd.val,es); \
			memmove(dest,src,a); m.edi.dd.val+=a; m.esi.dd.val+=a; } \
	} else { \
		memmove(dest,src,a*ecx); m.edi.dd.val+=a*ecx; m.esi.dd.val+=a*ecx; \
	}

#define MOVSB MOVS(1,1)
#define MOVSW MOVS(2,1)
#define MOVSD MOVS(4,1)

#define REP_MOVS(b) MOVS(b,m.ecx.dd.val)
#define REP_MOVSB REP_MOVS(1)
#define REP_MOVSW REP_MOVS(2)
#define REP_MOVSD REP_MOVS(4)

#define STOS(a,b) memcpy (realAddress(m.edi.dd.val,es), ((db *)&m.eax.dd.val)+b, a); m.edi.dd.val+=a

#ifdef MSB_FIRST
#define STOSB STOS(1,3)
#define STOSW STOS(2,2)
#else
#define STOSB STOS(1,0)
#define STOSW STOS(2,0)
#endif

#define STOSD STOS(4,0)

#define REP_STOSB for (i=0; i<m.ecx.dd.val; i++) { STOSB; }
#define REP_STOSW for (i=0; i<m.ecx.dd.val; i++) { STOSW; }
#define REP_STOSD for (i=0; i<m.ecx.dd.val; i++) { STOSD; }

#define LODS(a,b) memcpy (((db *)&m.eax.dd.val)+b, realAddress(m.esi.dd.val,ds), a); m.esi.dd.val+=a

#ifdef MSB_FIRST
#define LODSB LODS(1,3)
#define LODSW LODS(2,2)
#else
#define LODSB LODS(1,0)
#define LODSW LODS(2,0)
#endif

#define LODSD LODS(4,0)

#define REP_LODS(a,b) for (i=0; i<m.ecx.dd.val; i++) { LODS(a,b); }

#ifdef MSB_FIRST
#define REP_LODSB REP_LODS(1,3)
#define REP_LODSW REP_LODS(2,2)
#else
#define REP_LODSB REP_LODS(1,0)
#define REP_LODSW REP_LODS(2,0)
#endif

#define REP_LODSD REP_LODS(4,0)

// JMP - Unconditional Jump
#define JMP(label) GOTOLABEL(label)
#define GOTOLABEL(a) goto a

#define LOOP(label) DEC(32,m.ecx.dd.val); JNZ(label)

#define CLD m.DF=0
#define STD m.DF=1

void stackDump();
void hexDump (void *addr, int len);
void asm2C_INT(int a);
void asm2C_init();
void asm2C_printOffsets(unsigned int offset);

// directjeu nosetjmp,2
// directmenu
#define INT(a) asm2C_INT(a); TESTJUMPTOBACKGROUND

#define TESTJUMPTOBACKGROUND  if (m.jumpToBackGround) CALL(moveToBackGround);

void asm2C_OUT(int16_t address, int data);
#define OUT(a,b) asm2C_OUT(a,b)
int8_t asm2C_IN(int16_t data);
#define IN(a,b) a = asm2C_IN(b); TESTJUMPTOBACKGROUND

#define STI // TODO: STI not implemented
#define PUSHF
#define POPF
#define NOP

#define CALL(label) \
	if (setjmp(jmpbuffer) == 0) { \
		PUSH(?,jmpbuffer); \
		JMP(label); \
	}

#define RET POP(x,jmpbuffer); longjmp(jmpbuffer, 0);

#ifdef __LIBSDL2__
#include <SDL2/SDL.h>
#include <SDL2/SDL_mixer.h>
#endif

#ifdef __LIBRETRO__
#include "libretro.h"
extern retro_log_printf_t log_cb;
#else
extern FILE * logDebug;
#endif

void log_error(const char *fmt, ...);
void log_debug(const char *fmt, ...);
void log_info(const char *fmt, ...);
void log_debug2(const char *fmt, ...);

#if DEBUG==2
    #define R(a) log_debug("l:%d:%s\n",__LINE__,#a); a
#else
    #define R(a) a
#endif

bool is_little_endian();

#if defined(_MSC_VER)
#define SWAP16 _byteswap_ushort
#define SWAP32 _byteswap_ulong
#else
#define SWAP16(x) ((uint16_t)(                  \
			   (((uint16_t)(x) & 0x00ff) << 8)      | \
			   (((uint16_t)(x) & 0xff00) >> 8)        \
			   ))
#define SWAP32(x) ((uint32_t)(           \
			   (((uint32_t)(x) & 0x000000ff) << 24) | \
			   (((uint32_t)(x) & 0x0000ff00) <<  8) | \
			   (((uint32_t)(x) & 0x00ff0000) >>  8) | \
			   (((uint32_t)(x) & 0xff000000) >> 24)   \
			   ))
#endif

#ifdef __cplusplus
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
#define MRBOOM_H__
#pragma pack(push, 1)
typedef struct Mem {
registry32Bits eax;
registry32Bits ebx;
registry32Bits ecx;
registry32Bits edx;
registry32Bits esi;
registry32Bits edi;
registry32Bits ebp;
registry32Bits esp;
registry16Bits cs;
registry16Bits ds;
registry16Bits es;
registry16Bits fs;
registry16Bits gs;
registry16Bits ss;
bool CF;
bool ZF;
bool DF;
bool SF;
bool isLittle;
bool jumpToBackGround;
bool executionFinished;
db exitCode;
db dummy1[23];
db beginningdata;
db donoterasekeys;
dd liste_de_machin[11];
dd infojoueur2[5];
dd tecte2;
dd scrollyf;
db scrolly[1968];
dd special_clignotement;
db trucs[16];
dd last_voice;
dw blow_what2[14];
dw blow_what[14];
db buffer[65535];
db message2[6];
db dummy2[6];
db dummy3[6];
db dummy4[14];
db dummy5[6];
db dummy6[6];
db dummy7[6];
db dummy8[14];
db dummy9[6];
db dummy10[6];
db dummy11[6];
db dummy12[14];
db dummy13[6];
db dummy14[6];
db dummy15[6];
db dummy16[14];
dd total_liste;
dd bigendianin;
dd bigendianout;
db dataloaded;
db clavier[128];
dd taille_exe_gonfle;
db playsoundfx;
db master;
db clavier_stuff;
db clavier_stuff2;
db clavier_extanded[128];
db pal_pic[16];
db dummy17[16];
db dummy18[16];
db dummy19[16];
db dummy20[16];
db dummy21[16];
db dummy22[16];
db dummy23[16];
db dummy24[16];
db dummy25[16];
db dummy26[16];
db dummy27[16];
db dummy28[16];
db dummy29[16];
db dummy30[16];
db dummy31[16];
db dummy32[16];
db dummy33[16];
db dummy34[16];
db dummy35[16];
db dummy36[16];
db dummy37[16];
db dummy38[16];
db dummy39[16];
db dummy40[16];
db dummy41[16];
db dummy42[16];
db dummy43[16];
db dummy44[16];
db dummy45[16];
db dummy46[16];
db dummy47[16];
db dummy48[16];
db dummy49[16];
db dummy50[16];
db dummy51[16];
db dummy52[16];
db dummy53[16];
db dummy54[16];
db dummy55[16];
db dummy56[16];
db dummy57[16];
db dummy58[16];
db dummy59[16];
db dummy60[16];
db dummy61[16];
db dummy62[16];
db dummy63[16];
db pal_pic2[16];
db dummy64[16];
db dummy65[16];
db dummy66[16];
db dummy67[16];
db dummy68[16];
db dummy69[16];
db dummy70[16];
db dummy71[16];
db dummy72[16];
db dummy73[16];
db dummy74[16];
db dummy75[16];
db dummy76[16];
db dummy77[16];
db dummy78[16];
db dummy79[16];
db dummy80[16];
db dummy81[16];
db dummy82[16];
db dummy83[16];
db dummy84[16];
db dummy85[16];
db dummy86[16];
db dummy87[16];
db dummy88[16];
db dummy89[16];
db dummy90[16];
db dummy91[16];
db dummy92[16];
db dummy93[16];
db dummy94[16];
db dummy95[16];
db dummy96[16];
db dummy97[16];
db dummy98[16];
db dummy99[16];
db dummy100[16];
db dummy101[16];
db dummy102[16];
db dummy103[16];
db dummy104[16];
db dummy105[16];
db dummy106[16];
db dummy107[16];
db dummy108[16];
db dummy109[16];
db dummy110[16];
db pal_jeu[16];
db dummy111[16];
db dummy112[16];
db dummy113[16];
db dummy114[16];
db dummy115[16];
db dummy116[16];
db dummy117[16];
db dummy118[16];
db dummy119[16];
db dummy120[16];
db dummy121[16];
db dummy122[16];
db dummy123[16];
db dummy124[16];
db dummy125[16];
db dummy126[16];
db dummy127[16];
db dummy128[16];
db dummy129[16];
db dummy130[16];
db dummy131[16];
db dummy132[16];
db dummy133[16];
db dummy134[16];
db dummy135[16];
db dummy136[16];
db dummy137[16];
db dummy138[16];
db dummy139[16];
db dummy140[16];
db dummy141[16];
db dummy142[16];
db dummy143[16];
db dummy144[16];
db dummy145[16];
db dummy146[16];
db dummy147[16];
db dummy148[16];
db dummy149[16];
db dummy150[16];
db dummy151[16];
db dummy152[16];
db dummy153[16];
db dummy154[16];
db dummy155[16];
db dummy156[16];
db dummy157[16];
db pal_med[16];
db dummy158[16];
db dummy159[16];
db dummy160[16];
db dummy161[16];
db dummy162[16];
db dummy163[16];
db dummy164[16];
db dummy165[16];
db dummy166[16];
db dummy167[16];
db dummy168[16];
db dummy169[16];
db dummy170[16];
db dummy171[16];
db dummy172[16];
db dummy173[16];
db dummy174[16];
db dummy175[16];
db dummy176[16];
db dummy177[16];
db dummy178[16];
db dummy179[16];
db dummy180[16];
db dummy181[16];
db dummy182[16];
db dummy183[16];
db dummy184[16];
db dummy185[16];
db dummy186[16];
db dummy187[16];
db dummy188[16];
db dummy189[16];
db dummy190[16];
db dummy191[16];
db dummy192[16];
db dummy193[16];
db dummy194[16];
db dummy195[16];
db dummy196[16];
db dummy197[16];
db dummy198[16];
db dummy199[16];
db dummy200[16];
db dummy201[16];
db dummy202[16];
db dummy203[16];
db dummy204[16];
db pal_vic[16];
db dummy205[16];
db dummy206[16];
db dummy207[16];
db dummy208[16];
db dummy209[16];
db dummy210[16];
db dummy211[16];
db dummy212[16];
db dummy213[16];
db dummy214[16];
db dummy215[16];
db dummy216[16];
db dummy217[16];
db dummy218[16];
db dummy219[16];
db dummy220[16];
db dummy221[16];
db dummy222[16];
db dummy223[16];
db dummy224[16];
db dummy225[16];
db dummy226[16];
db dummy227[16];
db dummy228[16];
db dummy229[16];
db dummy230[16];
db dummy231[16];
db dummy232[16];
db dummy233[16];
db dummy234[16];
db dummy235[16];
db dummy236[16];
db dummy237[16];
db dummy238[16];
db dummy239[16];
db dummy240[16];
db dummy241[16];
db dummy242[16];
db dummy243[16];
db dummy244[16];
db dummy245[16];
db dummy246[16];
db dummy247[16];
db dummy248[16];
db dummy249[16];
db dummy250[16];
db dummy251[16];
db pal_draw[16];
db dummy252[16];
db dummy253[16];
db dummy254[16];
db dummy255[16];
db dummy256[16];
db dummy257[16];
db dummy258[16];
db dummy259[16];
db dummy260[16];
db dummy261[16];
db dummy262[16];
db dummy263[16];
db dummy264[16];
db dummy265[16];
db dummy266[16];
db dummy267[16];
db dummy268[16];
db dummy269[16];
db dummy270[16];
db dummy271[16];
db dummy272[16];
db dummy273[16];
db dummy274[16];
db dummy275[16];
db dummy276[16];
db dummy277[16];
db dummy278[16];
db dummy279[16];
db dummy280[16];
db dummy281[16];
db dummy282[16];
db dummy283[16];
db dummy284[16];
db dummy285[16];
db dummy286[16];
db dummy287[16];
db dummy288[16];
db dummy289[16];
db dummy290[16];
db dummy291[16];
db dummy292[16];
db dummy293[16];
db dummy294[16];
db dummy295[16];
db dummy296[16];
db dummy297[16];
db dummy298[16];
db isbigendian;
dd touches_[8];
dd dummy299[8];
dd dummy300[8];
dd dummy301[8];
dd dummy302[8];
dd dummy303[8];
dd dummy304[8];
dd dummy305[8];
db tected[21];
db tecte[56];
db dummy306[258];
db dummy307[512];
db message1[6];
db dummy308[6];
db dummy309[6];
db dummy310[14];
db dummy311[6];
db dummy312[6];
db dummy313[6];
db dummy314[14];
db dummy315[6];
db dummy316[6];
db dummy317[6];
db dummy318[14];
db dummy319[6];
db dummy320[6];
db dummy321[6];
db dummy322[14];
db message3[6];
db dummy323[6];
db dummy324[6];
db dummy325[14];
db dummy326[6];
db dummy327[6];
db dummy328[6];
db dummy329[14];
db dummy330[6];
db dummy331[6];
db dummy332[6];
db dummy333[14];
db dummy334[6];
db dummy335[6];
db dummy336[6];
db dummy337[14];
db mess_kli[6];
db dummy338[6];
db dummy339[6];
db dummy340[14];
db dummy341[6];
db dummy342[6];
db dummy343[6];
db dummy344[14];
db dummy345[6];
db dummy346[6];
db dummy347[6];
db dummy348[14];
db dummy349[6];
db dummy350[6];
db dummy351[6];
db dummy352[14];
db mess_luc[6];
db dummy353[6];
db dummy354[6];
db dummy355[14];
db dummy356[6];
db dummy357[6];
db dummy358[6];
db dummy359[14];
db dummy360[6];
db dummy361[6];
db dummy362[6];
db dummy363[14];
db dummy364[6];
db dummy365[6];
db dummy366[6];
db dummy367[14];
db mess_frd[6];
db dummy368[6];
db dummy369[6];
db dummy370[14];
db dummy371[6];
db dummy372[6];
db dummy373[6];
db dummy374[14];
db dummy375[6];
db dummy376[6];
db dummy377[6];
db dummy378[14];
db dummy379[6];
db dummy380[6];
db dummy381[6];
db dummy382[14];
db mess_jag[6];
db dummy383[6];
db dummy384[6];
db dummy385[14];
db dummy386[6];
db dummy387[6];
db dummy388[6];
db dummy389[14];
db dummy390[6];
db dummy391[6];
db dummy392[6];
db dummy393[14];
db dummy394[6];
db dummy395[6];
db dummy396[6];
db dummy397[14];
db mess_din[6];
db dummy398[6];
db dummy399[6];
db dummy400[14];
db dummy401[6];
db dummy402[6];
db dummy403[6];
db dummy404[14];
db dummy405[6];
db dummy406[6];
db dummy407[6];
db dummy408[14];
db dummy409[6];
db dummy410[6];
db dummy411[6];
db dummy412[14];
db mess_jdg[6];
db dummy413[6];
db dummy414[6];
db dummy415[14];
db dummy416[6];
db dummy417[6];
db dummy418[6];
db dummy419[14];
db mess_rmd[6];
db dummy420[6];
db dummy421[6];
db dummy422[14];
db dummy423[6];
db dummy424[6];
db dummy425[6];
db dummy426[14];
db dummy427[6];
db dummy428[6];
db dummy429[6];
db dummy430[14];
db dummy431[6];
db dummy432[6];
db dummy433[6];
db dummy434[14];
db mess_ors[6];
db dummy435[6];
db dummy436[6];
db dummy437[14];
db dummy438[6];
db dummy439[6];
db dummy440[6];
db dummy441[14];
db dummy442[6];
db dummy443[6];
db dummy444[6];
db dummy445[14];
db dummy446[6];
db dummy447[6];
db dummy448[6];
db dummy449[14];
db mess_kor[6];
db dummy450[6];
db dummy451[6];
db dummy452[14];
db dummy453[6];
db dummy454[6];
db dummy455[6];
db dummy456[14];
db dummy457[6];
db dummy458[6];
db dummy459[6];
db dummy460[14];
db dummy461[6];
db dummy462[6];
db dummy463[6];
db dummy464[14];
db mess_sl1[6];
db dummy465[6];
db dummy466[6];
db dummy467[14];
db dummy468[6];
db dummy469[6];
db dummy470[6];
db dummy471[14];
db dummy472[6];
db dummy473[6];
db dummy474[6];
db dummy475[14];
db dummy476[6];
db dummy477[6];
db dummy478[6];
db dummy479[14];
db mess_adr[6];
db dummy480[6];
db dummy481[6];
db dummy482[14];
db dummy483[6];
db dummy484[6];
db dummy485[6];
db dummy486[14];
db dummy487[6];
db dummy488[6];
db dummy489[6];
db dummy490[14];
db dummy491[6];
db dummy492[6];
db dummy493[6];
db dummy494[14];
db mess_wil[6];
db dummy495[6];
db dummy496[6];
db dummy497[14];
db dummy498[6];
db dummy499[6];
db dummy500[6];
db dummy501[14];
db mess_exo[6];
db dummy502[6];
db dummy503[6];
db dummy504[14];
db dummy505[6];
db dummy506[6];
db dummy507[6];
db dummy508[14];
db mess_cl[6];
db dummy509[6];
db dummy510[6];
db dummy511[14];
db dummy512[6];
db dummy513[6];
db dummy514[6];
db dummy515[14];
db mess_ben[6];
db dummy516[6];
db dummy517[6];
db dummy518[14];
db dummy519[6];
db dummy520[6];
db dummy521[6];
db dummy522[14];
db mess_aaa[6];
db dummy523[6];
db dummy524[6];
db dummy525[14];
db dummy526[6];
db dummy527[6];
db dummy528[6];
db dummy529[14];
db mess_fzf[6];
db dummy530[6];
db dummy531[6];
db dummy532[14];
db dummy533[6];
db dummy534[6];
db dummy535[6];
db dummy536[14];
db dummy537[6];
db dummy538[6];
db dummy539[6];
db dummy540[14];
db dummy541[6];
db dummy542[6];
db dummy543[6];
db dummy544[14];
db mess_het[6];
db dummy545[6];
db dummy546[6];
db dummy547[14];
db dummy548[6];
db dummy549[6];
db dummy550[6];
db dummy551[14];
db dummy552[6];
db dummy553[6];
db dummy554[6];
db dummy555[14];
db dummy556[6];
db dummy557[6];
db dummy558[6];
db dummy559[14];
db mess_big[6];
db dummy560[6];
db dummy561[6];
db dummy562[14];
db dummy563[6];
db dummy564[6];
db dummy565[6];
db dummy566[14];
db dummy567[6];
db dummy568[6];
db dummy569[6];
db dummy570[14];
db dummy571[6];
db dummy572[6];
db dummy573[6];
db dummy574[14];
db mess_hak[6];
db dummy575[6];
db dummy576[6];
db dummy577[14];
db dummy578[6];
db dummy579[6];
db dummy580[6];
db dummy581[14];
db dummy582[6];
db dummy583[6];
db dummy584[6];
db dummy585[14];
db dummy586[6];
db dummy587[6];
db dummy588[6];
db dummy589[14];
db mess_jc[6];
db dummy590[6];
db dummy591[6];
db dummy592[14];
db dummy593[6];
db dummy594[6];
db dummy595[6];
db dummy596[14];
db defo[4];
db truc_fin_s[32];
db dummy597[32];
db dummy598[32];
db dummy599[32];
db dummy600[32];
db dummy601[32];
db dummy602[32];
db dummy603[32];
db dummy604[32];
db dummy605[32];
db dummy606[32];
db dummy607[32];
db dummy608[32];
dd dummy609;
db truc_fin_soccer[32];
db dummy610[32];
db dummy611[32];
db dummy612[32];
db dummy613[32];
db dummy614[32];
db dummy615[32];
db dummy616[32];
db dummy617[32];
db dummy618[32];
db dummy619[32];
db dummy620[32];
db dummy621[32];
dd dummy622;
db truc_fin_s_c[32];
db dummy623[32];
db dummy624[32];
db dummy625[32];
db dummy626[32];
db dummy627[32];
db dummy628[32];
db dummy629[32];
db dummy630[32];
db dummy631[32];
db dummy632[32];
db dummy633[32];
db dummy634[32];
dd dummy635;
db truc_fin_s_m[32];
db dummy636[32];
db dummy637[32];
db dummy638[32];
db dummy639[32];
db dummy640[32];
db dummy641[32];
db dummy642[32];
db dummy643[32];
db dummy644[32];
db dummy645[32];
db dummy646[32];
db dummy647[32];
dd dummy648;
db truc_fin_s_n[32];
db dummy649[32];
db dummy650[32];
db dummy651[32];
db dummy652[32];
db dummy653[32];
db dummy654[32];
db dummy655[32];
db dummy656[32];
db dummy657[32];
db dummy658[32];
db dummy659[32];
db dummy660[32];
dd dummy661;
db truc_s[32];
db dummy662[32];
db dummy663[32];
db dummy664[32];
db dummy665[32];
db dummy666[32];
db dummy667[32];
db dummy668[32];
db dummy669[32];
db dummy670[32];
db dummy671[32];
db dummy672[32];
db dummy673[32];
db truc_foot[32];
db dummy674[32];
db dummy675[32];
db dummy676[32];
db dummy677[32];
db dummy678[32];
db dummy679[32];
db dummy680[32];
db dummy681[32];
db dummy682[32];
db dummy683[32];
db dummy684[32];
db dummy685[32];
db truc_soccer[32];
db dummy686[32];
db dummy687[32];
db dummy688[32];
db dummy689[32];
db dummy690[32];
db dummy691[32];
db dummy692[32];
db dummy693[32];
db dummy694[32];
db dummy695[32];
db dummy696[32];
db dummy697[32];
db truc_n[32];
db dummy698[32];
db dummy699[32];
db dummy700[32];
db dummy701[32];
db dummy702[32];
db dummy703[32];
db dummy704[32];
db dummy705[32];
db dummy706[32];
db dummy707[32];
db dummy708[32];
db dummy709[32];
db truc_c[32];
db dummy710[32];
db dummy711[32];
db dummy712[32];
db dummy713[32];
db dummy714[32];
db dummy715[32];
db dummy716[32];
db dummy717[32];
db dummy718[32];
db dummy719[32];
db dummy720[32];
db dummy721[32];
db truc_h[32];
db dummy722[32];
db dummy723[32];
db dummy724[32];
db dummy725[32];
db dummy726[32];
db dummy727[32];
db dummy728[32];
db dummy729[32];
db dummy730[32];
db dummy731[32];
db dummy732[32];
db dummy733[32];
db truc_f[32];
db dummy734[32];
db dummy735[32];
db dummy736[32];
db dummy737[32];
db dummy738[32];
db dummy739[32];
db dummy740[32];
db dummy741[32];
db dummy742[32];
db dummy743[32];
db dummy744[32];
db dummy745[32];
db truc_neige[32];
db dummy746[32];
db dummy747[32];
db dummy748[32];
db dummy749[32];
db dummy750[32];
db dummy751[32];
db dummy752[32];
db dummy753[32];
db dummy754[32];
db dummy755[32];
db dummy756[32];
db dummy757[32];
db truc2_save_foot[32];
db dummy758[32];
db truc2_save[13];
db truc2_save_n[32];
db dummy759[32];
db dummy760[32];
db dummy761[32];
db dummy762[32];
db dummy763[32];
db dummy764[32];
db dummy765[32];
db dummy766[32];
db dummy767[32];
db dummy768[32];
db dummy769[32];
db dummy770[32];
dd ia[16];
db offset_supporter[4];
db offset_cameraman[4];
db dummy771[12];
db dummy772[4];
db dummy773[12];
db dummy774[8];
db dummy775[8];
db dummy776[8];
db dummy777[4];
db dummy778[12];
db dummy779[8];
db dummy780[4];
db dummy781[12];
dd differentesply;
dd dummy782;
dd dummy783;
dd dummy784;
dd dummy785;
dd dummy786;
dd dummy787;
dd dummy788;
dd dummy789;
dd dummy790;
dd dummy791;
dd dummy792;
dd dummy793;
dd dummy794;
dd dummy795;
dd dummy796;
dd offset_pause[10];
dd dummy797[4];
dd dummy798[10];
dd dummy799[17];
dd dummy800;
dd offset_si;
dd dummy801;
dd dummy802;
dd dummy803;
dd dummy804;
dd dummy805;
dd dummy806;
dd dummy807;
dd dummy808;
dd dummy809;
dd dummy810;
dd dummy811;
dd dummy812;
dd dummy813;
dd dummy814;
dd dummy815;
dd dummy816;
dd dummy817;
dd dummy818;
dd dummy819;
dd dummy820;
dd dummy821;
dd dummy822;
dd dummy823;
dd dummy824;
dd dummy825;
dd dummy826;
dd dummy827;
dd dummy828;
dd dummy829;
dd dummy830;
dd dummy831;
dd dummy832;
dd dummy833;
dd dummy834;
dd dummy835;
dd dummy836;
dd dummy837;
dd dummy838;
dd dummy839;
dd dummy840;
dd dummy841;
dd liste_couleur_malade[2];
dd dummy842[2];
dd dummy843[2];
dd dummy844[2];
db love_si[4];
db dummy845[4];
db dummy846[4];
db dummy847[4];
db dummy848[4];
db dummy849[4];
db dummy850[4];
db dummy851[4];
db dummy852[4];
db dummy853[4];
db dummy854[4];
db dummy855[4];
db dummy856[4];
db dummy857[4];
db dummy858[4];
db dummy859[4];
db dummy860[4];
db dummy861[4];
db dummy862[4];
db dummy863[4];
db dummy864[4];
db dummy865[4];
db iff_file_name[13];
db reccord[13];
db reccord3[9];
db reccord2[13];
db suite[4];
db suite2[24];
db suite3[73];
db cfgerror[79];
db errorcfg[29];
db message_mem_rp[53];
db okcfg[37];
db okcfg3[36];
db win[55];
db nowin[39];
db terminalor[78];
db dummy866[49];
db nulosproduction[60];
db stat1[10];
db stat2[7];
db stat3[9];
db gameover[38];
db no_server_[33];
db select_server_[42];
db cnx1[32];
db transformateur_98[13];
db cnx2[6];
dd load_pcx_interne;
dd load_handle;
dd adresse_des_fonds[4];
dd adresse_des_fonds_foot[2];
dd dummy867[2];
dd adresse_des_fonds_neige;
dd dummy868;
dd dummy869;
dd adresse_des_fonds_final[4];
dd adresse_des_fonds_foret[4];
dd adresse_des_fonds_nuage[4];
dd adresse_des_fonds_crayon[4];
dd adresse_des_fonds_soccer[4];
dd nombre_de_fond;
dd adresse_des_draws[2];
dd nombre_de_draw;
dd adresse_des_vic[4];
dd nombre_de_vic;
dd kelle_donnee[5];
dd dummy870[3];
dd kelle_fin[5];
dd dummy871[3];
dd kelle_truc[5];
dd dummy872[3];
dd kelle_bonus[5];
dd dummy873[3];
dd kelle_apocalypse[5];
dd dummy874[3];
dd kelle_duree[5];
dd dummy875[3];
dw offset_briques[5];
dw dummy876[3];
dd kelle_offset_fond[5];
dd dummy877[3];
dw kel_viseur_brike_fin[5];
dw dummy878[3];
dw lapin_mort[4];
dw dummy879[4];
dw dummy880[4];
dw dummy881[4];
dw lapin_mortg[4];
dw dummy882[4];
dw dummy883[4];
dw dummy884[4];
dw lapin2[4];
dw dummy885[4];
dw dummy886[4];
dw dummy887[4];
dw dummy888[4];
dw dummy889[4];
dw dummy890;
dw lapin2g[4];
dw dummy891[4];
dw dummy892[4];
dw dummy893[4];
dw dummy894[4];
dw dummy895[4];
dw dummy896;
dw lapin2___[4];
dw dummy897[4];
dw dummy898[4];
dw dummy899[4];
dw lapin2___g[4];
dw dummy900[4];
dw dummy901[4];
dw dummy902[4];
dw lapin2_[4];
dw dummy903[4];
dw dummy904[4];
dw dummy905[4];
dw lapin2_g[4];
dw dummy906[4];
dw dummy907[4];
dw dummy908[4];
dw lapin2__[4];
dw dummy909[4];
dw dummy910[4];
dw dummy911[4];
dw lapin2__g[4];
dw dummy912[4];
dw dummy913[4];
dw dummy914[4];
dw grosbleu[4];
dw dummy915[4];
dw dummy916[4];
dw dummy917[4];
dw dummy918[4];
dw dummy919[4];
dw dummy920;
dw coca[4];
dw dummy921[4];
dw dummy922[4];
dw dummy923[4];
dw dummy924[8];
dw dummy925;
dw escargot[4];
dw dummy926[4];
dw dummy927[4];
dw dummy928[4];
dw dummy929[4];
dw dummy930[4];
dw dummy931;
dw old_school[4];
dw dummy932[4];
dw dummy933[4];
dw dummy934[4];
dw dummy935[3];
dw dummy936[5];
dw dummy937;
dw bleu_triste[4];
dw dummy938[4];
dw dummy939[4];
dw dummy940[4];
dw dummy941[4];
dw dummy942[4];
dw dummy943;
dw machine[16];
dw dummy944[4];
dw dummy945[4];
dw dummy946;
dw petit_jaune[4];
dw dummy947[4];
dw dummy948[4];
dw dummy949[4];
dw dummy950[8];
dw dummy951;
dw blanc[4];
dw dummy952[4];
dw dummy953[4];
dw dummy954[4];
dw dummy955[4];
dw dummy956[4];
dw dummy957;
dw bleu[4];
dw dummy958[4];
dw dummy959[4];
dw dummy960[4];
dw dummy961[6];
dw dummy962[2];
dw dummy963;
dw rouge[4];
dw dummy964[4];
dw dummy965[4];
dw dummy966[4];
dw dummy967[8];
dw dummy968;
dw vert[4];
dw dummy969[4];
dw dummy970[4];
dw dummy971[4];
dw dummy972[8];
dw dummy973;
dw blancg[4];
dw dummy974[4];
dw dummy975[4];
dw dummy976[4];
dw dummy977[8];
dw dummy978;
dw bleug[4];
dw dummy979[4];
dw dummy980[4];
dw dummy981[4];
dw dummy982[4];
dw dummy983[2];
dw dummy984[2];
dw dummy985;
dw rougeg[4];
dw dummy986[4];
dw dummy987[4];
dw dummy988[4];
dw dummy989[8];
dw dummy990;
dw vertg[4];
dw dummy991[4];
dw dummy992[4];
dw dummy993[4];
dw dummy994[4];
dw dummy995[4];
dw dummy996;
dd offset_ic[4];
dw central_b[7];
dw dummy997[7];
dw dummy998[7];
dw dummy999[7];
dw dummy1000[7];
dw dummy1001[7];
dw dummy1002[7];
dd viseur_victory[2];
dd dummy1003[2];
dd dummy1004[2];
dd dummy1005[2];
dd viseur_victoryc[2];
dd dummy1006[2];
dd dummy1007[2];
dd dummy1008[2];
dd viseur_victoryg[8];
dd viseur_name[2];
dd dummy1009[2];
dd dummy1010[2];
dd dummy1011[2];
dd viseur_namec[2];
dd dummy1012[2];
dd dummy1013[2];
dd dummy1014[2];
dd viseur_nameg[2];
dd dummy1015[2];
dd dummy1016[2];
dd dummy1017[2];
dw offset_medaille[13];
dw dummy1018[3];
dd random_place[8];
dd dummy1019[8];
dd dummy1020[8];
dd dummy1021[8];
dd dummy1022[8];
dd dummy1023[8];
dd dummy1024[8];
dd dummy1025[8];
dd dummy1026[8];
dd dummy1027[8];
dd dummy1028[8];
dd dummy1029[8];
dd dummy1030[8];
dd dummy1031[8];
dd dummy1032[8];
dd dummy1033[8];
db loaderror[78];
dd differents_offset_possible[4];
dd dummy1034[4];
dd dummy1035[4];
dd dummy1036[4];
dd dummy1037;
dd packed_liste[12];
dd dummy1038[24];
dd dummy1039[22];
dd dummy1040;
dd iff_liste[13];
dd dummy1041;
db liste_terrain[9];
db ascii[11];
db couleurssss[64];
db dummy1042[64];
db dummy1043[64];
db dummy1044[64];
db lost_conney;
db hazard_maladie[8];
db dummy1045[8];
db couleur[8];
db couleur_menu[8];
dw offset_fille[16];
dd offset_oiseau[16];
dd dummy1046[16];
dw fx[14];
dd liste_couleur_normal[2];
dd dummy1047[2];
dd dummy1048[2];
dd dummy1049[2];
dd s_normal[8];
dw l_normal[8];
dw c_normal[8];
dd a_normal[8];
dd r_normal[8];
dw donnee_s[8];
dw dummy1050[8];
dw dummy1051[8];
dd ooo34[8];
dw dummy1052[8];
dw dummy1053[8];
dd dummy1054[8];
dd dummy1055[8];
dd dummy1056[8];
dd dummy1057[5];
dd dummy1058[40];
dd dummy1059[8];
dd dummy1060[8];
dd dummy1061[2];
dd dummy1062[8];
dd dummy1063[8];
dd dummy1064;
dd dummy1065;
db dummy1066[8];
db dummy1067[8];
db dummy1068[8];
db dummy1069[8];
dw donnee_foot[8];
dw dummy1070[8];
dw dummy1071[8];
dd dummy1072[8];
dw dummy1073[8];
dw dummy1074[8];
dd dummy1075[8];
dd dummy1076[8];
dd dummy1077[8];
dd dummy1078[5];
dd dummy1079[40];
dd dummy1080[8];
dd dummy1081[8];
dd dummy1082[2];
dd dummy1083[8];
dd dummy1084[8];
dd dummy1085;
dd dummy1086;
db dummy1087[8];
db dummy1088[8];
db dummy1089[8];
db dummy1090[8];
dw donnee_soccer[8];
dw dummy1091[8];
dw dummy1092[8];
dd dummy1093[8];
dw dummy1094[8];
dw dummy1095[8];
dd dummy1096[8];
dd dummy1097[8];
dd dummy1098[8];
dd dummy1099[5];
dd dummy1100[10];
dd dummy1101[30];
dd dummy1102[8];
dd dummy1103[8];
dd dummy1104[2];
dd dummy1105[8];
dd dummy1106[8];
dd dummy1107;
dd dummy1108;
db dummy1109[8];
db dummy1110[8];
db dummy1111[8];
db dummy1112[8];
dw donnee_h[8];
dw dummy1113[8];
dw dummy1114[8];
dd dummy1115[8];
dw dummy1116[8];
dw dummy1117[8];
dd dummy1118[8];
dd dummy1119[8];
dd dummy1120[8];
dd dummy1121[5];
dd dummy1122[40];
dd dummy1123[8];
dd dummy1124[8];
dd dummy1125[2];
dd dummy1126[8];
dd dummy1127[8];
dd dummy1128;
dd dummy1129;
db dummy1130[8];
db dummy1131[8];
db dummy1132[8];
db dummy1133[8];
dw donnee_n[8];
dw dummy1134[8];
dw dummy1135[8];
dd dummy1136[8];
dw dummy1137[8];
dw dummy1138[8];
dd dummy1139[8];
dd dummy1140[8];
dd dummy1141[8];
dd dummy1142[5];
dd dummy1143[10];
dd dummy1144[5];
dd dummy1145[5];
dd dummy1146[5];
dd dummy1147[5];
dd dummy1148[5];
dd dummy1149[5];
dd dummy1150[8];
dd dummy1151[8];
dd dummy1152[2];
dd dummy1153[8];
dd dummy1154[8];
dd dummy1155;
dd dummy1156;
db dummy1157[8];
db dummy1158[8];
db dummy1159[8];
db dummy1160[8];
dw donnee_c[8];
dw dummy1161[8];
dw dummy1162[8];
dd dummy1163[8];
dw dummy1164[8];
dw dummy1165[8];
dd dummy1166[8];
dd dummy1167[8];
dd dummy1168[8];
dd dummy1169[5];
dd dummy1170[40];
dd dummy1171[8];
dd dummy1172[8];
dd dummy1173[2];
dd dummy1174[8];
dd dummy1175[8];
dd dummy1176;
dd dummy1177;
db dummy1178[8];
db dummy1179[8];
db dummy1180[8];
db dummy1181[8];
dw donnee_f[8];
dw dummy1182[8];
dw dummy1183[8];
dd dummy1184[8];
dw dummy1185[8];
dw dummy1186[8];
dd dummy1187[8];
dd dummy1188[8];
dd dummy1189[8];
dd dummy1190[5];
dd dummy1191[40];
dd dummy1192[8];
dd dummy1193[8];
dd dummy1194[2];
dd dummy1195[8];
dd dummy1196[8];
dd dummy1197;
dd dummy1198;
db dummy1199[8];
db dummy1200[8];
db dummy1201[8];
db dummy1202[8];
dw donnee_s_neige[8];
dw dummy1203[8];
dw dummy1204[8];
dd dummy1205[8];
dw dummy1206[8];
dw dummy1207[8];
dd dummy1208[8];
dd dummy1209[8];
dd dummy1210[8];
dd dummy1211[5];
dd dummy1212[40];
dd dummy1213[8];
dd dummy1214[8];
dd dummy1215[2];
dd dummy1216[8];
dd dummy1217[8];
dd dummy1218;
dd dummy1219;
db dummy1220[8];
db dummy1221[8];
db dummy1222[8];
db dummy1223[8];
dw mort_de_lapin[6];
dw dummy1224[6];
dw dummy1225[6];
dw dummy1226[6];
dw dummy1227[6];
dw dummy1228[2];
dw saut_de_lapin2[6];
dw dummy1229[6];
dw dummy1230[5];
dw dummy1231[3];
dw dummy1232[6];
dw dummy1233[6];
dw dummy1234;
dw dummy1235[4];
dw dummy1236[4];
dw saut_de_lapin[6];
dw dummy1237[6];
dw dummy1238[5];
dw dummy1239[3];
dw dummy1240[6];
dw dummy1241[6];
dw dummy1242;
dw dummy1243[4];
dw dummy1244[4];
dw dummy1245[4];
dw dummy1246[4];
dw dummy1247[4];
dw dummy1248[4];
dd n_team[8];
dd dummy1249;
dd c_team[8];
dd dummy1250;
dd s_team[8];
dd dummy1251;
dd infojoueur[8];
db panning2[19];
dd replayer_saver;
dd replayer_saver2;
dd replayer_saver3;
dd replayer_saver4;
db replayer_saver5;
db donnee4[72];
dd attente;
db nosetjmp;
dd nuage_sympa[5];
dd dummy1252[5];
dd dummy1253[5];
dd dummy1254[5];
dd dummy1255[5];
dd dummy1256[5];
dd dummy1257[5];
dd dummy1258[5];
dd dummy1259[5];
dd dummy1260[5];
dd dummy1261[5];
dd dummy1262[5];
dd dummy1263[5];
dd dummy1264[5];
dd dummy1265[5];
dd dummy1266[5];
dd vise_de_ca_haut[8];
dd vise_de_ca_haut2[8];
dd adder_inser_coin;
dd viseur_ic2;
dd inser_coin;
dd acceleration;
dd attente_entre_chake_bombe;
dd nouvelle_attente_entre_chake_bombe2[19];
dd viseur__nouvelle_attente_entre_chake_bombe;
dd liste_bombbbb;
dw dummy1267;
dw dummy1268;
dd dummy1269;
dd dummy1270;
dw dummy1271;
dw dummy1272;
dd dummy1273;
dd dummy1274;
dw dummy1275;
dw dummy1276;
dd dummy1277;
dd dummy1278;
dw dummy1279;
dw dummy1280;
dd dummy1281;
dd dummy1282;
dw dummy1283;
dw dummy1284;
dd dummy1285;
dd dummy1286;
dw dummy1287;
dw dummy1288;
dd dummy1289;
dd dummy1290;
dw dummy1291;
dw dummy1292;
dd dummy1293;
dd dummy1294;
dw dummy1295;
dw dummy1296;
dd dummy1297;
dd dummy1298;
dw dummy1299;
dw dummy1300;
dd dummy1301;
dd dummy1302;
dw dummy1303;
dw dummy1304;
dd dummy1305;
dd dummy1306;
dw dummy1307;
dw dummy1308;
dd dummy1309;
dd dummy1310;
dw dummy1311;
dw dummy1312;
dd dummy1313;
dd dummy1314;
dw dummy1315;
dw dummy1316;
dd dummy1317;
dd dummy1318;
dw dummy1319;
dw dummy1320;
dd dummy1321;
dd dummy1322;
dw dummy1323;
dw dummy1324;
dd dummy1325;
dd dummy1326;
dw dummy1327;
dw dummy1328;
dd dummy1329;
dd dummy1330;
dw dummy1331;
dw dummy1332;
dd dummy1333;
dd dummy1334;
dw dummy1335;
dw dummy1336;
dd dummy1337;
dd dummy1338;
dw dummy1339;
dw dummy1340;
dd dummy1341;
dd dummy1342;
dw dummy1343;
dw dummy1344;
dd dummy1345;
dd dummy1346;
dw dummy1347;
dw dummy1348;
dd dummy1349;
dd dummy1350;
dw dummy1351;
dw dummy1352;
dd dummy1353;
dd dummy1354;
dw dummy1355;
dw dummy1356;
dd dummy1357;
dd dummy1358;
dw dummy1359;
dw dummy1360;
dd dummy1361;
dd dummy1362;
dw dummy1363;
dw dummy1364;
dd dummy1365;
dd dummy1366;
dw dummy1367;
dw dummy1368;
dd dummy1369;
dd dummy1370;
dw dummy1371;
dw dummy1372;
dd dummy1373;
dd dummy1374;
dw dummy1375;
dw dummy1376;
dd dummy1377;
dd dummy1378;
dw dummy1379;
dw dummy1380;
dd dummy1381;
dd dummy1382;
dw dummy1383;
dw dummy1384;
dd dummy1385;
dd dummy1386;
dw dummy1387;
dw dummy1388;
dd dummy1389;
dd liste_bombbbb2;
dd special_nivo_6;
dd differentesply2;
dd temps_avant_demo;
dd ttp;
dd arbre;
dd viseur_couleur;
dd attente_nouveau_esc;
dd nombre_de_dyna_x4;
dd changeiny[8];
dd dummy1390[8];
dd viseur_change_in[8];
dd viseur_change_in_save[8];
dd anti_bomb[2];
dd dummy1391[2];
dd dummy1392[2];
dd dummy1393[2];
dd machin2;
dd machin3;
dd machin[16];
dd dummy1394[14];
dd dummy1395;
dd dummy1396[16];
dd dummy1397[14];
dd dummy1398;
dd duree_draw;
dd duree_med;
dd duree_vic;
dd affiche_raster;
dd save_banke;
dd attente_avant_draw;
dd attente_avant_med;
dd pic_time;
dd viseur_sur_fond;
dd viseur_sur_draw;
dd viseur_sur_vic;
dd compteur_nuage;
dd changementzz;
dd changementzz2;
dd changement;
db truc[416];
db truc2[416];
db truc_x[416];
db truc_y[416];
db truc_monstre[416];
dd touches[8];
dd avance[8];
dd avance2[8];
dd touches_save[8];
db action[32];
dd vie[8];
dd victoires[8];
dd latest_victory;
dd team[8];
dd nombre_minimum_de_dyna;
dd infos_j_n[5];
dd infos_m_n[40];
dd last_bomb[8];
dd viseur_liste_terrain;
dd nombre_de_dyna;
db nb_ai_bombermen;
dd nombre_de_monstres;
dd nombre_de_vbl_avant_le_droit_de_poser_bombe;
dd j1[5];
dd j2[5];
dd j3[5];
dd j4[5];
dd j5[5];
dd j6[5];
dd j7[5];
dd j8[5];
dw donnee[24];
dd ooo546[8];
dw dummy1399[8];
dw dummy1400[8];
dd dummy1401[8];
dd liste_couleur[8];
dd nombre_de_coups[8];
dd clignotement[8];
dd pousseur[8];
dd patineur[8];
dd vitesse_monstre[8];
dd tribombe2[8];
dd tribombe[8];
dd invinsible[8];
dd blocage[8];
dd lapipipino[8];
dd lapipipino2[8];
dd lapipipino3[8];
dd lapipipino4[8];
dd lapipipino5[8];
dd lapipipino6[8];
dd lapipipino7[8];
db action_replay;
db ordre2;
db detail;
db mechant;
db terrain;
db team3;
db pauseur2;
db bdraw666[2];
dw adder_bdraw;
dw temps;
dd kel_ombre;
dw ombres[8];
dw briques[495];
dw bombes[495];
dd control_joueur[8];
dd control_joueur2[8];
dd name_joueur[8];
dd temps_joueur[8];
dd nb_ordy_connected;
dd last_name;
db total_play[6];
db dummy1402[6];
db dummy1403[6];
db dummy1404[6];
db dummy1405[6];
db dummy1406[6];
db dummy1407[6];
db dummy1408[6];
db dummy1409[3];
db dummy1410[13];
db total_t[6];
db dummy1411[6];
db dummy1412[6];
db dummy1413[6];
db dummy1414[6];
db dummy1415[6];
db dummy1416[6];
db dummy1417[6];
db dummy1418[2];
db dummy1419[14];
db dummy1420[6];
db dummy1421[6];
db dummy1422[6];
db dummy1423[6];
db dummy1424[6];
db dummy1425[6];
db dummy1426[6];
db dummy1427[6];
db dummy1428[2];
db dummy1429[14];
db dummy1430[6];
db dummy1431[6];
db dummy1432[6];
db dummy1433[6];
db dummy1434[6];
db dummy1435[6];
db dummy1436[6];
db dummy1437[6];
db dummy1438[2];
db dummy1439[14];
db dummy1440[6];
db dummy1441[6];
db dummy1442[6];
db dummy1443[6];
db dummy1444[6];
db dummy1445[6];
db dummy1446[6];
db dummy1447[6];
db dummy1448[2];
db dummy1449[14];
db dummy1450[6];
db dummy1451[6];
db dummy1452[6];
db dummy1453[6];
db dummy1454[6];
db dummy1455[6];
db dummy1456[6];
db dummy1457[6];
db dummy1458[2];
db dummy1459[14];
db dummy1460[6];
db dummy1461[6];
db dummy1462[6];
db dummy1463[6];
db dummy1464[6];
db dummy1465[6];
db dummy1466[6];
db dummy1467[6];
db dummy1468[2];
db dummy1469[14];
db dummy1470[6];
db dummy1471[6];
db dummy1472[6];
db dummy1473[6];
db dummy1474[6];
db dummy1475[6];
db dummy1476[6];
db dummy1477[6];
db dummy1478[2];
db dummy1479[14];
db dummy1480[6];
db dummy1481[6];
db dummy1482[6];
db dummy1483[6];
db dummy1484[6];
db dummy1485[6];
db dummy1486[6];
db dummy1487[6];
db dummy1488[2];
db dummy1489[14];
db donnee2[7];
db dummy1490[7];
db dummy1491[7];
db dummy1492[7];
db dummy1493[7];
db dummy1494[7];
db dummy1495[7];
db dummy1496[7];
db dummy1497[2];
db dummy1498;
db nick_t[7];
db dummy1499[7];
db dummy1500[7];
db dummy1501[7];
db dummy1502[7];
db dummy1503[7];
db dummy1504[7];
db dummy1505[7];
db dummy1506[8];
db dummy1507[7];
db dummy1508[7];
db dummy1509[7];
db dummy1510[7];
db dummy1511[7];
db dummy1512[7];
db dummy1513[7];
db dummy1514[7];
db dummy1515[8];
db dummy1516[7];
db dummy1517[7];
db dummy1518[7];
db dummy1519[7];
db dummy1520[7];
db dummy1521[7];
db dummy1522[7];
db dummy1523[7];
db dummy1524[8];
db dummy1525[7];
db dummy1526[7];
db dummy1527[7];
db dummy1528[7];
db dummy1529[7];
db dummy1530[7];
db dummy1531[7];
db dummy1532[7];
db dummy1533[8];
db dummy1534[7];
db dummy1535[7];
db dummy1536[7];
db dummy1537[7];
db dummy1538[7];
db dummy1539[7];
db dummy1540[7];
db dummy1541[7];
db dummy1542[8];
db dummy1543[7];
db dummy1544[7];
db dummy1545[7];
db dummy1546[7];
db dummy1547[7];
db dummy1548[7];
db dummy1549[7];
db dummy1550[7];
db dummy1551[8];
db dummy1552[7];
db dummy1553[7];
db dummy1554[7];
db dummy1555[7];
db dummy1556[7];
db dummy1557[7];
db dummy1558[7];
db dummy1559[7];
db dummy1560[8];
db dummy1561[7];
db dummy1562[7];
db dummy1563[7];
db dummy1564[7];
db dummy1565[7];
db dummy1566[7];
db dummy1567[7];
db dummy1568[7];
db dummy1569[8];
db dummy1570[6];
dd lapin_mania[2];
dd dummy1571[2];
dd dummy1572[2];
dd dummy1573[2];
dd lapin_mania_malade[2];
dd dummy1574[2];
dd dummy1575[2];
dd dummy1576[2];
dd lapin_mania1[2];
dd dummy1577[2];
dd dummy1578[2];
dd dummy1579[2];
dd lapin_mania2[2];
dd dummy1580[2];
dd dummy1581[2];
dd dummy1582[2];
dd lapin_mania3[2];
dd dummy1583[2];
dd dummy1584[2];
dd dummy1585[2];
dd lapin_mania4[2];
dd dummy1586[2];
dd dummy1587[2];
dd dummy1588[2];
dd lapin_mania5[2];
dd dummy1589[2];
dd dummy1590[2];
dd dummy1591[2];
db truc_fin[416];
dd dummy1592;
db ordre;
db dummy1593[4];
db texte1[1024];
dw maladie[16];
db autofire;
db balance_le_bdrawn;
db bdraw1;
db on_les_dans_le_menu;
db sortie_slave;
db modeinfo;
db nomonster;
db twice;
db twice2;
db pic_de_tout_debut;
db une_touche_a_telle_ete_pressee;
db sors_du_menu_aussitot;
db team3_sauve;
db special_on_a_loadee_nivo;
db record_user;
db hazard_bonus[46];
db dummy1594[53];
dd viseur_hazard_bonus;
db hazard_bonus2[8];
db dummy1595[8];
dd viseur_hazard_bonus2;
db correspondance_bonus[16];
db correspondance_bonus2[16];
db last_sucker;
db affiche_pal;
db pause;
db pause2;
db temps2;
db sortie;
db in_the_apocalypse;
db pal[64];
db dummy1596[64];
db dummy1597[64];
db dummy1598[64];
db dummy1599[64];
db dummy1600[64];
db dummy1601[64];
db dummy1602[64];
db dummy1603[64];
db dummy1604[64];
db dummy1605[64];
db dummy1606[64];
db pal_affiche[768];
dd liste_bombe;
dd liste_bombe_array[3];
dw dummy1607[6];
dd dummy1608[3];
dw dummy1609[6];
dd dummy1610[3];
dw dummy1611[6];
dd dummy1612[3];
dw dummy1613[6];
dd dummy1614[3];
dw dummy1615[6];
dd dummy1616[3];
dw dummy1617[6];
dd dummy1618[3];
dw dummy1619[6];
dd dummy1620[3];
dw dummy1621[6];
dd dummy1622[3];
dw dummy1623[6];
dd dummy1624[3];
dw dummy1625[6];
dd dummy1626[3];
dw dummy1627[6];
dd dummy1628[3];
dw dummy1629[6];
dd dummy1630[3];
dw dummy1631[6];
dd dummy1632[3];
dw dummy1633[6];
dd dummy1634[3];
dw dummy1635[6];
dd dummy1636[3];
dw dummy1637[6];
dd dummy1638[3];
dw dummy1639[6];
dd dummy1640[3];
dw dummy1641[6];
dd dummy1642[3];
dw dummy1643[6];
dd dummy1644[3];
dw dummy1645[6];
dd dummy1646[3];
dw dummy1647[6];
dd dummy1648[3];
dw dummy1649[6];
dd dummy1650[3];
dw dummy1651[6];
dd dummy1652[3];
dw dummy1653[6];
dd dummy1654[3];
dw dummy1655[6];
dd dummy1656[3];
dw dummy1657[6];
dd dummy1658[3];
dw dummy1659[6];
dd dummy1660[3];
dw dummy1661[6];
dd dummy1662[3];
dw dummy1663[6];
dd dummy1664[3];
dw dummy1665[6];
dd dummy1666[3];
dw dummy1667[6];
dd dummy1668[3];
dw dummy1669[6];
dd dummy1670[3];
dw dummy1671[6];
dd dummy1672[3];
dw dummy1673[6];
dd dummy1674[3];
dw dummy1675[6];
dd dummy1676[3];
dw dummy1677[6];
dd dummy1678[3];
dw dummy1679[6];
dd dummy1680[3];
dw dummy1681[6];
dd dummy1682[3];
dw dummy1683[6];
dd dummy1684[3];
dw dummy1685[6];
dd dummy1686[3];
dw dummy1687[6];
dd dummy1688[3];
dw dummy1689[6];
dd dummy1690[3];
dw dummy1691[6];
dd dummy1692[3];
dw dummy1693[6];
dd dummy1694[3];
dw dummy1695[6];
dd dummy1696[3];
dw dummy1697[6];
dd dummy1698[3];
dw dummy1699[6];
dd dummy1700[3];
dw dummy1701[6];
dd dummy1702[3];
dw dummy1703[6];
dd dummy1704[3];
dw dummy1705[6];
dd dummy1706[3];
dw dummy1707[6];
dd dummy1708[3];
dw dummy1709[6];
dd dummy1710[3];
dw dummy1711[6];
dd dummy1712[3];
dw dummy1713[6];
dd dummy1714[3];
dw dummy1715[6];
dd dummy1716[3];
dw dummy1717[6];
dd dummy1718[3];
dw dummy1719[6];
dd dummy1720[3];
dw dummy1721[6];
dd dummy1722[3];
dw dummy1723[6];
dd dummy1724[3];
dw dummy1725[6];
dd dummy1726[3];
dw dummy1727[6];
dd dummy1728[3];
dw dummy1729[6];
dd dummy1730[3];
dw dummy1731[6];
dd dummy1732[3];
dw dummy1733[6];
dd dummy1734[3];
dw dummy1735[6];
dd dummy1736[3];
dw dummy1737[6];
dd dummy1738[3];
dw dummy1739[6];
dd dummy1740[3];
dw dummy1741[6];
dd dummy1742[3];
dw dummy1743[6];
dd dummy1744[3];
dw dummy1745[6];
dd dummy1746[3];
dw dummy1747[6];
dd dummy1748[3];
dw dummy1749[6];
dd dummy1750[3];
dw dummy1751[6];
dd dummy1752[3];
dw dummy1753[6];
dd dummy1754[3];
dw dummy1755[6];
dd dummy1756[3];
dw dummy1757[6];
dd dummy1758[3];
dw dummy1759[6];
dd dummy1760[3];
dw dummy1761[6];
dd dummy1762[3];
dw dummy1763[6];
dd dummy1764[3];
dw dummy1765[6];
dd dummy1766[3];
dw dummy1767[6];
dd dummy1768[3];
dw dummy1769[6];
dd dummy1770[3];
dw dummy1771[6];
dd dummy1772[3];
dw dummy1773[6];
dd dummy1774[3];
dw dummy1775[6];
dd dummy1776[3];
dw dummy1777[6];
dd dummy1778[3];
dw dummy1779[6];
dd dummy1780[3];
dw dummy1781[6];
dd dummy1782[3];
dw dummy1783[6];
dd dummy1784[3];
dw dummy1785[6];
dd dummy1786[3];
dw dummy1787[6];
dd dummy1788[3];
dw dummy1789[6];
dd dummy1790[3];
dw dummy1791[6];
dd dummy1792[3];
dw dummy1793[6];
dd dummy1794[3];
dw dummy1795[6];
dd dummy1796[3];
dw dummy1797[6];
dd dummy1798[3];
dw dummy1799[6];
dd dummy1800[3];
dw dummy1801[6];
dd dummy1802[3];
dw dummy1803[6];
dd dummy1804[3];
dw dummy1805[6];
dd dummy1806[3];
dw dummy1807[6];
dd dummy1808[3];
dw dummy1809[6];
dd dummy1810[3];
dw dummy1811[6];
dd dummy1812[3];
dw dummy1813[6];
dd dummy1814[3];
dw dummy1815[6];
dd dummy1816[3];
dw dummy1817[6];
dd dummy1818[3];
dw dummy1819[6];
dd dummy1820[3];
dw dummy1821[6];
dd dummy1822[3];
dw dummy1823[6];
dd dummy1824[3];
dw dummy1825[6];
dd dummy1826[3];
dw dummy1827[6];
dd dummy1828[3];
dw dummy1829[6];
dd dummy1830[3];
dw dummy1831[6];
dd dummy1832[3];
dw dummy1833[6];
dd dummy1834[3];
dw dummy1835[6];
dd dummy1836[3];
dw dummy1837[6];
dd dummy1838[3];
dw dummy1839[6];
dd dummy1840[3];
dw dummy1841[6];
dd dummy1842[3];
dw dummy1843[6];
dd dummy1844[3];
dw dummy1845[6];
dd dummy1846[3];
dw dummy1847[6];
dd dummy1848[3];
dw dummy1849[6];
dd dummy1850[3];
dw dummy1851[6];
dd dummy1852[3];
dw dummy1853[6];
dd dummy1854[3];
dw dummy1855[6];
dd dummy1856[3];
dw dummy1857[6];
dd dummy1858[3];
dw dummy1859[6];
dd dummy1860[3];
dw dummy1861[6];
dd dummy1862[3];
dw dummy1863[6];
dd dummy1864[3];
dw dummy1865[6];
dd dummy1866[3];
dw dummy1867[6];
dd dummy1868[3];
dw dummy1869[6];
dd dummy1870[3];
dw dummy1871[6];
dd dummy1872[3];
dw dummy1873[6];
dd dummy1874[3];
dw dummy1875[6];
dd dummy1876[3];
dw dummy1877[6];
dd dummy1878[3];
dw dummy1879[6];
dd dummy1880[3];
dw dummy1881[6];
dd dummy1882[3];
dw dummy1883[6];
dd dummy1884[3];
dw dummy1885[6];
dd dummy1886[3];
dw dummy1887[6];
dd dummy1888[3];
dw dummy1889[6];
dd dummy1890[3];
dw dummy1891[6];
dd dummy1892[3];
dw dummy1893[6];
dd dummy1894[3];
dw dummy1895[6];
dd dummy1896[3];
dw dummy1897[6];
dd dummy1898[3];
dw dummy1899[6];
dd dummy1900[3];
dw dummy1901[6];
dd dummy1902[3];
dw dummy1903[6];
dd dummy1904[3];
dw dummy1905[6];
dd dummy1906[3];
dw dummy1907[6];
dd dummy1908[3];
dw dummy1909[6];
dd dummy1910[3];
dw dummy1911[6];
dd dummy1912[3];
dw dummy1913[6];
dd dummy1914[3];
dw dummy1915[6];
dd dummy1916[3];
dw dummy1917[6];
dd dummy1918[3];
dw dummy1919[6];
dd dummy1920[3];
dw dummy1921[6];
dd dummy1922[3];
dw dummy1923[6];
dd dummy1924[3];
dw dummy1925[6];
dd dummy1926[3];
dw dummy1927[6];
dd dummy1928[3];
dw dummy1929[6];
dd dummy1930[3];
dw dummy1931[6];
dd dummy1932[3];
dw dummy1933[6];
dd dummy1934[3];
dw dummy1935[6];
dd dummy1936[3];
dw dummy1937[6];
dd dummy1938[3];
dw dummy1939[6];
dd dummy1940[3];
dw dummy1941[6];
dd dummy1942[3];
dw dummy1943[6];
dd dummy1944[3];
dw dummy1945[6];
dd dummy1946[3];
dw dummy1947[6];
dd dummy1948[3];
dw dummy1949[6];
dd dummy1950[3];
dw dummy1951[6];
dd dummy1952[3];
dw dummy1953[6];
dd dummy1954[3];
dw dummy1955[6];
dd dummy1956[3];
dw dummy1957[6];
dd dummy1958[3];
dw dummy1959[6];
dd dummy1960[3];
dw dummy1961[6];
dd dummy1962[3];
dw dummy1963[6];
dd dummy1964[3];
dw dummy1965[6];
dd dummy1966[3];
dw dummy1967[6];
dd dummy1968[3];
dw dummy1969[6];
dd dummy1970[3];
dw dummy1971[6];
dd dummy1972[3];
dw dummy1973[6];
dd dummy1974[3];
dw dummy1975[6];
dd dummy1976[3];
dw dummy1977[6];
dd dummy1978[3];
dw dummy1979[6];
dd dummy1980[3];
dw dummy1981[6];
dd dummy1982[3];
dw dummy1983[6];
dd dummy1984[3];
dw dummy1985[6];
dd dummy1986[3];
dw dummy1987[6];
dd dummy1988[3];
dw dummy1989[6];
dd dummy1990[3];
dw dummy1991[6];
dd dummy1992[3];
dw dummy1993[6];
dd dummy1994[3];
dw dummy1995[6];
dd dummy1996[3];
dw dummy1997[6];
dd dummy1998[3];
dw dummy1999[6];
dd dummy2000[3];
dw dummy2001[6];
dd dummy2002[3];
dw dummy2003[6];
dd dummy2004[3];
dw dummy2005[6];
dd dummy2006[3];
dw dummy2007[6];
dd dummy2008[3];
dw dummy2009[6];
dd dummy2010[3];
dw dummy2011[6];
dd dummy2012[3];
dw dummy2013[6];
dd dummy2014[3];
dw dummy2015[6];
dd dummy2016[3];
dw dummy2017[6];
dd dummy2018[3];
dw dummy2019[6];
dd dummy2020[3];
dw dummy2021[6];
dd dummy2022[3];
dw dummy2023[6];
dd dummy2024[3];
dw dummy2025[6];
dd dummy2026[3];
dw dummy2027[6];
dd dummy2028[3];
dw dummy2029[6];
dd dummy2030[3];
dw dummy2031[6];
dd dummy2032[3];
dw dummy2033[6];
dd dummy2034[3];
dw dummy2035[6];
dd dummy2036[3];
dw dummy2037[6];
dd dummy2038[3];
dw dummy2039[6];
dd dummy2040[3];
dw dummy2041[6];
dd dummy2042[3];
dw dummy2043[6];
dd dummy2044[3];
dw dummy2045[6];
dd dummy2046[3];
dw dummy2047[6];
dd dummy2048[3];
dw dummy2049[6];
dd dummy2050[3];
dw dummy2051[6];
dd dummy2052[3];
dw dummy2053[6];
dd dummy2054[3];
dw dummy2055[6];
dd dummy2056[3];
dw dummy2057[6];
dd dummy2058[3];
dw dummy2059[6];
dd dummy2060[3];
dw dummy2061[6];
dd dummy2062[3];
dw dummy2063[6];
dd dummy2064[3];
dw dummy2065[6];
dd dummy2066[3];
dw dummy2067[6];
dd dummy2068[3];
dw dummy2069[6];
dd dummy2070[3];
dw dummy2071[6];
dd dummy2072[3];
dw dummy2073[6];
dd dummy2074[3];
dw dummy2075[6];
dd dummy2076[3];
dw dummy2077[6];
dd dummy2078[3];
dw dummy2079[6];
dd dummy2080[3];
dw dummy2081[6];
dd dummy2082[3];
dw dummy2083[6];
dd dummy2084[3];
dw dummy2085[6];
dd dummy2086[3];
dw dummy2087[6];
dd dummy2088[3];
dw dummy2089[6];
dd dummy2090[3];
dw dummy2091[6];
dd dummy2092[3];
dw dummy2093[6];
dd dummy2094[3];
dw dummy2095[6];
dd dummy2096[3];
dw dummy2097[6];
dd dummy2098[3];
dw dummy2099[6];

db vgaPalette[256*3];
dd selectorsPointer;
dd selectors[NB_SELECTORS];
dd stackPointer;
dd stack[STACK_SIZE];
dd heapPointer;
db heap[HEAP_SIZE];
db vgaRamPaddingBefore[VGARAM_SIZE];
db vgaRam[VGARAM_SIZE];
db vgaRamPaddingAfter[VGARAM_SIZE];
char *path;
} Memory;
#pragma pack(pop)
extern Memory m;
int program();
#define sizeOfeax 4
#define sizeOfebx 4
#define sizeOfecx 4
#define sizeOfedx 4
#define sizeOfesi 4
#define sizeOfedi 4
#define sizeOfebp 4
#define sizeOfesp 4
#define sizeOfcs 2
#define sizeOfds 2
#define sizeOfes 2
#define sizeOffs 2
#define sizeOfgs 2
#define sizeOfss 2
#define sizeOfbeginningdata  1
#define sizeOfdonoterasekeys  1
#define sizeOfliste_de_machin  4
#define sizeOfinfojoueur2  4
#define sizeOftecte2  4
#define sizeOfscrollyf  4
#define sizeOfscrolly  1
#define sizeOfspecial_clignotement  4
#define sizeOftrucs  1
#define sizeOflast_voice  4
#define sizeOfblow_what2  2
#define sizeOfblow_what  2
#define sizeOfbuffer  1
#define sizeOfmessage2  1
#define sizeOftotal_liste  4
#define sizeOfbigendianin  4
#define sizeOfbigendianout  4
#define sizeOfdataloaded  1
#define sizeOfclavier  1
#define sizeOftaille_exe_gonfle  4
#define sizeOfplaysoundfx  1
#define sizeOfmaster  1
#define sizeOfclavier_stuff  1
#define sizeOfclavier_stuff2  1
#define sizeOfclavier_extanded  1
#define sizeOfpal_pic  1
#define sizeOfpal_pic2  1
#define sizeOfpal_jeu  1
#define sizeOfpal_med  1
#define sizeOfpal_vic  1
#define sizeOfpal_draw  1
#define sizeOfisbigendian  1
#define sizeOftouches_  4
#define sizeOftected  1
#define sizeOftecte  1
#define sizeOfmessage1  1
#define sizeOfmessage3  1
#define sizeOfmess_kli  1
#define sizeOfmess_luc  1
#define sizeOfmess_frd  1
#define sizeOfmess_jag  1
#define sizeOfmess_din  1
#define sizeOfmess_jdg  1
#define sizeOfmess_rmd  1
#define sizeOfmess_ors  1
#define sizeOfmess_kor  1
#define sizeOfmess_sl1  1
#define sizeOfmess_adr  1
#define sizeOfmess_wil  1
#define sizeOfmess_exo  1
#define sizeOfmess_cl  1
#define sizeOfmess_ben  1
#define sizeOfmess_aaa  1
#define sizeOfmess_fzf  1
#define sizeOfmess_het  1
#define sizeOfmess_big  1
#define sizeOfmess_hak  1
#define sizeOfmess_jc  1
#define sizeOfdefo  1
#define sizeOftruc_fin_s  1
#define sizeOftruc_fin_soccer  1
#define sizeOftruc_fin_s_c  1
#define sizeOftruc_fin_s_m  1
#define sizeOftruc_fin_s_n  1
#define sizeOftruc_s  1
#define sizeOftruc_foot  1
#define sizeOftruc_soccer  1
#define sizeOftruc_n  1
#define sizeOftruc_c  1
#define sizeOftruc_h  1
#define sizeOftruc_f  1
#define sizeOftruc_neige  1
#define sizeOftruc2_save_foot  1
#define sizeOftruc2_save  1
#define sizeOftruc2_save_n  1
#define sizeOfia  4
#define sizeOfoffset_supporter  1
#define sizeOfoffset_cameraman  1
#define sizeOfdifferentesply  4
#define sizeOfoffset_pause  4
#define sizeOfoffset_si  4
#define sizeOfliste_couleur_malade  4
#define sizeOflove_si  1
#define sizeOfiff_file_name  1
#define sizeOfreccord  1
#define sizeOfreccord3  1
#define sizeOfreccord2  1
#define sizeOfsuite  1
#define sizeOfsuite2  1
#define sizeOfsuite3  1
#define sizeOfcfgerror  1
#define sizeOferrorcfg  1
#define sizeOfmessage_mem_rp  1
#define sizeOfokcfg  1
#define sizeOfokcfg3  1
#define sizeOfwin  1
#define sizeOfnowin  1
#define sizeOfterminalor  1
#define sizeOfnulosproduction  1
#define sizeOfstat1  1
#define sizeOfstat2  1
#define sizeOfstat3  1
#define sizeOfgameover  1
#define sizeOfno_server_  1
#define sizeOfselect_server_  1
#define sizeOfcnx1  1
#define sizeOftransformateur_98  1
#define sizeOfcnx2  1
#define sizeOfload_pcx_interne  4
#define sizeOfload_handle  4
#define sizeOfadresse_des_fonds  4
#define sizeOfadresse_des_fonds_foot  4
#define sizeOfadresse_des_fonds_neige  4
#define sizeOfadresse_des_fonds_final  4
#define sizeOfadresse_des_fonds_foret  4
#define sizeOfadresse_des_fonds_nuage  4
#define sizeOfadresse_des_fonds_crayon  4
#define sizeOfadresse_des_fonds_soccer  4
#define sizeOfnombre_de_fond  4
#define sizeOfadresse_des_draws  4
#define sizeOfnombre_de_draw  4
#define sizeOfadresse_des_vic  4
#define sizeOfnombre_de_vic  4
#define sizeOfkelle_donnee  4
#define sizeOfkelle_fin  4
#define sizeOfkelle_truc  4
#define sizeOfkelle_bonus  4
#define sizeOfkelle_apocalypse  4
#define sizeOfkelle_duree  4
#define sizeOfoffset_briques  2
#define sizeOfkelle_offset_fond  4
#define sizeOfkel_viseur_brike_fin  2
#define sizeOflapin_mort  2
#define sizeOflapin_mortg  2
#define sizeOflapin2  2
#define sizeOflapin2g  2
#define sizeOflapin2___  2
#define sizeOflapin2___g  2
#define sizeOflapin2_  2
#define sizeOflapin2_g  2
#define sizeOflapin2__  2
#define sizeOflapin2__g  2
#define sizeOfgrosbleu  2
#define sizeOfcoca  2
#define sizeOfescargot  2
#define sizeOfold_school  2
#define sizeOfbleu_triste  2
#define sizeOfmachine  2
#define sizeOfpetit_jaune  2
#define sizeOfblanc  2
#define sizeOfbleu  2
#define sizeOfrouge  2
#define sizeOfvert  2
#define sizeOfblancg  2
#define sizeOfbleug  2
#define sizeOfrougeg  2
#define sizeOfvertg  2
#define sizeOfoffset_ic  4
#define sizeOfcentral_b  2
#define sizeOfviseur_victory  4
#define sizeOfviseur_victoryc  4
#define sizeOfviseur_victoryg  4
#define sizeOfviseur_name  4
#define sizeOfviseur_namec  4
#define sizeOfviseur_nameg  4
#define sizeOfoffset_medaille  2
#define sizeOfrandom_place  4
#define sizeOfloaderror  1
#define sizeOfdifferents_offset_possible  4
#define sizeOfpacked_liste  4
#define sizeOfiff_liste  4
#define sizeOfliste_terrain  1
#define sizeOfascii  1
#define sizeOfcouleurssss  1
#define sizeOflost_conney  1
#define sizeOfhazard_maladie  1
#define sizeOfcouleur  1
#define sizeOfcouleur_menu  1
#define sizeOfoffset_fille  2
#define sizeOfoffset_oiseau  4
#define sizeOffx  2
#define sizeOfliste_couleur_normal  4
#define sizeOfs_normal  4
#define sizeOfl_normal  2
#define sizeOfc_normal  2
#define sizeOfa_normal  4
#define sizeOfr_normal  4
#define sizeOfdonnee_s  2
#define sizeOfooo34  4
#define sizeOfdonnee_foot  2
#define sizeOfdonnee_soccer  2
#define sizeOfdonnee_h  2
#define sizeOfdonnee_n  2
#define sizeOfdonnee_c  2
#define sizeOfdonnee_f  2
#define sizeOfdonnee_s_neige  2
#define sizeOfmort_de_lapin  2
#define sizeOfsaut_de_lapin2  2
#define sizeOfsaut_de_lapin  2
#define sizeOfn_team  4
#define sizeOfc_team  4
#define sizeOfs_team  4
#define sizeOfinfojoueur  4
#define sizeOfpanning2  1
#define sizeOfreplayer_saver  4
#define sizeOfreplayer_saver2  4
#define sizeOfreplayer_saver3  4
#define sizeOfreplayer_saver4  4
#define sizeOfreplayer_saver5  1
#define sizeOfdonnee4  1
#define sizeOfattente  4
#define sizeOfnosetjmp  1
#define sizeOfnuage_sympa  4
#define sizeOfvise_de_ca_haut  4
#define sizeOfvise_de_ca_haut2  4
#define sizeOfadder_inser_coin  4
#define sizeOfviseur_ic2  4
#define sizeOfinser_coin  4
#define sizeOfacceleration  4
#define sizeOfattente_entre_chake_bombe  4
#define sizeOfnouvelle_attente_entre_chake_bombe2  4
#define sizeOfviseur__nouvelle_attente_entre_chake_bombe  4
#define sizeOfliste_bombbbb  4
#define sizeOfliste_bombbbb2  4
#define sizeOfspecial_nivo_6  4
#define sizeOfdifferentesply2  4
#define sizeOftemps_avant_demo  4
#define sizeOfttp  4
#define sizeOfarbre  4
#define sizeOfviseur_couleur  4
#define sizeOfattente_nouveau_esc  4
#define sizeOfnombre_de_dyna_x4  4
#define sizeOfchangeiny  4
#define sizeOfviseur_change_in  4
#define sizeOfviseur_change_in_save  4
#define sizeOfanti_bomb  4
#define sizeOfmachin2  4
#define sizeOfmachin3  4
#define sizeOfmachin  4
#define sizeOfduree_draw  4
#define sizeOfduree_med  4
#define sizeOfduree_vic  4
#define sizeOfaffiche_raster  4
#define sizeOfsave_banke  4
#define sizeOfattente_avant_draw  4
#define sizeOfattente_avant_med  4
#define sizeOfpic_time  4
#define sizeOfviseur_sur_fond  4
#define sizeOfviseur_sur_draw  4
#define sizeOfviseur_sur_vic  4
#define sizeOfcompteur_nuage  4
#define sizeOfchangementzz  4
#define sizeOfchangementzz2  4
#define sizeOfchangement  4
#define sizeOftruc  1
#define sizeOftruc2  1
#define sizeOftruc_x  1
#define sizeOftruc_y  1
#define sizeOftruc_monstre  1
#define sizeOftouches  4
#define sizeOfavance  4
#define sizeOfavance2  4
#define sizeOftouches_save  4
#define sizeOfaction  1
#define sizeOfvie  4
#define sizeOfvictoires  4
#define sizeOflatest_victory  4
#define sizeOfteam  4
#define sizeOfnombre_minimum_de_dyna  4
#define sizeOfinfos_j_n  4
#define sizeOfinfos_m_n  4
#define sizeOflast_bomb  4
#define sizeOfviseur_liste_terrain  4
#define sizeOfnombre_de_dyna  4
#define sizeOfnb_ai_bombermen  1
#define sizeOfnombre_de_monstres  4
#define sizeOfnombre_de_vbl_avant_le_droit_de_poser_bombe  4
#define sizeOfj1  4
#define sizeOfj2  4
#define sizeOfj3  4
#define sizeOfj4  4
#define sizeOfj5  4
#define sizeOfj6  4
#define sizeOfj7  4
#define sizeOfj8  4
#define sizeOfdonnee  2
#define sizeOfooo546  4
#define sizeOfliste_couleur  4
#define sizeOfnombre_de_coups  4
#define sizeOfclignotement  4
#define sizeOfpousseur  4
#define sizeOfpatineur  4
#define sizeOfvitesse_monstre  4
#define sizeOftribombe2  4
#define sizeOftribombe  4
#define sizeOfinvinsible  4
#define sizeOfblocage  4
#define sizeOflapipipino  4
#define sizeOflapipipino2  4
#define sizeOflapipipino3  4
#define sizeOflapipipino4  4
#define sizeOflapipipino5  4
#define sizeOflapipipino6  4
#define sizeOflapipipino7  4
#define sizeOfaction_replay  1
#define sizeOfordre2  1
#define sizeOfdetail  1
#define sizeOfmechant  1
#define sizeOfterrain  1
#define sizeOfteam3  1
#define sizeOfpauseur2  1
#define sizeOfbdraw666  1
#define sizeOfadder_bdraw  2
#define sizeOftemps  2
#define sizeOfkel_ombre  4
#define sizeOfombres  2
#define sizeOfbriques  2
#define sizeOfbombes  2
#define sizeOfcontrol_joueur  4
#define sizeOfcontrol_joueur2  4
#define sizeOfname_joueur  4
#define sizeOftemps_joueur  4
#define sizeOfnb_ordy_connected  4
#define sizeOflast_name  4
#define sizeOftotal_play  1
#define sizeOftotal_t  1
#define sizeOfdonnee2  1
#define sizeOfnick_t  1
#define sizeOflapin_mania  4
#define sizeOflapin_mania_malade  4
#define sizeOflapin_mania1  4
#define sizeOflapin_mania2  4
#define sizeOflapin_mania3  4
#define sizeOflapin_mania4  4
#define sizeOflapin_mania5  4
#define sizeOftruc_fin  1
#define sizeOfordre  1
#define sizeOftexte1  1
#define sizeOfmaladie  2
#define sizeOfautofire  1
#define sizeOfbalance_le_bdrawn  1
#define sizeOfbdraw1  1
#define sizeOfon_les_dans_le_menu  1
#define sizeOfsortie_slave  1
#define sizeOfmodeinfo  1
#define sizeOfnomonster  1
#define sizeOftwice  1
#define sizeOftwice2  1
#define sizeOfpic_de_tout_debut  1
#define sizeOfune_touche_a_telle_ete_pressee  1
#define sizeOfsors_du_menu_aussitot  1
#define sizeOfteam3_sauve  1
#define sizeOfspecial_on_a_loadee_nivo  1
#define sizeOfrecord_user  1
#define sizeOfhazard_bonus  1
#define sizeOfviseur_hazard_bonus  4
#define sizeOfhazard_bonus2  1
#define sizeOfviseur_hazard_bonus2  4
#define sizeOfcorrespondance_bonus  1
#define sizeOfcorrespondance_bonus2  1
#define sizeOflast_sucker  1
#define sizeOfaffiche_pal  1
#define sizeOfpause  1
#define sizeOfpause2  1
#define sizeOftemps2  1
#define sizeOfsortie  1
#define sizeOfin_the_apocalypse  1
#define sizeOfpal  1
#define sizeOfpal_affiche  1
#define sizeOfliste_bombe  4
#define sizeOfliste_bombe_array  4

void fixBigEndian(void *data);
#ifdef __cplusplus
}
#endif
#endif


