# Changelog

<!--next-version-placeholder-->

## v2.9.4 (2023-01-28)
### Fix
* Semantic release python pypi receipe ([`495629a`](https://github.com/mps-youtube/yewtube/commit/495629ab78534a1a6b36a2adae2bc6c200083706))

## v2.9.3 (2023-01-28)
### Fix
* Updated readme metioned yewtube as fork of mpsyt ([`385d6a7`](https://github.com/mps-youtube/yewtube/commit/385d6a77708991d1d27371067023b253c2d14770))

### Documentation
* Fix broken readme links ([`6d2d723`](https://github.com/mps-youtube/yewtube/commit/6d2d723e13d18854ab0a2c8c4364ff5a1c99b5d9))

## v2.9.2 (2023-01-26)
### Fix
* Remove pyreadline dependency (#105) ([#107](https://github.com/iamtalhaasghar/yewtube/issues/107)) ([`19e4148`](https://github.com/iamtalhaasghar/yewtube/commit/19e4148242380b543a4825962716550114984f11))

## v2.9.1 (2023-01-26)
### Fix
* #50 - brought back download audio file ([`b46dab4`](https://github.com/iamtalhaasghar/yewtube/commit/b46dab47e61c68efa0e51836a8cc9141d15d9e87))

## v2.9.0 (2022-10-20)
### Feature
* **mplayer:** Set cache ([#93](https://github.com/iamtalhaasghar/yewtube/issues/93)) ([`16d3a18`](https://github.com/iamtalhaasghar/yewtube/commit/16d3a186fb9feb24530e1f07b211062c44a515a0))

### Fix
* #76 video pops up ([`eaeff58`](https://github.com/iamtalhaasghar/yewtube/commit/eaeff58f94e2fd89706e42fdab6b8e82ef770941))

## v2.8.5 (2022-09-08)
### Fix
* #75 program crashes while creating custom playlist and saving it without playing ([`2552eff`](https://github.com/iamtalhaasghar/yewtube/commit/2552eff602683fbd28bc6841768bf6cf585fc960))
* **main:** Handle error when setting locale ([#86](https://github.com/iamtalhaasghar/yewtube/issues/86)) ([`ecd117c`](https://github.com/iamtalhaasghar/yewtube/commit/ecd117ca1ef753509b78082d6f919c9bc2b1756b))
* Enable quit-watch-later in mpv #77 ([`079e440`](https://github.com/iamtalhaasghar/yewtube/commit/079e44088260c938dc3ae71cd55146fb51de653e))

### Documentation
* Added common issues file. ([#91](https://github.com/iamtalhaasghar/yewtube/issues/91)) ([`4b69e5e`](https://github.com/iamtalhaasghar/yewtube/commit/4b69e5ee96ed36efa9a68f6315322ed3d44d1e3d))

## v2.8.4 (2022-05-05)
### Fix
* #53 viewing playlists uploaded by a user is back ([`f201cb5`](https://github.com/iamtalhaasghar/yewtube/commit/f201cb5f4cd45b9341ced6b549fc35a57e85eb9f))

## v2.8.3 (2022-04-25)
### Fix
* #45 fetch all videos of a playlist ([`261f468`](https://github.com/iamtalhaasghar/yewtube/commit/261f4687668c6c05415102c66587a27518bbac10))
* Save full playlists by name and all its videos ([`d69a959`](https://github.com/iamtalhaasghar/yewtube/commit/d69a9594c5824d97201774e81444b75aea93e861))
* #67  vlc dummy Interface does not work with live channels  ([`2d4637b`](https://github.com/iamtalhaasghar/yewtube/commit/2d4637b04b6f738ab832b3beacab1e490e99a518))

## v2.8.2 (2022-03-17)
### Fix
* #63 module album search crash ([`3f2fcfb`](https://github.com/iamtalhaasghar/yewtube/commit/3f2fcfb27bb60928282d1a4a68adff22980f5938))

## v2.8.1 (2022-03-08)
### Fix
* #54 play video using youtube short link ([`92d1c77`](https://github.com/iamtalhaasghar/yewtube/commit/92d1c776d4bcc47509becadc5ba9248477dc0dcc))
* Use mkdocs instead of sphinx docs ([`32a2e9c`](https://github.com/iamtalhaasghar/yewtube/commit/32a2e9cdddac3ebb458d7bdcd793ed83ccc2fdf0))

## v2.8.0 (2022-02-28)
### Feature
* **helptext:** Help changelog ([`0643941`](https://github.com/iamtalhaasghar/yewtube/commit/06439411d7a78fe6701f7313e9b3b0720248a197))
* **setup:** Extras dependencies for mpris ([`936e890`](https://github.com/iamtalhaasghar/yewtube/commit/936e8909b5212eda3a64e8b93be79d4353e6d646))

### Fix
* #37 use `set pages` command to config how many search result pages to show ([`2baec5f`](https://github.com/iamtalhaasghar/yewtube/commit/2baec5fd11c0edf88d3543dd81333c5ecf67c918))
* #44 dont run init when importing mps_youtube ([`a072c22`](https://github.com/iamtalhaasghar/yewtube/commit/a072c22e2781160bca79d0164e46e49f07ac28e1))
* **mpris:** Handle no data on time-pos ([`8bb29d3`](https://github.com/iamtalhaasghar/yewtube/commit/8bb29d33825ad826e51d9d8eada32a9b7bd10ffd))
* #39 key error 'data' ([`834ed5b`](https://github.com/iamtalhaasghar/yewtube/commit/834ed5b0af5f92e1233e8ba327327654f67f61a0))
* #38 improved help menu responsiveness ([`972b4ef`](https://github.com/iamtalhaasghar/yewtube/commit/972b4efdb5fe8f5d3295b1c3fe607d209e7d39b6))
* #35 remove api key instructions ([`4f1fee3`](https://github.com/iamtalhaasghar/yewtube/commit/4f1fee3b711b2383b2704fba39bdce772894cc75))
* #24 colorama support for windows ([`9cf2616`](https://github.com/iamtalhaasghar/yewtube/commit/9cf261615a52f6ac64b6fb28390db2a71a7ab470))

## v2.7.0 (2022-02-19)
### Feature
* Use yewtube over tor using torsocks 🔥 ([`1e9c4ce`](https://github.com/iamtalhaasghar/yewtube/commit/1e9c4ce5992528286f552c8b563daef4abf9566a))

## v2.6.9 (2022-02-19)
### Fix
* #28 show changelog with `help new` command ([`d52b65d`](https://github.com/iamtalhaasghar/yewtube/commit/d52b65d0c0cd8708020a2d6788102d82d8ebeee5))

## v2.6.8 (2022-02-19)
### Fix
* fixed #26 album search working now without youtube api ([`9c3ae03`](https://github.com/iamtalhaasghar/yewtube/commit/9c3ae03b8c0ae006f1b9a917e4330270fec2f929))

## v2.6.7 (2022-02-19)
### Fix
* Check for app updates ([`eabfb52`](https://github.com/iamtalhaasghar/yewtube/commit/eabfb5233c7b87c5f300ebc41250a3f52db07411))
* Don't crash if playlists / history file has invalid youtube id fixed #24 ([`323d5d8`](https://github.com/iamtalhaasghar/yewtube/commit/323d5d822cefc23889665d71cfffe9e40750433b))

## v2.6.6 (2022-02-18)
### Fix
* Playlists are working again fixed #18 ([`bfceee4`](https://github.com/iamtalhaasghar/yewtube/commit/bfceee493261d099c85bf2c4c9e79e5710e9799f))
* Buffersize warning ([`d185c3f`](https://github.com/iamtalhaasghar/yewtube/commit/d185c3fdf8d520bcb4595f5e458d6022a7b6d1aa))
* **g:** Mpv msglevel ([`062b125`](https://github.com/iamtalhaasghar/yewtube/commit/062b12503a8fa15dc720cf3ac91f001b74a5cf10))

## v2.6.5 (2022-02-17)
### Fix
* Default player priority is vlc > mpv > mplayer on first install fixed #16 ([`35409eb`](https://github.com/iamtalhaasghar/yewtube/commit/35409eb31cc67f03c50589e02cdff2ad08fe4911))
* **mplayer:** _get_mplayer_version ([`ab21c5d`](https://github.com/iamtalhaasghar/yewtube/commit/ab21c5d1bc872ed482bf482ad37949129c1e4f78))
* Bring back requirements.txt to life ([`ff6e59d`](https://github.com/iamtalhaasghar/yewtube/commit/ff6e59d75834c61d72ec6bbc92f5eb339cc82607))
* **util.uea_pad:** Handle AttributeError on t.split ([`1643266`](https://github.com/iamtalhaasghar/yewtube/commit/1643266f21ccf7a99481a1615b4a53c4fbabc878))

## v2.6.4 (2022-02-16)
### Fix
* Duplicate changelog and readme files ([`0265ef7`](https://github.com/iamtalhaasghar/yewtube/commit/0265ef7507b539791684bdcf40b30ddaafc525e8))

## v2.6.3 (2022-02-16)
### Fix
* Welcome from semantic release python ([`c237a68`](https://github.com/iamtalhaasghar/yewtube/commit/c237a6808869062036f5196775352c1504eafe06))

# yewtube was forked from mps-youtube
### Features
* was made to work without YouTube API v3
* play music in vlc with no gui
<br>
<br>
<hr>
<br>
<br>
Version 0.2.8
17 February 2018

Features:
---------

- Lastfm scrobbling (@rien333) (#758)
- `splaylist` and `suser` commands for Spotify (@ritiek) (#678)
- Autoplay support (@nikhilweee) (#594)
- `genpl` command (@nishanthkarthik) (#642)
- `video_format` configuration setting (@Vrihub) (#656)
- `live` command for live streams (@Razesdark) (#635)
- Add time column (@akaWolf) (#582)
- Add video ID column (@Razesdark) (#627)
- Allow filtering search by duration (@jas32096) (#548)
- Allow filtering search by date (@jas32096) (#553)
- Add `history recent` to display history without duplicates (@srvanrell) (#510)
- `--no-textart` to disable ascii art (for screenreaders) (@Gongreg) (#517)
- `set_title` option to disable setting window title (@ardrabczyk) (#498)
- Add `s` command for getting stream information (@ritiek) (#675)
- Add option to disable mpris (@hrnr) (#728)
- Generate playlist from video description (@Razesdark) (#649)

Enhancements:
-------------
- Store playlists as m3u files instead of binary (@kraetzin) (#682)
- Show replies when displaying comments (@paulfertser) (#677)
- Use https urls for album art (@vszakats) (#574)
- When using "repeat" with mpv, keep player running (@ritiek) (#660)
- Display artist/album in mpris using lastfm (@vn-ki) (#739)
- Use channel.list API for user search (@Razesdark) (#628)
- Maintain volume across songs with mpv (@Razesdark) (#720)
- Prevent mpris from crashing the main process (@hrnr) (#728)

Bug fixes:
----------
- Fix mpris seeking with recent mpv vesions (@mg6) (#687)
- Fix removing video from multi-page playlist (@kraetzin) (#695)
- Skip unavailable tracks (@ritiek) (#734)
- Correctly display minutes/seconds (@Laxa) (#748)
- Handle `null` time-pos from mpv (@pritambaral) (#519)
- Fix da/dv command regex (@Vrihub) (#691)
- Skip channels in video/playlist searches (@ritiek) (#664)
- Fix divide by zero error (@ids1024) (#620)

Use `git log v0.2.7.1..v0.2.8` to see all changes, including various minor
fixes, documentation changes, etc. not included here.

-------------------------------------------------------------------------------

Version 0.2.7.1
6 July 2016

Bug fixes:
----------
- Fix pickle error (@ids1024) (#503)
- Install LICENSE, README.md, and CHANGELOG as package_data (@ids1024)
- Update youtube-dl in py2exe build (@ids1024)

-------------------------------------------------------------------------------

Version 0.2.7
27 June 2016

Features:
---------
- Setting for default audio format (@nishanthkarthik) (#71 #466 #467)
- Search history with `history` command (@kraetzin) (#344 #472)
- Add syntax for repeating a track several times (@ghallak) (#437 #490)
- Reverse command (@kraetzin) (#422 #473)
- New `daurl <url>` command (@maricn) (#402)

Enhancements:
-------------
- Pass `--no-ytdl` to mpv (@ids1024) (#492)
- Do not suppress mpv output in debug mode (@ids1024)
- Print traceback in debug mode (@ids1024)
- Speed up `checkupdate` by avoiding redirects (@ids1024) (#454)
- Pass `--play-and-exit` if vlc is used as a player (@ids1024)`

Bug fixes:
----------
- Fix error with python 3.3 (@ids1024) (#414)
- Fix maxres bug (@ids1024) (#430)
- Fix playlist cache bug in info command (@ids1024) (#468)
- Fix usersearch argument error (@ids1024) (#469 #482)
- Fix progress bar with new mpv versions (@ids1024) (#470 #485)
- Fix syntax error with set command (@ids1024) (#419)
- Fix syntax error with -w, -f, -a (@ids1024) (#420)
- Fix clipboard support (@ids1024) (#461)
- Fix mpv version checking on windows (@ids1024) (#397)
- Add youtube_dl as dependency to Dockerfile (@PI-Victor) (#481)

Internal api changes:
---------------------
- The code is now split between several files (@ids1024) (#208)
- Add initial content api, for now only used for comments (@ids1024)
- Begin documenting internal apis using sphinx (@ids1024)

-------------------------------------------------------------------------------

Version 0.2.6
1 January 2016

Features:
- Add browserplay command to play video in browser (rjvani) (#355 #390)
- Make url command support multiple url, and allow loading urls from file
    (paulnicolet) (#90 #391)
- Make youtube id available to download command (ids1024) (#375)
- Make pagination work properly for all lists of songs (local playlists, etc.)
    and make them all support the dump command (ids1024) (#201)
- Show warning when adding duplicate track to playlist (BensonQiu) (#374 #383)

Bug fixes:
- Support playlists longer than 200 items (ids1024) (#192)
- Make dapl download complete playlist (JKatzwinkel) (#294 #325)
- Use pyperclip instead of xerox, fixing clipboard on linux (ids1024) (#311)
- Fix error message on windows when video title has & (ids1024) (#321)
- Run notifier command in background (hrnr) (#339)
- Correctly handle -v option of play (TimoDritschler) (#352)
- Make it possible to use a pager with --help (livingBEEF) (#349)
- Allow mplayer for https streams if version is new enough
    (ids1024 Evidlo paddatrapper) (#315 #336 #317)
- Use mpv.com instead of mpv.exe on windows (ids1024)

Internal API changes:
- Split code into several files (still a work in progress) (ids1024) (#208)
- Use a python decorator to declare commands (ids1024)
- Create a paginatesongs() function for handling the pagination and dump
  command uniformly as mentioned in features (#399) (ids1024)
- Various others

There have been various other small bug fixes and internal API changes. Use
`git log v0.2.5..0.2.6` to see all of them.

-------------------------------------------------------------------------------

Version 0.2.5
1 June 2015

- Support python 3 only (will not run with python 2)
- Fix progress bar bug on Windows (#215, #223)
- Fix bug in playlist search (#282)
- Add user_order setting for separate order of user searches (lol768) (#277)
- Add mix command (lol768) (#241, #283)
- Add page count with total number of pages and current page (JKatzwinkel)
- Fix UnicodeEncodeError on non-unicode terminals
- Install .desktop in setup.py so it does not have to be installed manually
    required for Ubuntu sound menu support

-------------------------------------------------------------------------------

Version 0.2.4
13 May 2015

 - Fix issue with rate-limiting in "album" command (#217)
 - Implement support for MPRIS (hrnr and ids1024) (#191, #210)
 - Fix display issue with small terminal width (#215)
 - Use version 3 of the youtube api (JKatzwinkel, ids1024, and lol768) (#256)
     version 2 was disabled by youtube and no longer works

-------------------------------------------------------------------------------

Version 0.2.3
17 February 2015

 - Fix issue with opening old playlist file (#214)
 - Fix issue with "set" command
 - Metadata tagging of downloaded audio files
     requires ffmpeg or avconv
     early implementation, uses YouTube video title, needs more work

-------------------------------------------------------------------------------

Version 0.2.2
14 February 2015

- Implement skip to previous track (ids1024) #175 #18 #14
    Use > and < keys for next and prev track, q for quit (was ctrl-c)
    mpv / mplayer input.conf can be imported to use custom keymappings

- Implement optional external download application (ids1024 and np1) #198 #132
    enter "help dl-command" for more info

- Show stream quality on status line (Brebiche38) #134 #163

- Implement support for creating Windows builds with py2exe (ids1024) #190
    Use setup.py in py2exe branch

- Fix progress bar for mpv 0.7 (ids1024) #155 #161
    Resolves issues with playback looping

- Fix mps-youtube does not run on FreeBSD (nivit)

- Fix YouTube comments overshoot window size

- Fix issue with audio remux when using `d` download command

-------------------------------------------------------------------------------

Version 0.2.1
27 November 2014

[Bugfix] - Detect installed player on installation (#149)

-------------------------------------------------------------------------------

Version 0.2.0
25 November 2014

- Auto detect terminal window size

- Transcode audio to MP3 and other formats (requires ffmpeg or avconv)

- Enabled da and dv commands for playlist search results

- Added dapl and dvpl to download YouTube playlist audio/video
    by url/id to a separate subdirectory (mtahmed) #110

- Progress indicator now works with mpv (previously only mplayer)

- Added option to show system notifications (Alex Nisnevich) #95
    (can be used with libnotify - notify-send on linux)

- Added overwrite true/false option for downloads (mtahmed) #93
    (skips download if downloaded file already exists)

- Added copy to clipboard feature #97
    (requires python xerox module and xclip on linux or pywin32 on windows)

- Remux audio downloads for better file compatibility (#135)

[Bugfix] - Accept two-character length usernames (#99)

[Bugfix] - Expand ~ character in download directory setting (punchagan)

[Bugfix] - Don't truncate filename (YoussF) #122

[Bugfix] - Exit with correct status code

-------------------------------------------------------------------------------

Version 0.01.46
May 18 2014

 - Added c <number> to view comments for a video
    (first 50 comments, no reply-comments)

 - Added feature to match album tracks using MusicBrainz (vixus0)
    To search albums, enter "album" optionally followed by album title

 - Custom formatted search result list using "set columns" command
   Optionally shows: rating, likes, dislikes, views, user, date, category
   and comments (number of) in search results

 - Added "set order <relevance|views|rating|date>" command for
     specifying search result ordering

 - Added "set console-width" for setting output width (default 80)

 - Added uploaded date in video info display (request #64)

 - Added likes / dislikes in video info display

-------------------------------------------------------------------------------

Version 0.01.44
Mar 27 2014

 - Added max_res config item for selecting video resolution (request 56)
 - Added window_size and window_pos for selecting size / position of player
 - Improved handling of playlist file read/write (issue 66)
 - Revert to lower quality on unavailable/corrupt streams (issue 65)
 - Enabled multiple invocation commands (comma separated) (request 61)
    Eg: mpsyt //the doors, 1, shuffle, 1-3-a, quit
 - Improved url caching
 - Added shuffle command (no arguments, shuffles displayed items)
 - Handle 'video not available in your country' during multiple downloads
 - Fix UnicodeDecodeError in mplayer progress parsing (issue 58)
 - Fix UnicodeEncodeError under Windows with Python 2.7 (issue 59)

-------------------------------------------------------------------------------

Version 0.01.41
Mar 14 2014

 - new configuration option, max_results - sets number of returned results
    (1 - 50)
 - pl <url> now accepts YouTube playlist id's as well as url's
 - Fix error in download of .m4a files when mplayer is set as player.
 - Added option for downloading multiple items
     eg. da 1-4 or dv 3,5,6

-------------------------------------------------------------------------------

Version 0.01.40
Mar 11 2014

 - Bugfix release, corrects UnicodeDecode error

-------------------------------------------------------------------------------

Version 0.01.39
Mar 10 2014

Features:
 - Added time / progress bar indicator. Big thanks to Thomas LÉVEIL!
    (mplayer only)
 - Added command to retrieve YouTube user playlists; 
    userpl {username} or upl {username}
 - Added command to retrieve related videos; r{number}
 - playurl now respects -f, -w, and -a flags (fullscreen, window or audio)
 - Implemented input history persistence (uses readline, linux only)
 - Implemented non-interactive mode for command line invocation with playurl
 - Implemented less interactive mode for command line invocation with dlurl

Changes:
 - // or .. prefix to search for YouTube playlists (was plsearch / pls)

Help / Documentation:
 - help <command> will show relevant help topic page e.g., help dlurl
 - Documented configuration options ("set" commands)
 - Re-authored some help categories
 - Changed help <number> to help <topic>, removed menu from help pages

Bugfixes
 - mplayer / mpv window now displays content title instead of url
 - Fixed issue with Python3 terminal output on playback ctrl-c interrupt
 - Fixed issue with debug mode not logging to file
 - Changed year format in YT playlist result screen to last two digits.
      (Under some environments it was showing 4-digit years)

-------------------------------------------------------------------------------

Version 0.01.38
Mar 5 2014

 - Added i<number> for YT playlist information display 
 - Added stream url preloading for first item of opened YT playlists
 - Added last-updated date to YT playlist search result list 
 - Fixed UnicodeError when run in non-UTF8 environments
 - Added more verbosity to --version command line option
 - Added --debug command line option (logs to <tmpdir>/mpsyt.log)

-------------------------------------------------------------------------------

Version 0.01.37
Mar 2 2014

 - Excluded YouTube paid videos from search results
 - Added "pl <playlist url>" command to open YouTube playlist url
 - Added "plsearch <query>" command to search for YouTube playlists
 - Added "dump" command to show entire YT playlist (useful for saving locally)
 - Added "undump" command to undo dump (re-paginates YT playlist items)
 - Added "u <number>" command to list uploads by uploader of <number>
 - Added "url <YouTube url>" command for retrieving a specific YT video
 - Added "playurl <YouTube url>" command for directly playing a YT video
 - Added "dlurl <YouTube url>" command for directly downloading a YT video
 - Changed command to list user uploads, new syntax is "user <username>"
 - Added mpsyt --version flag for printing version info
 - Added mpsyt --help flag for printing help text
 - Fixed indentation bug when scrolling through readline history

-------------------------------------------------------------------------------

Version 0.01.36
Feb 27 2014

 - Wait for preloading item if it is selected while preloading
 - Fix bug where -a audio override is sometimes ignored

-------------------------------------------------------------------------------

Version 0.01.35
Feb 25 2014

 - Faster opening of audio streams with mpv 
    (--demuxer-lavf-o=fflags=+ignid argument added for m4a streams)

 - Faster opening of audio streams with mplayer 
    (reject m4a streams, prefer ogg streams)
    (fallback to video stream and suppress video when no ogg available)

-------------------------------------------------------------------------------

Version 0.01.34
Feb 22 2014

 - Fix bug: fails when no playlist file exists

-------------------------------------------------------------------------------

Version 0.01.33
Feb 22 2014

 - Changed structure of playlist file. Now consumes KB's rather than MB's
 - Same playlist file shared between Python2.7+ and Python3+ (was separate)
 - Improved display alignment for Russian text
 - Preload of url fails silently on unobtainable items (previously crashed)
 - Added prompt to mux audio on m4v download (experimental)

-------------------------------------------------------------------------------

Version 0.01.32
Feb 17 2014

 - Improve display alignment with certain unicode characters
 - Fix crash when using 'set' command on Windows (thomasleveil)

-------------------------------------------------------------------------------

Version 0.01.31
Feb 13 2014

 - Migrate location of config directory to reflect new name
   (~/.config/mps-youtube)

