// Copyright 2010-2012, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#include "data_manager/user_pos_manager.h"

#include "base/base.h"
#include "base/singleton.h"
#include "dictionary/pos_group.h"
#include "dictionary/user_pos.h"

namespace mozc {

UserPosManager *UserPosManager::GetUserPosManager() {
  return Singleton<UserPosManager>::get();
}

namespace {
// The following header file is automatically generated and contains the
// definition of variable, kPOSToken, of type UserPOSImpl::POSToken.
// TODO(noriyukit): We may need to change the path to header file to avoid file
// name collision among platforms.
#include "dictionary/user_pos_data.h"

class MozcUserPOS : public UserPOS {
 public:
  MozcUserPOS() : UserPOS(kPOSToken) {
    DCHECK(kPOSToken != NULL);
  }
};
}  // namespace

const UserPOSInterface *UserPosManager::GetUserPOS() const {
  // TODO(noriyukit): We may want to stop using singleton here.
  return Singleton<MozcUserPOS>::get();
}

namespace {
// kLidGroup[] is defined in the following automatically generated header file.
#include "data_manager/pos_group_data.h"

class MozcPosGroup : public PosGroup {
 public:
  MozcPosGroup() : PosGroup(kLidGroup) {}
};
}  // namespace

const PosGroup *UserPosManager::GetPosGroup() {
  return Singleton<MozcPosGroup>::get();
}

}  // namespace mozc
