// Copyright 2010-2013, Google Inc.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
//     * Neither the name of Google Inc. nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// Metadata of OAuth2 client (used by OAuth2Util)

#ifndef MOZC_SYNC_OAUTH2_CLIENT_H_
#define MOZC_SYNC_OAUTH2_CLIENT_H_

#include <string>

namespace mozc {
namespace sync {

// There are several kinds of OAuth2 client with which we can access to Google
// APIs. See: https://code.google.com/apis/console/
// We support normal installed application and Chrome application now.
enum OAuth2ClientType {
  INSTALLED_APP,
  CHROME_APP
};

struct OAuth2Client {
  const string name_;
  const string client_id_;
  const string client_secret_;
  OAuth2ClientType client_type_;
  OAuth2Client(const string &name,
               const string &client_id,
               const string &client_secret,
               OAuth2ClientType client_type)
      : name_(name),
        client_id_(client_id),
        client_secret_(client_secret),
        client_type_(client_type) {}

  static OAuth2Client GetDefaultInstance();
};
}  // namespace mozc::sync
}  // namespace mozc

#endif  // MOZC_SYNC_OAUTH2_CLIENT_H_
