#!/usr/bin/python

from optparse import OptionParser
import dbus, glib, signal
import dbus.mainloop.glib
import os, fcntl, struct

inhibit_cookie = 0
main_loop = None

def sighandler(signum, frame):
	global main_loop
	if signum == signal.SIGTERM:
		glib.idle_add(uninhibit)

def check_lock(lockfile):
	# See if Firefox is still running by trying to lock it's lockfile
	if lockfile == None:
		return False

	fd = os.open(lockfile, os.O_WRONLY|os.O_CREAT|os.O_TRUNC, 0666)
	# This creates a flock struct
	lock = struct.pack("hhqqi", 1, 0, 0, 0, 0)
	lockfile = lock
	fcntl.fcntl(fd, fcntl.F_GETLK, lockfile)
	try:
		fcntl.fcntl(fd, fcntl.F_SETLK, lock)
		# If this was successful, then Firefox isn't running any more.
		# We just die like Firefox did
		exit(0)
	except IOError:
		# Firefox is still running
		os.close(fd)
		return True

def error_cb(error):
	print "Error: ", error
	exit(1)

def uninhibit_cb():
	global main_loop
	main_loop.quit()

def uninhibit():
	global inhibit_cookie
	bus = dbus.SessionBus()
	session_manager = bus.get_object('org.gnome.SessionManager', '/org/gnome/SessionManager')
	session_manager_iface = dbus.Interface(session_manager, dbus_interface='org.gnome.SessionManager')
	session_manager_iface.Uninhibit(inhibit_cookie, error_handler=error_cb, reply_handler=uninhibit_cb)

def inhibit_cb(cookie):
	global inhibit_cookie
	inhibit_cookie = cookie

def inhibit(app_id, flags, reason, xid):
	global cookie
	real_reason = "" if reason == None else reason
	real_xid = 0 if xid == None else xid
	bus = dbus.SessionBus()
	session_manager = bus.get_object('org.gnome.SessionManager', '/org/gnome/SessionManager')
	session_manager_iface = dbus.Interface(session_manager, dbus_interface='org.gnome.SessionManager')
	session_manager_iface.Inhibit(app_id, real_xid, real_reason, flags, error_handler=error_cb, reply_handler=inhibit_cb)

def parse_args():
	parser = OptionParser()
	parser.add_option("-a", "--app-id", type="string", dest="app_id")
	parser.add_option("-f", "--flags", type="int", dest="flags")
	parser.add_option("-r", "--reason", type="string", dest="reason")
	parser.add_option("-x", "--xid", type="int", dest="xid")
	parser.add_option("-l", "--lockfile", type="string", dest="lockfile")
	return parser.parse_args()

if __name__ == '__main__':
	(options, args) = parse_args()
	if options.flags == None or options.reason == None or (options.app_id == None and options.xid == None):
		exit(1)

	signal.signal(signal.SIGTERM, sighandler)
	main_loop = glib.MainLoop()
	dbus.mainloop.glib.DBusGMainLoop(set_as_default=True)
	glib.idle_add(inhibit, options.app_id, options.flags, options.reason, options.xid)
	glib.timeout_add_seconds(10, check_lock, options.lockfile)
	main_loop.run()

	exit(0)
