package Zemanta::Utils;

use warnings;
use strict;

sub _read_file {
	my $path = shift;
	open(CRED, "<", $path) or die("Can't read $path: $!\n");

	my $value;
	while(defined($value = <CRED>)) {
		last if $value and $value !~ /^#/;
	}
	close(CRED);

	return if $value =~ /^#/;

	chomp($value);
	return $value;
}

sub read_credential {
	my $path = shift;

	my $value = _read_file($path);
	$value = _read_file($value) if( -e $value );

	die("No credential found in $path\n") unless $value;

	return $value;
}

1;
