#!/usr/bin/perl -w
# CGI script to proxy GET & POST requests to the backend server.
# Optionally the requests are signed with a shared secret.
#
# Tomaz Solc, 11. 2. 2009
#
# Debian packages required: libwww-perl

use strict;

use CGI;

use LWP::UserAgent;
use HTTP::Request::Common qw(POST);
use Digest::MD5 qw(md5_hex);

use FindBin qw($Bin);
use lib "$Bin/lib";

use Zemanta::Utils;

my $backend_url = "http://api.zemanta.com/services/rest/0.0/";

my $q = new CGI;
my $ua = LWP::UserAgent->new(agent => "Zemanta JSON-Proxy/2.00");

# Return a simple, JSON-formatted error message
sub error {
	my ($msg) = @_;

	chomp($msg);
	print "Content-type: text/plain\n\n";
	print "{\"status\":\"fail\",\"error\":\"json-proxy.cgi: $msg\"}";
	exit(0);
}

sub sign_vars {
	my ($vars, $shared_secret) = @_;

	my $raw = $shared_secret . join("", sort {$a cmp $b} values %$vars);

	$vars->{'signature'} = md5_hex($raw);
}

sub main
{
	my %vars = $q->Vars();

	my $path = File::Spec->catfile(	$Bin,
					"SECRET" );

	if( -e $path ) {
		# This is Zemanta Pro. Attach signature to the request.
		my $shared_secret;
		eval { 
			$shared_secret = Zemanta::Utils::read_credential($path);
		};
		error($@) if $@;
		sign_vars(\%vars, $shared_secret);
	}

	my $req = POST $backend_url, \%vars;

	my $response = $ua->request($req);

	my $status = $response->status_line;

	print $response->headers->as_string;
	print "status: $status\n";
	print "\n";
	print $response->content;
}

&main();
