#ifndef USBWIZARD_H
#define USBWIZARD_H

#include <QtGui/QWizard>
#include <QtGui/QRadioButton>

class QLabel;
class QRadioButton;
class DiskDevice;
class QLineEdit;
class InfoButton;
class PopupWindow;
class QPushButton;
class ChooseMountPointWidget;
class QCheckBox;
class OptionsForFSWidget;
class QComboBox;
class QTextBrowser;
class UdevRule;

class DeviceView : public QRadioButton
{
	public:
		DeviceView(DiskDevice *device,const QString& buttonText) : QRadioButton(buttonText) {
			deviceCore = device;
		}
		DiskDevice *core() const {
			return deviceCore;
		}
		
		void setMountOptions(const QString& options) {
			mountOptions = options;
		}
		const QString& getMountOptions() const {
			return mountOptions;
		}
		
		void setMountPoint(const QString& point) {
			mountPoint = point;
		}
		const QString& getMountPoint() const {
			return mountPoint;
		}
	private:
		DiskDevice *deviceCore;
	
		QString mountOptions;
		QString mountPoint;
};

class UsbWizard : public QWizard
{
	Q_OBJECT
	signals:
		void ruleEdited(UdevRule *editedRule);
		void ruleCreated(UdevRule *createdRule);
	public slots:
		void setDefaultDevice(DiskDevice *device);
	public:
		UsbWizard(PopupWindow *popup,QWidget *parent = 0);
		~UsbWizard();
	
		void editUdevRule(UdevRule *udevRule);
	
		void setUsbDevices(const QList<DiskDevice *>& usbDevices);
		void addUsbDevice(DiskDevice *addedDevice);
		void removeUsbDevice(DiskDevice *removedDevice);
		
		void setMountOptionsForDevice(DiskDevice *device,const QString& mountOptions);
		void setMountPointForDevice(DiskDevice *device,const QString& mountPoint);
	protected:
		void closeEvent(QCloseEvent *event);
	private slots:
		void currentPageChanged(int id);
		void cancel();
		void finish();
	private:
		enum Pages { Introduction, ChooseDevice, DeviceDefinition, MountPoint, Options, AccessOptions, Result };
	
		DeviceView *chosenDeviceView;
		
		UdevRule *currentUdevRule;
		
		bool setDefaultDeviceDefinition;
		bool setDefaultMountPoint;
		bool setDefaultOptions;
		bool setDefaultAccessOptions;
		
		QPushButton *nextButton;
		QPushButton *finishButton;
		QPushButton *cancelButton;
	
		// Intro page
		QWizardPage *introPage;
		QLabel *introLabel;
	
		// Choose device page
		QWizardPage *chooseDevicePage;
		QLabel *chooseDeviceLabel;
		QList<DeviceView *> chooseDevices;
		QRadioButton *deviceNotConnected;

		// Device definition page
		QWizardPage *deviceDefinitionPage;
		QLabel *deviceDefinitionLabel;
	
		QLineEdit *deviceName;
		QLineEdit *vendorName;
		QLineEdit *modelName;
		QLineEdit *busName;
		QLineEdit *subsystemName;
	
		InfoButton *deviceNameInfoButton;
		InfoButton *vendorInfoButton;
		InfoButton *modelInfoButton;
		InfoButton *busInfoButton;
		InfoButton *subsystemInfoButton;
		
		// Mount point page
		QWizardPage *mountPointPage;
		QLabel *mountPointLabel;
		
		ChooseMountPointWidget *mountPoint;
		QCheckBox *removeMountPoint;
		
		// Options for automounting page
		QWizardPage *optionsPage;
		QLabel *optionsLabel;
		
		OptionsForFSWidget *optionsForFSWidget;
		
		// Access options page
		QWizardPage *accessOptionsPage;
		QLabel *accessOptionsLabel;
		
		QComboBox *groupName;
		QComboBox *ownerName;
		
		// Result page
		QWizardPage *resultPage;
		
		QTextBrowser *resultViewer;
};

#endif
