//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Gui
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QtGui/QLabel>
#include <QtGui/QDialog>
#include <QtGui/QIcon>
#include <QtGui/QVBoxLayout>
#include "aboutprogramdialog.h"
#include "const.h"

AboutProgramDialog::AboutProgramDialog(QWidget *parent) : QDialog(parent) {
	iconLabel = new QLabel;
	iconLabel->setPixmap(QPixmap(PROGRAM_ICON_PATH));
		
	textLabel = new QLabel;
	textLabel->setWordWrap(true);
	
	textLabel->setText("<center><h3>" + tr("MountManager - mounting in Linux is easy!") + "</h3></center>"
					+ "<b>" + tr("Developers") + ":</b> <br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Tikhonov Sergey</i><br>"
					+ "<b>" + tr("Assistans") + ":</b> <br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Devaev Maxim</i><br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Nasyrov Renat</i><br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Fomkin Vladimir</i><br>"
					+ "<b>" + tr("Testers") + ":</b> <br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Kolbin Yaroslav</i><br>"
						+ "&nbsp;&nbsp;&nbsp;&nbsp;<i>Ursul Alexey</i><br>"
					+ "<font size='2'>" + tr("Copyright (c) 2007-2008 Tikhonov Sergey and ViaLinx Laboratories. All offers and reports you can send to e-mail: <b>sstikhonov@gmail.com</b>") + "</font>");
			
	setWindowTitle(tr("About MountManager"));
	
	QHBoxLayout *iconLayout = new QHBoxLayout;
	iconLayout->addStretch();
	iconLayout->addWidget(iconLabel);
	iconLayout->addStretch();
	
	mainLayout = new QVBoxLayout;
	mainLayout->addLayout(iconLayout);
	mainLayout->addWidget(textLabel);
	
	setLayout(mainLayout);
	setFixedSize(sizeHint());
	setStyleSheet("QDialog { background: qlineargradient(x1: 0, y1: 0, x2: 1, y2: 1, stop: 0 white, stop: 0.5 #c8e4ef, stop: 1 white); }");
}

AboutProgramDialog::~AboutProgramDialog() {
	delete iconLabel;
	delete textLabel;
	
	delete mainLayout;
}
