//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#include <QXmlAttributes>
#include <QLocale>
#include <QDebug>
#include "diskoptionsparser.h"

DiskOptionsParser::DiskOptionsParser(QString language) {

	if (language.isEmpty()) {
		lang = QLocale().name();
		lang = lang.remove(lang.indexOf("_"),lang.length());
	} else
		lang = language;
	expertNow = false;
	valid = true;
	currentOption = 0;
	init();
}

DiskOptionsParser::~DiskOptionsParser() {
	foreach (Option *option,optionsList)
		delete option;
}

bool DiskOptionsParser::isValid() {
	return valid;
}

QList<Option *> DiskOptionsParser::options() {
	return optionsList;
}

void DiskOptionsParser::init() {
	currentOption = new Option;
	isValuesNow = false;
	isComboBoxItemsNow = false;
	areThereComboBoxItems = false;
	isAcceptComboBoxItems = false;
	comboBoxItemsLocale.clear();
	optionTitleLocale.clear();
	variantStatus.clear();
}

bool DiskOptionsParser::startElement(const QString& /*namespace*/,const QString& /*localName*/,const QString& qName, const QXmlAttributes& attributes) {
	if (qName == "options")
		optionsList.clear();
	else if (qName == "expert")
		expertNow = true;
	else if (qName == "option")
		init();
	else if (qName == "title")
		optionTitleLocale = attributes.value("lang");
	else if (qName == "values")
		isValuesNow = true;
	else if (qName == "show")
		isComboBoxItemsNow = true;
	else if (qName == "locale") {
		if (isComboBoxItemsNow) {
			comboBoxItemsLocale = attributes.value("name");
			if (comboBoxItemsLocale == lang || (! areThereComboBoxItems && comboBoxItemsLocale == "en"))
				isAcceptComboBoxItems = true;
				
		}
	}
	else if (qName == "variant") {
		if (isValuesNow)
			variantStatus = attributes.value("status");
	}
	return true;
}

bool DiskOptionsParser::characters(const QString& str) {
	tempText = str;
	return true;
}

bool DiskOptionsParser::endElement(const QString & /*namespaceURI*/, const QString & /*localName*/, const QString & qName) {
	if (qName == "expert")
		expertNow = false;
	else if (qName == "option") {
		if (!currentOption->optionTitle.isEmpty()) {
			if (currentOption->optionType == "ComboBox" && !areThereComboBoxItems)
				return true;
			currentOption->isExpertOption = expertNow;
			optionsList.append(currentOption);
		}
	}
	else if (qName == "title") {
		if ((currentOption->optionTitle.isEmpty() && optionTitleLocale == "en") || optionTitleLocale == lang)
			currentOption->optionTitle = tempText;
	}
	else if (qName == "type")
		currentOption->optionType = tempText;
	else if (qName == "values")
		isValuesNow = false;
	else if (qName == "show")
		isComboBoxItemsNow = false;
	else if (qName == "locale") {
		if (isAcceptComboBoxItems)
			areThereComboBoxItems = true;
	}
	else if (qName == "variant") {
		if (isValuesNow) {
			bool isCheckBoxChecked = false;
			if (!variantStatus.isEmpty()) {
				if (variantStatus.contains("default"))
					currentOption->optionDefaultValue = tempText;
				if (variantStatus.contains("checked"))
					isCheckBoxChecked = true;
			}
			Value *value = new Value;
			value->isChecked = isCheckBoxChecked;
			value->text = tempText;
			if (tempText == currentOption->optionDefaultValue)
				value->isDefault = true;
			else
				value->isDefault = false;
			currentOption->optionValues.append(value);
		}
		else if (isComboBoxItemsNow)
			if (isAcceptComboBoxItems)
				currentOption->optionComboBoxItems.append(tempText);
	}
	else if (qName == "docmark")
		currentOption->optionDocMark = tempText;
	else if (qName == "default")
		currentOption->optionDefaultValue = tempText;
	else if (qName == "maximum")
		currentOption->maximumValue = tempText;
	tempText.clear();
	variantStatus.clear();
	return true;
}

bool DiskOptionsParser::fatalError(const QXmlParseException &)
{
	valid = false;
	return false;
}

void DiskOptionsParser::setLanguage(const QString& newLanguage) {
	lang = newLanguage;
}

QString& DiskOptionsParser::language() {
	return lang;
}

const QString& DiskOptionsParser::language() const {
	return lang;
}
