//MountManager - the program for easy mounting of storage devices in Linux
//Copyright (C) 2007-2008 Tikhonov Sergey
//
//This file is part of MountManager Core
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#ifndef DISKOPTIONSCENTER_H
#define DISKOPTIONSCENTER_H

#include <QStringList>
#include <QMap>

class DiskOptionsParser;
class Option;
class QFile;
class QXmlSimpleReader;
class QXmlInputSource;

class DiskOptionsCenter
{
	private:
		DiskOptionsParser *optionsParser;
		QXmlSimpleReader *optionsReader;
		QFile *inputFile;
		QXmlInputSource *inputSource;
		void setSourcePath(const QString& sourcePath);

		QList<Option *> emptyOptions;
		QMap<QString, QList<Option *> > cache;
	public:
		DiskOptionsCenter(const QString& fileSystem = QString(),QString lang = QString());
		~DiskOptionsCenter();

		void setLanguage(const QString& language);

		QString& language();
		const QString& language() const;

		const QList<Option *>& fileSystemOptions(const QString& fileSystem);
};

#endif
