#include <QtGui/QLineEdit>
#include <QtGui/QVBoxLayout>
#include <QtCore/QTimer>
#include "sharesview.h"

const int SPEED = 15;

SharesView::SharesView() {
	toHide = false;
	
	timer = new QTimer;
	timer->setInterval(50);

	lineEdit = new QLineEdit;
	
	manageSharesWidget = new QWidget;
	manageSharesWidget->setAutoFillBackground(false);
	
	QVBoxLayout *manageSharesWidgetLayout = new QVBoxLayout;
	manageSharesWidgetLayout->addWidget(lineEdit);
	manageSharesWidgetLayout->setContentsMargins(5,5,5,5);
	manageSharesWidget->setLayout(manageSharesWidgetLayout);
	
	QVBoxLayout *mainLayout = new QVBoxLayout;
	mainLayout->addStretch();
	mainLayout->addWidget(manageSharesWidget);
	setLayout(mainLayout);
	
	connect(timer,SIGNAL(timeout()),this,SLOT(updateSize()));
	manageSharesWidget->setMaximumHeight(0);
}

SharesView::~SharesView() {
	delete timer;
	delete lineEdit;
	delete manageSharesWidget;
}

void SharesView::hideWithRolling() {
	toHide = true;
	timer->start();
}
	
void SharesView::showWithRolling() {
	toHide = false;
	timer->start();
}

void SharesView::updateSize() {
	if (toHide) {
		if (manageSharesWidget->height() + SPEED >= manageSharesWidget->sizeHint().height())
			manageSharesWidget->setMaximumHeight(manageSharesWidget->sizeHint().height());
		else
			manageSharesWidget->setMaximumHeight(manageSharesWidget->height() + SPEED);
		if (manageSharesWidget->height() != manageSharesWidget->sizeHint().height())
			timer->start();
	} else {
		if (manageSharesWidget->height() - SPEED <= 0)
			manageSharesWidget->setMaximumHeight(0);
		else
			manageSharesWidget->setMaximumHeight(manageSharesWidget->height() - SPEED);
		if (manageSharesWidget->height() != 0)
			timer->start();
	}
	manageSharesWidget->resize(manageSharesWidget->width(),manageSharesWidget->sizeHint().height());
}
