/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.CharLookupContainer;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import java.util.Arrays;

abstract class AbstractCharCollection
implements CharCollection {
    AbstractCharCollection() {
    }

    public int removeAll(CharLookupContainer c) {
        final CharLookupContainer c2 = c;
        return this.removeAll(new CharPredicate(){

            public boolean apply(char k) {
                return c2.contains(k);
            }
        });
    }

    public int retainAll(CharLookupContainer c) {
        final CharLookupContainer c2 = c;
        return this.removeAll(new CharPredicate(){

            public boolean apply(char k) {
                return !c2.contains(k);
            }
        });
    }

    public int retainAll(final CharPredicate predicate) {
        return this.removeAll(new CharPredicate(){

            public boolean apply(char value) {
                return !predicate.apply(value);
            }
        });
    }

    public char[] toArray() {
        int size = this.size();
        char[] array = new char[size];
        int i = 0;
        for (CharCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

