# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2007-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Philippe Normand <philippe@fluendo.com>

from elisa.core import media_uri
from elisa.plugins.thetvdb.constants import *

def get_series_lookup_url(search_term):
    """
    A little helper giving the API url call to use to search for a series
    on thetvdb.com

    @returns: the search URL that can be used in a get() call of the
              resource_provider.
    @rtype:   L{elisa.core.media_uri.MediaUri}
    """
    quoted_term = media_uri.quote(search_term)
    url = "http://%s/api/GetSeries.php?seriesname=%s" % (API_SERVER, quoted_term)
    return media_uri.MediaUri(url)

def get_episode_url(series_id, season, episode, lang):
    url = 'http://%s/api/%s/series/%s/default/%s/%s/%s.xml' % (API_SERVER,
                                                               API_KEY,
                                                               series_id,
                                                               season,
                                                               episode,
                                                               lang)
    return media_uri.MediaUri(url)
