# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
Some very incomplete unit tests for the box widget.
"""

from twisted.trial.unittest import TestCase

from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.box import Box, HBox


class TestBox(TestCase):

    def test_focus_empty(self):
        # A box that doesn't contain anything
        box = Box()
        self.failIf(box.focus)
        self.failUnless(box.set_focus())
        self.failUnless(box.focus)
        box.clean()

    def test_focus_children(self):
        # A box that contains focusable children
        box = HBox()
        child1 = Widget()
        child2 = Widget()
        box.pack_start(child1)
        box.pack_start(child2)
        self.failIf(box.focus)
        self.failIf(child1.focus)
        self.failIf(child2.focus)
        self.failUnless(box.set_focus())
        self.failUnless(box.focus)
        self.failIf(child2.focus)
        box.clean()

    def test_focus_non_widget_children(self):
        # A box that contains only non focusable children
        box = HBox()
        child1 = Image()
        child2 = Image()
        box.pack_start(child1)
        box.pack_start(child2)
        self.failIf(box.focus)
        self.failUnless(box.set_focus())
        self.failUnless(box.focus)
        box.clean()

    def test_focus_mixed_children(self):
        # A box that contains mixed children (focusable and non focusable)
        box = HBox()
        child1 = Image()
        child2 = Widget()
        box.pack_start(child1)
        box.pack_start(child2)
        self.failIf(box.focus)
        self.failIf(child2.focus)
        self.failUnless(box.set_focus())
        self.failUnless(box.focus)
        box.clean()
