# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

import pgm

from elisa.core.input_event import EventValue

from elisa.plugins.pigment.widgets.list import List


class ListVertical(List):

    def _compute_relative_spacing(self, spacing):
        fx, fy = self.get_factors_relative(spacing.unit)
        return fy*spacing.value

    def _prepare_all_widgets(self):
        self._relative_spacing = self._compute_relative_spacing(self._spacing)
        # total amount of spacing needed
        total_spacing = self._relative_spacing*(self._visible_range_size-1)

        self._item_width = 1.0
        self._item_height = (1.0-total_spacing)/self._visible_range_size

        for widget in self._widgets:
            widget.size = (self._item_width, self._item_height)

    def compute_y(self, index):
        return index*(self._item_height+self._relative_spacing)

    def _layout_widget(self, widget, position):
        widget.y = self.compute_y(position)
        widget.opacity = self.compute_opacity(position)

    def _prepare_selector(self):
        if self._selector != None:
            self._selector.position = (0.0, 0.0, 0.0)
            self._selector.size = (self._item_width, self._item_height)

    def _actual_layout_selector(self, selector, selected_item_index):
        selector.y = self.compute_y(selected_item_index)

    def handle_input(self, manager, event):
        if event.value == EventValue.KEY_GO_UP and \
           self.selected_item_index > 0:
            self.selected_item_index -= 1
            return True
        elif event.value == EventValue.KEY_GO_DOWN and \
             self.selected_item_index < len(self.model)-1:
            self.selected_item_index += 1
            return True
        if event.value == EventValue.KEY_PAGE_UP:
            self.selected_item_index -= (self.visible_range_size - 1)
            return True
        if event.value == EventValue.KEY_PAGE_DOWN:
            self.selected_item_index += (self.visible_range_size - 1)
            return True

        return super(ListVertical, self).handle_input(manager, event)

    # Signals support methods

    def do_drag_motion(self, x, y, z, button, time, pressure):
        if not self._dragging:
            return True

        time_since_last = time - self._last_drag_motion
        if time_since_last > self.drag_motion_resolution:
            self._last_drag_motion = time
        else:
            return True

        absolute_item_height = self._item_height*self.absolute_height
        motion = (y-self._initial[1])/absolute_item_height
        self.visible_range_start -= motion

        time_delta = time - self._initial[2]
        if time_delta != 0:
            self.speed = motion/time_delta*1000.0

        self._initial = (x, y, time)
        self._drag_accum += abs(motion)

        return True

if __name__ == "__main__":
    import logging
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    list = ListVertical.demo()
    list.size = (100.0, 200.0)
    try:
        __IPYTHON__
    except NameError:
        pgm.main()
