// Permission is hereby granted, free of charge, to any person obtaining 
// a copy of this software and associated documentation files (the 
// "Software"), to deal in the Software without restriction, including 
// without limitation the rights to use, copy, modify, merge, publish, 
// distribute, sublicense, and/or sell copies of the Software, and to 
// permit persons to whom the Software is furnished to do so, subject to 
// the following conditions: 
//  
// The above copyright notice and this permission notice shall be 
// included in all copies or substantial portions of the Software. 
//  
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, 
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF 
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE 
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION 
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION 
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. 
// 
// Copyright (c) 2008 Novell, Inc. (http://www.novell.com) 
// 
// Authors: 
//      Sandy Armstrong <sanfordarmstrong@gmail.com>
// 


using System;
using System.Reflection;

using Mono.Unix;
using Mono.WebBrowser;
using Mono.WebBrowser.DOM;

using System.Windows.Automation;
using AEIds = System.Windows.Automation.AutomationElementIdentifiers;
using SWF = System.Windows.Forms;

namespace Mono.UIAutomation.Winforms
{
	[MapsComponent (typeof (SWF.WebBrowser))]
	internal class WebBrowserProvider : FragmentControlProvider
	{
		private SWF.WebBrowser webBrowser;
		
		public WebBrowserProvider(SWF.WebBrowser webBrowser) : base (webBrowser)
		{
			this.webBrowser = webBrowser;
		}

		protected override object GetProviderPropertyValue (int propertyId)
		{
			if (propertyId == AEIds.ControlTypeProperty.Id)
				return ControlType.Pane.Id;
			else if (propertyId == AEIds.LocalizedControlTypeProperty.Id)
				return Catalog.GetString ("pane");
			else if (propertyId == AEIds.HasNativeAccessibilityObjectProperty.Id)
				return true;
			else if (propertyId == AEIds.NativeAccessibilityObjectProperty.Id) {
				PropertyInfo webProp = typeof (SWF.WebBrowserBase).GetProperty ("WebHost", BindingFlags.NonPublic | BindingFlags.Instance);
				IWebBrowser iweb = (IWebBrowser) webProp.GetValue (webBrowser, new object [] {});
	
				IntPtr raw = iweb.Document.FirstChild.AccessibleObject;
				if (raw == IntPtr.Zero)
					return null;
				Atk.Object obj = GLib.Object.GetObject (raw, false) as Atk.Object;
				//obj.Name = webBrowser.Name;
				return obj;
			} else
				return base.GetProviderPropertyValue (propertyId);
		}
	}
}
