/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.impl;

import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import org.apache.hadoop.metrics2.Metric;
import org.apache.hadoop.metrics2.MetricCounter;
import org.apache.hadoop.metrics2.MetricGauge;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.MetricsVisitor;
import org.apache.hadoop.metrics2.impl.MetricsRecordImpl;

class MBeanInfoBuilder
implements MetricsVisitor {
    private final String name;
    private final String description;
    private List<MBeanAttributeInfo> attrs;
    private Iterable<MetricsRecordImpl> recs;
    private int curRecNo;

    MBeanInfoBuilder(String name, String desc) {
        this.name = name;
        this.description = desc;
        this.attrs = new ArrayList<MBeanAttributeInfo>();
    }

    MBeanInfoBuilder reset(Iterable<MetricsRecordImpl> recs) {
        this.recs = recs;
        this.attrs.clear();
        return this;
    }

    MBeanAttributeInfo newAttrInfo(String name, String desc, String type) {
        return new MBeanAttributeInfo(this.getAttrName(name), type, desc, true, false, false);
    }

    MBeanAttributeInfo newAttrInfo(Metric m, String type) {
        return this.newAttrInfo(m.name(), m.description(), type);
    }

    @Override
    public void gauge(MetricGauge<Integer> metric, int value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Integer"));
    }

    @Override
    public void gauge(MetricGauge<Long> metric, long value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Long"));
    }

    @Override
    public void gauge(MetricGauge<Float> metric, float value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Float"));
    }

    @Override
    public void gauge(MetricGauge<Double> metric, double value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Double"));
    }

    @Override
    public void counter(MetricCounter<Integer> metric, int value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Integer"));
    }

    @Override
    public void counter(MetricCounter<Long> metric, long value) {
        this.attrs.add(this.newAttrInfo(metric, "java.lang.Long"));
    }

    String getAttrName(String name) {
        return this.curRecNo > 0 ? name + "." + this.curRecNo : name;
    }

    MBeanInfo get() {
        this.curRecNo = 0;
        for (MetricsRecordImpl rec : this.recs) {
            for (MetricsTag t : rec.tags()) {
                this.attrs.add(this.newAttrInfo("tag." + t.name(), t.description(), "java.lang.String"));
            }
            for (Metric m : rec.metrics()) {
                m.visit(this);
            }
            ++this.curRecNo;
        }
        MBeanAttributeInfo[] attrsArray = new MBeanAttributeInfo[this.attrs.size()];
        return new MBeanInfo(this.name, this.description, this.attrs.toArray(attrsArray), null, null, null);
    }
}

