/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.mapred.JobHistory;

public class DefaultJobHistoryParser {
    public static void parseJobTasks(String jobHistoryFile, JobHistory.JobInfo job, FileSystem fs) throws IOException {
        JobHistory.parseHistoryFromFS(jobHistoryFile, new JobTasksParseListener(job), fs);
    }

    static class KilledOnNodesFilter
    extends NodesFilter {
        KilledOnNodesFilter() {
        }

        @Override
        void setFailureType() {
            this.failureType = JobHistory.Values.KILLED.name();
        }
    }

    static class FailedOnNodesFilter
    extends NodesFilter {
        FailedOnNodesFilter() {
        }

        @Override
        void setFailureType() {
            this.failureType = JobHistory.Values.FAILED.name();
        }
    }

    static abstract class NodesFilter
    implements JobHistory.Listener {
        private Map<String, Set<String>> badNodesToNumFailedTasks = new HashMap<String, Set<String>>();
        String failureType;

        Map<String, Set<String>> getValues() {
            return this.badNodesToNumFailedTasks;
        }

        @Override
        public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
            if ((recType.equals((Object)JobHistory.RecordTypes.MapAttempt) || recType.equals((Object)JobHistory.RecordTypes.ReduceAttempt)) && this.failureType.equals(values.get((Object)JobHistory.Keys.TASK_STATUS))) {
                String hostName = values.get((Object)JobHistory.Keys.HOSTNAME);
                String taskid = values.get((Object)JobHistory.Keys.TASKID);
                Set<String> tasks = this.badNodesToNumFailedTasks.get(hostName);
                if (null == tasks) {
                    tasks = new TreeSet<String>();
                    tasks.add(taskid);
                    this.badNodesToNumFailedTasks.put(hostName, tasks);
                } else {
                    tasks.add(taskid);
                }
            }
        }

        abstract void setFailureType();

        String getFailureType() {
            return this.failureType;
        }

        NodesFilter() {
            this.setFailureType();
        }
    }

    static class JobTasksParseListener
    implements JobHistory.Listener {
        JobHistory.JobInfo job;

        JobTasksParseListener(JobHistory.JobInfo job) {
            this.job = job;
        }

        private JobHistory.Task getTask(String taskId) {
            JobHistory.Task task = this.job.getAllTasks().get(taskId);
            if (null == task) {
                task = new JobHistory.Task();
                task.set(JobHistory.Keys.TASKID, taskId);
                this.job.getAllTasks().put(taskId, task);
            }
            return task;
        }

        private JobHistory.MapAttempt getMapAttempt(String jobid, String jobTrackerId, String taskId, String taskAttemptId) {
            JobHistory.Task task = this.getTask(taskId);
            JobHistory.MapAttempt mapAttempt = (JobHistory.MapAttempt)task.getTaskAttempts().get(taskAttemptId);
            if (null == mapAttempt) {
                mapAttempt = new JobHistory.MapAttempt();
                mapAttempt.set(JobHistory.Keys.TASK_ATTEMPT_ID, taskAttemptId);
                task.getTaskAttempts().put(taskAttemptId, mapAttempt);
            }
            return mapAttempt;
        }

        private JobHistory.ReduceAttempt getReduceAttempt(String jobid, String jobTrackerId, String taskId, String taskAttemptId) {
            JobHistory.Task task = this.getTask(taskId);
            JobHistory.ReduceAttempt reduceAttempt = (JobHistory.ReduceAttempt)task.getTaskAttempts().get(taskAttemptId);
            if (null == reduceAttempt) {
                reduceAttempt = new JobHistory.ReduceAttempt();
                reduceAttempt.set(JobHistory.Keys.TASK_ATTEMPT_ID, taskAttemptId);
                task.getTaskAttempts().put(taskAttemptId, reduceAttempt);
            }
            return reduceAttempt;
        }

        @Override
        public void handle(JobHistory.RecordTypes recType, Map<JobHistory.Keys, String> values) throws IOException {
            String jobTrackerId = values.get((Object)JobHistory.Keys.JOBTRACKERID);
            String jobid = values.get((Object)JobHistory.Keys.JOBID);
            if (recType == JobHistory.RecordTypes.Job) {
                this.job.handle(values);
            }
            if (recType.equals((Object)JobHistory.RecordTypes.Task)) {
                String taskid = values.get((Object)JobHistory.Keys.TASKID);
                this.getTask(taskid).handle((Map)values);
            } else if (recType.equals((Object)JobHistory.RecordTypes.MapAttempt)) {
                String taskid = values.get((Object)JobHistory.Keys.TASKID);
                String mapAttemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                this.getMapAttempt(jobid, jobTrackerId, taskid, mapAttemptId).handle((Map)values);
            } else if (recType.equals((Object)JobHistory.RecordTypes.ReduceAttempt)) {
                String taskid = values.get((Object)JobHistory.Keys.TASKID);
                String reduceAttemptId = values.get((Object)JobHistory.Keys.TASK_ATTEMPT_ID);
                this.getReduceAttempt(jobid, jobTrackerId, taskid, reduceAttemptId).handle((Map)values);
            }
        }
    }
}

