"use strict";

var helpers = require("../../helpers/helpers");

exports["Europe/Brussels"] = {
	"1914" : helpers.makeTestYear("Europe/Brussels", [
		["1914-11-07T23:59:59+00:00", "23:59:59", "WET", 0],
		["1914-11-08T00:00:00+00:00", "01:00:00", "CET", -60]
	]),

	"1916" : helpers.makeTestYear("Europe/Brussels", [
		["1916-04-30T22:59:59+00:00", "23:59:59", "CET", -60],
		["1916-04-30T23:00:00+00:00", "01:00:00", "CEST", -120],
		["1916-09-30T22:59:59+00:00", "00:59:59", "CEST", -120],
		["1916-09-30T23:00:00+00:00", "00:00:00", "CET", -60]
	]),

	"1917" : helpers.makeTestYear("Europe/Brussels", [
		["1917-04-16T00:59:59+00:00", "01:59:59", "CET", -60],
		["1917-04-16T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1917-09-17T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1917-09-17T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1918" : helpers.makeTestYear("Europe/Brussels", [
		["1918-04-15T00:59:59+00:00", "01:59:59", "CET", -60],
		["1918-04-15T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1918-09-16T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1918-09-16T01:00:00+00:00", "02:00:00", "CET", -60],
		["1918-11-11T10:59:59+00:00", "11:59:59", "CET", -60],
		["1918-11-11T11:00:00+00:00", "11:00:00", "WET", 0]
	]),

	"1919" : helpers.makeTestYear("Europe/Brussels", [
		["1919-03-01T22:59:59+00:00", "22:59:59", "WET", 0],
		["1919-03-01T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1919-10-04T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1919-10-04T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1920" : helpers.makeTestYear("Europe/Brussels", [
		["1920-02-14T22:59:59+00:00", "22:59:59", "WET", 0],
		["1920-02-14T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1920-10-23T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1920-10-23T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1921" : helpers.makeTestYear("Europe/Brussels", [
		["1921-03-14T22:59:59+00:00", "22:59:59", "WET", 0],
		["1921-03-14T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1921-10-25T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1921-10-25T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1922" : helpers.makeTestYear("Europe/Brussels", [
		["1922-03-25T22:59:59+00:00", "22:59:59", "WET", 0],
		["1922-03-25T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1922-10-07T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1922-10-07T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1923" : helpers.makeTestYear("Europe/Brussels", [
		["1923-04-21T22:59:59+00:00", "22:59:59", "WET", 0],
		["1923-04-21T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1923-10-06T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1923-10-06T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1924" : helpers.makeTestYear("Europe/Brussels", [
		["1924-03-29T22:59:59+00:00", "22:59:59", "WET", 0],
		["1924-03-29T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1924-10-04T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1924-10-04T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1925" : helpers.makeTestYear("Europe/Brussels", [
		["1925-04-04T22:59:59+00:00", "22:59:59", "WET", 0],
		["1925-04-04T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1925-10-03T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1925-10-03T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1926" : helpers.makeTestYear("Europe/Brussels", [
		["1926-04-17T22:59:59+00:00", "22:59:59", "WET", 0],
		["1926-04-17T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1926-10-02T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1926-10-02T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1927" : helpers.makeTestYear("Europe/Brussels", [
		["1927-04-09T22:59:59+00:00", "22:59:59", "WET", 0],
		["1927-04-09T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1927-10-01T22:59:59+00:00", "23:59:59", "WEST", -60],
		["1927-10-01T23:00:00+00:00", "23:00:00", "WET", 0]
	]),

	"1928" : helpers.makeTestYear("Europe/Brussels", [
		["1928-04-14T22:59:59+00:00", "22:59:59", "WET", 0],
		["1928-04-14T23:00:00+00:00", "00:00:00", "WEST", -60],
		["1928-10-07T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1928-10-07T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1929" : helpers.makeTestYear("Europe/Brussels", [
		["1929-04-21T01:59:59+00:00", "01:59:59", "WET", 0],
		["1929-04-21T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1929-10-06T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1929-10-06T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1930" : helpers.makeTestYear("Europe/Brussels", [
		["1930-04-13T01:59:59+00:00", "01:59:59", "WET", 0],
		["1930-04-13T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1930-10-05T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1930-10-05T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1931" : helpers.makeTestYear("Europe/Brussels", [
		["1931-04-19T01:59:59+00:00", "01:59:59", "WET", 0],
		["1931-04-19T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1931-10-04T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1931-10-04T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1932" : helpers.makeTestYear("Europe/Brussels", [
		["1932-04-03T01:59:59+00:00", "01:59:59", "WET", 0],
		["1932-04-03T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1932-10-02T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1932-10-02T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1933" : helpers.makeTestYear("Europe/Brussels", [
		["1933-03-26T01:59:59+00:00", "01:59:59", "WET", 0],
		["1933-03-26T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1933-10-08T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1933-10-08T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1934" : helpers.makeTestYear("Europe/Brussels", [
		["1934-04-08T01:59:59+00:00", "01:59:59", "WET", 0],
		["1934-04-08T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1934-10-07T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1934-10-07T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1935" : helpers.makeTestYear("Europe/Brussels", [
		["1935-03-31T01:59:59+00:00", "01:59:59", "WET", 0],
		["1935-03-31T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1935-10-06T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1935-10-06T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1936" : helpers.makeTestYear("Europe/Brussels", [
		["1936-04-19T01:59:59+00:00", "01:59:59", "WET", 0],
		["1936-04-19T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1936-10-04T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1936-10-04T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1937" : helpers.makeTestYear("Europe/Brussels", [
		["1937-04-04T01:59:59+00:00", "01:59:59", "WET", 0],
		["1937-04-04T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1937-10-03T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1937-10-03T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1938" : helpers.makeTestYear("Europe/Brussels", [
		["1938-03-27T01:59:59+00:00", "01:59:59", "WET", 0],
		["1938-03-27T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1938-10-02T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1938-10-02T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1939" : helpers.makeTestYear("Europe/Brussels", [
		["1939-04-16T01:59:59+00:00", "01:59:59", "WET", 0],
		["1939-04-16T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1939-11-19T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1939-11-19T02:00:00+00:00", "02:00:00", "WET", 0]
	]),

	"1940" : helpers.makeTestYear("Europe/Brussels", [
		["1940-02-25T01:59:59+00:00", "01:59:59", "WET", 0],
		["1940-02-25T02:00:00+00:00", "03:00:00", "WEST", -60],
		["1940-05-20T01:59:59+00:00", "02:59:59", "WEST", -60],
		["1940-05-20T02:00:00+00:00", "04:00:00", "CEST", -120]
	]),

	"1942" : helpers.makeTestYear("Europe/Brussels", [
		["1942-11-02T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1942-11-02T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1943" : helpers.makeTestYear("Europe/Brussels", [
		["1943-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1943-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1943-10-04T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1943-10-04T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1944" : helpers.makeTestYear("Europe/Brussels", [
		["1944-04-03T00:59:59+00:00", "01:59:59", "CET", -60],
		["1944-04-03T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1944-09-17T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1944-09-17T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1945" : helpers.makeTestYear("Europe/Brussels", [
		["1945-04-02T00:59:59+00:00", "01:59:59", "CET", -60],
		["1945-04-02T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1945-09-16T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1945-09-16T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1946" : helpers.makeTestYear("Europe/Brussels", [
		["1946-05-19T00:59:59+00:00", "01:59:59", "CET", -60],
		["1946-05-19T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1946-10-07T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1946-10-07T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1977" : helpers.makeTestYear("Europe/Brussels", [
		["1977-04-03T00:59:59+00:00", "01:59:59", "CET", -60],
		["1977-04-03T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1977-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1977-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1978" : helpers.makeTestYear("Europe/Brussels", [
		["1978-04-02T00:59:59+00:00", "01:59:59", "CET", -60],
		["1978-04-02T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1978-10-01T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1978-10-01T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1979" : helpers.makeTestYear("Europe/Brussels", [
		["1979-04-01T00:59:59+00:00", "01:59:59", "CET", -60],
		["1979-04-01T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1979-09-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1979-09-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1980" : helpers.makeTestYear("Europe/Brussels", [
		["1980-04-06T00:59:59+00:00", "01:59:59", "CET", -60],
		["1980-04-06T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1980-09-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1980-09-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1981" : helpers.makeTestYear("Europe/Brussels", [
		["1981-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1981-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1981-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1981-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1982" : helpers.makeTestYear("Europe/Brussels", [
		["1982-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1982-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1982-09-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1982-09-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1983" : helpers.makeTestYear("Europe/Brussels", [
		["1983-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1983-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1983-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1983-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1984" : helpers.makeTestYear("Europe/Brussels", [
		["1984-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["1984-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1984-09-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1984-09-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1985" : helpers.makeTestYear("Europe/Brussels", [
		["1985-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1985-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1985-09-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1985-09-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1986" : helpers.makeTestYear("Europe/Brussels", [
		["1986-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["1986-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1986-09-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1986-09-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1987" : helpers.makeTestYear("Europe/Brussels", [
		["1987-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1987-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1987-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1987-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1988" : helpers.makeTestYear("Europe/Brussels", [
		["1988-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1988-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1988-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1988-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1989" : helpers.makeTestYear("Europe/Brussels", [
		["1989-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["1989-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1989-09-24T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1989-09-24T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1990" : helpers.makeTestYear("Europe/Brussels", [
		["1990-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["1990-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1990-09-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1990-09-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1991" : helpers.makeTestYear("Europe/Brussels", [
		["1991-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1991-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1991-09-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1991-09-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1992" : helpers.makeTestYear("Europe/Brussels", [
		["1992-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1992-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1992-09-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1992-09-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1993" : helpers.makeTestYear("Europe/Brussels", [
		["1993-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1993-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1993-09-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1993-09-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1994" : helpers.makeTestYear("Europe/Brussels", [
		["1994-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["1994-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1994-09-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1994-09-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1995" : helpers.makeTestYear("Europe/Brussels", [
		["1995-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["1995-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1995-09-24T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1995-09-24T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1996" : helpers.makeTestYear("Europe/Brussels", [
		["1996-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["1996-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1996-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1996-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1997" : helpers.makeTestYear("Europe/Brussels", [
		["1997-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["1997-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1997-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1997-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1998" : helpers.makeTestYear("Europe/Brussels", [
		["1998-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["1998-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1998-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1998-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"1999" : helpers.makeTestYear("Europe/Brussels", [
		["1999-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["1999-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["1999-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["1999-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2000" : helpers.makeTestYear("Europe/Brussels", [
		["2000-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2000-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2000-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2000-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2001" : helpers.makeTestYear("Europe/Brussels", [
		["2001-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2001-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2001-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2001-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2002" : helpers.makeTestYear("Europe/Brussels", [
		["2002-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2002-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2002-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2002-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2003" : helpers.makeTestYear("Europe/Brussels", [
		["2003-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2003-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2003-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2003-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2004" : helpers.makeTestYear("Europe/Brussels", [
		["2004-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2004-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2004-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2004-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2005" : helpers.makeTestYear("Europe/Brussels", [
		["2005-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2005-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2005-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2005-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2006" : helpers.makeTestYear("Europe/Brussels", [
		["2006-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2006-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2006-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2006-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2007" : helpers.makeTestYear("Europe/Brussels", [
		["2007-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2007-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2007-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2007-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2008" : helpers.makeTestYear("Europe/Brussels", [
		["2008-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2008-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2008-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2008-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2009" : helpers.makeTestYear("Europe/Brussels", [
		["2009-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2009-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2009-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2009-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2010" : helpers.makeTestYear("Europe/Brussels", [
		["2010-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2010-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2010-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2010-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2011" : helpers.makeTestYear("Europe/Brussels", [
		["2011-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2011-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2011-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2011-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2012" : helpers.makeTestYear("Europe/Brussels", [
		["2012-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2012-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2012-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2012-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2013" : helpers.makeTestYear("Europe/Brussels", [
		["2013-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2013-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2013-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2013-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2014" : helpers.makeTestYear("Europe/Brussels", [
		["2014-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2014-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2014-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2014-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2015" : helpers.makeTestYear("Europe/Brussels", [
		["2015-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2015-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2015-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2015-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2016" : helpers.makeTestYear("Europe/Brussels", [
		["2016-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2016-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2016-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2016-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2017" : helpers.makeTestYear("Europe/Brussels", [
		["2017-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2017-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2017-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2017-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2018" : helpers.makeTestYear("Europe/Brussels", [
		["2018-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2018-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2018-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2018-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2019" : helpers.makeTestYear("Europe/Brussels", [
		["2019-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2019-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2019-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2019-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2020" : helpers.makeTestYear("Europe/Brussels", [
		["2020-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2020-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2020-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2020-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2021" : helpers.makeTestYear("Europe/Brussels", [
		["2021-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2021-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2021-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2021-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2022" : helpers.makeTestYear("Europe/Brussels", [
		["2022-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2022-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2022-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2022-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2023" : helpers.makeTestYear("Europe/Brussels", [
		["2023-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2023-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2023-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2023-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2024" : helpers.makeTestYear("Europe/Brussels", [
		["2024-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2024-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2024-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2024-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2025" : helpers.makeTestYear("Europe/Brussels", [
		["2025-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2025-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2025-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2025-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2026" : helpers.makeTestYear("Europe/Brussels", [
		["2026-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2026-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2026-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2026-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2027" : helpers.makeTestYear("Europe/Brussels", [
		["2027-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2027-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2027-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2027-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2028" : helpers.makeTestYear("Europe/Brussels", [
		["2028-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2028-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2028-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2028-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2029" : helpers.makeTestYear("Europe/Brussels", [
		["2029-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2029-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2029-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2029-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2030" : helpers.makeTestYear("Europe/Brussels", [
		["2030-03-31T00:59:59+00:00", "01:59:59", "CET", -60],
		["2030-03-31T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2030-10-27T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2030-10-27T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2031" : helpers.makeTestYear("Europe/Brussels", [
		["2031-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2031-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2031-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2031-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2032" : helpers.makeTestYear("Europe/Brussels", [
		["2032-03-28T00:59:59+00:00", "01:59:59", "CET", -60],
		["2032-03-28T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2032-10-31T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2032-10-31T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2033" : helpers.makeTestYear("Europe/Brussels", [
		["2033-03-27T00:59:59+00:00", "01:59:59", "CET", -60],
		["2033-03-27T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2033-10-30T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2033-10-30T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2034" : helpers.makeTestYear("Europe/Brussels", [
		["2034-03-26T00:59:59+00:00", "01:59:59", "CET", -60],
		["2034-03-26T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2034-10-29T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2034-10-29T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2035" : helpers.makeTestYear("Europe/Brussels", [
		["2035-03-25T00:59:59+00:00", "01:59:59", "CET", -60],
		["2035-03-25T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2035-10-28T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2035-10-28T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2036" : helpers.makeTestYear("Europe/Brussels", [
		["2036-03-30T00:59:59+00:00", "01:59:59", "CET", -60],
		["2036-03-30T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2036-10-26T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2036-10-26T01:00:00+00:00", "02:00:00", "CET", -60]
	]),

	"2037" : helpers.makeTestYear("Europe/Brussels", [
		["2037-03-29T00:59:59+00:00", "01:59:59", "CET", -60],
		["2037-03-29T01:00:00+00:00", "03:00:00", "CEST", -120],
		["2037-10-25T00:59:59+00:00", "02:59:59", "CEST", -120],
		["2037-10-25T01:00:00+00:00", "02:00:00", "CET", -60]
	])
};