"use strict";

var helpers = require("../../helpers/helpers");

exports["Canada/Newfoundland"] = {
	"1917" : helpers.makeTestYear("Canada/Newfoundland", [
		["1917-04-08T05:30:51+00:00", "01:59:59", "NST", 12652 / 60],
		["1917-04-08T05:30:52+00:00", "03:00:00", "NDT", 9052 / 60],
		["1917-09-17T04:30:51+00:00", "01:59:59", "NDT", 9052 / 60],
		["1917-09-17T04:30:52+00:00", "01:00:00", "NST", 12652 / 60]
	]),

	"1918" : helpers.makeTestYear("Canada/Newfoundland", [
		["1918-04-14T05:30:51+00:00", "01:59:59", "NST", 12652 / 60],
		["1918-04-14T05:30:52+00:00", "03:00:00", "NDT", 9052 / 60],
		["1918-10-27T04:30:51+00:00", "01:59:59", "NDT", 9052 / 60],
		["1918-10-27T04:30:52+00:00", "01:00:00", "NST", 12652 / 60]
	]),

	"1919" : helpers.makeTestYear("Canada/Newfoundland", [
		["1919-05-06T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1919-05-06T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1919-08-13T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1919-08-13T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1920" : helpers.makeTestYear("Canada/Newfoundland", [
		["1920-05-03T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1920-05-03T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1920-11-01T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1920-11-01T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1921" : helpers.makeTestYear("Canada/Newfoundland", [
		["1921-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1921-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1921-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1921-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1922" : helpers.makeTestYear("Canada/Newfoundland", [
		["1922-05-08T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1922-05-08T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1922-10-30T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1922-10-30T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1923" : helpers.makeTestYear("Canada/Newfoundland", [
		["1923-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1923-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1923-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1923-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1924" : helpers.makeTestYear("Canada/Newfoundland", [
		["1924-05-05T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1924-05-05T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1924-10-27T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1924-10-27T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1925" : helpers.makeTestYear("Canada/Newfoundland", [
		["1925-05-04T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1925-05-04T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1925-10-26T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1925-10-26T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1926" : helpers.makeTestYear("Canada/Newfoundland", [
		["1926-05-03T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1926-05-03T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1926-11-01T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1926-11-01T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1927" : helpers.makeTestYear("Canada/Newfoundland", [
		["1927-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1927-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1927-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1927-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1928" : helpers.makeTestYear("Canada/Newfoundland", [
		["1928-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1928-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1928-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1928-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1929" : helpers.makeTestYear("Canada/Newfoundland", [
		["1929-05-06T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1929-05-06T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1929-10-28T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1929-10-28T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1930" : helpers.makeTestYear("Canada/Newfoundland", [
		["1930-05-05T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1930-05-05T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1930-10-27T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1930-10-27T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1931" : helpers.makeTestYear("Canada/Newfoundland", [
		["1931-05-04T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1931-05-04T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1931-10-26T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1931-10-26T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1932" : helpers.makeTestYear("Canada/Newfoundland", [
		["1932-05-02T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1932-05-02T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1932-10-31T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1932-10-31T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1933" : helpers.makeTestYear("Canada/Newfoundland", [
		["1933-05-08T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1933-05-08T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1933-10-30T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1933-10-30T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1934" : helpers.makeTestYear("Canada/Newfoundland", [
		["1934-05-07T02:30:51+00:00", "22:59:59", "NST", 12652 / 60],
		["1934-05-07T02:30:52+00:00", "00:00:00", "NDT", 9052 / 60],
		["1934-10-29T01:30:51+00:00", "22:59:59", "NDT", 9052 / 60],
		["1934-10-29T01:30:52+00:00", "22:00:00", "NST", 12652 / 60]
	]),

	"1935" : helpers.makeTestYear("Canada/Newfoundland", [
		["1935-03-30T03:30:51+00:00", "23:59:59", "NST", 12652 / 60],
		["1935-03-30T03:30:52+00:00", "00:00:52", "NST", 210],
		["1935-05-06T02:29:59+00:00", "22:59:59", "NST", 210],
		["1935-05-06T02:30:00+00:00", "00:00:00", "NDT", 150],
		["1935-10-28T01:29:59+00:00", "22:59:59", "NDT", 150],
		["1935-10-28T01:30:00+00:00", "22:00:00", "NST", 210]
	]),

	"1936" : helpers.makeTestYear("Canada/Newfoundland", [
		["1936-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1936-05-11T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1936-10-05T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1936-10-05T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1937" : helpers.makeTestYear("Canada/Newfoundland", [
		["1937-05-10T03:29:59+00:00", "23:59:59", "NST", 210],
		["1937-05-10T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1937-10-04T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1937-10-04T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1938" : helpers.makeTestYear("Canada/Newfoundland", [
		["1938-05-09T03:29:59+00:00", "23:59:59", "NST", 210],
		["1938-05-09T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1938-10-03T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1938-10-03T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1939" : helpers.makeTestYear("Canada/Newfoundland", [
		["1939-05-15T03:29:59+00:00", "23:59:59", "NST", 210],
		["1939-05-15T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1939-10-02T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1939-10-02T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1940" : helpers.makeTestYear("Canada/Newfoundland", [
		["1940-05-13T03:29:59+00:00", "23:59:59", "NST", 210],
		["1940-05-13T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1940-10-07T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1940-10-07T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1941" : helpers.makeTestYear("Canada/Newfoundland", [
		["1941-05-12T03:29:59+00:00", "23:59:59", "NST", 210],
		["1941-05-12T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1941-10-06T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1941-10-06T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1942" : helpers.makeTestYear("Canada/Newfoundland", [
		["1942-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1942-05-11T03:30:00+00:00", "01:00:00", "NWT", 150]
	]),

	"1945" : helpers.makeTestYear("Canada/Newfoundland", [
		["1945-08-14T22:59:59+00:00", "20:29:59", "NWT", 150],
		["1945-08-14T23:00:00+00:00", "20:30:00", "NPT", 150],
		["1945-09-30T04:29:59+00:00", "01:59:59", "NPT", 150],
		["1945-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1946" : helpers.makeTestYear("Canada/Newfoundland", [
		["1946-05-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["1946-05-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1946-10-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1946-10-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1947" : helpers.makeTestYear("Canada/Newfoundland", [
		["1947-05-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["1947-05-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1947-10-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1947-10-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1948" : helpers.makeTestYear("Canada/Newfoundland", [
		["1948-05-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["1948-05-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1948-10-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1948-10-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1949" : helpers.makeTestYear("Canada/Newfoundland", [
		["1949-05-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["1949-05-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1949-10-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1949-10-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1950" : helpers.makeTestYear("Canada/Newfoundland", [
		["1950-05-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["1950-05-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1950-10-08T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1950-10-08T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1951" : helpers.makeTestYear("Canada/Newfoundland", [
		["1951-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1951-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1951-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1951-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1952" : helpers.makeTestYear("Canada/Newfoundland", [
		["1952-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1952-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1952-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1952-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1953" : helpers.makeTestYear("Canada/Newfoundland", [
		["1953-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1953-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1953-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1953-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1954" : helpers.makeTestYear("Canada/Newfoundland", [
		["1954-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1954-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1954-09-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1954-09-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1955" : helpers.makeTestYear("Canada/Newfoundland", [
		["1955-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1955-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1955-09-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1955-09-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1956" : helpers.makeTestYear("Canada/Newfoundland", [
		["1956-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1956-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1956-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1956-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1957" : helpers.makeTestYear("Canada/Newfoundland", [
		["1957-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1957-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1957-09-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1957-09-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1958" : helpers.makeTestYear("Canada/Newfoundland", [
		["1958-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1958-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1958-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1958-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1959" : helpers.makeTestYear("Canada/Newfoundland", [
		["1959-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1959-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1959-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1959-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1960" : helpers.makeTestYear("Canada/Newfoundland", [
		["1960-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1960-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1960-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1960-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1961" : helpers.makeTestYear("Canada/Newfoundland", [
		["1961-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1961-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1961-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1961-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1962" : helpers.makeTestYear("Canada/Newfoundland", [
		["1962-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1962-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1962-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1962-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1963" : helpers.makeTestYear("Canada/Newfoundland", [
		["1963-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1963-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1963-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1963-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1964" : helpers.makeTestYear("Canada/Newfoundland", [
		["1964-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1964-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1964-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1964-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1965" : helpers.makeTestYear("Canada/Newfoundland", [
		["1965-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1965-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1965-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1965-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1966" : helpers.makeTestYear("Canada/Newfoundland", [
		["1966-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1966-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1966-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1966-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1967" : helpers.makeTestYear("Canada/Newfoundland", [
		["1967-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1967-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1967-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1967-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1968" : helpers.makeTestYear("Canada/Newfoundland", [
		["1968-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1968-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1968-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1968-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1969" : helpers.makeTestYear("Canada/Newfoundland", [
		["1969-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1969-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1969-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1969-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1970" : helpers.makeTestYear("Canada/Newfoundland", [
		["1970-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1970-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1970-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1970-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1971" : helpers.makeTestYear("Canada/Newfoundland", [
		["1971-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1971-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1971-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1971-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1972" : helpers.makeTestYear("Canada/Newfoundland", [
		["1972-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1972-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1972-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1972-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1973" : helpers.makeTestYear("Canada/Newfoundland", [
		["1973-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1973-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1973-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1973-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1974" : helpers.makeTestYear("Canada/Newfoundland", [
		["1974-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1974-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1974-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1974-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1975" : helpers.makeTestYear("Canada/Newfoundland", [
		["1975-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1975-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1975-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1975-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1976" : helpers.makeTestYear("Canada/Newfoundland", [
		["1976-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1976-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1976-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1976-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1977" : helpers.makeTestYear("Canada/Newfoundland", [
		["1977-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1977-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1977-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1977-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1978" : helpers.makeTestYear("Canada/Newfoundland", [
		["1978-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1978-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1978-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1978-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1979" : helpers.makeTestYear("Canada/Newfoundland", [
		["1979-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1979-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1979-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1979-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1980" : helpers.makeTestYear("Canada/Newfoundland", [
		["1980-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1980-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1980-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1980-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1981" : helpers.makeTestYear("Canada/Newfoundland", [
		["1981-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1981-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1981-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1981-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1982" : helpers.makeTestYear("Canada/Newfoundland", [
		["1982-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1982-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1982-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1982-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1983" : helpers.makeTestYear("Canada/Newfoundland", [
		["1983-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1983-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1983-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1983-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1984" : helpers.makeTestYear("Canada/Newfoundland", [
		["1984-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1984-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1984-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1984-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1985" : helpers.makeTestYear("Canada/Newfoundland", [
		["1985-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1985-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1985-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1985-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1986" : helpers.makeTestYear("Canada/Newfoundland", [
		["1986-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1986-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1986-10-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1986-10-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1987" : helpers.makeTestYear("Canada/Newfoundland", [
		["1987-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1987-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1987-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1987-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1988" : helpers.makeTestYear("Canada/Newfoundland", [
		["1988-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["1988-04-03T03:31:00+00:00", "02:01:00", "NDDT", 90],
		["1988-10-30T01:30:59+00:00", "00:00:59", "NDDT", 90],
		["1988-10-30T01:31:00+00:00", "22:01:00", "NST", 210]
	]),

	"1989" : helpers.makeTestYear("Canada/Newfoundland", [
		["1989-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["1989-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1989-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1989-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1990" : helpers.makeTestYear("Canada/Newfoundland", [
		["1990-04-01T03:30:59+00:00", "00:00:59", "NST", 210],
		["1990-04-01T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1990-10-28T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1990-10-28T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1991" : helpers.makeTestYear("Canada/Newfoundland", [
		["1991-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["1991-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1991-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1991-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1992" : helpers.makeTestYear("Canada/Newfoundland", [
		["1992-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1992-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1992-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1992-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1993" : helpers.makeTestYear("Canada/Newfoundland", [
		["1993-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["1993-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1993-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1993-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1994" : helpers.makeTestYear("Canada/Newfoundland", [
		["1994-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["1994-04-03T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1994-10-30T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1994-10-30T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1995" : helpers.makeTestYear("Canada/Newfoundland", [
		["1995-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["1995-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1995-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1995-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1996" : helpers.makeTestYear("Canada/Newfoundland", [
		["1996-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["1996-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1996-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1996-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1997" : helpers.makeTestYear("Canada/Newfoundland", [
		["1997-04-06T03:30:59+00:00", "00:00:59", "NST", 210],
		["1997-04-06T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1997-10-26T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1997-10-26T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1998" : helpers.makeTestYear("Canada/Newfoundland", [
		["1998-04-05T03:30:59+00:00", "00:00:59", "NST", 210],
		["1998-04-05T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1998-10-25T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1998-10-25T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"1999" : helpers.makeTestYear("Canada/Newfoundland", [
		["1999-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["1999-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["1999-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["1999-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2000" : helpers.makeTestYear("Canada/Newfoundland", [
		["2000-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["2000-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2000-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2000-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2001" : helpers.makeTestYear("Canada/Newfoundland", [
		["2001-04-01T03:30:59+00:00", "00:00:59", "NST", 210],
		["2001-04-01T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2001-10-28T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2001-10-28T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2002" : helpers.makeTestYear("Canada/Newfoundland", [
		["2002-04-07T03:30:59+00:00", "00:00:59", "NST", 210],
		["2002-04-07T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2002-10-27T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2002-10-27T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2003" : helpers.makeTestYear("Canada/Newfoundland", [
		["2003-04-06T03:30:59+00:00", "00:00:59", "NST", 210],
		["2003-04-06T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2003-10-26T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2003-10-26T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2004" : helpers.makeTestYear("Canada/Newfoundland", [
		["2004-04-04T03:30:59+00:00", "00:00:59", "NST", 210],
		["2004-04-04T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2004-10-31T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2004-10-31T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2005" : helpers.makeTestYear("Canada/Newfoundland", [
		["2005-04-03T03:30:59+00:00", "00:00:59", "NST", 210],
		["2005-04-03T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2005-10-30T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2005-10-30T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2006" : helpers.makeTestYear("Canada/Newfoundland", [
		["2006-04-02T03:30:59+00:00", "00:00:59", "NST", 210],
		["2006-04-02T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2006-10-29T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2006-10-29T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2007" : helpers.makeTestYear("Canada/Newfoundland", [
		["2007-03-11T03:30:59+00:00", "00:00:59", "NST", 210],
		["2007-03-11T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2007-11-04T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2007-11-04T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2008" : helpers.makeTestYear("Canada/Newfoundland", [
		["2008-03-09T03:30:59+00:00", "00:00:59", "NST", 210],
		["2008-03-09T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2008-11-02T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2008-11-02T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2009" : helpers.makeTestYear("Canada/Newfoundland", [
		["2009-03-08T03:30:59+00:00", "00:00:59", "NST", 210],
		["2009-03-08T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2009-11-01T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2009-11-01T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2010" : helpers.makeTestYear("Canada/Newfoundland", [
		["2010-03-14T03:30:59+00:00", "00:00:59", "NST", 210],
		["2010-03-14T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2010-11-07T02:30:59+00:00", "00:00:59", "NDT", 150],
		["2010-11-07T02:31:00+00:00", "23:01:00", "NST", 210]
	]),

	"2011" : helpers.makeTestYear("Canada/Newfoundland", [
		["2011-03-13T03:30:59+00:00", "00:00:59", "NST", 210],
		["2011-03-13T03:31:00+00:00", "01:01:00", "NDT", 150],
		["2011-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2011-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2012" : helpers.makeTestYear("Canada/Newfoundland", [
		["2012-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2012-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2012-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2012-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2013" : helpers.makeTestYear("Canada/Newfoundland", [
		["2013-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2013-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2013-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2013-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2014" : helpers.makeTestYear("Canada/Newfoundland", [
		["2014-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2014-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2014-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2014-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2015" : helpers.makeTestYear("Canada/Newfoundland", [
		["2015-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2015-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2015-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2015-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2016" : helpers.makeTestYear("Canada/Newfoundland", [
		["2016-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2016-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2016-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2016-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2017" : helpers.makeTestYear("Canada/Newfoundland", [
		["2017-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2017-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2017-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2017-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2018" : helpers.makeTestYear("Canada/Newfoundland", [
		["2018-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2018-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2018-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2018-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2019" : helpers.makeTestYear("Canada/Newfoundland", [
		["2019-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2019-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2019-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2019-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2020" : helpers.makeTestYear("Canada/Newfoundland", [
		["2020-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2020-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2020-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2020-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2021" : helpers.makeTestYear("Canada/Newfoundland", [
		["2021-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2021-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2021-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2021-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2022" : helpers.makeTestYear("Canada/Newfoundland", [
		["2022-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2022-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2022-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2022-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2023" : helpers.makeTestYear("Canada/Newfoundland", [
		["2023-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2023-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2023-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2023-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2024" : helpers.makeTestYear("Canada/Newfoundland", [
		["2024-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2024-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2024-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2024-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2025" : helpers.makeTestYear("Canada/Newfoundland", [
		["2025-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2025-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2025-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2025-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2026" : helpers.makeTestYear("Canada/Newfoundland", [
		["2026-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2026-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2026-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2026-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2027" : helpers.makeTestYear("Canada/Newfoundland", [
		["2027-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2027-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2027-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2027-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2028" : helpers.makeTestYear("Canada/Newfoundland", [
		["2028-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2028-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2028-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2028-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2029" : helpers.makeTestYear("Canada/Newfoundland", [
		["2029-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2029-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2029-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2029-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2030" : helpers.makeTestYear("Canada/Newfoundland", [
		["2030-03-10T05:29:59+00:00", "01:59:59", "NST", 210],
		["2030-03-10T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2030-11-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2030-11-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2031" : helpers.makeTestYear("Canada/Newfoundland", [
		["2031-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2031-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2031-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2031-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2032" : helpers.makeTestYear("Canada/Newfoundland", [
		["2032-03-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["2032-03-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2032-11-07T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2032-11-07T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2033" : helpers.makeTestYear("Canada/Newfoundland", [
		["2033-03-13T05:29:59+00:00", "01:59:59", "NST", 210],
		["2033-03-13T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2033-11-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2033-11-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2034" : helpers.makeTestYear("Canada/Newfoundland", [
		["2034-03-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["2034-03-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2034-11-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2034-11-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2035" : helpers.makeTestYear("Canada/Newfoundland", [
		["2035-03-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["2035-03-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2035-11-04T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2035-11-04T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2036" : helpers.makeTestYear("Canada/Newfoundland", [
		["2036-03-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["2036-03-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2036-11-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2036-11-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"2037" : helpers.makeTestYear("Canada/Newfoundland", [
		["2037-03-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["2037-03-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["2037-11-01T04:29:59+00:00", "01:59:59", "NDT", 150],
		["2037-11-01T04:30:00+00:00", "01:00:00", "NST", 210]
	])
};