"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Metlakatla"] = {
	"guess" : helpers.makeTestGuess("America/Metlakatla", { offset: true, abbr: true, expect: "America/Anchorage" }),

	"1942" : helpers.makeTestYear("America/Metlakatla", [
		["1942-02-09T09:59:59+00:00", "01:59:59", "PST", 480],
		["1942-02-09T10:00:00+00:00", "03:00:00", "PWT", 420]
	]),

	"1945" : helpers.makeTestYear("America/Metlakatla", [
		["1945-08-14T22:59:59+00:00", "15:59:59", "PWT", 420],
		["1945-08-14T23:00:00+00:00", "16:00:00", "PPT", 420],
		["1945-09-30T08:59:59+00:00", "01:59:59", "PPT", 420],
		["1945-09-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1969" : helpers.makeTestYear("America/Metlakatla", [
		["1969-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1969-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1969-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1969-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1970" : helpers.makeTestYear("America/Metlakatla", [
		["1970-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1970-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1970-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1970-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1971" : helpers.makeTestYear("America/Metlakatla", [
		["1971-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1971-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1971-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1971-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1972" : helpers.makeTestYear("America/Metlakatla", [
		["1972-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1972-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1972-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1972-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1973" : helpers.makeTestYear("America/Metlakatla", [
		["1973-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1973-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1973-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1973-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1974" : helpers.makeTestYear("America/Metlakatla", [
		["1974-01-06T09:59:59+00:00", "01:59:59", "PST", 480],
		["1974-01-06T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1974-10-27T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1974-10-27T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1975" : helpers.makeTestYear("America/Metlakatla", [
		["1975-02-23T09:59:59+00:00", "01:59:59", "PST", 480],
		["1975-02-23T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1975-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1975-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1976" : helpers.makeTestYear("America/Metlakatla", [
		["1976-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1976-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1976-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1976-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1977" : helpers.makeTestYear("America/Metlakatla", [
		["1977-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1977-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1977-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1977-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1978" : helpers.makeTestYear("America/Metlakatla", [
		["1978-04-30T09:59:59+00:00", "01:59:59", "PST", 480],
		["1978-04-30T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1978-10-29T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1978-10-29T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1979" : helpers.makeTestYear("America/Metlakatla", [
		["1979-04-29T09:59:59+00:00", "01:59:59", "PST", 480],
		["1979-04-29T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1979-10-28T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1979-10-28T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1980" : helpers.makeTestYear("America/Metlakatla", [
		["1980-04-27T09:59:59+00:00", "01:59:59", "PST", 480],
		["1980-04-27T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1980-10-26T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1980-10-26T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1981" : helpers.makeTestYear("America/Metlakatla", [
		["1981-04-26T09:59:59+00:00", "01:59:59", "PST", 480],
		["1981-04-26T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1981-10-25T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1981-10-25T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1982" : helpers.makeTestYear("America/Metlakatla", [
		["1982-04-25T09:59:59+00:00", "01:59:59", "PST", 480],
		["1982-04-25T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1982-10-31T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1982-10-31T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"1983" : helpers.makeTestYear("America/Metlakatla", [
		["1983-04-24T09:59:59+00:00", "01:59:59", "PST", 480],
		["1983-04-24T10:00:00+00:00", "03:00:00", "PDT", 420],
		["1983-10-30T08:59:59+00:00", "01:59:59", "PDT", 420],
		["1983-10-30T09:00:00+00:00", "01:00:00", "PST", 480]
	]),

	"2015" : helpers.makeTestYear("America/Metlakatla", [
		["2015-11-01T09:59:59+00:00", "01:59:59", "PST", 480],
		["2015-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2016" : helpers.makeTestYear("America/Metlakatla", [
		["2016-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2016-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2016-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2016-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2017" : helpers.makeTestYear("America/Metlakatla", [
		["2017-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2017-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2017-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2017-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2018" : helpers.makeTestYear("America/Metlakatla", [
		["2018-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2018-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2018-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2018-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2019" : helpers.makeTestYear("America/Metlakatla", [
		["2019-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2019-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2019-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2019-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2020" : helpers.makeTestYear("America/Metlakatla", [
		["2020-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2020-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2020-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2020-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2021" : helpers.makeTestYear("America/Metlakatla", [
		["2021-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2021-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2021-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2021-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2022" : helpers.makeTestYear("America/Metlakatla", [
		["2022-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2022-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2022-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2022-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2023" : helpers.makeTestYear("America/Metlakatla", [
		["2023-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2023-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2023-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2023-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2024" : helpers.makeTestYear("America/Metlakatla", [
		["2024-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2024-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2024-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2024-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2025" : helpers.makeTestYear("America/Metlakatla", [
		["2025-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2025-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2025-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2025-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2026" : helpers.makeTestYear("America/Metlakatla", [
		["2026-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2026-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2026-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2026-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2027" : helpers.makeTestYear("America/Metlakatla", [
		["2027-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2027-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2027-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2027-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2028" : helpers.makeTestYear("America/Metlakatla", [
		["2028-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2028-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2028-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2028-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2029" : helpers.makeTestYear("America/Metlakatla", [
		["2029-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2029-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2029-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2029-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2030" : helpers.makeTestYear("America/Metlakatla", [
		["2030-03-10T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2030-03-10T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2030-11-03T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2030-11-03T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2031" : helpers.makeTestYear("America/Metlakatla", [
		["2031-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2031-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2031-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2031-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2032" : helpers.makeTestYear("America/Metlakatla", [
		["2032-03-14T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2032-03-14T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2032-11-07T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2032-11-07T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2033" : helpers.makeTestYear("America/Metlakatla", [
		["2033-03-13T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2033-03-13T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2033-11-06T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2033-11-06T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2034" : helpers.makeTestYear("America/Metlakatla", [
		["2034-03-12T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2034-03-12T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2034-11-05T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2034-11-05T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2035" : helpers.makeTestYear("America/Metlakatla", [
		["2035-03-11T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2035-03-11T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2035-11-04T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2035-11-04T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2036" : helpers.makeTestYear("America/Metlakatla", [
		["2036-03-09T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2036-03-09T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2036-11-02T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2036-11-02T10:00:00+00:00", "01:00:00", "AKST", 540]
	]),

	"2037" : helpers.makeTestYear("America/Metlakatla", [
		["2037-03-08T10:59:59+00:00", "01:59:59", "AKST", 540],
		["2037-03-08T11:00:00+00:00", "03:00:00", "AKDT", 480],
		["2037-11-01T09:59:59+00:00", "01:59:59", "AKDT", 480],
		["2037-11-01T10:00:00+00:00", "01:00:00", "AKST", 540]
	])
};