"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Goose_Bay"] = {
	"1918" : helpers.makeTestYear("America/Goose_Bay", [
		["1918-04-14T05:30:51+00:00", "01:59:59", "NST", 12652 / 60],
		["1918-04-14T05:30:52+00:00", "03:00:00", "NDT", 9052 / 60],
		["1918-10-27T04:30:51+00:00", "01:59:59", "NDT", 9052 / 60],
		["1918-10-27T04:30:52+00:00", "01:00:00", "NST", 12652 / 60]
	]),

	"1935" : helpers.makeTestYear("America/Goose_Bay", [
		["1935-03-30T03:30:51+00:00", "23:59:59", "NST", 12652 / 60],
		["1935-03-30T03:30:52+00:00", "00:00:52", "NST", 210]
	]),

	"1936" : helpers.makeTestYear("America/Goose_Bay", [
		["1936-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1936-05-11T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1936-10-05T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1936-10-05T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1937" : helpers.makeTestYear("America/Goose_Bay", [
		["1937-05-10T03:29:59+00:00", "23:59:59", "NST", 210],
		["1937-05-10T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1937-10-04T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1937-10-04T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1938" : helpers.makeTestYear("America/Goose_Bay", [
		["1938-05-09T03:29:59+00:00", "23:59:59", "NST", 210],
		["1938-05-09T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1938-10-03T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1938-10-03T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1939" : helpers.makeTestYear("America/Goose_Bay", [
		["1939-05-15T03:29:59+00:00", "23:59:59", "NST", 210],
		["1939-05-15T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1939-10-02T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1939-10-02T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1940" : helpers.makeTestYear("America/Goose_Bay", [
		["1940-05-13T03:29:59+00:00", "23:59:59", "NST", 210],
		["1940-05-13T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1940-10-07T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1940-10-07T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1941" : helpers.makeTestYear("America/Goose_Bay", [
		["1941-05-12T03:29:59+00:00", "23:59:59", "NST", 210],
		["1941-05-12T03:30:00+00:00", "01:00:00", "NDT", 150],
		["1941-10-06T02:29:59+00:00", "23:59:59", "NDT", 150],
		["1941-10-06T02:30:00+00:00", "23:00:00", "NST", 210]
	]),

	"1942" : helpers.makeTestYear("America/Goose_Bay", [
		["1942-05-11T03:29:59+00:00", "23:59:59", "NST", 210],
		["1942-05-11T03:30:00+00:00", "01:00:00", "NWT", 150]
	]),

	"1945" : helpers.makeTestYear("America/Goose_Bay", [
		["1945-08-14T22:59:59+00:00", "20:29:59", "NWT", 150],
		["1945-08-14T23:00:00+00:00", "20:30:00", "NPT", 150],
		["1945-09-30T04:29:59+00:00", "01:59:59", "NPT", 150],
		["1945-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1946" : helpers.makeTestYear("America/Goose_Bay", [
		["1946-05-12T05:29:59+00:00", "01:59:59", "NST", 210],
		["1946-05-12T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1946-10-06T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1946-10-06T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1947" : helpers.makeTestYear("America/Goose_Bay", [
		["1947-05-11T05:29:59+00:00", "01:59:59", "NST", 210],
		["1947-05-11T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1947-10-05T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1947-10-05T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1948" : helpers.makeTestYear("America/Goose_Bay", [
		["1948-05-09T05:29:59+00:00", "01:59:59", "NST", 210],
		["1948-05-09T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1948-10-03T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1948-10-03T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1949" : helpers.makeTestYear("America/Goose_Bay", [
		["1949-05-08T05:29:59+00:00", "01:59:59", "NST", 210],
		["1949-05-08T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1949-10-02T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1949-10-02T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1950" : helpers.makeTestYear("America/Goose_Bay", [
		["1950-05-14T05:29:59+00:00", "01:59:59", "NST", 210],
		["1950-05-14T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1950-10-08T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1950-10-08T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1951" : helpers.makeTestYear("America/Goose_Bay", [
		["1951-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1951-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1951-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1951-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1952" : helpers.makeTestYear("America/Goose_Bay", [
		["1952-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1952-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1952-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1952-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1953" : helpers.makeTestYear("America/Goose_Bay", [
		["1953-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1953-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1953-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1953-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1954" : helpers.makeTestYear("America/Goose_Bay", [
		["1954-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1954-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1954-09-26T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1954-09-26T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1955" : helpers.makeTestYear("America/Goose_Bay", [
		["1955-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1955-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1955-09-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1955-09-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1956" : helpers.makeTestYear("America/Goose_Bay", [
		["1956-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1956-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1956-09-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1956-09-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1957" : helpers.makeTestYear("America/Goose_Bay", [
		["1957-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1957-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1957-09-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1957-09-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1958" : helpers.makeTestYear("America/Goose_Bay", [
		["1958-04-27T05:29:59+00:00", "01:59:59", "NST", 210],
		["1958-04-27T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1958-09-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1958-09-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1959" : helpers.makeTestYear("America/Goose_Bay", [
		["1959-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1959-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1959-09-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1959-09-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1960" : helpers.makeTestYear("America/Goose_Bay", [
		["1960-04-24T05:29:59+00:00", "01:59:59", "NST", 210],
		["1960-04-24T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1960-10-30T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1960-10-30T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1961" : helpers.makeTestYear("America/Goose_Bay", [
		["1961-04-30T05:29:59+00:00", "01:59:59", "NST", 210],
		["1961-04-30T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1961-10-29T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1961-10-29T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1962" : helpers.makeTestYear("America/Goose_Bay", [
		["1962-04-29T05:29:59+00:00", "01:59:59", "NST", 210],
		["1962-04-29T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1962-10-28T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1962-10-28T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1963" : helpers.makeTestYear("America/Goose_Bay", [
		["1963-04-28T05:29:59+00:00", "01:59:59", "NST", 210],
		["1963-04-28T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1963-10-27T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1963-10-27T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1964" : helpers.makeTestYear("America/Goose_Bay", [
		["1964-04-26T05:29:59+00:00", "01:59:59", "NST", 210],
		["1964-04-26T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1964-10-25T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1964-10-25T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1965" : helpers.makeTestYear("America/Goose_Bay", [
		["1965-04-25T05:29:59+00:00", "01:59:59", "NST", 210],
		["1965-04-25T05:30:00+00:00", "03:00:00", "NDT", 150],
		["1965-10-31T04:29:59+00:00", "01:59:59", "NDT", 150],
		["1965-10-31T04:30:00+00:00", "01:00:00", "NST", 210]
	]),

	"1966" : helpers.makeTestYear("America/Goose_Bay", [
		["1966-03-15T05:29:59+00:00", "01:59:59", "NST", 210],
		["1966-03-15T05:30:00+00:00", "01:30:00", "AST", 240],
		["1966-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1966-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1966-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1966-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1967" : helpers.makeTestYear("America/Goose_Bay", [
		["1967-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1967-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1967-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1967-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1968" : helpers.makeTestYear("America/Goose_Bay", [
		["1968-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1968-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1968-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1968-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1969" : helpers.makeTestYear("America/Goose_Bay", [
		["1969-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1969-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1969-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1969-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1970" : helpers.makeTestYear("America/Goose_Bay", [
		["1970-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1970-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1970-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1970-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1971" : helpers.makeTestYear("America/Goose_Bay", [
		["1971-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1971-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1971-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1971-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1972" : helpers.makeTestYear("America/Goose_Bay", [
		["1972-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1972-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1972-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1972-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1973" : helpers.makeTestYear("America/Goose_Bay", [
		["1973-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1973-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1973-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1973-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1974" : helpers.makeTestYear("America/Goose_Bay", [
		["1974-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1974-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1974-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1974-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1975" : helpers.makeTestYear("America/Goose_Bay", [
		["1975-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1975-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1975-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1975-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1976" : helpers.makeTestYear("America/Goose_Bay", [
		["1976-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1976-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1976-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1976-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1977" : helpers.makeTestYear("America/Goose_Bay", [
		["1977-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1977-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1977-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1977-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1978" : helpers.makeTestYear("America/Goose_Bay", [
		["1978-04-30T05:59:59+00:00", "01:59:59", "AST", 240],
		["1978-04-30T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1978-10-29T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1978-10-29T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1979" : helpers.makeTestYear("America/Goose_Bay", [
		["1979-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1979-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1979-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1979-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1980" : helpers.makeTestYear("America/Goose_Bay", [
		["1980-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1980-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1980-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1980-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1981" : helpers.makeTestYear("America/Goose_Bay", [
		["1981-04-26T05:59:59+00:00", "01:59:59", "AST", 240],
		["1981-04-26T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1981-10-25T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1981-10-25T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1982" : helpers.makeTestYear("America/Goose_Bay", [
		["1982-04-25T05:59:59+00:00", "01:59:59", "AST", 240],
		["1982-04-25T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1982-10-31T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1982-10-31T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1983" : helpers.makeTestYear("America/Goose_Bay", [
		["1983-04-24T05:59:59+00:00", "01:59:59", "AST", 240],
		["1983-04-24T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1983-10-30T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1983-10-30T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1984" : helpers.makeTestYear("America/Goose_Bay", [
		["1984-04-29T05:59:59+00:00", "01:59:59", "AST", 240],
		["1984-04-29T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1984-10-28T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1984-10-28T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1985" : helpers.makeTestYear("America/Goose_Bay", [
		["1985-04-28T05:59:59+00:00", "01:59:59", "AST", 240],
		["1985-04-28T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1985-10-27T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1985-10-27T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1986" : helpers.makeTestYear("America/Goose_Bay", [
		["1986-04-27T05:59:59+00:00", "01:59:59", "AST", 240],
		["1986-04-27T06:00:00+00:00", "03:00:00", "ADT", 180],
		["1986-10-26T04:59:59+00:00", "01:59:59", "ADT", 180],
		["1986-10-26T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"1987" : helpers.makeTestYear("America/Goose_Bay", [
		["1987-04-05T04:00:59+00:00", "00:00:59", "AST", 240],
		["1987-04-05T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1987-10-25T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1987-10-25T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1988" : helpers.makeTestYear("America/Goose_Bay", [
		["1988-04-03T04:00:59+00:00", "00:00:59", "AST", 240],
		["1988-04-03T04:01:00+00:00", "02:01:00", "ADDT", 120],
		["1988-10-30T02:00:59+00:00", "00:00:59", "ADDT", 120],
		["1988-10-30T02:01:00+00:00", "22:01:00", "AST", 240]
	]),

	"1989" : helpers.makeTestYear("America/Goose_Bay", [
		["1989-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["1989-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1989-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1989-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1990" : helpers.makeTestYear("America/Goose_Bay", [
		["1990-04-01T04:00:59+00:00", "00:00:59", "AST", 240],
		["1990-04-01T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1990-10-28T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1990-10-28T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1991" : helpers.makeTestYear("America/Goose_Bay", [
		["1991-04-07T04:00:59+00:00", "00:00:59", "AST", 240],
		["1991-04-07T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1991-10-27T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1991-10-27T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1992" : helpers.makeTestYear("America/Goose_Bay", [
		["1992-04-05T04:00:59+00:00", "00:00:59", "AST", 240],
		["1992-04-05T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1992-10-25T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1992-10-25T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1993" : helpers.makeTestYear("America/Goose_Bay", [
		["1993-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["1993-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1993-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1993-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1994" : helpers.makeTestYear("America/Goose_Bay", [
		["1994-04-03T04:00:59+00:00", "00:00:59", "AST", 240],
		["1994-04-03T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1994-10-30T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1994-10-30T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1995" : helpers.makeTestYear("America/Goose_Bay", [
		["1995-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["1995-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1995-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1995-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1996" : helpers.makeTestYear("America/Goose_Bay", [
		["1996-04-07T04:00:59+00:00", "00:00:59", "AST", 240],
		["1996-04-07T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1996-10-27T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1996-10-27T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1997" : helpers.makeTestYear("America/Goose_Bay", [
		["1997-04-06T04:00:59+00:00", "00:00:59", "AST", 240],
		["1997-04-06T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1997-10-26T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1997-10-26T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1998" : helpers.makeTestYear("America/Goose_Bay", [
		["1998-04-05T04:00:59+00:00", "00:00:59", "AST", 240],
		["1998-04-05T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1998-10-25T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1998-10-25T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"1999" : helpers.makeTestYear("America/Goose_Bay", [
		["1999-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["1999-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["1999-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["1999-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2000" : helpers.makeTestYear("America/Goose_Bay", [
		["2000-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["2000-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2000-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2000-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2001" : helpers.makeTestYear("America/Goose_Bay", [
		["2001-04-01T04:00:59+00:00", "00:00:59", "AST", 240],
		["2001-04-01T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2001-10-28T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2001-10-28T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2002" : helpers.makeTestYear("America/Goose_Bay", [
		["2002-04-07T04:00:59+00:00", "00:00:59", "AST", 240],
		["2002-04-07T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2002-10-27T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2002-10-27T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2003" : helpers.makeTestYear("America/Goose_Bay", [
		["2003-04-06T04:00:59+00:00", "00:00:59", "AST", 240],
		["2003-04-06T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2003-10-26T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2003-10-26T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2004" : helpers.makeTestYear("America/Goose_Bay", [
		["2004-04-04T04:00:59+00:00", "00:00:59", "AST", 240],
		["2004-04-04T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2004-10-31T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2004-10-31T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2005" : helpers.makeTestYear("America/Goose_Bay", [
		["2005-04-03T04:00:59+00:00", "00:00:59", "AST", 240],
		["2005-04-03T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2005-10-30T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2005-10-30T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2006" : helpers.makeTestYear("America/Goose_Bay", [
		["2006-04-02T04:00:59+00:00", "00:00:59", "AST", 240],
		["2006-04-02T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2006-10-29T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2006-10-29T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2007" : helpers.makeTestYear("America/Goose_Bay", [
		["2007-03-11T04:00:59+00:00", "00:00:59", "AST", 240],
		["2007-03-11T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2007-11-04T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2007-11-04T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2008" : helpers.makeTestYear("America/Goose_Bay", [
		["2008-03-09T04:00:59+00:00", "00:00:59", "AST", 240],
		["2008-03-09T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2008-11-02T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2008-11-02T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2009" : helpers.makeTestYear("America/Goose_Bay", [
		["2009-03-08T04:00:59+00:00", "00:00:59", "AST", 240],
		["2009-03-08T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2009-11-01T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2009-11-01T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2010" : helpers.makeTestYear("America/Goose_Bay", [
		["2010-03-14T04:00:59+00:00", "00:00:59", "AST", 240],
		["2010-03-14T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2010-11-07T03:00:59+00:00", "00:00:59", "ADT", 180],
		["2010-11-07T03:01:00+00:00", "23:01:00", "AST", 240]
	]),

	"2011" : helpers.makeTestYear("America/Goose_Bay", [
		["2011-03-13T04:00:59+00:00", "00:00:59", "AST", 240],
		["2011-03-13T04:01:00+00:00", "01:01:00", "ADT", 180],
		["2011-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2011-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2012" : helpers.makeTestYear("America/Goose_Bay", [
		["2012-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2012-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2012-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2012-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2013" : helpers.makeTestYear("America/Goose_Bay", [
		["2013-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2013-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2013-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2013-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2014" : helpers.makeTestYear("America/Goose_Bay", [
		["2014-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2014-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2014-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2014-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2015" : helpers.makeTestYear("America/Goose_Bay", [
		["2015-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2015-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2015-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2015-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2016" : helpers.makeTestYear("America/Goose_Bay", [
		["2016-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2016-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2016-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2016-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2017" : helpers.makeTestYear("America/Goose_Bay", [
		["2017-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2017-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2017-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2017-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2018" : helpers.makeTestYear("America/Goose_Bay", [
		["2018-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2018-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2018-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2018-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2019" : helpers.makeTestYear("America/Goose_Bay", [
		["2019-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2019-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2019-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2019-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2020" : helpers.makeTestYear("America/Goose_Bay", [
		["2020-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2020-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2020-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2020-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2021" : helpers.makeTestYear("America/Goose_Bay", [
		["2021-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2021-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2021-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2021-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2022" : helpers.makeTestYear("America/Goose_Bay", [
		["2022-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2022-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2022-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2022-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2023" : helpers.makeTestYear("America/Goose_Bay", [
		["2023-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2023-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2023-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2023-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2024" : helpers.makeTestYear("America/Goose_Bay", [
		["2024-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2024-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2024-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2024-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2025" : helpers.makeTestYear("America/Goose_Bay", [
		["2025-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2025-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2025-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2025-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2026" : helpers.makeTestYear("America/Goose_Bay", [
		["2026-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2026-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2026-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2026-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2027" : helpers.makeTestYear("America/Goose_Bay", [
		["2027-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2027-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2027-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2027-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2028" : helpers.makeTestYear("America/Goose_Bay", [
		["2028-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2028-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2028-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2028-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2029" : helpers.makeTestYear("America/Goose_Bay", [
		["2029-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2029-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2029-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2029-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2030" : helpers.makeTestYear("America/Goose_Bay", [
		["2030-03-10T05:59:59+00:00", "01:59:59", "AST", 240],
		["2030-03-10T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2030-11-03T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2030-11-03T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2031" : helpers.makeTestYear("America/Goose_Bay", [
		["2031-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2031-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2031-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2031-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2032" : helpers.makeTestYear("America/Goose_Bay", [
		["2032-03-14T05:59:59+00:00", "01:59:59", "AST", 240],
		["2032-03-14T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2032-11-07T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2032-11-07T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2033" : helpers.makeTestYear("America/Goose_Bay", [
		["2033-03-13T05:59:59+00:00", "01:59:59", "AST", 240],
		["2033-03-13T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2033-11-06T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2033-11-06T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2034" : helpers.makeTestYear("America/Goose_Bay", [
		["2034-03-12T05:59:59+00:00", "01:59:59", "AST", 240],
		["2034-03-12T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2034-11-05T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2034-11-05T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2035" : helpers.makeTestYear("America/Goose_Bay", [
		["2035-03-11T05:59:59+00:00", "01:59:59", "AST", 240],
		["2035-03-11T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2035-11-04T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2035-11-04T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2036" : helpers.makeTestYear("America/Goose_Bay", [
		["2036-03-09T05:59:59+00:00", "01:59:59", "AST", 240],
		["2036-03-09T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2036-11-02T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2036-11-02T05:00:00+00:00", "01:00:00", "AST", 240]
	]),

	"2037" : helpers.makeTestYear("America/Goose_Bay", [
		["2037-03-08T05:59:59+00:00", "01:59:59", "AST", 240],
		["2037-03-08T06:00:00+00:00", "03:00:00", "ADT", 180],
		["2037-11-01T04:59:59+00:00", "01:59:59", "ADT", 180],
		["2037-11-01T05:00:00+00:00", "01:00:00", "AST", 240]
	])
};