#!/bin/bash
export LC_ALL=C
set -e
CC="${TEST_CC:-cc}"
CXX="${TEST_CXX:-c++}"
GCC="${TEST_GCC:-gcc}"
GXX="${TEST_GXX:-g++}"
OBJDUMP="${OBJDUMP:-objdump}"
MACHINE="${MACHINE:-$(uname -m)}"
testname=$(basename "$0" .sh)
echo -n "Testing $testname ... "
t=out/test/elf/$MACHINE/$testname
mkdir -p $t

mkdir -p $t/foo

cat <<EOF | $CC -o $t/foo/a.o -c -xc -
int main() {}
EOF

cat <<EOF > $t/b.script
INPUT(a.o)
EOF

$CC -o $t/exe -L$t/foo $t/b.script

echo OK
