/*
 *  mod-xslt -- Copyright (C) 2002, 2003 
 *   		 Carlo Contavalli 
 *   		 <ccontavalli at masobit.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef MXSLT_AP1_H
# define MXSLT_AP1_H

  /* Standard includes */
# include <modxslt0/modxslt.h>
# include <assert.h>
# include <unistd.h>
# include <stdlib.h>

  /* Apache includes */
# include "ap_config.h"
# include "httpd.h"
# include "http_log.h"
# include "http_config.h"
# include "http_request.h"
# include "http_protocol.h"
# include "http_conf_globals.h"
# include "buff.h"
# include "http_vhost.h"

  /* Boolean variables */
# define MXSLT_STATE_UNSET (-1)
# define MXSLT_STATE_OFF (0)
# define MXSLT_STATE_ON (1)

  /* xslt handlers */
# define MXSLT_DYN_HANDLER "mod-xslt-dynamic"
# define MXSLT_FRC_HANDLER "mod-xslt-force"

# define MXSLT_NOTE_LOG "mod-xslt-tmp"

  /* String constants */
# define MXSLT_NOTE_HANDLER "MXSLT_HANDLER"

  /* Temporary file handling constants */
# define MXSLT_DEFAULT_TMP_DIR "/tmp/mod-xslt"
# define MXSLT_TMP_NAME "mod-xslt.XXXXXX"

  /* Some macros */
# define mxslt_engine_on(state) ((state) == MXSLT_STATE_ON)

  /* Debugging */
# if defined MXSLT_DO_DEBUG && defined __GNUC__
#  define AP1_DEBUG_DUMP_TABLE(str, table) ({ int __i; \
  					     array_header * __harr = ap_table_elts(table); \
                                             table_entry * __entry = (table_entry *)__harr->elts; \
					     MXSLT_DEBUG(str); \
                                             for(__i=0; __i < __harr->nelts; __i++) \
					       MXSLT_DEBUG("    %s -> %s\n", __entry[__i].key, __entry[__i].val); })
#  define mxslt_ap1_get_config(a, b) ({  mxslt_dir_config_t * __var; \
				       __var=(mxslt_dir_config_t *)ap_get_module_config(a,b); \
				       MXSLT_DEBUG("Fetched config\n");\
				       MXSLT_DEBUG("* config: %08x\n", (int)__var); \
				       MXSLT_DEBUG("* config->state: %d\n", __var->state); \
				       MXSLT_DEBUG("* config->tmpdir: %s\n", __var->tmpdir); \
				       AP1_DEBUG_DUMP_TABLE("* config->params\n", __var->params); \
				       AP1_DEBUG_DUMP_TABLE("* config->mime_styles\n", __var->mime_styles); \
				       AP1_DEBUG_DUMP_TABLE("* config->filter_dynamic\n", __var->filter_dynamic); \
				       AP1_DEBUG_DUMP_TABLE("* config->filter_force\n", __var->filter_force); \
				       __var;  })
# else /* MXSLT_DO_DEBUG */
#  define mxslt_ap1_get_config(a, b) (mxslt_dir_config_t *)ap_get_module_config(a, b)
# endif /* MXSLT_DO_DEBUG */


# ifndef MXSLT_MAX_REDIR
#  define MXSLT_MAX_REDIR 15
# endif

typedef struct mxslt_dir_config_t {
  table * mime_styles;
  table * default_styles;
  table * filter_dynamic;
  table * filter_force;
  table * params;
  table * rules;

  char * tmpdir;
  int state;
  int unlink;
} mxslt_dir_config_t;

/* ./mod_xslt.c */
extern mxslt_shoot_t ap1_mxslt_global_state;
extern mxslt_recursion_t mxslt_global_recursion;
/*
extern mxslt_doc_t * mxslt_global_document;
extern request_rec * mxslt_global_r;
*/

/* ./ap1-helpers.c */
extern void mxslt_remove_file(char * filename);
extern int mxslt_ap1_mktemp_file(request_rec * r, char * dir, char ** file);
extern void mxslt_ap1_error(void *ctx, const char *msg, ...);
extern int mxslt_ap1_set_headers(mxslt_doc_t *document, request_rec *r);
extern request_rec *mxslt_ap1_sub_request_pass(request_rec *r, mxslt_dir_config_t *config, char * uri,
					  char **file, int * status, int unlink);
extern request_rec *mxslt_ap1_sub_request(request_rec *r, int fd, struct in_addr *, uri_components * uri, int * toret);
extern int mxslt_ap1_file_parse(request_rec *r, const char *filename, const char * defaultstyle, const char *forcestyle, table * rules, table * table);
extern table * mxslt_ap1_merge_tables(pool * p, table * table_new, table * table_old);

#endif /* MXSLT_AP1_H */
