%global macrosdir %(d=%{_rpmconfigdir}/macros.d; [ -d $d ] || d=%{_sysconfdir}/rpm; echo $d)
%global vimdatadir %{_datadir}/vim/vimfiles

Name:           environment-modules
Version:        5.1.0
Release:        1%{?dist}
Summary:        Provides dynamic modification of a user's environment

License:        GPLv2+
URL:            http://modules.sourceforge.net/
Source0:        http://downloads.sourceforge.net/modules/modules-5.1.0.tar.bz2

BuildRequires:  tcl
BuildRequires:  dejagnu
BuildRequires:  make
BuildRequires:  sed
BuildRequires:  less
%if 0%{?rhel} && 0%{?rhel} <= 6
BuildRequires:  net-tools
BuildRequires:  procps
%else
BuildRequires:  hostname
BuildRequires:  procps-ng
%endif
# specific requirements to build extension library
BuildRequires:  gcc
BuildRequires:  tcl-devel
Requires:       tcl
Requires:       sed
Requires:       less
Requires:       vim-filesystem
%if 0%{?rhel} && 0%{?rhel} <= 6
Requires:       procps
Requires:       man
%else
Requires:       procps-ng
Requires:       man-db
%endif
Requires(post): coreutils
Requires(post): %{_sbindir}/update-alternatives
Requires(postun): %{_sbindir}/update-alternatives
%if 0%{?fedora}
Provides:       environment(modules)
%else
Provides:       environment-modules
%endif
Obsoletes:      modules-tcl <= 1.923
Obsoletes:      environment-modules-compat <= 4.8.99

%description
The Environment Modules package provides for the dynamic modification of
a user's environment via modulefiles.

Each modulefile contains the information needed to configure the shell
for an application. Once the Modules package is initialized, the
environment can be modified on a per-module basis using the module
command which interprets modulefiles. Typically modulefiles instruct
the module command to alter or set shell environment variables such as
PATH, MANPATH, etc. modulefiles may be shared by many users on a system
and users may have their own collection to supplement or replace the
shared modulefiles.

Modules can be loaded and unloaded dynamically and atomically, in an
clean fashion. All popular shells are supported, including bash, ksh,
zsh, sh, csh, tcsh, as well as some scripting languages such as perl.

Modules are useful in managing different versions of applications.
Modules can also be bundled into metamodules that will load an entire
suite of different applications.

NOTE: You will need to get a new shell after installing this package to
have access to the module alias.


%prep
%setup -q -n modules-5.1.0


%build
%if 0%{?fedora} >= 22 || 0%{?rhel} >= 8
  %global pythonbin /usr/bin/python3
%else
  %global pythonbin /usr/bin/python
%endif

%configure --prefix=%{_datadir}/Modules \
           --libdir=%{_libdir} \
           --etcdir=%{_sysconfdir}/%{name} \
           --bindir=%{_datadir}/Modules/bin \
           --libexecdir=%{_datadir}/Modules/libexec \
           --mandir=%{_mandir} \
           --vimdatadir=%{vimdatadir} \
           --with-bashcompletiondir=%{_datadir}/bash-completion/completions \
           --with-fishcompletiondir=%{_datadir}/fish/vendor_completions.d \
           --with-zshcompletiondir=%{_datadir}/zsh/site-functions \
           --enable-multilib-support \
           --disable-doc-install \
           --enable-modulespath \
           --with-python=%{pythonbin} \
           --with-modulepath=%{_datadir}/Modules/modulefiles:%{_sysconfdir}/modulefiles:%{_datadir}/modulefiles \
           --with-quarantine-vars='LD_LIBRARY_PATH LD_PRELOAD'

%if 0%{?fedora} >= 22 || 0%{?rhel} >= 7
%make_build
%else
make %{?_smp_mflags}
%endif


%install
%if 0%{?fedora} >= 22 || 0%{?rhel} >= 7
%make_install
%else
make install DESTDIR=%{buildroot}
%endif

mkdir -p %{buildroot}%{_sysconfdir}/modulefiles
mkdir -p %{buildroot}%{_datadir}/modulefiles
mkdir -p %{buildroot}%{_sysconfdir}/profile.d
mkdir -p %{buildroot}%{_bindir}
%if 0%{?fedora}
# setup for alternatives
touch %{buildroot}%{_sysconfdir}/profile.d/modules.{csh,sh}
touch %{buildroot}%{_bindir}/modulecmd
# remove modulecmd wrapper as it will be handled by alternatives
rm -f %{buildroot}%{_datadir}/Modules/bin/modulecmd
%else
# install profile links
ln -s %{_datadir}/Modules/init/profile.csh %{buildroot}%{_sysconfdir}/profile.d/modules.csh
ln -s %{_datadir}/Modules/init/profile.sh %{buildroot}%{_sysconfdir}/profile.d/modules.sh
# install modulecmd wrapper script
mv %{buildroot}%{_datadir}/Modules/bin/modulecmd %{buildroot}%{_bindir}/
%endif

# major utilities go to regular bin dir
mv %{buildroot}%{_datadir}/Modules/bin/envml %{buildroot}%{_bindir}/

mv {doc/build/,}NEWS.txt
mv {doc/build/,}MIGRATING.txt
mv {doc/build/,}CONTRIBUTING.txt
mv {doc/build/,}INSTALL.txt
mv {doc/build/,}changes.txt

# install the rpm config file
install -Dpm 644 contrib/rpm/macros.%{name} %{buildroot}/%{macrosdir}/macros.%{name}


%check
make test QUICKTEST=1


%if 0%{?fedora}
%post
# Cleanup from pre-alternatives
[ ! -L %{_sysconfdir}/profile.d/modules.sh ] &&  rm -f %{_sysconfdir}/profile.d/modules.sh
[ ! -L %{_sysconfdir}/profile.d/modules.csh ] &&  rm -f %{_sysconfdir}/profile.d/modules.csh
[ ! -L %{_bindir}/modulecmd ] &&  rm -f %{_bindir}/modulecmd

# Migration from version 3.x to 4
if [ "$(readlink /etc/alternatives/modules.sh)" = '%{_datadir}/Modules/init/modules.sh' ]; then
  %{_sbindir}/update-alternatives --remove modules.sh %{_datadir}/Modules/init/modules.sh
fi

%{_sbindir}/update-alternatives \
  --install %{_sysconfdir}/profile.d/modules.sh modules.sh %{_datadir}/Modules/init/profile.sh 40 \
  --slave %{_sysconfdir}/profile.d/modules.csh modules.csh %{_datadir}/Modules/init/profile.csh \
  --slave %{_bindir}/modulecmd modulecmd %{_datadir}/Modules/libexec/modulecmd.tcl

%postun
if [ $1 -eq 0 ] ; then
  %{_sbindir}/update-alternatives --remove modules.sh %{_datadir}/Modules/init/profile.sh
fi
%endif


%files
%if 0%{?rhel} && 0%{?rhel} <= 6
%doc COPYING.GPLv2
%else
%license COPYING.GPLv2
%endif
%doc ChangeLog README NEWS.txt MIGRATING.txt INSTALL.txt CONTRIBUTING.txt changes.txt
%{_sysconfdir}/modulefiles
%if 0%{?fedora}
%ghost %{_sysconfdir}/profile.d/modules.csh
%ghost %{_sysconfdir}/profile.d/modules.sh
%ghost %{_bindir}/modulecmd
%else
%{_sysconfdir}/profile.d/modules.csh
%{_sysconfdir}/profile.d/modules.sh
%{_bindir}/modulecmd
%endif
%{_bindir}/envml
%{_libdir}/libtclenvmodules.so
%dir %{_datadir}/Modules
%{_datadir}/Modules/bin
%dir %{_datadir}/Modules/libexec
%{_datadir}/Modules/libexec/modulecmd.tcl
%dir %{_datadir}/Modules/init
%{_datadir}/Modules/init/*
# do not need to require shell package as we "own" completion dir
%dir %{_datadir}/bash-completion/completions
%{_datadir}/bash-completion/completions/module
%{_datadir}/bash-completion/completions/ml
%dir %{_datadir}/zsh/site-functions
%{_datadir}/zsh/site-functions/_module
%dir %{_datadir}/fish/vendor_completions.d
%{_datadir}/fish/vendor_completions.d/module.fish
%dir %{_sysconfdir}/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/initrc
%config(noreplace) %{_sysconfdir}/%{name}/modulespath
%config(noreplace) %{_sysconfdir}/%{name}/siteconfig.tcl
%{_datadir}/Modules/modulefiles
%{_datadir}/modulefiles
%{_mandir}/man1/ml.1.gz
%{_mandir}/man1/module.1.gz
%{_mandir}/man4/modulefile.4.gz
%{macrosdir}/macros.%{name}
%{vimdatadir}/ftdetect/modulefile.vim
%{vimdatadir}/ftplugin/modulefile.vim
%{vimdatadir}/syntax/modulefile.vim


%changelog
* Sat Apr 30 2022 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 5.1.0-1
- Update to 5.1.0
- Install shell completion scripts in system-wide shell-specific locations

* Sat Oct 16 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 5.0.1-1
- Update to 5.0.1

* Sun Sep 12 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 5.0.0-1
- Update to 5.0.0
- Configuration guide example.txt is replaced by more up to date INSTALL.txt
  document

* Sun Jul 25 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 5.0.0-0.1.alpha
- Update to 5.0.0-alpha
- Remove createmodule.sh and createmodule.py utilities ('module sh-to-mod'
  should be used instead)
- Remove configure options that have been made default starting version 5.0
- Remove compat subpackage
- Run non-regression tests in quick mode

* Wed Jul 14 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.8.0-1
- Update to 4.8.0

* Tue Apr  6 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.7.1-1
- Update to 4.7.1

* Fri Feb 19 2021 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.7.0-1
- Update to 4.7.0
- Remove obsolete 'Group' tag
- Add build dependency on 'make'
- Align spec file syntax with Fedora spec file

* Sat Nov 14 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.6.1-1
- Update to 4.6.1

* Wed Sep 16 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.6.0-1
- Update to 4.6.0
- Enable multilib support
- Specifically enable compatibility version build to make compat package

* Mon Aug 31 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.5.3-1
- Update to 4.5.3
- Use 'configure' macro
- Fix modulecmd pre-alternatives cleanup check
- Use 'make_build' and 'make_install' macros

* Thu Jul 30 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.5.2-1
- Update to 4.5.2

* Mon Jun 01 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.5.1-1
- Update to 4.5.1

* Tue Apr 07 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.5.0-1
- Update to 4.5.0
- Add ml(1) man page
- Append LD_PRELOAD environment variable to the quarantine environment
  variable list
- createmodule.py tool is now automatically installed during Modules
  installation process and its Python shebang is set by the configure option
  --with-python

* Fri Jan 03 2020 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.4.1-1
- Update to 4.4.1
- Fix spec file for el8 build

* Sun Nov 17 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.4.0-1
- Update to 4.4.0

* Sat Sep 21 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.3.1-1
- Update to 4.3.1

* Fri Jul 26 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.3.0-1
- Update to 4.3.0
- Add Vim syntax addons
- Enable libtclenvmodules
- Add a default site configuration file in etc directory
- Disable shell startup file set (bugs #1578587 and #1699234)
- Set etc directory to /etc/environment-modules and move in it configuration
  files previously installed in init directory. modulerc and .modulespath
  files in init directory respectively become initrc and modulespath in etc
  directory (bug #1506663) 

* Mon Jul 08 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.5-1
- Update to 4.2.5

* Fri Apr 26 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.4-1
- Update to 4.2.4

* Sat Mar 23 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.3-1
- Update to 4.2.3
- Add CONTRIBUTING guide to doc

* Sun Feb 17 2019 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.2-1
- Update to 4.2.2

* Sun Nov 11 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.1-1
- Update to 4.2.1

* Thu Oct 18 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.2.0-1
- Update to 4.2.0

* Mon Aug 20 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.1.4-1
- Update to 4.1.4

* Mon Jun 18 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.1.3-1
- Update to 4.1.3

* Sat Mar 31 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.1.2-1
- Update to 4.1.2

* Sat Feb 17 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.1.1-1
- Update to 4.1.1
- Move hostname requirement to compat subpackage (bug #1545369)
- Add procps in build requirements as 'ps' is now checked at configure time

* Mon Jan 15 2018 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.1.0-1
- Update to 4.1.0
- Enable pagination with less as pager
- Define LD_LIBRARY_PATH as quarantine variable to protect module execution

* Mon Oct 16 2017 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.0.0-1
- Update to 4.0.0
- Add Obsoletes/Provides rules for modules-tcl package

* Tue Sep 26 2017 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.0.0-0.2.beta
- Integrate createmodule.sh and createmodule.py in distribution tarball

* Mon Sep 25 2017 Xavier Delaruelle <xavier.delaruelle@cea.fr> - 4.0.0-0.1.beta
- Update to 4.0.0-beta
- Define compat subpackage to provide 3.2 compatibility version also
  provided in source tarball
- Add condition statements to either build on Fedora and EL systems

* Wed Aug 02 2017 Fedora Release Engineering <releng@fedoraproject.org> - 3.2.10-23
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Binutils_Mass_Rebuild

* Wed Jul 26 2017 Fedora Release Engineering <releng@fedoraproject.org> - 3.2.10-22
- Rebuilt for https://fedoraproject.org/wiki/Fedora_27_Mass_Rebuild

* Thu Mar 16 2017 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-21
- Use alternatives for man pages as well

* Fri Feb 10 2017 Fedora Release Engineering <releng@fedoraproject.org> - 3.2.10-20
- Rebuilt for https://fedoraproject.org/wiki/Fedora_26_Mass_Rebuild

* Mon Dec 19 2016 Miro Hrončok <mhroncok@redhat.com> - 3.2.10-19
- Rebuild for Python 3.6

* Sun Dec 4 2016 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-18
- Fix compilation with -Werror=implicit-function-declaration
- Use %%license

* Wed Feb 03 2016 Fedora Release Engineering <releng@fedoraproject.org> - 3.2.10-17
- Rebuilt for https://fedoraproject.org/wiki/Fedora_24_Mass_Rebuild

* Mon Jul 13 2015 Orion Poplwski <orion@cora.nwra.com> - 3.2.10-16
- Add patch to fix unload from loaded modulefile (bug #1117334)

* Wed Jun 17 2015 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.10-15
- Rebuilt for https://fedoraproject.org/wiki/Fedora_23_Mass_Rebuild

* Mon Mar 2 2015 Orion Poplwski <orion@cora.nwra.com> - 3.2.10-14
- Fix createmodule.sh to handle exported functions (bug #1197321)
- Handle more prefix/suffix cases in createmodule.{sh,py} (bug #1079341)

* Wed Jan 28 2015 Orion Poplwski <orion@cora.nwra.com> - 3.2.10-13
- Add patch for python 3 support, use python3 for createmodule.py on F22

* Sat Aug 16 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.10-12
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_22_Mass_Rebuild

* Sat Jun 07 2014 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.10-11
- Rebuilt for https://fedoraproject.org/wiki/Fedora_21_Mass_Rebuild

* Tue May 27 2014 Orion Poplwski <orion@cora.nwra.com> - 3.2.10-10
- Add patch to support Tcl 8.6

* Wed May 21 2014 Jaroslav Škarvada <jskarvad@redhat.com> - 3.2.10-10
- Rebuilt for https://fedoraproject.org/wiki/Changes/f21tcl86

* Mon Apr 14 2014 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-9
- Use alternatives for /etc/profile.d/modules.{csh,sh}
- Add /usr/share/modulefiles to MODULEPATH
- Add rpm macro to define %%_modulesdir

* Mon Dec 23 2013 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-8
- Fix -Werror=format-security (bug #1037053)

* Wed Sep 4 2013 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-7
- Update createmodule scripts to handle more path like variables (bug #976647)

* Sat Aug 03 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.10-6
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Tue May 14 2013 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-5
- Really do not replace modified profile.d scripts (bug #962762)
- Specfile cleanup

* Wed Apr 17 2013 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-4
- Do not replace modified profile.d scripts (bug #953199)

* Wed Feb 13 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.10-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_19_Mass_Rebuild

* Tue Jan 15 2013 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-2
- Add patch to comment out stray module use in modules file when not using
  versioning (bug #895555)
- Add patch to fix module clear command (bug #895551)
- Add patch from modules list to add completion to avail command

* Fri Dec 21 2012 Orion Poplawski <orion@cora.nwra.com> - 3.2.10-1
- Update to 3.2.10
- Drop regex patch

* Wed Oct 31 2012 Orion Poplawski <orion@cora.nwra.com> - 3.2.9c-5
- Updated createmodule.sh, added createmodule.py, can handle path prefixes

* Fri Aug 24 2012 Orion Poplawski <orion@cora.nwra.com> - 3.2.9c-4
- Add patch to fix segfault from Tcl RexExp handling (bug 834580)

* Wed Jul 18 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.9c-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Fri Jan 13 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.9c-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Tue Nov 29 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.9c-1
- Update to 3.2.9c (fixes bug 753760)

* Tue Nov 22 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.9b-2
- Make .modulespath a config file

* Tue Nov 15 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.9b-1
- Update to 3.2.9b

* Fri Nov 11 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.9a-2
- Add %%check section

* Fri Nov 11 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.9a-1
- Update to 3.2.9a
- Drop strcpy patch

* Thu Sep 22 2011 Orion Poplawski <orion@cora.nwra.com> - 3.2.8a-3
- Add patch to fix overlapping strcpy() in Remove_Path, hopefully fixes
  bug 737043

* Tue Feb 08 2011 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.8a-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_15_Mass_Rebuild

* Mon Oct 4 2010 Orion Poplawski <orion@cora.nwra.com> - 3.2.8a-1
- Update to 3.2.8a, changes --with-def-man-path to --with-man-path

* Mon Oct 4 2010 Orion Poplawski <orion@cora.nwra.com> - 3.2.8-1
- Update to 3.2.8
- Drop mandir patch, use --with-def-man-path

* Thu Jan 7 2010 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-7
- Add patch to set a sane default MANPATH
- Add createmodule.sh utility script for creating modulefiles

* Mon Nov 30 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-6
- Add Requires: propcs (bug #54272)

* Mon Oct 26 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-5
- Don't assume different shell init scripts exist (bug #530770)

* Fri Oct 23 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-4
- Don't load bash init script when bash is running as "sh" (bug #529745)

* Mon Oct 19 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-3
- Support different flavors of "sh" (bug #529493)

* Wed Sep 23 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-2
- Add patch to fix modulecmd path in init files

* Wed Sep 23 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7b-1
- Update to 3.2.7b

* Mon Sep 21 2009 Orion Poplawski <orion@cora.nwra.com> - 3.2.7-1
- Update to 3.2.7, fixes bug #524475
- Drop versioning patch fixed upstream

* Fri Jul 24 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.6-8
- Rebuilt for https://fedoraproject.org/wiki/Fedora_12_Mass_Rebuild

* Tue Feb 24 2009 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 3.2.6-7
- Rebuilt for https://fedoraproject.org/wiki/Fedora_11_Mass_Rebuild

* Wed Sep 3 2008 - Orion Poplawski <orion@cora.nwra.com> - 3.2.6-6
- Change %%patch -> %%patch0

* Fri Mar 14 2008 - Orion Poplawski <orion@cora.nwra.com> - 3.2.6-5
- Add BR libX11-devel so modulecmd can handle X resources

* Wed Mar  5 2008 - Orion Poplawski <orion@cora.nwra.com> - 3.2.6-4
- Add patch to fix extraneous version path entry properly
- Use --with-module-path to point to /etc/modulefiles for local modules,
  this also fixes bug #436041

* Sat Feb  9 2008 - Orion Poplawski <orion@cora.nwra.com> - 3.2.6-3
- Rebuild for gcc 3.4

* Thu Jan 03 2008 - Alex Lancaster <alexlan at fedoraproject.org> - 3.2.6-2
- Rebuild for new Tcl (8.5).

* Fri Nov  2 2007 - Orion Poplawski <orion@cora.nwra.com> - 3.2.6-1
- Update to 3.2.6

* Tue Aug 21 2007 - Orion Poplawski <orion@cora.nwra.com> - 3.2.5-2
- Update license tag to GPLv2

* Fri Feb 16 2007 - Orion Poplawski <orion@cora.nwra.com> - 3.2.5-1
- Update to 3.2.5

* Wed Feb 14 2007 - Orion Poplawski <orion@cora.nwra.com> - 3.2.4-2
- Rebuild for Tcl downgrade

* Fri Feb 09 2007 - Orion Poplawski <orion@cora.nwra.com> - 3.2.4-1
- Update to 3.2.4

* Wed Dec 20 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.3-3
- Add --with-version-path to set VERSIONPATH (bug 220260)

* Tue Aug 29 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.3-2
- Rebuild for FC6

* Fri Jun  2 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.3-1
- Update to 3.2.3

* Fri May  5 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.2-1
- Update to 3.2.2

* Fri Mar 24 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.1-1
- Update to 3.2.1

* Thu Feb  9 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.0p1-1
- Update to 3.2.0p1

* Fri Jan 27 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.0-2
- Add profile.d links

* Tue Jan 24 2006 - Orion Poplawski <orion@cora.nwra.com> - 3.2.0-1
- Fedora Extras packaging
