use strict;
use warnings;

use Module::Build;

my $builder = Module::Build->new(
    module_name       => 'Module::Build::CipUX',
    license           => 'gpl',
    dist_author       => 'Christian Kuelker <christian.kuelker@cipworx.org>',
    dist_version_from => 'lib/Module/Build/CipUX.pm',

    #   create_makefile_pl => 'traditional',
    #   create_readme      => 1,
    installdirs => 'vendor',

    recommends => {
        'Test::Perl::Critic' => 0,
        'Readonly::XS'       => 0,
    },

    build_requires => {
        'Test::More'          => 0,
        'Test::Pod'           => '1.14',
        'Test::Pod::Coverage' => '1.04',
        'version'             => 0,
    },

    requires => {
        'Module::Build' => 0,
        'Readonly'      => 0,
        'version'       => 0,
    },

    add_to_cleanup => ['Module-Build-CipUX-*'],
);

$builder->create_build_script();
