
#ifndef _LIBINJECTION_SQLI_DATA_H
#define _LIBINJECTION_SQLI_DATA_H

#include "libinjection.h"

typedef struct {
    const char *word;
    char type;
} keyword_t;

static size_t parse_money(sfilter * sf);
static size_t parse_other(sfilter * sf);
static size_t parse_white(sfilter * sf);
static size_t parse_operator1(sfilter *sf);
static size_t parse_char(sfilter *sf);
static size_t parse_hash(sfilter *sf);
static size_t parse_dash(sfilter *sf);
static size_t parse_slash(sfilter *sf);
static size_t parse_backslash(sfilter * sf);
static size_t parse_operator2(sfilter *sf);
static size_t parse_string(sfilter *sf);
static size_t parse_word(sfilter * sf);
static size_t parse_var(sfilter * sf);
static size_t parse_number(sfilter * sf);
static size_t parse_tick(sfilter * sf);
static size_t parse_underscore(sfilter * sf);
static size_t parse_ustring(sfilter * sf);
static size_t parse_qstring(sfilter * sf);
static size_t parse_nqstring(sfilter * sf);
static size_t parse_xstring(sfilter * sf);
static size_t parse_bstring(sfilter * sf);
static size_t parse_estring(sfilter * sf);


typedef size_t (*pt2Function)(sfilter *sf);
static const pt2Function char_parse_map[] = {
   &parse_white, /* 0 */
   &parse_white, /* 1 */
   &parse_white, /* 2 */
   &parse_white, /* 3 */
   &parse_white, /* 4 */
   &parse_white, /* 5 */
   &parse_white, /* 6 */
   &parse_white, /* 7 */
   &parse_white, /* 8 */
   &parse_white, /* 9 */
   &parse_white, /* 10 */
   &parse_white, /* 11 */
   &parse_white, /* 12 */
   &parse_white, /* 13 */
   &parse_white, /* 14 */
   &parse_white, /* 15 */
   &parse_white, /* 16 */
   &parse_white, /* 17 */
   &parse_white, /* 18 */
   &parse_white, /* 19 */
   &parse_white, /* 20 */
   &parse_white, /* 21 */
   &parse_white, /* 22 */
   &parse_white, /* 23 */
   &parse_white, /* 24 */
   &parse_white, /* 25 */
   &parse_white, /* 26 */
   &parse_white, /* 27 */
   &parse_white, /* 28 */
   &parse_white, /* 29 */
   &parse_white, /* 30 */
   &parse_white, /* 31 */
   &parse_white, /* 32 */
   &parse_operator2, /* 33 */
   &parse_string, /* 34 */
   &parse_hash, /* 35 */
   &parse_money, /* 36 */
   &parse_operator1, /* 37 */
   &parse_operator2, /* 38 */
   &parse_string, /* 39 */
   &parse_char, /* 40 */
   &parse_char, /* 41 */
   &parse_operator2, /* 42 */
   &parse_operator1, /* 43 */
   &parse_char, /* 44 */
   &parse_dash, /* 45 */
   &parse_number, /* 46 */
   &parse_slash, /* 47 */
   &parse_number, /* 48 */
   &parse_number, /* 49 */
   &parse_number, /* 50 */
   &parse_number, /* 51 */
   &parse_number, /* 52 */
   &parse_number, /* 53 */
   &parse_number, /* 54 */
   &parse_number, /* 55 */
   &parse_number, /* 56 */
   &parse_number, /* 57 */
   &parse_operator2, /* 58 */
   &parse_char, /* 59 */
   &parse_operator2, /* 60 */
   &parse_operator2, /* 61 */
   &parse_operator2, /* 62 */
   &parse_other, /* 63 */
   &parse_var, /* 64 */
   &parse_word, /* 65 */
   &parse_bstring, /* 66 */
   &parse_word, /* 67 */
   &parse_word, /* 68 */
   &parse_estring, /* 69 */
   &parse_word, /* 70 */
   &parse_word, /* 71 */
   &parse_word, /* 72 */
   &parse_word, /* 73 */
   &parse_word, /* 74 */
   &parse_word, /* 75 */
   &parse_word, /* 76 */
   &parse_word, /* 77 */
   &parse_nqstring, /* 78 */
   &parse_word, /* 79 */
   &parse_word, /* 80 */
   &parse_qstring, /* 81 */
   &parse_word, /* 82 */
   &parse_word, /* 83 */
   &parse_word, /* 84 */
   &parse_ustring, /* 85 */
   &parse_word, /* 86 */
   &parse_word, /* 87 */
   &parse_xstring, /* 88 */
   &parse_word, /* 89 */
   &parse_word, /* 90 */
   &parse_other, /* 91 */
   &parse_backslash, /* 92 */
   &parse_other, /* 93 */
   &parse_operator1, /* 94 */
   &parse_underscore, /* 95 */
   &parse_tick, /* 96 */
   &parse_word, /* 97 */
   &parse_bstring, /* 98 */
   &parse_word, /* 99 */
   &parse_word, /* 100 */
   &parse_estring, /* 101 */
   &parse_word, /* 102 */
   &parse_word, /* 103 */
   &parse_word, /* 104 */
   &parse_word, /* 105 */
   &parse_word, /* 106 */
   &parse_word, /* 107 */
   &parse_word, /* 108 */
   &parse_word, /* 109 */
   &parse_nqstring, /* 110 */
   &parse_word, /* 111 */
   &parse_word, /* 112 */
   &parse_qstring, /* 113 */
   &parse_word, /* 114 */
   &parse_word, /* 115 */
   &parse_word, /* 116 */
   &parse_ustring, /* 117 */
   &parse_word, /* 118 */
   &parse_word, /* 119 */
   &parse_xstring, /* 120 */
   &parse_word, /* 121 */
   &parse_word, /* 122 */
   &parse_other, /* 123 */
   &parse_operator2, /* 124 */
   &parse_other, /* 125 */
   &parse_operator1, /* 126 */
   &parse_white, /* 127 */
};

static const keyword_t sql_keywords[] = {
    {"!!", 'o'},
    {"!<", 'o'},
    {"!=", 'o'},
    {"!>", 'o'},
    {"%=", 'o'},
    {"&&", '&'},
    {"&=", 'o'},
    {"*=", 'o'},
    {"+=", 'o'},
    {"-=", 'o'},
    {"/=", 'o'},
    {"0&((((", 'F'},
    {"0&(((1", 'F'},
    {"0&(((F", 'F'},
    {"0&(((N", 'F'},
    {"0&(((S", 'F'},
    {"0&(((V", 'F'},
    {"0&((1)", 'F'},
    {"0&((1O", 'F'},
    {"0&((F(", 'F'},
    {"0&((N)", 'F'},
    {"0&((NO", 'F'},
    {"0&((S)", 'F'},
    {"0&((SO", 'F'},
    {"0&((V)", 'F'},
    {"0&((VO", 'F'},
    {"0&(1))", 'F'},
    {"0&(1)O", 'F'},
    {"0&(1)U", 'F'},
    {"0&(1O(", 'F'},
    {"0&(1OF", 'F'},
    {"0&(1OS", 'F'},
    {"0&(1OV", 'F'},
    {"0&(F((", 'F'},
    {"0&(F()", 'F'},
    {"0&(F(1", 'F'},
    {"0&(F(F", 'F'},
    {"0&(F(N", 'F'},
    {"0&(F(S", 'F'},
    {"0&(F(V", 'F'},
    {"0&(N))", 'F'},
    {"0&(N)O", 'F'},
    {"0&(N)U", 'F'},
    {"0&(NO(", 'F'},
    {"0&(NOF", 'F'},
    {"0&(NOS", 'F'},
    {"0&(NOV", 'F'},
    {"0&(S))", 'F'},
    {"0&(S)O", 'F'},
    {"0&(S)U", 'F'},
    {"0&(SO(", 'F'},
    {"0&(SO1", 'F'},
    {"0&(SOF", 'F'},
    {"0&(SON", 'F'},
    {"0&(SOS", 'F'},
    {"0&(SOV", 'F'},
    {"0&(V))", 'F'},
    {"0&(V)O", 'F'},
    {"0&(V)U", 'F'},
    {"0&(VO(", 'F'},
    {"0&(VOF", 'F'},
    {"0&(VOS", 'F'},
    {"0&1O((", 'F'},
    {"0&1O(1", 'F'},
    {"0&1O(F", 'F'},
    {"0&1O(N", 'F'},
    {"0&1O(S", 'F'},
    {"0&1O(V", 'F'},
    {"0&1OF(", 'F'},
    {"0&1OS(", 'F'},
    {"0&1OS1", 'F'},
    {"0&1OSF", 'F'},
    {"0&1OSO", 'F'},
    {"0&1OSU", 'F'},
    {"0&1OSV", 'F'},
    {"0&1OV(", 'F'},
    {"0&1OVF", 'F'},
    {"0&1OVO", 'F'},
    {"0&1OVS", 'F'},
    {"0&1OVU", 'F'},
    {"0&1UE(", 'F'},
    {"0&1UE1", 'F'},
    {"0&1UEF", 'F'},
    {"0&1UEK", 'F'},
    {"0&1UEN", 'F'},
    {"0&1UES", 'F'},
    {"0&1UEV", 'F'},
    {"0&F(((", 'F'},
    {"0&F(()", 'F'},
    {"0&F((1", 'F'},
    {"0&F((F", 'F'},
    {"0&F((N", 'F'},
    {"0&F((S", 'F'},
    {"0&F((V", 'F'},
    {"0&F())", 'F'},
    {"0&F()O", 'F'},
    {"0&F()U", 'F'},
    {"0&F(1)", 'F'},
    {"0&F(1O", 'F'},
    {"0&F(F(", 'F'},
    {"0&F(N)", 'F'},
    {"0&F(NO", 'F'},
    {"0&F(S)", 'F'},
    {"0&F(SO", 'F'},
    {"0&F(V)", 'F'},
    {"0&F(VO", 'F'},
    {"0&NO((", 'F'},
    {"0&NO(1", 'F'},
    {"0&NO(F", 'F'},
    {"0&NO(N", 'F'},
    {"0&NO(S", 'F'},
    {"0&NO(V", 'F'},
    {"0&NOF(", 'F'},
    {"0&NOS(", 'F'},
    {"0&NOS1", 'F'},
    {"0&NOSF", 'F'},
    {"0&NOSO", 'F'},
    {"0&NOSU", 'F'},
    {"0&NOSV", 'F'},
    {"0&NOV(", 'F'},
    {"0&NOVF", 'F'},
    {"0&NOVO", 'F'},
    {"0&NOVS", 'F'},
    {"0&NOVU", 'F'},
    {"0&NUE(", 'F'},
    {"0&NUE1", 'F'},
    {"0&NUEF", 'F'},
    {"0&NUEK", 'F'},
    {"0&NUEN", 'F'},
    {"0&NUES", 'F'},
    {"0&NUEV", 'F'},
    {"0&SO((", 'F'},
    {"0&SO(1", 'F'},
    {"0&SO(F", 'F'},
    {"0&SO(N", 'F'},
    {"0&SO(S", 'F'},
    {"0&SO(V", 'F'},
    {"0&SO1(", 'F'},
    {"0&SO1F", 'F'},
    {"0&SO1N", 'F'},
    {"0&SO1O", 'F'},
    {"0&SO1S", 'F'},
    {"0&SO1U", 'F'},
    {"0&SO1V", 'F'},
    {"0&SOF(", 'F'},
    {"0&SON(", 'F'},
    {"0&SON1", 'F'},
    {"0&SONF", 'F'},
    {"0&SONO", 'F'},
    {"0&SONU", 'F'},
    {"0&SOS(", 'F'},
    {"0&SOS1", 'F'},
    {"0&SOSF", 'F'},
    {"0&SOSO", 'F'},
    {"0&SOSU", 'F'},
    {"0&SOSV", 'F'},
    {"0&SOV(", 'F'},
    {"0&SOVF", 'F'},
    {"0&SOVO", 'F'},
    {"0&SOVS", 'F'},
    {"0&SOVU", 'F'},
    {"0&SUE(", 'F'},
    {"0&SUE1", 'F'},
    {"0&SUEF", 'F'},
    {"0&SUEK", 'F'},
    {"0&SUEN", 'F'},
    {"0&SUES", 'F'},
    {"0&SUEV", 'F'},
    {"0&VO((", 'F'},
    {"0&VO(1", 'F'},
    {"0&VO(F", 'F'},
    {"0&VO(N", 'F'},
    {"0&VO(S", 'F'},
    {"0&VO(V", 'F'},
    {"0&VOF(", 'F'},
    {"0&VOS(", 'F'},
    {"0&VOS1", 'F'},
    {"0&VOSF", 'F'},
    {"0&VOSO", 'F'},
    {"0&VOSU", 'F'},
    {"0&VOSV", 'F'},
    {"0&VUE(", 'F'},
    {"0&VUE1", 'F'},
    {"0&VUEF", 'F'},
    {"0&VUEK", 'F'},
    {"0&VUEN", 'F'},
    {"0&VUES", 'F'},
    {"0&VUEV", 'F'},
    {"0)))))", 'F'},
    {"0))))U", 'F'},
    {"0)))UE", 'F'},
    {"0))UE(", 'F'},
    {"0))UE1", 'F'},
    {"0))UEF", 'F'},
    {"0))UEK", 'F'},
    {"0))UEN", 'F'},
    {"0))UES", 'F'},
    {"0))UEV", 'F'},
    {"0)UE((", 'F'},
    {"0)UE(1", 'F'},
    {"0)UE(F", 'F'},
    {"0)UE(N", 'F'},
    {"0)UE(S", 'F'},
    {"0)UE(V", 'F'},
    {"0)UE1K", 'F'},
    {"0)UE1O", 'F'},
    {"0)UEF(", 'F'},
    {"0)UEK(", 'F'},
    {"0)UEK1", 'F'},
    {"0)UEKF", 'F'},
    {"0)UEKN", 'F'},
    {"0)UEKS", 'F'},
    {"0)UEKV", 'F'},
    {"0)UENK", 'F'},
    {"0)UENO", 'F'},
    {"0)UESK", 'F'},
    {"0)UESO", 'F'},
    {"0)UEVK", 'F'},
    {"0)UEVO", 'F'},
    {"01&(((", 'F'},
    {"01&((1", 'F'},
    {"01&((E", 'F'},
    {"01&((F", 'F'},
    {"01&((N", 'F'},
    {"01&((S", 'F'},
    {"01&((V", 'F'},
    {"01&(1&", 'F'},
    {"01&(1)", 'F'},
    {"01&(1,", 'F'},
    {"01&(1O", 'F'},
    {"01&(E(", 'F'},
    {"01&(E1", 'F'},
    {"01&(EF", 'F'},
    {"01&(EK", 'F'},
    {"01&(EN", 'F'},
    {"01&(EO", 'F'},
    {"01&(ES", 'F'},
    {"01&(EV", 'F'},
    {"01&(F(", 'F'},
    {"01&(N&", 'F'},
    {"01&(N)", 'F'},
    {"01&(N,", 'F'},
    {"01&(NO", 'F'},
    {"01&(S&", 'F'},
    {"01&(S)", 'F'},
    {"01&(S,", 'F'},
    {"01&(SO", 'F'},
    {"01&(V&", 'F'},
    {"01&(V)", 'F'},
    {"01&(V,", 'F'},
    {"01&(VO", 'F'},
    {"01&1", 'F'},
    {"01&1&(", 'F'},
    {"01&1&1", 'F'},
    {"01&1&F", 'F'},
    {"01&1&N", 'F'},
    {"01&1&S", 'F'},
    {"01&1&V", 'F'},
    {"01&1)&", 'F'},
    {"01&1))", 'F'},
    {"01&1)U", 'F'},
    {"01&1;", 'F'},
    {"01&1;C", 'F'},
    {"01&1;E", 'F'},
    {"01&1;T", 'F'},
    {"01&1B(", 'F'},
    {"01&1B1", 'F'},
    {"01&1BF", 'F'},
    {"01&1BN", 'F'},
    {"01&1BS", 'F'},
    {"01&1BV", 'F'},
    {"01&1C", 'F'},
    {"01&1EK", 'F'},
    {"01&1EN", 'F'},
    {"01&1F(", 'F'},
    {"01&1K(", 'F'},
    {"01&1K1", 'F'},
    {"01&1KF", 'F'},
    {"01&1KN", 'F'},
    {"01&1KS", 'F'},
    {"01&1KV", 'F'},
    {"01&1O(", 'F'},
    {"01&1OF", 'F'},
    {"01&1OO", 'F'},
    {"01&1OS", 'F'},
    {"01&1OV", 'F'},
    {"01&1TN", 'F'},
    {"01&1U", 'F'},
    {"01&1U(", 'F'},
    {"01&1U;", 'F'},
    {"01&1UC", 'F'},
    {"01&1UE", 'F'},
    {"01&E((", 'F'},
    {"01&E(1", 'F'},
    {"01&E(F", 'F'},
    {"01&E(N", 'F'},
    {"01&E(O", 'F'},
    {"01&E(S", 'F'},
    {"01&E(V", 'F'},
    {"01&E1", 'F'},
    {"01&E1;", 'F'},
    {"01&E1C", 'F'},
    {"01&E1K", 'F'},
    {"01&E1O", 'F'},
    {"01&EF(", 'F'},
    {"01&EK(", 'F'},
    {"01&EK1", 'F'},
    {"01&EKF", 'F'},
    {"01&EKN", 'F'},
    {"01&EKS", 'F'},
    {"01&EKU", 'F'},
    {"01&EKV", 'F'},
    {"01&EN", 'F'},
    {"01&EN;", 'F'},
    {"01&ENC", 'F'},
    {"01&ENK", 'F'},
    {"01&ENO", 'F'},
    {"01&ES", 'F'},
    {"01&ES;", 'F'},
    {"01&ESC", 'F'},
    {"01&ESK", 'F'},
    {"01&ESO", 'F'},
    {"01&EUE", 'F'},
    {"01&EV", 'F'},
    {"01&EV;", 'F'},
    {"01&EVC", 'F'},
    {"01&EVK", 'F'},
    {"01&EVO", 'F'},
    {"01&F((", 'F'},
    {"01&F()", 'F'},
    {"01&F(1", 'F'},
    {"01&F(F", 'F'},
    {"01&F(N", 'F'},
    {"01&F(S", 'F'},
    {"01&F(V", 'F'},
    {"01&K&(", 'F'},
    {"01&K&1", 'F'},
    {"01&K&F", 'F'},
    {"01&K&N", 'F'},
    {"01&K&S", 'F'},
    {"01&K&V", 'F'},
    {"01&K((", 'F'},
    {"01&K(1", 'F'},
    {"01&K(F", 'F'},
    {"01&K(N", 'F'},
    {"01&K(S", 'F'},
    {"01&K(V", 'F'},
    {"01&K1O", 'F'},
    {"01&KF(", 'F'},
    {"01&KNK", 'F'},
    {"01&KO(", 'F'},
    {"01&KO1", 'F'},
    {"01&KOF", 'F'},
    {"01&KOK", 'F'},
    {"01&KON", 'F'},
    {"01&KOS", 'F'},
    {"01&KOV", 'F'},
    {"01&KSO", 'F'},
    {"01&KVO", 'F'},
    {"01&N&(", 'F'},
    {"01&N&1", 'F'},
    {"01&N&F", 'F'},
    {"01&N&N", 'F'},
    {"01&N&S", 'F'},
    {"01&N&V", 'F'},
    {"01&N)&", 'F'},
    {"01&N))", 'F'},
    {"01&N)U", 'F'},
    {"01&N;", 'F'},
    {"01&N;C", 'F'},
    {"01&N;E", 'F'},
    {"01&N;T", 'F'},
    {"01&NB(", 'F'},
    {"01&NB1", 'F'},
    {"01&NBF", 'F'},
    {"01&NBN", 'F'},
    {"01&NBS", 'F'},
    {"01&NBV", 'F'},
    {"01&NC", 'F'},
    {"01&NEN", 'F'},
    {"01&NF(", 'F'},
    {"01&NK(", 'F'},
    {"01&NK1", 'F'},
    {"01&NKF", 'F'},
    {"01&NKN", 'F'},
    {"01&NKS", 'F'},
    {"01&NKV", 'F'},
    {"01&NO(", 'F'},
    {"01&NOF", 'F'},
    {"01&NOS", 'F'},
    {"01&NOV", 'F'},
    {"01&NTN", 'F'},
    {"01&NU", 'F'},
    {"01&NU(", 'F'},
    {"01&NU;", 'F'},
    {"01&NUC", 'F'},
    {"01&NUE", 'F'},
    {"01&S", 'F'},
    {"01&S&(", 'F'},
    {"01&S&1", 'F'},
    {"01&S&F", 'F'},
    {"01&S&N", 'F'},
    {"01&S&S", 'F'},
    {"01&S&V", 'F'},
    {"01&S)&", 'F'},
    {"01&S))", 'F'},
    {"01&S)U", 'F'},
    {"01&S1", 'F'},
    {"01&S1;", 'F'},
    {"01&S1C", 'F'},
    {"01&S1O", 'F'},
    {"01&S;", 'F'},
    {"01&S;C", 'F'},
    {"01&S;E", 'F'},
    {"01&S;T", 'F'},
    {"01&SB(", 'F'},
    {"01&SB1", 'F'},
    {"01&SBF", 'F'},
    {"01&SBN", 'F'},
    {"01&SBS", 'F'},
    {"01&SBV", 'F'},
    {"01&SC", 'F'},
    {"01&SEK", 'F'},
    {"01&SEN", 'F'},
    {"01&SF(", 'F'},
    {"01&SK(", 'F'},
    {"01&SK1", 'F'},
    {"01&SKF", 'F'},
    {"01&SKN", 'F'},
    {"01&SKS", 'F'},
    {"01&SKV", 'F'},
    {"01&SO(", 'F'},
    {"01&SO1", 'F'},
    {"01&SOF", 'F'},
    {"01&SON", 'F'},
    {"01&SOO", 'F'},
    {"01&SOS", 'F'},
    {"01&SOV", 'F'},
    {"01&STN", 'F'},
    {"01&SU", 'F'},
    {"01&SU(", 'F'},
    {"01&SU;", 'F'},
    {"01&SUC", 'F'},
    {"01&SUE", 'F'},
    {"01&SV", 'F'},
    {"01&SV;", 'F'},
    {"01&SVC", 'F'},
    {"01&SVO", 'F'},
    {"01&V", 'F'},
    {"01&V&(", 'F'},
    {"01&V&1", 'F'},
    {"01&V&F", 'F'},
    {"01&V&N", 'F'},
    {"01&V&S", 'F'},
    {"01&V&V", 'F'},
    {"01&V)&", 'F'},
    {"01&V))", 'F'},
    {"01&V)U", 'F'},
    {"01&V;", 'F'},
    {"01&V;C", 'F'},
    {"01&V;E", 'F'},
    {"01&V;T", 'F'},
    {"01&VB(", 'F'},
    {"01&VB1", 'F'},
    {"01&VBF", 'F'},
    {"01&VBN", 'F'},
    {"01&VBS", 'F'},
    {"01&VBV", 'F'},
    {"01&VC", 'F'},
    {"01&VEK", 'F'},
    {"01&VEN", 'F'},
    {"01&VF(", 'F'},
    {"01&VK(", 'F'},
    {"01&VK1", 'F'},
    {"01&VKF", 'F'},
    {"01&VKN", 'F'},
    {"01&VKS", 'F'},
    {"01&VKV", 'F'},
    {"01&VO(", 'F'},
    {"01&VOF", 'F'},
    {"01&VOO", 'F'},
    {"01&VOS", 'F'},
    {"01&VS", 'F'},
    {"01&VS;", 'F'},
    {"01&VSC", 'F'},
    {"01&VSO", 'F'},
    {"01&VTN", 'F'},
    {"01&VU", 'F'},
    {"01&VU(", 'F'},
    {"01&VU;", 'F'},
    {"01&VUC", 'F'},
    {"01&VUE", 'F'},
    {"01((((", 'F'},
    {"01(((E", 'F'},
    {"01(((U", 'F'},
    {"01((EK", 'F'},
    {"01((EN", 'F'},
    {"01((U(", 'F'},
    {"01(EKN", 'F'},
    {"01(ENK", 'F'},
    {"01(U((", 'F'},
    {"01(U(E", 'F'},
    {"01)&((", 'F'},
    {"01)&(1", 'F'},
    {"01)&(E", 'F'},
    {"01)&(F", 'F'},
    {"01)&(N", 'F'},
    {"01)&(S", 'F'},
    {"01)&(V", 'F'},
    {"01)&1", 'F'},
    {"01)&1&", 'F'},
    {"01)&1)", 'F'},
    {"01)&1;", 'F'},
    {"01)&1B", 'F'},
    {"01)&1C", 'F'},
    {"01)&1F", 'F'},
    {"01)&1O", 'F'},
    {"01)&1U", 'F'},
    {"01)&F(", 'F'},
    {"01)&N", 'F'},
    {"01)&N&", 'F'},
    {"01)&N)", 'F'},
    {"01)&N;", 'F'},
    {"01)&NB", 'F'},
    {"01)&NC", 'F'},
    {"01)&NF", 'F'},
    {"01)&NO", 'F'},
    {"01)&NU", 'F'},
    {"01)&S", 'F'},
    {"01)&S&", 'F'},
    {"01)&S)", 'F'},
    {"01)&S;", 'F'},
    {"01)&SB", 'F'},
    {"01)&SC", 'F'},
    {"01)&SF", 'F'},
    {"01)&SO", 'F'},
    {"01)&SU", 'F'},
    {"01)&V", 'F'},
    {"01)&V&", 'F'},
    {"01)&V)", 'F'},
    {"01)&V;", 'F'},
    {"01)&VB", 'F'},
    {"01)&VC", 'F'},
    {"01)&VF", 'F'},
    {"01)&VO", 'F'},
    {"01)&VU", 'F'},
    {"01))&(", 'F'},
    {"01))&1", 'F'},
    {"01))&F", 'F'},
    {"01))&N", 'F'},
    {"01))&S", 'F'},
    {"01))&V", 'F'},
    {"01)))&", 'F'},
    {"01))))", 'F'},
    {"01))),", 'F'},
    {"01)));", 'F'},
    {"01)))B", 'F'},
    {"01)))E", 'F'},
    {"01)))K", 'F'},
    {"01)))O", 'F'},
    {"01)))U", 'F'},
    {"01)),(", 'F'},
    {"01));E", 'F'},
    {"01));T", 'F'},
    {"01))B(", 'F'},
    {"01))B1", 'F'},
    {"01))BF", 'F'},
    {"01))BN", 'F'},
    {"01))BS", 'F'},
    {"01))BV", 'F'},
    {"01))E(", 'F'},
    {"01))E1", 'F'},
    {"01))EF", 'F'},
    {"01))EK", 'F'},
    {"01))EN", 'F'},
    {"01))ES", 'F'},
    {"01))EV", 'F'},
    {"01))K(", 'F'},
    {"01))K1", 'F'},
    {"01))KB", 'F'},
    {"01))KF", 'F'},
    {"01))KN", 'F'},
    {"01))KS", 'F'},
    {"01))KU", 'F'},
    {"01))KV", 'F'},
    {"01))O(", 'F'},
    {"01))O1", 'F'},
    {"01))OF", 'F'},
    {"01))ON", 'F'},
    {"01))OS", 'F'},
    {"01))OV", 'F'},
    {"01))U(", 'F'},
    {"01))UE", 'F'},
    {"01),((", 'F'},
    {"01),(1", 'F'},
    {"01),(F", 'F'},
    {"01),(N", 'F'},
    {"01),(S", 'F'},
    {"01),(V", 'F'},
    {"01);E(", 'F'},
    {"01);E1", 'F'},
    {"01);EF", 'F'},
    {"01);EK", 'F'},
    {"01);EN", 'F'},
    {"01);EO", 'F'},
    {"01);ES", 'F'},
    {"01);EV", 'F'},
    {"01);T(", 'F'},
    {"01);T1", 'F'},
    {"01);TF", 'F'},
    {"01);TK", 'F'},
    {"01);TN", 'F'},
    {"01);TO", 'F'},
    {"01);TS", 'F'},
    {"01);TV", 'F'},
    {"01)B((", 'F'},
    {"01)B(1", 'F'},
    {"01)B(F", 'F'},
    {"01)B(N", 'F'},
    {"01)B(S", 'F'},
    {"01)B(V", 'F'},
    {"01)B1", 'F'},
    {"01)B1&", 'F'},
    {"01)B1;", 'F'},
    {"01)B1C", 'F'},
    {"01)B1K", 'F'},
    {"01)B1N", 'F'},
    {"01)B1O", 'F'},
    {"01)B1U", 'F'},
    {"01)BF(", 'F'},
    {"01)BN", 'F'},
    {"01)BN&", 'F'},
    {"01)BN;", 'F'},
    {"01)BNC", 'F'},
    {"01)BNK", 'F'},
    {"01)BNO", 'F'},
    {"01)BNU", 'F'},
    {"01)BS", 'F'},
    {"01)BS&", 'F'},
    {"01)BS;", 'F'},
    {"01)BSC", 'F'},
    {"01)BSK", 'F'},
    {"01)BSO", 'F'},
    {"01)BSU", 'F'},
    {"01)BV", 'F'},
    {"01)BV&", 'F'},
    {"01)BV;", 'F'},
    {"01)BVC", 'F'},
    {"01)BVK", 'F'},
    {"01)BVO", 'F'},
    {"01)BVU", 'F'},
    {"01)E((", 'F'},
    {"01)E(1", 'F'},
    {"01)E(F", 'F'},
    {"01)E(N", 'F'},
    {"01)E(S", 'F'},
    {"01)E(V", 'F'},
    {"01)E1C", 'F'},
    {"01)E1O", 'F'},
    {"01)EF(", 'F'},
    {"01)EK(", 'F'},
    {"01)EK1", 'F'},
    {"01)EKF", 'F'},
    {"01)EKN", 'F'},
    {"01)EKS", 'F'},
    {"01)EKV", 'F'},
    {"01)ENC", 'F'},
    {"01)ENO", 'F'},
    {"01)ESC", 'F'},
    {"01)ESO", 'F'},
    {"01)EVC", 'F'},
    {"01)EVO", 'F'},
    {"01)K((", 'F'},
    {"01)K(1", 'F'},
    {"01)K(F", 'F'},
    {"01)K(N", 'F'},
    {"01)K(S", 'F'},
    {"01)K(V", 'F'},
    {"01)K1&", 'F'},
    {"01)K1;", 'F'},
    {"01)K1B", 'F'},
    {"01)K1E", 'F'},
    {"01)K1O", 'F'},
    {"01)K1U", 'F'},
    {"01)KB(", 'F'},
    {"01)KB1", 'F'},
    {"01)KBF", 'F'},
    {"01)KBN", 'F'},
    {"01)KBS", 'F'},
    {"01)KBV", 'F'},
    {"01)KF(", 'F'},
    {"01)KN&", 'F'},
    {"01)KN;", 'F'},
    {"01)KNB", 'F'},
    {"01)KNE", 'F'},
    {"01)KNK", 'F'},
    {"01)KNU", 'F'},
    {"01)KS&", 'F'},
    {"01)KS;", 'F'},
    {"01)KSB", 'F'},
    {"01)KSE", 'F'},
    {"01)KSO", 'F'},
    {"01)KSU", 'F'},
    {"01)KUE", 'F'},
    {"01)KV&", 'F'},
    {"01)KV;", 'F'},
    {"01)KVB", 'F'},
    {"01)KVE", 'F'},
    {"01)KVO", 'F'},
    {"01)KVU", 'F'},
    {"01)O((", 'F'},
    {"01)O(1", 'F'},
    {"01)O(E", 'F'},
    {"01)O(F", 'F'},
    {"01)O(N", 'F'},
    {"01)O(S", 'F'},
    {"01)O(V", 'F'},
    {"01)O1", 'F'},
    {"01)O1&", 'F'},
    {"01)O1)", 'F'},
    {"01)O1;", 'F'},
    {"01)O1B", 'F'},
    {"01)O1C", 'F'},
    {"01)O1K", 'F'},
    {"01)O1O", 'F'},
    {"01)O1U", 'F'},
    {"01)OF(", 'F'},
    {"01)ON", 'F'},
    {"01)ON&", 'F'},
    {"01)ON)", 'F'},
    {"01)ON;", 'F'},
    {"01)ONB", 'F'},
    {"01)ONC", 'F'},
    {"01)ONK", 'F'},
    {"01)ONO", 'F'},
    {"01)ONU", 'F'},
    {"01)OS", 'F'},
    {"01)OS&", 'F'},
    {"01)OS)", 'F'},
    {"01)OS;", 'F'},
    {"01)OSB", 'F'},
    {"01)OSC", 'F'},
    {"01)OSK", 'F'},
    {"01)OSO", 'F'},
    {"01)OSU", 'F'},
    {"01)OV", 'F'},
    {"01)OV&", 'F'},
    {"01)OV)", 'F'},
    {"01)OV;", 'F'},
    {"01)OVB", 'F'},
    {"01)OVC", 'F'},
    {"01)OVK", 'F'},
    {"01)OVO", 'F'},
    {"01)OVU", 'F'},
    {"01)U((", 'F'},
    {"01)U(E", 'F'},
    {"01)UE(", 'F'},
    {"01)UE1", 'F'},
    {"01)UEF", 'F'},
    {"01)UEK", 'F'},
    {"01)UEN", 'F'},
    {"01)UES", 'F'},
    {"01)UEV", 'F'},
    {"01,(((", 'F'},
    {"01,((1", 'F'},
    {"01,((E", 'F'},
    {"01,((F", 'F'},
    {"01,((N", 'F'},
    {"01,((S", 'F'},
    {"01,((V", 'F'},
    {"01,(1)", 'F'},
    {"01,(1O", 'F'},
    {"01,(E(", 'F'},
    {"01,(E1", 'F'},
    {"01,(EF", 'F'},
    {"01,(EK", 'F'},
    {"01,(EN", 'F'},
    {"01,(ES", 'F'},
    {"01,(EV", 'F'},
    {"01,(F(", 'F'},
    {"01,(N)", 'F'},
    {"01,(NO", 'F'},
    {"01,(S)", 'F'},
    {"01,(SO", 'F'},
    {"01,(V)", 'F'},
    {"01,(VO", 'F'},
    {"01,F((", 'F'},
    {"01,F()", 'F'},
    {"01,F(1", 'F'},
    {"01,F(F", 'F'},
    {"01,F(N", 'F'},
    {"01,F(S", 'F'},
    {"01,F(T", 'F'},
    {"01,F(V", 'F'},
    {"01,V))", 'F'},
    {"01,V),", 'F'},
    {"01,V)O", 'F'},
    {"01,VB(", 'F'},
    {"01,VB1", 'F'},
    {"01,VBF", 'F'},
    {"01,VBN", 'F'},
    {"01,VBS", 'F'},
    {"01,VBV", 'F'},
    {"01,VO(", 'F'},
    {"01,VOF", 'F'},
    {"01,VOS", 'F'},
    {"01,VUE", 'F'},
    {"01;E((", 'F'},
    {"01;E(1", 'F'},
    {"01;E(E", 'F'},
    {"01;E(F", 'F'},
    {"01;E(N", 'F'},
    {"01;E(S", 'F'},
    {"01;E(V", 'F'},
    {"01;E1,", 'F'},
    {"01;E1;", 'F'},
    {"01;E1C", 'F'},
    {"01;E1O", 'F'},
    {"01;E1T", 'F'},
    {"01;EF(", 'F'},
    {"01;EK(", 'F'},
    {"01;EK1", 'F'},
    {"01;EKF", 'F'},
    {"01;EKN", 'F'},
    {"01;EKO", 'F'},
    {"01;EKS", 'F'},
    {"01;EKV", 'F'},
    {"01;EN,", 'F'},
    {"01;EN;", 'F'},
    {"01;ENC", 'F'},
    {"01;ENK", 'F'},
    {"01;ENO", 'F'},
    {"01;ENT", 'F'},
    {"01;EO(", 'F'},
    {"01;ES,", 'F'},
    {"01;ES;", 'F'},
    {"01;ESC", 'F'},
    {"01;ESO", 'F'},
    {"01;EST", 'F'},
    {"01;EV,", 'F'},
    {"01;EV;", 'F'},
    {"01;EVC", 'F'},
    {"01;EVO", 'F'},
    {"01;EVT", 'F'},
    {"01;N:T", 'F'},
    {"01;T((", 'F'},
    {"01;T(1", 'F'},
    {"01;T(E", 'F'},
    {"01;T(F", 'F'},
    {"01;T(N", 'F'},
    {"01;T(S", 'F'},
    {"01;T(V", 'F'},
    {"01;T1,", 'F'},
    {"01;T1;", 'F'},
    {"01;T1C", 'F'},
    {"01;T1F", 'F'},
    {"01;T1O", 'F'},
    {"01;T1T", 'F'},
    {"01;T;", 'F'},
    {"01;T;C", 'F'},
    {"01;TF(", 'F'},
    {"01;TK(", 'F'},
    {"01;TK1", 'F'},
    {"01;TKF", 'F'},
    {"01;TKK", 'F'},
    {"01;TKN", 'F'},
    {"01;TKO", 'F'},
    {"01;TKS", 'F'},
    {"01;TKV", 'F'},
    {"01;TN(", 'F'},
    {"01;TN,", 'F'},
    {"01;TN1", 'F'},
    {"01;TN;", 'F'},
    {"01;TNC", 'F'},
    {"01;TNE", 'F'},
    {"01;TNF", 'F'},
    {"01;TNK", 'F'},
    {"01;TNN", 'F'},
    {"01;TNO", 'F'},
    {"01;TNS", 'F'},
    {"01;TNT", 'F'},
    {"01;TNV", 'F'},
    {"01;TO(", 'F'},
    {"01;TS,", 'F'},
    {"01;TS;", 'F'},
    {"01;TSC", 'F'},
    {"01;TSF", 'F'},
    {"01;TSO", 'F'},
    {"01;TST", 'F'},
    {"01;TT(", 'F'},
    {"01;TT1", 'F'},
    {"01;TTF", 'F'},
    {"01;TTN", 'F'},
    {"01;TTS", 'F'},
    {"01;TTV", 'F'},
    {"01;TV,", 'F'},
    {"01;TV;", 'F'},
    {"01;TVC", 'F'},
    {"01;TVF", 'F'},
    {"01;TVO", 'F'},
    {"01;TVT", 'F'},
    {"01A(((", 'F'},
    {"01A((1", 'F'},
    {"01A((F", 'F'},
    {"01A((N", 'F'},
    {"01A((S", 'F'},
    {"01A((V", 'F'},
    {"01A(F(", 'F'},
    {"01A(N)", 'F'},
    {"01A(NO", 'F'},
    {"01A(S)", 'F'},
    {"01A(SO", 'F'},
    {"01A(V)", 'F'},
    {"01A(VO", 'F'},
    {"01AF((", 'F'},
    {"01AF()", 'F'},
    {"01AF(1", 'F'},
    {"01AF(F", 'F'},
    {"01AF(N", 'F'},
    {"01AF(S", 'F'},
    {"01AF(V", 'F'},
    {"01ASO(", 'F'},
    {"01ASO1", 'F'},
    {"01ASOF", 'F'},
    {"01ASON", 'F'},
    {"01ASOS", 'F'},
    {"01ASOV", 'F'},
    {"01ASUE", 'F'},
    {"01ATO(", 'F'},
    {"01ATO1", 'F'},
    {"01ATOF", 'F'},
    {"01ATON", 'F'},
    {"01ATOS", 'F'},
    {"01ATOV", 'F'},
    {"01ATUE", 'F'},
    {"01AVO(", 'F'},
    {"01AVOF", 'F'},
    {"01AVOS", 'F'},
    {"01AVUE", 'F'},
    {"01B(((", 'F'},
    {"01B((1", 'F'},
    {"01B((F", 'F'},
    {"01B((N", 'F'},
    {"01B((S", 'F'},
    {"01B((V", 'F'},
    {"01B(1)", 'F'},
    {"01B(1O", 'F'},
    {"01B(F(", 'F'},
    {"01B(N)", 'F'},
    {"01B(NO", 'F'},
    {"01B(S)", 'F'},
    {"01B(SO", 'F'},
    {"01B(V)", 'F'},
    {"01B(VO", 'F'},
    {"01B1", 'F'},
    {"01B1&(", 'F'},
    {"01B1&1", 'F'},
    {"01B1&F", 'F'},
    {"01B1&N", 'F'},
    {"01B1&S", 'F'},
    {"01B1&V", 'F'},
    {"01B1,(", 'F'},
    {"01B1,F", 'F'},
    {"01B1,V", 'F'},
    {"01B1;", 'F'},
    {"01B1;C", 'F'},
    {"01B1B(", 'F'},
    {"01B1B1", 'F'},
    {"01B1BF", 'F'},
    {"01B1BN", 'F'},
    {"01B1BS", 'F'},
    {"01B1BV", 'F'},
    {"01B1C", 'F'},
    {"01B1K(", 'F'},
    {"01B1K1", 'F'},
    {"01B1KF", 'F'},
    {"01B1KN", 'F'},
    {"01B1KS", 'F'},
    {"01B1KV", 'F'},
    {"01B1O(", 'F'},
    {"01B1OF", 'F'},
    {"01B1OS", 'F'},
    {"01B1OV", 'F'},
    {"01B1U(", 'F'},
    {"01B1UE", 'F'},
    {"01BE((", 'F'},
    {"01BE(1", 'F'},
    {"01BE(F", 'F'},
    {"01BE(N", 'F'},
    {"01BE(S", 'F'},
    {"01BE(V", 'F'},
    {"01BEK(", 'F'},
    {"01BF((", 'F'},
    {"01BF()", 'F'},
    {"01BF(1", 'F'},
    {"01BF(F", 'F'},
    {"01BF(N", 'F'},
    {"01BF(S", 'F'},
    {"01BF(V", 'F'},
    {"01BN", 'F'},
    {"01BN&(", 'F'},
    {"01BN&1", 'F'},
    {"01BN&F", 'F'},
    {"01BN&N", 'F'},
    {"01BN&S", 'F'},
    {"01BN&V", 'F'},
    {"01BN,(", 'F'},
    {"01BN,F", 'F'},
    {"01BN,V", 'F'},
    {"01BN;", 'F'},
    {"01BN;C", 'F'},
    {"01BNB(", 'F'},
    {"01BNB1", 'F'},
    {"01BNBF", 'F'},
    {"01BNBN", 'F'},
    {"01BNBS", 'F'},
    {"01BNBV", 'F'},
    {"01BNC", 'F'},
    {"01BNK(", 'F'},
    {"01BNK1", 'F'},
    {"01BNKF", 'F'},
    {"01BNKN", 'F'},
    {"01BNKS", 'F'},
    {"01BNKV", 'F'},
    {"01BNO(", 'F'},
    {"01BNOF", 'F'},
    {"01BNOS", 'F'},
    {"01BNOV", 'F'},
    {"01BNU(", 'F'},
    {"01BNUE", 'F'},
    {"01BS", 'F'},
    {"01BS&(", 'F'},
    {"01BS&1", 'F'},
    {"01BS&F", 'F'},
    {"01BS&N", 'F'},
    {"01BS&S", 'F'},
    {"01BS&V", 'F'},
    {"01BS,(", 'F'},
    {"01BS,F", 'F'},
    {"01BS,V", 'F'},
    {"01BS;", 'F'},
    {"01BS;C", 'F'},
    {"01BSB(", 'F'},
    {"01BSB1", 'F'},
    {"01BSBF", 'F'},
    {"01BSBN", 'F'},
    {"01BSBS", 'F'},
    {"01BSBV", 'F'},
    {"01BSC", 'F'},
    {"01BSK(", 'F'},
    {"01BSK1", 'F'},
    {"01BSKF", 'F'},
    {"01BSKN", 'F'},
    {"01BSKS", 'F'},
    {"01BSKV", 'F'},
    {"01BSO(", 'F'},
    {"01BSO1", 'F'},
    {"01BSOF", 'F'},
    {"01BSON", 'F'},
    {"01BSOS", 'F'},
    {"01BSOV", 'F'},
    {"01BSU(", 'F'},
    {"01BSUE", 'F'},
    {"01BV", 'F'},
    {"01BV&(", 'F'},
    {"01BV&1", 'F'},
    {"01BV&F", 'F'},
    {"01BV&N", 'F'},
    {"01BV&S", 'F'},
    {"01BV&V", 'F'},
    {"01BV,(", 'F'},
    {"01BV,1", 'F'},
    {"01BV,F", 'F'},
    {"01BV,N", 'F'},
    {"01BV,S", 'F'},
    {"01BV,V", 'F'},
    {"01BV;", 'F'},
    {"01BV;C", 'F'},
    {"01BVB(", 'F'},
    {"01BVB1", 'F'},
    {"01BVBF", 'F'},
    {"01BVBN", 'F'},
    {"01BVBS", 'F'},
    {"01BVBV", 'F'},
    {"01BVC", 'F'},
    {"01BVK(", 'F'},
    {"01BVK1", 'F'},
    {"01BVKF", 'F'},
    {"01BVKN", 'F'},
    {"01BVKS", 'F'},
    {"01BVKV", 'F'},
    {"01BVO(", 'F'},
    {"01BVOF", 'F'},
    {"01BVOS", 'F'},
    {"01BVU(", 'F'},
    {"01BVUE", 'F'},
    {"01C", 'F'},
    {"01E(((", 'F'},
    {"01E((1", 'F'},
    {"01E((F", 'F'},
    {"01E((N", 'F'},
    {"01E((S", 'F'},
    {"01E((V", 'F'},
    {"01E(1)", 'F'},
    {"01E(1O", 'F'},
    {"01E(F(", 'F'},
    {"01E(N)", 'F'},
    {"01E(NO", 'F'},
    {"01E(S)", 'F'},
    {"01E(SO", 'F'},
    {"01E(V)", 'F'},
    {"01E(VO", 'F'},
    {"01E1C", 'F'},
    {"01E1O(", 'F'},
    {"01E1OF", 'F'},
    {"01E1OS", 'F'},
    {"01E1OV", 'F'},
    {"01E1UE", 'F'},
    {"01EF((", 'F'},
    {"01EF()", 'F'},
    {"01EF(1", 'F'},
    {"01EF(F", 'F'},
    {"01EF(N", 'F'},
    {"01EF(S", 'F'},
    {"01EF(V", 'F'},
    {"01EK((", 'F'},
    {"01EK(1", 'F'},
    {"01EK(E", 'F'},
    {"01EK(F", 'F'},
    {"01EK(N", 'F'},
    {"01EK(S", 'F'},
    {"01EK(V", 'F'},
    {"01EK1C", 'F'},
    {"01EK1O", 'F'},
    {"01EK1U", 'F'},
    {"01EKF(", 'F'},
    {"01EKNC", 'F'},
    {"01EKNE", 'F'},
    {"01EKNU", 'F'},
    {"01EKOK", 'F'},
    {"01EKSC", 'F'},
    {"01EKSO", 'F'},
    {"01EKSU", 'F'},
    {"01EKU(", 'F'},
    {"01EKU1", 'F'},
    {"01EKUE", 'F'},
    {"01EKUF", 'F'},
    {"01EKUN", 'F'},
    {"01EKUS", 'F'},
    {"01EKUV", 'F'},
    {"01EKVC", 'F'},
    {"01EKVO", 'F'},
    {"01EKVU", 'F'},
    {"01ENC", 'F'},
    {"01ENEN", 'F'},
    {"01ENO(", 'F'},
    {"01ENOF", 'F'},
    {"01ENOS", 'F'},
    {"01ENOV", 'F'},
    {"01ENUE", 'F'},
    {"01EOKN", 'F'},
    {"01ESC", 'F'},
    {"01ESO(", 'F'},
    {"01ESO1", 'F'},
    {"01ESOF", 'F'},
    {"01ESON", 'F'},
    {"01ESOS", 'F'},
    {"01ESOV", 'F'},
    {"01ESUE", 'F'},
    {"01EU((", 'F'},
    {"01EU(1", 'F'},
    {"01EU(F", 'F'},
    {"01EU(N", 'F'},
    {"01EU(S", 'F'},
    {"01EU(V", 'F'},
    {"01EU1,", 'F'},
    {"01EU1C", 'F'},
    {"01EU1O", 'F'},
    {"01EUEF", 'F'},
    {"01EUEK", 'F'},
    {"01EUF(", 'F'},
    {"01EUN,", 'F'},
    {"01EUNC", 'F'},
    {"01EUNO", 'F'},
    {"01EUS,", 'F'},
    {"01EUSC", 'F'},
    {"01EUSO", 'F'},
    {"01EUV,", 'F'},
    {"01EUVC", 'F'},
    {"01EUVO", 'F'},
    {"01EVC", 'F'},
    {"01EVO(", 'F'},
    {"01EVOF", 'F'},
    {"01EVOS", 'F'},
    {"01EVUE", 'F'},
    {"01F(((", 'F'},
    {"01F(()", 'F'},
    {"01F((1", 'F'},
    {"01F((F", 'F'},
    {"01F((N", 'F'},
    {"01F((S", 'F'},
    {"01F((V", 'F'},
    {"01F())", 'F'},
    {"01F()1", 'F'},
    {"01F()F", 'F'},
    {"01F()K", 'F'},
    {"01F()N", 'F'},
    {"01F()O", 'F'},
    {"01F()S", 'F'},
    {"01F()U", 'F'},
    {"01F()V", 'F'},
    {"01F(1)", 'F'},
    {"01F(1N", 'F'},
    {"01F(1O", 'F'},
    {"01F(F(", 'F'},
    {"01F(N)", 'F'},
    {"01F(N,", 'F'},
    {"01F(NO", 'F'},
    {"01F(S)", 'F'},
    {"01F(SO", 'F'},
    {"01F(V)", 'F'},
    {"01F(VO", 'F'},
    {"01K(((", 'F'},
    {"01K((1", 'F'},
    {"01K((F", 'F'},
    {"01K((N", 'F'},
    {"01K((S", 'F'},
    {"01K((V", 'F'},
    {"01K(1)", 'F'},
    {"01K(1O", 'F'},
    {"01K(F(", 'F'},
    {"01K(N)", 'F'},
    {"01K(NO", 'F'},
    {"01K(S)", 'F'},
    {"01K(SO", 'F'},
    {"01K(V)", 'F'},
    {"01K(VO", 'F'},
    {"01K)&(", 'F'},
    {"01K)&1", 'F'},
    {"01K)&F", 'F'},
    {"01K)&N", 'F'},
    {"01K)&S", 'F'},
    {"01K)&V", 'F'},
    {"01K))&", 'F'},
    {"01K)))", 'F'},
    {"01K));", 'F'},
    {"01K))B", 'F'},
    {"01K))E", 'F'},
    {"01K))K", 'F'},
    {"01K))O", 'F'},
    {"01K))U", 'F'},
    {"01K);E", 'F'},
    {"01K);T", 'F'},
    {"01K)B(", 'F'},
    {"01K)B1", 'F'},
    {"01K)BF", 'F'},
    {"01K)BN", 'F'},
    {"01K)BS", 'F'},
    {"01K)BV", 'F'},
    {"01K)E(", 'F'},
    {"01K)E1", 'F'},
    {"01K)EF", 'F'},
    {"01K)EK", 'F'},
    {"01K)EN", 'F'},
    {"01K)ES", 'F'},
    {"01K)EV", 'F'},
    {"01K)OF", 'F'},
    {"01K)UE", 'F'},
    {"01K1", 'F'},
    {"01K1&(", 'F'},
    {"01K1&1", 'F'},
    {"01K1&F", 'F'},
    {"01K1&N", 'F'},
    {"01K1&S", 'F'},
    {"01K1&V", 'F'},
    {"01K1;", 'F'},
    {"01K1;C", 'F'},
    {"01K1;E", 'F'},
    {"01K1;T", 'F'},
    {"01K1B(", 'F'},
    {"01K1B1", 'F'},
    {"01K1BF", 'F'},
    {"01K1BN", 'F'},
    {"01K1BS", 'F'},
    {"01K1BV", 'F'},
    {"01K1C", 'F'},
    {"01K1E(", 'F'},
    {"01K1E1", 'F'},
    {"01K1EF", 'F'},
    {"01K1EK", 'F'},
    {"01K1EN", 'F'},
    {"01K1ES", 'F'},
    {"01K1EV", 'F'},
    {"01K1O(", 'F'},
    {"01K1OF", 'F'},
    {"01K1OS", 'F'},
    {"01K1OV", 'F'},
    {"01K1U(", 'F'},
    {"01K1UE", 'F'},
    {"01KF((", 'F'},
    {"01KF()", 'F'},
    {"01KF(1", 'F'},
    {"01KF(F", 'F'},
    {"01KF(N", 'F'},
    {"01KF(S", 'F'},
    {"01KF(V", 'F'},
    {"01KN", 'F'},
    {"01KN&(", 'F'},
    {"01KN&1", 'F'},
    {"01KN&F", 'F'},
    {"01KN&N", 'F'},
    {"01KN&S", 'F'},
    {"01KN&V", 'F'},
    {"01KN;", 'F'},
    {"01KN;C", 'F'},
    {"01KN;E", 'F'},
    {"01KN;T", 'F'},
    {"01KNB(", 'F'},
    {"01KNB1", 'F'},
    {"01KNBF", 'F'},
    {"01KNBN", 'F'},
    {"01KNBS", 'F'},
    {"01KNBV", 'F'},
    {"01KNC", 'F'},
    {"01KNE(", 'F'},
    {"01KNE1", 'F'},
    {"01KNEF", 'F'},
    {"01KNEN", 'F'},
    {"01KNES", 'F'},
    {"01KNEV", 'F'},
    {"01KNU(", 'F'},
    {"01KNUE", 'F'},
    {"01KS", 'F'},
    {"01KS&(", 'F'},
    {"01KS&1", 'F'},
    {"01KS&F", 'F'},
    {"01KS&N", 'F'},
    {"01KS&S", 'F'},
    {"01KS&V", 'F'},
    {"01KS;", 'F'},
    {"01KS;C", 'F'},
    {"01KS;E", 'F'},
    {"01KS;T", 'F'},
    {"01KSB(", 'F'},
    {"01KSB1", 'F'},
    {"01KSBF", 'F'},
    {"01KSBN", 'F'},
    {"01KSBS", 'F'},
    {"01KSBV", 'F'},
    {"01KSC", 'F'},
    {"01KSE(", 'F'},
    {"01KSE1", 'F'},
    {"01KSEF", 'F'},
    {"01KSEK", 'F'},
    {"01KSEN", 'F'},
    {"01KSES", 'F'},
    {"01KSEV", 'F'},
    {"01KSO(", 'F'},
    {"01KSO1", 'F'},
    {"01KSOF", 'F'},
    {"01KSON", 'F'},
    {"01KSOS", 'F'},
    {"01KSOV", 'F'},
    {"01KSU(", 'F'},
    {"01KSUE", 'F'},
    {"01KUE(", 'F'},
    {"01KUE1", 'F'},
    {"01KUEF", 'F'},
    {"01KUEK", 'F'},
    {"01KUEN", 'F'},
    {"01KUES", 'F'},
    {"01KUEV", 'F'},
    {"01KV", 'F'},
    {"01KV&(", 'F'},
    {"01KV&1", 'F'},
    {"01KV&F", 'F'},
    {"01KV&N", 'F'},
    {"01KV&S", 'F'},
    {"01KV&V", 'F'},
    {"01KV;", 'F'},
    {"01KV;C", 'F'},
    {"01KV;E", 'F'},
    {"01KV;T", 'F'},
    {"01KVB(", 'F'},
    {"01KVB1", 'F'},
    {"01KVBF", 'F'},
    {"01KVBN", 'F'},
    {"01KVBS", 'F'},
    {"01KVBV", 'F'},
    {"01KVC", 'F'},
    {"01KVE(", 'F'},
    {"01KVE1", 'F'},
    {"01KVEF", 'F'},
    {"01KVEK", 'F'},
    {"01KVEN", 'F'},
    {"01KVES", 'F'},
    {"01KVEV", 'F'},
    {"01KVO(", 'F'},
    {"01KVOF", 'F'},
    {"01KVOS", 'F'},
    {"01KVU(", 'F'},
    {"01KVUE", 'F'},
    {"01N&F(", 'F'},
    {"01N(((", 'F'},
    {"01N((1", 'F'},
    {"01N((F", 'F'},
    {"01N((N", 'F'},
    {"01N((S", 'F'},
    {"01N((V", 'F'},
    {"01N(1)", 'F'},
    {"01N(1O", 'F'},
    {"01N(F(", 'F'},
    {"01N(S)", 'F'},
    {"01N(SO", 'F'},
    {"01N(V)", 'F'},
    {"01N(VO", 'F'},
    {"01N)))", 'F'},
    {"01N))N", 'F'},
    {"01N))U", 'F'},
    {"01N)UE", 'F'},
    {"01N,F(", 'F'},
    {"01NE((", 'F'},
    {"01NE(1", 'F'},
    {"01NE(F", 'F'},
    {"01NE(N", 'F'},
    {"01NE(S", 'F'},
    {"01NE(V", 'F'},
    {"01NE1C", 'F'},
    {"01NE1O", 'F'},
    {"01NEF(", 'F'},
    {"01NENC", 'F'},
    {"01NENO", 'F'},
    {"01NESC", 'F'},
    {"01NESO", 'F'},
    {"01NEVC", 'F'},
    {"01NEVO", 'F'},
    {"01NF((", 'F'},
    {"01NF()", 'F'},
    {"01NF(1", 'F'},
    {"01NF(F", 'F'},
    {"01NF(N", 'F'},
    {"01NF(S", 'F'},
    {"01NF(V", 'F'},
    {"01NO((", 'F'},
    {"01NO(1", 'F'},
    {"01NO(F", 'F'},
    {"01NO(N", 'F'},
    {"01NO(S", 'F'},
    {"01NO(V", 'F'},
    {"01NOF(", 'F'},
    {"01NOS(", 'F'},
    {"01NOS1", 'F'},
    {"01NOSF", 'F'},
    {"01NOSO", 'F'},
    {"01NOSU", 'F'},
    {"01NOSV", 'F'},
    {"01NOV(", 'F'},
    {"01NOVF", 'F'},
    {"01NOVO", 'F'},
    {"01NOVS", 'F'},
    {"01NOVU", 'F'},
    {"01NU((", 'F'},
    {"01NU(E", 'F'},
    {"01NUE", 'F'},
    {"01NUE(", 'F'},
    {"01NUE1", 'F'},
    {"01NUE;", 'F'},
    {"01NUEC", 'F'},
    {"01NUEF", 'F'},
    {"01NUEK", 'F'},
    {"01NUEN", 'F'},
    {"01NUES", 'F'},
    {"01NUEV", 'F'},
    {"01O(((", 'F'},
    {"01O((1", 'F'},
    {"01O((E", 'F'},
    {"01O((F", 'F'},
    {"01O((N", 'F'},
    {"01O((O", 'F'},
    {"01O((S", 'F'},
    {"01O((T", 'F'},
    {"01O((V", 'F'},
    {"01O(1&", 'F'},
    {"01O(1)", 'F'},
    {"01O(1,", 'F'},
    {"01O(1O", 'F'},
    {"01O(E(", 'F'},
    {"01O(E1", 'F'},
    {"01O(EE", 'F'},
    {"01O(EF", 'F'},
    {"01O(EK", 'F'},
    {"01O(EN", 'F'},
    {"01O(ES", 'F'},
    {"01O(EV", 'F'},
    {"01O(F(", 'F'},
    {"01O(N&", 'F'},
    {"01O(N)", 'F'},
    {"01O(N,", 'F'},
    {"01O(NO", 'F'},
    {"01O(O(", 'F'},
    {"01O(O1", 'F'},
    {"01O(OF", 'F'},
    {"01O(ON", 'F'},
    {"01O(OS", 'F'},
    {"01O(OV", 'F'},
    {"01O(S&", 'F'},
    {"01O(S)", 'F'},
    {"01O(S,", 'F'},
    {"01O(SO", 'F'},
    {"01O(T(", 'F'},
    {"01O(V&", 'F'},
    {"01O(V)", 'F'},
    {"01O(V,", 'F'},
    {"01O(VO", 'F'},
    {"01OF((", 'F'},
    {"01OF()", 'F'},
    {"01OF(1", 'F'},
    {"01OF(E", 'F'},
    {"01OF(F", 'F'},
    {"01OF(N", 'F'},
    {"01OF(S", 'F'},
    {"01OF(V", 'F'},
    {"01OK&(", 'F'},
    {"01OK&1", 'F'},
    {"01OK&F", 'F'},
    {"01OK&N", 'F'},
    {"01OK&S", 'F'},
    {"01OK&V", 'F'},
    {"01OK((", 'F'},
    {"01OK(1", 'F'},
    {"01OK(F", 'F'},
    {"01OK(N", 'F'},
    {"01OK(S", 'F'},
    {"01OK(V", 'F'},
    {"01OK1C", 'F'},
    {"01OK1O", 'F'},
    {"01OKF(", 'F'},
    {"01OKNC", 'F'},
    {"01OKO(", 'F'},
    {"01OKO1", 'F'},
    {"01OKOF", 'F'},
    {"01OKON", 'F'},
    {"01OKOS", 'F'},
    {"01OKOV", 'F'},
    {"01OKSC", 'F'},
    {"01OKSO", 'F'},
    {"01OKVC", 'F'},
    {"01OKVO", 'F'},
    {"01ONSU", 'F'},
    {"01OS&(", 'F'},
    {"01OS&1", 'F'},
    {"01OS&E", 'F'},
    {"01OS&F", 'F'},
    {"01OS&K", 'F'},
    {"01OS&N", 'F'},
    {"01OS&S", 'F'},
    {"01OS&U", 'F'},
    {"01OS&V", 'F'},
    {"01OS((", 'F'},
    {"01OS(E", 'F'},
    {"01OS(U", 'F'},
    {"01OS)&", 'F'},
    {"01OS))", 'F'},
    {"01OS),", 'F'},
    {"01OS);", 'F'},
    {"01OS)B", 'F'},
    {"01OS)E", 'F'},
    {"01OS)K", 'F'},
    {"01OS)O", 'F'},
    {"01OS)U", 'F'},
    {"01OS,(", 'F'},
    {"01OS,F", 'F'},
    {"01OS,V", 'F'},
    {"01OS1(", 'F'},
    {"01OS1F", 'F'},
    {"01OS1N", 'F'},
    {"01OS1S", 'F'},
    {"01OS1U", 'F'},
    {"01OS1V", 'F'},
    {"01OS;", 'F'},
    {"01OS;C", 'F'},
    {"01OS;E", 'F'},
    {"01OS;N", 'F'},
    {"01OS;T", 'F'},
    {"01OSA(", 'F'},
    {"01OSAF", 'F'},
    {"01OSAS", 'F'},
    {"01OSAT", 'F'},
    {"01OSAV", 'F'},
    {"01OSB(", 'F'},
    {"01OSB1", 'F'},
    {"01OSBE", 'F'},
    {"01OSBF", 'F'},
    {"01OSBN", 'F'},
    {"01OSBS", 'F'},
    {"01OSBV", 'F'},
    {"01OSC", 'F'},
    {"01OSE(", 'F'},
    {"01OSE1", 'F'},
    {"01OSEF", 'F'},
    {"01OSEK", 'F'},
    {"01OSEN", 'F'},
    {"01OSEO", 'F'},
    {"01OSES", 'F'},
    {"01OSEU", 'F'},
    {"01OSEV", 'F'},
    {"01OSF(", 'F'},
    {"01OSK(", 'F'},
    {"01OSK)", 'F'},
    {"01OSK1", 'F'},
    {"01OSKB", 'F'},
    {"01OSKF", 'F'},
    {"01OSKN", 'F'},
    {"01OSKS", 'F'},
    {"01OSKU", 'F'},
    {"01OSKV", 'F'},
    {"01OSO(", 'F'},
    {"01OSO1", 'F'},
    {"01OSOF", 'F'},
    {"01OSOK", 'F'},
    {"01OSON", 'F'},
    {"01OSOS", 'F'},
    {"01OSOT", 'F'},
    {"01OSOU", 'F'},
    {"01OSOV", 'F'},
    {"01OSU", 'F'},
    {"01OSU(", 'F'},
    {"01OSU1", 'F'},
    {"01OSU;", 'F'},
    {"01OSUC", 'F'},
    {"01OSUE", 'F'},
    {"01OSUF", 'F'},
    {"01OSUK", 'F'},
    {"01OSUN", 'F'},
    {"01OSUO", 'F'},
    {"01OSUS", 'F'},
    {"01OSUT", 'F'},
    {"01OSUV", 'F'},
    {"01OSV(", 'F'},
    {"01OSVF", 'F'},
    {"01OSVO", 'F'},
    {"01OSVS", 'F'},
    {"01OSVU", 'F'},
    {"01OT((", 'F'},
    {"01OT(1", 'F'},
    {"01OT(F", 'F'},
    {"01OT(N", 'F'},
    {"01OT(S", 'F'},
    {"01OT(V", 'F'},
    {"01OU((", 'F'},
    {"01OU(E", 'F'},
    {"01OUEK", 'F'},
    {"01OUEN", 'F'},
    {"01OV", 'F'},
    {"01OV&(", 'F'},
    {"01OV&1", 'F'},
    {"01OV&E", 'F'},
    {"01OV&F", 'F'},
    {"01OV&K", 'F'},
    {"01OV&N", 'F'},
    {"01OV&S", 'F'},
    {"01OV&U", 'F'},
    {"01OV&V", 'F'},
    {"01OV((", 'F'},
    {"01OV(E", 'F'},
    {"01OV(U", 'F'},
    {"01OV)&", 'F'},
    {"01OV))", 'F'},
    {"01OV),", 'F'},
    {"01OV);", 'F'},
    {"01OV)B", 'F'},
    {"01OV)E", 'F'},
    {"01OV)K", 'F'},
    {"01OV)O", 'F'},
    {"01OV)U", 'F'},
    {"01OV,(", 'F'},
    {"01OV,1", 'F'},
    {"01OV,F", 'F'},
    {"01OV,N", 'F'},
    {"01OV,S", 'F'},
    {"01OV,V", 'F'},
    {"01OV;", 'F'},
    {"01OV;C", 'F'},
    {"01OV;E", 'F'},
    {"01OV;N", 'F'},
    {"01OV;T", 'F'},
    {"01OVA(", 'F'},
    {"01OVAF", 'F'},
    {"01OVAS", 'F'},
    {"01OVAT", 'F'},
    {"01OVAV", 'F'},
    {"01OVB(", 'F'},
    {"01OVB1", 'F'},
    {"01OVBE", 'F'},
    {"01OVBF", 'F'},
    {"01OVBN", 'F'},
    {"01OVBS", 'F'},
    {"01OVBV", 'F'},
    {"01OVC", 'F'},
    {"01OVE(", 'F'},
    {"01OVE1", 'F'},
    {"01OVEF", 'F'},
    {"01OVEK", 'F'},
    {"01OVEN", 'F'},
    {"01OVEO", 'F'},
    {"01OVES", 'F'},
    {"01OVEU", 'F'},
    {"01OVEV", 'F'},
    {"01OVF(", 'F'},
    {"01OVK(", 'F'},
    {"01OVK)", 'F'},
    {"01OVK1", 'F'},
    {"01OVKB", 'F'},
    {"01OVKF", 'F'},
    {"01OVKN", 'F'},
    {"01OVKS", 'F'},
    {"01OVKU", 'F'},
    {"01OVKV", 'F'},
    {"01OVO(", 'F'},
    {"01OVOF", 'F'},
    {"01OVOK", 'F'},
    {"01OVOS", 'F'},
    {"01OVOT", 'F'},
    {"01OVOU", 'F'},
    {"01OVS(", 'F'},
    {"01OVS1", 'F'},
    {"01OVSF", 'F'},
    {"01OVSO", 'F'},
    {"01OVSU", 'F'},
    {"01OVSV", 'F'},
    {"01OVU", 'F'},
    {"01OVU(", 'F'},
    {"01OVU1", 'F'},
    {"01OVU;", 'F'},
    {"01OVUC", 'F'},
    {"01OVUE", 'F'},
    {"01OVUF", 'F'},
    {"01OVUK", 'F'},
    {"01OVUN", 'F'},
    {"01OVUO", 'F'},
    {"01OVUS", 'F'},
    {"01OVUT", 'F'},
    {"01OVUV", 'F'},
    {"01SF((", 'F'},
    {"01SF()", 'F'},
    {"01SF(1", 'F'},
    {"01SF(F", 'F'},
    {"01SF(N", 'F'},
    {"01SF(S", 'F'},
    {"01SF(V", 'F'},
    {"01SUE", 'F'},
    {"01SUE;", 'F'},
    {"01SUEC", 'F'},
    {"01SUEK", 'F'},
    {"01SV", 'F'},
    {"01SV;", 'F'},
    {"01SV;C", 'F'},
    {"01SVC", 'F'},
    {"01SVO(", 'F'},
    {"01SVOF", 'F'},
    {"01SVOS", 'F'},
    {"01U", 'F'},
    {"01U(((", 'F'},
    {"01U((1", 'F'},
    {"01U((E", 'F'},
    {"01U((F", 'F'},
    {"01U((N", 'F'},
    {"01U((S", 'F'},
    {"01U((V", 'F'},
    {"01U(1)", 'F'},
    {"01U(1O", 'F'},
    {"01U(E(", 'F'},
    {"01U(E1", 'F'},
    {"01U(EF", 'F'},
    {"01U(EK", 'F'},
    {"01U(EN", 'F'},
    {"01U(ES", 'F'},
    {"01U(EV", 'F'},
    {"01U(F(", 'F'},
    {"01U(N)", 'F'},
    {"01U(NO", 'F'},
    {"01U(S)", 'F'},
    {"01U(SO", 'F'},
    {"01U(V)", 'F'},
    {"01U(VO", 'F'},
    {"01U1,(", 'F'},
    {"01U1,F", 'F'},
    {"01U1,V", 'F'},
    {"01U1C", 'F'},
    {"01U1O(", 'F'},
    {"01U1OF", 'F'},
    {"01U1OS", 'F'},
    {"01U1OV", 'F'},
    {"01U;", 'F'},
    {"01U;C", 'F'},
    {"01UC", 'F'},
    {"01UE", 'F'},
    {"01UE((", 'F'},
    {"01UE(1", 'F'},
    {"01UE(E", 'F'},
    {"01UE(F", 'F'},
    {"01UE(N", 'F'},
    {"01UE(O", 'F'},
    {"01UE(S", 'F'},
    {"01UE(V", 'F'},
    {"01UE1", 'F'},
    {"01UE1&", 'F'},
    {"01UE1(", 'F'},
    {"01UE1)", 'F'},
    {"01UE1,", 'F'},
    {"01UE1;", 'F'},
    {"01UE1B", 'F'},
    {"01UE1C", 'F'},
    {"01UE1F", 'F'},
    {"01UE1K", 'F'},
    {"01UE1N", 'F'},
    {"01UE1O", 'F'},
    {"01UE1S", 'F'},
    {"01UE1U", 'F'},
    {"01UE1V", 'F'},
    {"01UE;", 'F'},
    {"01UE;C", 'F'},
    {"01UEC", 'F'},
    {"01UEF", 'F'},
    {"01UEF(", 'F'},
    {"01UEF,", 'F'},
    {"01UEF;", 'F'},
    {"01UEFC", 'F'},
    {"01UEK", 'F'},
    {"01UEK(", 'F'},
    {"01UEK1", 'F'},
    {"01UEK;", 'F'},
    {"01UEKC", 'F'},
    {"01UEKF", 'F'},
    {"01UEKN", 'F'},
    {"01UEKO", 'F'},
    {"01UEKS", 'F'},
    {"01UEKV", 'F'},
    {"01UEN", 'F'},
    {"01UEN&", 'F'},
    {"01UEN(", 'F'},
    {"01UEN)", 'F'},
    {"01UEN,", 'F'},
    {"01UEN1", 'F'},
    {"01UEN;", 'F'},
    {"01UENB", 'F'},
    {"01UENC", 'F'},
    {"01UENF", 'F'},
    {"01UENK", 'F'},
    {"01UENO", 'F'},
    {"01UENS", 'F'},
    {"01UENU", 'F'},
    {"01UEOK", 'F'},
    {"01UEON", 'F'},
    {"01UEOO", 'F'},
    {"01UES", 'F'},
    {"01UES&", 'F'},
    {"01UES(", 'F'},
    {"01UES)", 'F'},
    {"01UES,", 'F'},
    {"01UES1", 'F'},
    {"01UES;", 'F'},
    {"01UESB", 'F'},
    {"01UESC", 'F'},
    {"01UESF", 'F'},
    {"01UESK", 'F'},
    {"01UESO", 'F'},
    {"01UESU", 'F'},
    {"01UESV", 'F'},
    {"01UEV", 'F'},
    {"01UEV&", 'F'},
    {"01UEV(", 'F'},
    {"01UEV)", 'F'},
    {"01UEV,", 'F'},
    {"01UEV;", 'F'},
    {"01UEVB", 'F'},
    {"01UEVC", 'F'},
    {"01UEVF", 'F'},
    {"01UEVK", 'F'},
    {"01UEVN", 'F'},
    {"01UEVO", 'F'},
    {"01UEVS", 'F'},
    {"01UEVU", 'F'},
    {"01UF((", 'F'},
    {"01UF()", 'F'},
    {"01UF(1", 'F'},
    {"01UF(F", 'F'},
    {"01UF(N", 'F'},
    {"01UF(S", 'F'},
    {"01UF(V", 'F'},
    {"01UK((", 'F'},
    {"01UK(E", 'F'},
    {"01UN((", 'F'},
    {"01UN(1", 'F'},
    {"01UN(F", 'F'},
    {"01UN(S", 'F'},
    {"01UN(V", 'F'},
    {"01UN,(", 'F'},
    {"01UN,F", 'F'},
    {"01UN,V", 'F'},
    {"01UN1(", 'F'},
    {"01UN1,", 'F'},
    {"01UN1O", 'F'},
    {"01UNC", 'F'},
    {"01UNE(", 'F'},
    {"01UNE1", 'F'},
    {"01UNEF", 'F'},
    {"01UNEN", 'F'},
    {"01UNES", 'F'},
    {"01UNEV", 'F'},
    {"01UNF(", 'F'},
    {"01UNO(", 'F'},
    {"01UNOF", 'F'},
    {"01UNOS", 'F'},
    {"01UNOV", 'F'},
    {"01UNS(", 'F'},
    {"01UNS,", 'F'},
    {"01UNSO", 'F'},
    {"01UO((", 'F'},
    {"01UO(E", 'F'},
    {"01UON(", 'F'},
    {"01UON1", 'F'},
    {"01UONF", 'F'},
    {"01UONS", 'F'},
    {"01US,(", 'F'},
    {"01US,F", 'F'},
    {"01US,V", 'F'},
    {"01USC", 'F'},
    {"01USO(", 'F'},
    {"01USO1", 'F'},
    {"01USOF", 'F'},
    {"01USON", 'F'},
    {"01USOS", 'F'},
    {"01USOV", 'F'},
    {"01UTN(", 'F'},
    {"01UTN1", 'F'},
    {"01UTNF", 'F'},
    {"01UTNS", 'F'},
    {"01UV,(", 'F'},
    {"01UV,1", 'F'},
    {"01UV,F", 'F'},
    {"01UV,N", 'F'},
    {"01UV,S", 'F'},
    {"01UV,V", 'F'},
    {"01UVC", 'F'},
    {"01UVO(", 'F'},
    {"01UVOF", 'F'},
    {"01UVOS", 'F'},
    {"01VF((", 'F'},
    {"01VF()", 'F'},
    {"01VF(1", 'F'},
    {"01VF(F", 'F'},
    {"01VF(N", 'F'},
    {"01VF(S", 'F'},
    {"01VF(V", 'F'},
    {"01VO((", 'F'},
    {"01VO(1", 'F'},
    {"01VO(F", 'F'},
    {"01VO(N", 'F'},
    {"01VO(S", 'F'},
    {"01VO(V", 'F'},
    {"01VOF(", 'F'},
    {"01VOS(", 'F'},
    {"01VOS1", 'F'},
    {"01VOSF", 'F'},
    {"01VOSO", 'F'},
    {"01VOSU", 'F'},
    {"01VOSV", 'F'},
    {"01VS", 'F'},
    {"01VS;", 'F'},
    {"01VS;C", 'F'},
    {"01VSC", 'F'},
    {"01VSO(", 'F'},
    {"01VSO1", 'F'},
    {"01VSOF", 'F'},
    {"01VSON", 'F'},
    {"01VSOS", 'F'},
    {"01VSOV", 'F'},
    {"01VUE", 'F'},
    {"01VUE;", 'F'},
    {"01VUEC", 'F'},
    {"01VUEK", 'F'},
    {"0;TKNC", 'F'},
    {"0E((((", 'F'},
    {"0E(((1", 'F'},
    {"0E(((E", 'F'},
    {"0E(((F", 'F'},
    {"0E(((N", 'F'},
    {"0E(((S", 'F'},
    {"0E(((V", 'F'},
    {"0E((1(", 'F'},
    {"0E((1)", 'F'},
    {"0E((1,", 'F'},
    {"0E((1F", 'F'},
    {"0E((1N", 'F'},
    {"0E((1O", 'F'},
    {"0E((1S", 'F'},
    {"0E((1V", 'F'},
    {"0E((E(", 'F'},
    {"0E((E1", 'F'},
    {"0E((EF", 'F'},
    {"0E((EK", 'F'},
    {"0E((EN", 'F'},
    {"0E((ES", 'F'},
    {"0E((EV", 'F'},
    {"0E((F(", 'F'},
    {"0E((N(", 'F'},
    {"0E((N)", 'F'},
    {"0E((N,", 'F'},
    {"0E((N1", 'F'},
    {"0E((NF", 'F'},
    {"0E((NO", 'F'},
    {"0E((S(", 'F'},
    {"0E((S)", 'F'},
    {"0E((S,", 'F'},
    {"0E((S1", 'F'},
    {"0E((SF", 'F'},
    {"0E((SO", 'F'},
    {"0E((SV", 'F'},
    {"0E((V(", 'F'},
    {"0E((V)", 'F'},
    {"0E((V,", 'F'},
    {"0E((VF", 'F'},
    {"0E((VO", 'F'},
    {"0E((VS", 'F'},
    {"0E(1)&", 'F'},
    {"0E(1))", 'F'},
    {"0E(1),", 'F'},
    {"0E(1)1", 'F'},
    {"0E(1)F", 'F'},
    {"0E(1)K", 'F'},
    {"0E(1)N", 'F'},
    {"0E(1)O", 'F'},
    {"0E(1)S", 'F'},
    {"0E(1)U", 'F'},
    {"0E(1)V", 'F'},
    {"0E(1,F", 'F'},
    {"0E(1F(", 'F'},
    {"0E(1N)", 'F'},
    {"0E(1NO", 'F'},
    {"0E(1O(", 'F'},
    {"0E(1OF", 'F'},
    {"0E(1OS", 'F'},
    {"0E(1OV", 'F'},
    {"0E(1S)", 'F'},
    {"0E(1V)", 'F'},
    {"0E(1VO", 'F'},
    {"0E(E((", 'F'},
    {"0E(E(1", 'F'},
    {"0E(E(E", 'F'},
    {"0E(E(F", 'F'},
    {"0E(E(N", 'F'},
    {"0E(E(S", 'F'},
    {"0E(E(V", 'F'},
    {"0E(E1O", 'F'},
    {"0E(EF(", 'F'},
    {"0E(EK(", 'F'},
    {"0E(EK1", 'F'},
    {"0E(EKF", 'F'},
    {"0E(EKN", 'F'},
    {"0E(EKS", 'F'},
    {"0E(EKV", 'F'},
    {"0E(ENO", 'F'},
    {"0E(ESO", 'F'},
    {"0E(EVO", 'F'},
    {"0E(F((", 'F'},
    {"0E(F()", 'F'},
    {"0E(F(1", 'F'},
    {"0E(F(F", 'F'},
    {"0E(F(N", 'F'},
    {"0E(F(S", 'F'},
    {"0E(F(V", 'F'},
    {"0E(N((", 'F'},
    {"0E(N(1", 'F'},
    {"0E(N(F", 'F'},
    {"0E(N(S", 'F'},
    {"0E(N(V", 'F'},
    {"0E(N)&", 'F'},
    {"0E(N))", 'F'},
    {"0E(N),", 'F'},
    {"0E(N)1", 'F'},
    {"0E(N)F", 'F'},
    {"0E(N)K", 'F'},
    {"0E(N)N", 'F'},
    {"0E(N)O", 'F'},
    {"0E(N)S", 'F'},
    {"0E(N)U", 'F'},
    {"0E(N)V", 'F'},
    {"0E(N,F", 'F'},
    {"0E(N1)", 'F'},
    {"0E(N1O", 'F'},
    {"0E(NF(", 'F'},
    {"0E(NO(", 'F'},
    {"0E(NOF", 'F'},
    {"0E(NOS", 'F'},
    {"0E(NOV", 'F'},
    {"0E(S)&", 'F'},
    {"0E(S))", 'F'},
    {"0E(S),", 'F'},
    {"0E(S)1", 'F'},
    {"0E(S)F", 'F'},
    {"0E(S)K", 'F'},
    {"0E(S)N", 'F'},
    {"0E(S)O", 'F'},
    {"0E(S)S", 'F'},
    {"0E(S)U", 'F'},
    {"0E(S)V", 'F'},
    {"0E(S,F", 'F'},
    {"0E(S1)", 'F'},
    {"0E(S1O", 'F'},
    {"0E(SF(", 'F'},
    {"0E(SO(", 'F'},
    {"0E(SO1", 'F'},
    {"0E(SOF", 'F'},
    {"0E(SON", 'F'},
    {"0E(SOS", 'F'},
    {"0E(SOV", 'F'},
    {"0E(SV)", 'F'},
    {"0E(SVO", 'F'},
    {"0E(V)&", 'F'},
    {"0E(V))", 'F'},
    {"0E(V),", 'F'},
    {"0E(V)1", 'F'},
    {"0E(V)F", 'F'},
    {"0E(V)K", 'F'},
    {"0E(V)N", 'F'},
    {"0E(V)O", 'F'},
    {"0E(V)S", 'F'},
    {"0E(V)U", 'F'},
    {"0E(V)V", 'F'},
    {"0E(V,F", 'F'},
    {"0E(VF(", 'F'},
    {"0E(VO(", 'F'},
    {"0E(VOF", 'F'},
    {"0E(VOS", 'F'},
    {"0E(VS)", 'F'},
    {"0E(VSO", 'F'},
    {"0E1&((", 'F'},
    {"0E1&(E", 'F'},
    {"0E1)", 'F'},
    {"0E1))", 'F'},
    {"0E1)))", 'F'},
    {"0E1))1", 'F'},
    {"0E1));", 'F'},
    {"0E1))C", 'F'},
    {"0E1))F", 'F'},
    {"0E1))K", 'F'},
    {"0E1))N", 'F'},
    {"0E1))O", 'F'},
    {"0E1))S", 'F'},
    {"0E1))U", 'F'},
    {"0E1))V", 'F'},
    {"0E1);", 'F'},
    {"0E1);C", 'F'},
    {"0E1)C", 'F'},
    {"0E1)KN", 'F'},
    {"0E1)O(", 'F'},
    {"0E1)O1", 'F'},
    {"0E1)OF", 'F'},
    {"0E1)ON", 'F'},
    {"0E1)OS", 'F'},
    {"0E1)OV", 'F'},
    {"0E1)UE", 'F'},
    {"0E1,((", 'F'},
    {"0E1,(1", 'F'},
    {"0E1,(F", 'F'},
    {"0E1,(N", 'F'},
    {"0E1,(S", 'F'},
    {"0E1,(V", 'F'},
    {"0E1,F(", 'F'},
    {"0E1,V,", 'F'},
    {"0E1,VK", 'F'},
    {"0E1,VO", 'F'},
    {"0E1F((", 'F'},
    {"0E1F()", 'F'},
    {"0E1F(1", 'F'},
    {"0E1F(F", 'F'},
    {"0E1F(N", 'F'},
    {"0E1F(S", 'F'},
    {"0E1F(V", 'F'},
    {"0E1K((", 'F'},
    {"0E1K(1", 'F'},
    {"0E1K(E", 'F'},
    {"0E1K(F", 'F'},
    {"0E1K(N", 'F'},
    {"0E1K(S", 'F'},
    {"0E1K(V", 'F'},
    {"0E1K1)", 'F'},
    {"0E1K1K", 'F'},
    {"0E1K1O", 'F'},
    {"0E1KF(", 'F'},
    {"0E1KN", 'F'},
    {"0E1KN)", 'F'},
    {"0E1KN;", 'F'},
    {"0E1KNC", 'F'},
    {"0E1KNK", 'F'},
    {"0E1KS)", 'F'},
    {"0E1KSK", 'F'},
    {"0E1KSO", 'F'},
    {"0E1KV)", 'F'},
    {"0E1KVK", 'F'},
    {"0E1KVO", 'F'},
    {"0E1N;", 'F'},
    {"0E1N;C", 'F'},
    {"0E1NC", 'F'},
    {"0E1NKN", 'F'},
    {"0E1NO(", 'F'},
    {"0E1NOF", 'F'},
    {"0E1NOS", 'F'},
    {"0E1NOV", 'F'},
    {"0E1O((", 'F'},
    {"0E1O(1", 'F'},
    {"0E1O(E", 'F'},
    {"0E1O(F", 'F'},
    {"0E1O(N", 'F'},
    {"0E1O(S", 'F'},
    {"0E1O(V", 'F'},
    {"0E1OF(", 'F'},
    {"0E1OS&", 'F'},
    {"0E1OS(", 'F'},
    {"0E1OS)", 'F'},
    {"0E1OS,", 'F'},
    {"0E1OS1", 'F'},
    {"0E1OSF", 'F'},
    {"0E1OSK", 'F'},
    {"0E1OSO", 'F'},
    {"0E1OSV", 'F'},
    {"0E1OV&", 'F'},
    {"0E1OV(", 'F'},
    {"0E1OV)", 'F'},
    {"0E1OV,", 'F'},
    {"0E1OVF", 'F'},
    {"0E1OVK", 'F'},
    {"0E1OVO", 'F'},
    {"0E1OVS", 'F'},
    {"0E1S;", 'F'},
    {"0E1S;C", 'F'},
    {"0E1SC", 'F'},
    {"0E1V", 'F'},
    {"0E1V;", 'F'},
    {"0E1V;C", 'F'},
    {"0E1VC", 'F'},
    {"0E1VO(", 'F'},
    {"0E1VOF", 'F'},
    {"0E1VOS", 'F'},
    {"0ECHO", 'F'},
    {"0ECHO;", 'F'},
    {"0ECHOC", 'F'},
    {"0EE(((", 'F'},
    {"0EE((F", 'F'},
    {"0EE(F(", 'F'},
    {"0EEK((", 'F'},
    {"0EEK(F", 'F'},
    {"0EF(((", 'F'},
    {"0EF(()", 'F'},
    {"0EF((1", 'F'},
    {"0EF((F", 'F'},
    {"0EF((N", 'F'},
    {"0EF((O", 'F'},
    {"0EF((S", 'F'},
    {"0EF((V", 'F'},
    {"0EF()&", 'F'},
    {"0EF())", 'F'},
    {"0EF(),", 'F'},
    {"0EF()1", 'F'},
    {"0EF()F", 'F'},
    {"0EF()K", 'F'},
    {"0EF()N", 'F'},
    {"0EF()O", 'F'},
    {"0EF()S", 'F'},
    {"0EF()V", 'F'},
    {"0EF(1)", 'F'},
    {"0EF(1,", 'F'},
    {"0EF(1O", 'F'},
    {"0EF(F(", 'F'},
    {"0EF(N)", 'F'},
    {"0EF(N,", 'F'},
    {"0EF(NO", 'F'},
    {"0EF(O)", 'F'},
    {"0EF(S)", 'F'},
    {"0EF(S,", 'F'},
    {"0EF(SO", 'F'},
    {"0EF(V)", 'F'},
    {"0EF(V,", 'F'},
    {"0EF(VO", 'F'},
    {"0EK(((", 'F'},
    {"0EK((1", 'F'},
    {"0EK((E", 'F'},
    {"0EK((F", 'F'},
    {"0EK((N", 'F'},
    {"0EK((S", 'F'},
    {"0EK((V", 'F'},
    {"0EK(1(", 'F'},
    {"0EK(1)", 'F'},
    {"0EK(1,", 'F'},
    {"0EK(1F", 'F'},
    {"0EK(1N", 'F'},
    {"0EK(1O", 'F'},
    {"0EK(1S", 'F'},
    {"0EK(1V", 'F'},
    {"0EK(E(", 'F'},
    {"0EK(E1", 'F'},
    {"0EK(EF", 'F'},
    {"0EK(EK", 'F'},
    {"0EK(EN", 'F'},
    {"0EK(ES", 'F'},
    {"0EK(EV", 'F'},
    {"0EK(F(", 'F'},
    {"0EK(N(", 'F'},
    {"0EK(N)", 'F'},
    {"0EK(N,", 'F'},
    {"0EK(N1", 'F'},
    {"0EK(NF", 'F'},
    {"0EK(NO", 'F'},
    {"0EK(S(", 'F'},
    {"0EK(S)", 'F'},
    {"0EK(S,", 'F'},
    {"0EK(S1", 'F'},
    {"0EK(SF", 'F'},
    {"0EK(SO", 'F'},
    {"0EK(SV", 'F'},
    {"0EK(V(", 'F'},
    {"0EK(V)", 'F'},
    {"0EK(V,", 'F'},
    {"0EK(VF", 'F'},
    {"0EK(VO", 'F'},
    {"0EK(VS", 'F'},
    {"0EK1&(", 'F'},
    {"0EK1)", 'F'},
    {"0EK1))", 'F'},
    {"0EK1);", 'F'},
    {"0EK1)C", 'F'},
    {"0EK1)K", 'F'},
    {"0EK1)O", 'F'},
    {"0EK1)U", 'F'},
    {"0EK1,(", 'F'},
    {"0EK1,F", 'F'},
    {"0EK1,V", 'F'},
    {"0EK1F(", 'F'},
    {"0EK1K(", 'F'},
    {"0EK1K1", 'F'},
    {"0EK1KF", 'F'},
    {"0EK1KN", 'F'},
    {"0EK1KS", 'F'},
    {"0EK1KV", 'F'},
    {"0EK1N", 'F'},
    {"0EK1N;", 'F'},
    {"0EK1NC", 'F'},
    {"0EK1NF", 'F'},
    {"0EK1NK", 'F'},
    {"0EK1NO", 'F'},
    {"0EK1O(", 'F'},
    {"0EK1OF", 'F'},
    {"0EK1OS", 'F'},
    {"0EK1OV", 'F'},
    {"0EK1S", 'F'},
    {"0EK1S;", 'F'},
    {"0EK1SC", 'F'},
    {"0EK1SF", 'F'},
    {"0EK1SK", 'F'},
    {"0EK1V", 'F'},
    {"0EK1V;", 'F'},
    {"0EK1VC", 'F'},
    {"0EK1VF", 'F'},
    {"0EK1VK", 'F'},
    {"0EK1VO", 'F'},
    {"0EKE((", 'F'},
    {"0EKE(F", 'F'},
    {"0EKEK(", 'F'},
    {"0EKF((", 'F'},
    {"0EKF()", 'F'},
    {"0EKF(1", 'F'},
    {"0EKF(F", 'F'},
    {"0EKF(N", 'F'},
    {"0EKF(O", 'F'},
    {"0EKF(S", 'F'},
    {"0EKF(V", 'F'},
    {"0EKN&(", 'F'},
    {"0EKN((", 'F'},
    {"0EKN(1", 'F'},
    {"0EKN(F", 'F'},
    {"0EKN(S", 'F'},
    {"0EKN(V", 'F'},
    {"0EKN)", 'F'},
    {"0EKN))", 'F'},
    {"0EKN);", 'F'},
    {"0EKN)C", 'F'},
    {"0EKN)K", 'F'},
    {"0EKN)O", 'F'},
    {"0EKN)U", 'F'},
    {"0EKN,(", 'F'},
    {"0EKN,F", 'F'},
    {"0EKN,V", 'F'},
    {"0EKN1", 'F'},
    {"0EKN1;", 'F'},
    {"0EKN1C", 'F'},
    {"0EKN1F", 'F'},
    {"0EKN1K", 'F'},
    {"0EKN1O", 'F'},
    {"0EKNF(", 'F'},
    {"0EKNK(", 'F'},
    {"0EKNK1", 'F'},
    {"0EKNKF", 'F'},
    {"0EKNKN", 'F'},
    {"0EKNKS", 'F'},
    {"0EKNKV", 'F'},
    {"0EKO((", 'F'},
    {"0EKO(1", 'F'},
    {"0EKO(F", 'F'},
    {"0EKO(N", 'F'},
    {"0EKO(S", 'F'},
    {"0EKO(V", 'F'},
    {"0EKOK(", 'F'},
    {"0EKS&(", 'F'},
    {"0EKS)", 'F'},
    {"0EKS))", 'F'},
    {"0EKS);", 'F'},
    {"0EKS)C", 'F'},
    {"0EKS)K", 'F'},
    {"0EKS)O", 'F'},
    {"0EKS)U", 'F'},
    {"0EKS,(", 'F'},
    {"0EKS,F", 'F'},
    {"0EKS,V", 'F'},
    {"0EKS1", 'F'},
    {"0EKS1;", 'F'},
    {"0EKS1C", 'F'},
    {"0EKS1F", 'F'},
    {"0EKS1K", 'F'},
    {"0EKS1O", 'F'},
    {"0EKSF(", 'F'},
    {"0EKSK(", 'F'},
    {"0EKSK1", 'F'},
    {"0EKSKF", 'F'},
    {"0EKSKN", 'F'},
    {"0EKSKS", 'F'},
    {"0EKSKV", 'F'},
    {"0EKSO(", 'F'},
    {"0EKSO1", 'F'},
    {"0EKSOF", 'F'},
    {"0EKSON", 'F'},
    {"0EKSOS", 'F'},
    {"0EKSOV", 'F'},
    {"0EKSV", 'F'},
    {"0EKSV;", 'F'},
    {"0EKSVC", 'F'},
    {"0EKSVF", 'F'},
    {"0EKSVK", 'F'},
    {"0EKSVO", 'F'},
    {"0EKV&(", 'F'},
    {"0EKV)", 'F'},
    {"0EKV))", 'F'},
    {"0EKV);", 'F'},
    {"0EKV)C", 'F'},
    {"0EKV)K", 'F'},
    {"0EKV)O", 'F'},
    {"0EKV)U", 'F'},
    {"0EKV,(", 'F'},
    {"0EKV,1", 'F'},
    {"0EKV,F", 'F'},
    {"0EKV,N", 'F'},
    {"0EKV,S", 'F'},
    {"0EKV,V", 'F'},
    {"0EKVF(", 'F'},
    {"0EKVK(", 'F'},
    {"0EKVK1", 'F'},
    {"0EKVKF", 'F'},
    {"0EKVKN", 'F'},
    {"0EKVKS", 'F'},
    {"0EKVKV", 'F'},
    {"0EKVO(", 'F'},
    {"0EKVOF", 'F'},
    {"0EKVOS", 'F'},
    {"0EKVS", 'F'},
    {"0EKVS;", 'F'},
    {"0EKVSC", 'F'},
    {"0EKVSF", 'F'},
    {"0EKVSK", 'F'},
    {"0EKVSO", 'F'},
    {"0EN&((", 'F'},
    {"0EN&(E", 'F'},
    {"0EN(((", 'F'},
    {"0EN((1", 'F'},
    {"0EN((F", 'F'},
    {"0EN((N", 'F'},
    {"0EN((S", 'F'},
    {"0EN((V", 'F'},
    {"0EN(1O", 'F'},
    {"0EN(F(", 'F'},
    {"0EN(S)", 'F'},
    {"0EN(SO", 'F'},
    {"0EN(V)", 'F'},
    {"0EN(VO", 'F'},
    {"0EN)", 'F'},
    {"0EN))", 'F'},
    {"0EN)))", 'F'},
    {"0EN))1", 'F'},
    {"0EN));", 'F'},
    {"0EN))C", 'F'},
    {"0EN))F", 'F'},
    {"0EN))K", 'F'},
    {"0EN))N", 'F'},
    {"0EN))O", 'F'},
    {"0EN))S", 'F'},
    {"0EN))U", 'F'},
    {"0EN))V", 'F'},
    {"0EN);", 'F'},
    {"0EN);C", 'F'},
    {"0EN)C", 'F'},
    {"0EN)KN", 'F'},
    {"0EN)O(", 'F'},
    {"0EN)O1", 'F'},
    {"0EN)OF", 'F'},
    {"0EN)ON", 'F'},
    {"0EN)OS", 'F'},
    {"0EN)OV", 'F'},
    {"0EN)UE", 'F'},
    {"0EN,((", 'F'},
    {"0EN,(1", 'F'},
    {"0EN,(F", 'F'},
    {"0EN,(N", 'F'},
    {"0EN,(S", 'F'},
    {"0EN,(V", 'F'},
    {"0EN,F(", 'F'},
    {"0EN,V,", 'F'},
    {"0EN,VK", 'F'},
    {"0EN,VO", 'F'},
    {"0EN1;", 'F'},
    {"0EN1;C", 'F'},
    {"0EN1C", 'F'},
    {"0EN1O(", 'F'},
    {"0EN1OF", 'F'},
    {"0EN1OS", 'F'},
    {"0EN1OV", 'F'},
    {"0ENF((", 'F'},
    {"0ENF()", 'F'},
    {"0ENF(1", 'F'},
    {"0ENF(F", 'F'},
    {"0ENF(N", 'F'},
    {"0ENF(S", 'F'},
    {"0ENF(V", 'F'},
    {"0ENK((", 'F'},
    {"0ENK(1", 'F'},
    {"0ENK(E", 'F'},
    {"0ENK(F", 'F'},
    {"0ENK(N", 'F'},
    {"0ENK(S", 'F'},
    {"0ENK(V", 'F'},
    {"0ENK1)", 'F'},
    {"0ENK1K", 'F'},
    {"0ENK1O", 'F'},
    {"0ENKF(", 'F'},
    {"0ENKN)", 'F'},
    {"0ENKN,", 'F'},
    {"0ENKN;", 'F'},
    {"0ENKNB", 'F'},
    {"0ENKNC", 'F'},
    {"0ENKNK", 'F'},
    {"0ENKS)", 'F'},
    {"0ENKSK", 'F'},
    {"0ENKSO", 'F'},
    {"0ENKV)", 'F'},
    {"0ENKVK", 'F'},
    {"0ENKVO", 'F'},
    {"0ENO((", 'F'},
    {"0ENO(1", 'F'},
    {"0ENO(E", 'F'},
    {"0ENO(F", 'F'},
    {"0ENO(N", 'F'},
    {"0ENO(S", 'F'},
    {"0ENO(V", 'F'},
    {"0ENOF(", 'F'},
    {"0ENOS&", 'F'},
    {"0ENOS(", 'F'},
    {"0ENOS)", 'F'},
    {"0ENOS,", 'F'},
    {"0ENOS1", 'F'},
    {"0ENOSF", 'F'},
    {"0ENOSK", 'F'},
    {"0ENOSO", 'F'},
    {"0ENOSV", 'F'},
    {"0ENOV&", 'F'},
    {"0ENOV(", 'F'},
    {"0ENOV)", 'F'},
    {"0ENOV,", 'F'},
    {"0ENOVF", 'F'},
    {"0ENOVK", 'F'},
    {"0ENOVO", 'F'},
    {"0ENOVS", 'F'},
    {"0EO(((", 'F'},
    {"0EO((1", 'F'},
    {"0EO((F", 'F'},
    {"0EO((N", 'F'},
    {"0EO((S", 'F'},
    {"0EO((V", 'F'},
    {"0EO(1,", 'F'},
    {"0EO(1O", 'F'},
    {"0EO(F(", 'F'},
    {"0EO(N,", 'F'},
    {"0EO(NO", 'F'},
    {"0EO(S,", 'F'},
    {"0EO(SO", 'F'},
    {"0EO(V,", 'F'},
    {"0EO(VO", 'F'},
    {"0EOK((", 'F'},
    {"0EOK(E", 'F'},
    {"0ES&((", 'F'},
    {"0ES&(E", 'F'},
    {"0ES)", 'F'},
    {"0ES))", 'F'},
    {"0ES)))", 'F'},
    {"0ES))1", 'F'},
    {"0ES));", 'F'},
    {"0ES))C", 'F'},
    {"0ES))F", 'F'},
    {"0ES))K", 'F'},
    {"0ES))N", 'F'},
    {"0ES))O", 'F'},
    {"0ES))S", 'F'},
    {"0ES))U", 'F'},
    {"0ES))V", 'F'},
    {"0ES);", 'F'},
    {"0ES);C", 'F'},
    {"0ES)C", 'F'},
    {"0ES)KN", 'F'},
    {"0ES)O(", 'F'},
    {"0ES)O1", 'F'},
    {"0ES)OF", 'F'},
    {"0ES)ON", 'F'},
    {"0ES)OS", 'F'},
    {"0ES)OV", 'F'},
    {"0ES)UE", 'F'},
    {"0ES,((", 'F'},
    {"0ES,(1", 'F'},
    {"0ES,(F", 'F'},
    {"0ES,(N", 'F'},
    {"0ES,(S", 'F'},
    {"0ES,(V", 'F'},
    {"0ES,F(", 'F'},
    {"0ES,V,", 'F'},
    {"0ES,VK", 'F'},
    {"0ES,VO", 'F'},
    {"0ES1", 'F'},
    {"0ES1;", 'F'},
    {"0ES1;C", 'F'},
    {"0ES1C", 'F'},
    {"0ES1O(", 'F'},
    {"0ES1OF", 'F'},
    {"0ES1OS", 'F'},
    {"0ES1OV", 'F'},
    {"0ESF((", 'F'},
    {"0ESF()", 'F'},
    {"0ESF(1", 'F'},
    {"0ESF(F", 'F'},
    {"0ESF(N", 'F'},
    {"0ESF(S", 'F'},
    {"0ESF(V", 'F'},
    {"0ESK((", 'F'},
    {"0ESK(1", 'F'},
    {"0ESK(E", 'F'},
    {"0ESK(F", 'F'},
    {"0ESK(N", 'F'},
    {"0ESK(S", 'F'},
    {"0ESK(V", 'F'},
    {"0ESK1)", 'F'},
    {"0ESK1K", 'F'},
    {"0ESK1O", 'F'},
    {"0ESKF(", 'F'},
    {"0ESKN", 'F'},
    {"0ESKN)", 'F'},
    {"0ESKN;", 'F'},
    {"0ESKNC", 'F'},
    {"0ESKNK", 'F'},
    {"0ESKS)", 'F'},
    {"0ESKSK", 'F'},
    {"0ESKSO", 'F'},
    {"0ESKV)", 'F'},
    {"0ESKVK", 'F'},
    {"0ESKVO", 'F'},
    {"0ESO((", 'F'},
    {"0ESO(1", 'F'},
    {"0ESO(E", 'F'},
    {"0ESO(F", 'F'},
    {"0ESO(N", 'F'},
    {"0ESO(S", 'F'},
    {"0ESO(V", 'F'},
    {"0ESO1&", 'F'},
    {"0ESO1(", 'F'},
    {"0ESO1)", 'F'},
    {"0ESO1,", 'F'},
    {"0ESO1F", 'F'},
    {"0ESO1K", 'F'},
    {"0ESO1N", 'F'},
    {"0ESO1O", 'F'},
    {"0ESO1S", 'F'},
    {"0ESO1V", 'F'},
    {"0ESOF(", 'F'},
    {"0ESON&", 'F'},
    {"0ESON(", 'F'},
    {"0ESON)", 'F'},
    {"0ESON,", 'F'},
    {"0ESON1", 'F'},
    {"0ESONF", 'F'},
    {"0ESONK", 'F'},
    {"0ESONO", 'F'},
    {"0ESOS&", 'F'},
    {"0ESOS(", 'F'},
    {"0ESOS)", 'F'},
    {"0ESOS,", 'F'},
    {"0ESOS1", 'F'},
    {"0ESOSF", 'F'},
    {"0ESOSK", 'F'},
    {"0ESOSO", 'F'},
    {"0ESOSV", 'F'},
    {"0ESOV&", 'F'},
    {"0ESOV(", 'F'},
    {"0ESOV)", 'F'},
    {"0ESOV,", 'F'},
    {"0ESOVF", 'F'},
    {"0ESOVK", 'F'},
    {"0ESOVO", 'F'},
    {"0ESOVS", 'F'},
    {"0ESV", 'F'},
    {"0ESV;", 'F'},
    {"0ESV;C", 'F'},
    {"0ESVC", 'F'},
    {"0ESVO(", 'F'},
    {"0ESVOF", 'F'},
    {"0ESVOS", 'F'},
    {"0EV&((", 'F'},
    {"0EV&(E", 'F'},
    {"0EV)", 'F'},
    {"0EV))", 'F'},
    {"0EV)))", 'F'},
    {"0EV))1", 'F'},
    {"0EV));", 'F'},
    {"0EV))C", 'F'},
    {"0EV))F", 'F'},
    {"0EV))K", 'F'},
    {"0EV))N", 'F'},
    {"0EV))O", 'F'},
    {"0EV))S", 'F'},
    {"0EV))U", 'F'},
    {"0EV))V", 'F'},
    {"0EV);", 'F'},
    {"0EV);C", 'F'},
    {"0EV)C", 'F'},
    {"0EV)KN", 'F'},
    {"0EV)O(", 'F'},
    {"0EV)O1", 'F'},
    {"0EV)OF", 'F'},
    {"0EV)ON", 'F'},
    {"0EV)OS", 'F'},
    {"0EV)OV", 'F'},
    {"0EV)UE", 'F'},
    {"0EV,((", 'F'},
    {"0EV,(1", 'F'},
    {"0EV,(F", 'F'},
    {"0EV,(N", 'F'},
    {"0EV,(S", 'F'},
    {"0EV,(V", 'F'},
    {"0EV,1,", 'F'},
    {"0EV,1K", 'F'},
    {"0EV,1O", 'F'},
    {"0EV,F(", 'F'},
    {"0EV,N,", 'F'},
    {"0EV,NK", 'F'},
    {"0EV,NO", 'F'},
    {"0EV,S,", 'F'},
    {"0EV,SK", 'F'},
    {"0EV,SO", 'F'},
    {"0EV,V,", 'F'},
    {"0EV,VK", 'F'},
    {"0EV,VO", 'F'},
    {"0EVF((", 'F'},
    {"0EVF()", 'F'},
    {"0EVF(1", 'F'},
    {"0EVF(F", 'F'},
    {"0EVF(N", 'F'},
    {"0EVF(S", 'F'},
    {"0EVF(V", 'F'},
    {"0EVK((", 'F'},
    {"0EVK(1", 'F'},
    {"0EVK(E", 'F'},
    {"0EVK(F", 'F'},
    {"0EVK(N", 'F'},
    {"0EVK(S", 'F'},
    {"0EVK(V", 'F'},
    {"0EVK1)", 'F'},
    {"0EVK1K", 'F'},
    {"0EVK1O", 'F'},
    {"0EVKF(", 'F'},
    {"0EVKN", 'F'},
    {"0EVKN)", 'F'},
    {"0EVKN;", 'F'},
    {"0EVKNC", 'F'},
    {"0EVKNK", 'F'},
    {"0EVKS)", 'F'},
    {"0EVKSK", 'F'},
    {"0EVKSO", 'F'},
    {"0EVKV)", 'F'},
    {"0EVKVK", 'F'},
    {"0EVKVO", 'F'},
    {"0EVN", 'F'},
    {"0EVN;", 'F'},
    {"0EVN;C", 'F'},
    {"0EVNC", 'F'},
    {"0EVNKN", 'F'},
    {"0EVNO(", 'F'},
    {"0EVNOF", 'F'},
    {"0EVNOS", 'F'},
    {"0EVNOV", 'F'},
    {"0EVO((", 'F'},
    {"0EVO(1", 'F'},
    {"0EVO(E", 'F'},
    {"0EVO(F", 'F'},
    {"0EVO(N", 'F'},
    {"0EVO(S", 'F'},
    {"0EVO(V", 'F'},
    {"0EVOF(", 'F'},
    {"0EVOS&", 'F'},
    {"0EVOS(", 'F'},
    {"0EVOS)", 'F'},
    {"0EVOS,", 'F'},
    {"0EVOS1", 'F'},
    {"0EVOSF", 'F'},
    {"0EVOSK", 'F'},
    {"0EVOSO", 'F'},
    {"0EVOSV", 'F'},
    {"0EVS", 'F'},
    {"0EVS;", 'F'},
    {"0EVS;C", 'F'},
    {"0EVSC", 'F'},
    {"0EVSO(", 'F'},
    {"0EVSO1", 'F'},
    {"0EVSOF", 'F'},
    {"0EVSON", 'F'},
    {"0EVSOS", 'F'},
    {"0EVSOV", 'F'},
    {"0F((((", 'F'},
    {"0F((()", 'F'},
    {"0F(((1", 'F'},
    {"0F(((E", 'F'},
    {"0F(((F", 'F'},
    {"0F(((K", 'F'},
    {"0F(((N", 'F'},
    {"0F(((S", 'F'},
    {"0F(((T", 'F'},
    {"0F(((V", 'F'},
    {"0F(()&", 'F'},
    {"0F(())", 'F'},
    {"0F((),", 'F'},
    {"0F(()1", 'F'},
    {"0F(();", 'F'},
    {"0F(()A", 'F'},
    {"0F(()B", 'F'},
    {"0F(()C", 'F'},
    {"0F(()E", 'F'},
    {"0F(()F", 'F'},
    {"0F(()K", 'F'},
    {"0F(()N", 'F'},
    {"0F(()O", 'F'},
    {"0F(()S", 'F'},
    {"0F(()U", 'F'},
    {"0F(()V", 'F'},
    {"0F((1)", 'F'},
    {"0F((1,", 'F'},
    {"0F((1O", 'F'},
    {"0F((E(", 'F'},
    {"0F((E1", 'F'},
    {"0F((EF", 'F'},
    {"0F((EK", 'F'},
    {"0F((EN", 'F'},
    {"0F((ES", 'F'},
    {"0F((EV", 'F'},
    {"0F((F(", 'F'},
    {"0F((K(", 'F'},
    {"0F((K,", 'F'},
    {"0F((N)", 'F'},
    {"0F((N,", 'F'},
    {"0F((NO", 'F'},
    {"0F((S)", 'F'},
    {"0F((S,", 'F'},
    {"0F((SO", 'F'},
    {"0F((T)", 'F'},
    {"0F((T,", 'F'},
    {"0F((V)", 'F'},
    {"0F((V,", 'F'},
    {"0F((VO", 'F'},
    {"0F()&(", 'F'},
    {"0F()&1", 'F'},
    {"0F()&E", 'F'},
    {"0F()&F", 'F'},
    {"0F()&K", 'F'},
    {"0F()&N", 'F'},
    {"0F()&S", 'F'},
    {"0F()&V", 'F'},
    {"0F())&", 'F'},
    {"0F()))", 'F'},
    {"0F()),", 'F'},
    {"0F())1", 'F'},
    {"0F());", 'F'},
    {"0F())A", 'F'},
    {"0F())B", 'F'},
    {"0F())C", 'F'},
    {"0F())E", 'F'},
    {"0F())F", 'F'},
    {"0F())K", 'F'},
    {"0F())N", 'F'},
    {"0F())O", 'F'},
    {"0F())S", 'F'},
    {"0F())U", 'F'},
    {"0F())V", 'F'},
    {"0F(),(", 'F'},
    {"0F(),1", 'F'},
    {"0F(),F", 'F'},
    {"0F(),N", 'F'},
    {"0F(),S", 'F'},
    {"0F(),V", 'F'},
    {"0F()1(", 'F'},
    {"0F()1F", 'F'},
    {"0F()1N", 'F'},
    {"0F()1O", 'F'},
    {"0F()1S", 'F'},
    {"0F()1U", 'F'},
    {"0F()1V", 'F'},
    {"0F();E", 'F'},
    {"0F();N", 'F'},
    {"0F();T", 'F'},
    {"0F()A(", 'F'},
    {"0F()AF", 'F'},
    {"0F()AS", 'F'},
    {"0F()AT", 'F'},
    {"0F()AV", 'F'},
    {"0F()B(", 'F'},
    {"0F()B1", 'F'},
    {"0F()BE", 'F'},
    {"0F()BF", 'F'},
    {"0F()BN", 'F'},
    {"0F()BS", 'F'},
    {"0F()BV", 'F'},
    {"0F()C", 'F'},
    {"0F()E(", 'F'},
    {"0F()E1", 'F'},
    {"0F()EF", 'F'},
    {"0F()EK", 'F'},
    {"0F()EN", 'F'},
    {"0F()EO", 'F'},
    {"0F()ES", 'F'},
    {"0F()EU", 'F'},
    {"0F()EV", 'F'},
    {"0F()F(", 'F'},
    {"0F()K(", 'F'},
    {"0F()K)", 'F'},
    {"0F()K1", 'F'},
    {"0F()KF", 'F'},
    {"0F()KN", 'F'},
    {"0F()KS", 'F'},
    {"0F()KU", 'F'},
    {"0F()KV", 'F'},
    {"0F()N&", 'F'},
    {"0F()N(", 'F'},
    {"0F()N)", 'F'},
    {"0F()N,", 'F'},
    {"0F()N1", 'F'},
    {"0F()NE", 'F'},
    {"0F()NF", 'F'},
    {"0F()NO", 'F'},
    {"0F()NU", 'F'},
    {"0F()O(", 'F'},
    {"0F()O1", 'F'},
    {"0F()OF", 'F'},
    {"0F()OK", 'F'},
    {"0F()ON", 'F'},
    {"0F()OS", 'F'},
    {"0F()OT", 'F'},
    {"0F()OU", 'F'},
    {"0F()OV", 'F'},
    {"0F()S(", 'F'},
    {"0F()S1", 'F'},
    {"0F()SF", 'F'},
    {"0F()SO", 'F'},
    {"0F()SU", 'F'},
    {"0F()SV", 'F'},
    {"0F()U", 'F'},
    {"0F()U(", 'F'},
    {"0F()U1", 'F'},
    {"0F()U;", 'F'},
    {"0F()UC", 'F'},
    {"0F()UE", 'F'},
    {"0F()UF", 'F'},
    {"0F()UK", 'F'},
    {"0F()UN", 'F'},
    {"0F()UO", 'F'},
    {"0F()US", 'F'},
    {"0F()UT", 'F'},
    {"0F()UV", 'F'},
    {"0F()V(", 'F'},
    {"0F()VF", 'F'},
    {"0F()VO", 'F'},
    {"0F()VS", 'F'},
    {"0F()VU", 'F'},
    {"0F(1)", 'F'},
    {"0F(1)&", 'F'},
    {"0F(1))", 'F'},
    {"0F(1),", 'F'},
    {"0F(1)1", 'F'},
    {"0F(1);", 'F'},
    {"0F(1)A", 'F'},
    {"0F(1)B", 'F'},
    {"0F(1)C", 'F'},
    {"0F(1)E", 'F'},
    {"0F(1)F", 'F'},
    {"0F(1)K", 'F'},
    {"0F(1)N", 'F'},
    {"0F(1)O", 'F'},
    {"0F(1)S", 'F'},
    {"0F(1)U", 'F'},
    {"0F(1)V", 'F'},
    {"0F(1,(", 'F'},
    {"0F(1,F", 'F'},
    {"0F(1,V", 'F'},
    {"0F(1O(", 'F'},
    {"0F(1OF", 'F'},
    {"0F(1OS", 'F'},
    {"0F(1OV", 'F'},
    {"0F(E((", 'F'},
    {"0F(E(1", 'F'},
    {"0F(E(F", 'F'},
    {"0F(E(N", 'F'},
    {"0F(E(S", 'F'},
    {"0F(E(V", 'F'},
    {"0F(E1O", 'F'},
    {"0F(EF(", 'F'},
    {"0F(EK(", 'F'},
    {"0F(EK1", 'F'},
    {"0F(EKF", 'F'},
    {"0F(EKN", 'F'},
    {"0F(EKS", 'F'},
    {"0F(EKV", 'F'},
    {"0F(ENO", 'F'},
    {"0F(ESO", 'F'},
    {"0F(EVO", 'F'},
    {"0F(F((", 'F'},
    {"0F(F()", 'F'},
    {"0F(F(1", 'F'},
    {"0F(F(F", 'F'},
    {"0F(F(N", 'F'},
    {"0F(F(S", 'F'},
    {"0F(F(V", 'F'},
    {"0F(K((", 'F'},
    {"0F(K()", 'F'},
    {"0F(K,(", 'F'},
    {"0F(K,F", 'F'},
    {"0F(N)", 'F'},
    {"0F(N)&", 'F'},
    {"0F(N))", 'F'},
    {"0F(N),", 'F'},
    {"0F(N)1", 'F'},
    {"0F(N);", 'F'},
    {"0F(N)A", 'F'},
    {"0F(N)B", 'F'},
    {"0F(N)C", 'F'},
    {"0F(N)E", 'F'},
    {"0F(N)F", 'F'},
    {"0F(N)K", 'F'},
    {"0F(N)N", 'F'},
    {"0F(N)O", 'F'},
    {"0F(N)S", 'F'},
    {"0F(N)U", 'F'},
    {"0F(N)V", 'F'},
    {"0F(N,(", 'F'},
    {"0F(N,F", 'F'},
    {"0F(N,V", 'F'},
    {"0F(NO(", 'F'},
    {"0F(NOF", 'F'},
    {"0F(NOS", 'F'},
    {"0F(NOV", 'F'},
    {"0F(S)", 'F'},
    {"0F(S)&", 'F'},
    {"0F(S))", 'F'},
    {"0F(S),", 'F'},
    {"0F(S)1", 'F'},
    {"0F(S);", 'F'},
    {"0F(S)A", 'F'},
    {"0F(S)B", 'F'},
    {"0F(S)C", 'F'},
    {"0F(S)E", 'F'},
    {"0F(S)F", 'F'},
    {"0F(S)K", 'F'},
    {"0F(S)N", 'F'},
    {"0F(S)O", 'F'},
    {"0F(S)S", 'F'},
    {"0F(S)U", 'F'},
    {"0F(S)V", 'F'},
    {"0F(S,(", 'F'},
    {"0F(S,F", 'F'},
    {"0F(S,V", 'F'},
    {"0F(SO(", 'F'},
    {"0F(SO1", 'F'},
    {"0F(SOF", 'F'},
    {"0F(SON", 'F'},
    {"0F(SOS", 'F'},
    {"0F(SOV", 'F'},
    {"0F(T))", 'F'},
    {"0F(T),", 'F'},
    {"0F(T,(", 'F'},
    {"0F(T,1", 'F'},
    {"0F(T,F", 'F'},
    {"0F(T,N", 'F'},
    {"0F(T,S", 'F'},
    {"0F(T,V", 'F'},
    {"0F(V)", 'F'},
    {"0F(V)&", 'F'},
    {"0F(V))", 'F'},
    {"0F(V),", 'F'},
    {"0F(V)1", 'F'},
    {"0F(V);", 'F'},
    {"0F(V)A", 'F'},
    {"0F(V)B", 'F'},
    {"0F(V)C", 'F'},
    {"0F(V)E", 'F'},
    {"0F(V)F", 'F'},
    {"0F(V)K", 'F'},
    {"0F(V)N", 'F'},
    {"0F(V)O", 'F'},
    {"0F(V)S", 'F'},
    {"0F(V)U", 'F'},
    {"0F(V)V", 'F'},
    {"0F(V,(", 'F'},
    {"0F(V,1", 'F'},
    {"0F(V,F", 'F'},
    {"0F(V,N", 'F'},
    {"0F(V,S", 'F'},
    {"0F(V,V", 'F'},
    {"0F(VO(", 'F'},
    {"0F(VOF", 'F'},
    {"0F(VOS", 'F'},
    {"0K((((", 'F'},
    {"0K(((1", 'F'},
    {"0K(((F", 'F'},
    {"0K(((N", 'F'},
    {"0K(((S", 'F'},
    {"0K(((V", 'F'},
    {"0K((1)", 'F'},
    {"0K((1O", 'F'},
    {"0K((F(", 'F'},
    {"0K((N)", 'F'},
    {"0K((NO", 'F'},
    {"0K((S)", 'F'},
    {"0K((SO", 'F'},
    {"0K((V)", 'F'},
    {"0K((VO", 'F'},
    {"0K(1))", 'F'},
    {"0K(1),", 'F'},
    {"0K(1)A", 'F'},
    {"0K(1)K", 'F'},
    {"0K(1)O", 'F'},
    {"0K(1O(", 'F'},
    {"0K(1OF", 'F'},
    {"0K(1OS", 'F'},
    {"0K(1OV", 'F'},
    {"0K(F((", 'F'},
    {"0K(F()", 'F'},
    {"0K(F(1", 'F'},
    {"0K(F(F", 'F'},
    {"0K(F(N", 'F'},
    {"0K(F(S", 'F'},
    {"0K(F(V", 'F'},
    {"0K(N))", 'F'},
    {"0K(N),", 'F'},
    {"0K(N)A", 'F'},
    {"0K(N)K", 'F'},
    {"0K(N)O", 'F'},
    {"0K(NO(", 'F'},
    {"0K(NOF", 'F'},
    {"0K(NOS", 'F'},
    {"0K(NOV", 'F'},
    {"0K(S))", 'F'},
    {"0K(S),", 'F'},
    {"0K(S)A", 'F'},
    {"0K(S)K", 'F'},
    {"0K(S)O", 'F'},
    {"0K(SO(", 'F'},
    {"0K(SO1", 'F'},
    {"0K(SOF", 'F'},
    {"0K(SON", 'F'},
    {"0K(SOS", 'F'},
    {"0K(SOV", 'F'},
    {"0K(V))", 'F'},
    {"0K(V),", 'F'},
    {"0K(V)A", 'F'},
    {"0K(V)K", 'F'},
    {"0K(V)O", 'F'},
    {"0K(VO(", 'F'},
    {"0K(VOF", 'F'},
    {"0K(VOS", 'F'},
    {"0K1,((", 'F'},
    {"0K1,(1", 'F'},
    {"0K1,(F", 'F'},
    {"0K1,(N", 'F'},
    {"0K1,(S", 'F'},
    {"0K1,(V", 'F'},
    {"0K1,F(", 'F'},
    {"0K1,VC", 'F'},
    {"0K1,VO", 'F'},
    {"0K1A((", 'F'},
    {"0K1A(F", 'F'},
    {"0K1A(N", 'F'},
    {"0K1A(S", 'F'},
    {"0K1A(V", 'F'},
    {"0K1AF(", 'F'},
    {"0K1ASO", 'F'},
    {"0K1ATO", 'F'},
    {"0K1AVO", 'F'},
    {"0K1K((", 'F'},
    {"0K1K(1", 'F'},
    {"0K1K(F", 'F'},
    {"0K1K(N", 'F'},
    {"0K1K(S", 'F'},
    {"0K1K(V", 'F'},
    {"0K1K1O", 'F'},
    {"0K1K1U", 'F'},
    {"0K1KF(", 'F'},
    {"0K1KNU", 'F'},
    {"0K1KSO", 'F'},
    {"0K1KSU", 'F'},
    {"0K1KVO", 'F'},
    {"0K1KVU", 'F'},
    {"0K1O((", 'F'},
    {"0K1O(1", 'F'},
    {"0K1O(F", 'F'},
    {"0K1O(N", 'F'},
    {"0K1O(S", 'F'},
    {"0K1O(V", 'F'},
    {"0K1OF(", 'F'},
    {"0K1OS(", 'F'},
    {"0K1OS,", 'F'},
    {"0K1OS1", 'F'},
    {"0K1OSA", 'F'},
    {"0K1OSF", 'F'},
    {"0K1OSK", 'F'},
    {"0K1OSO", 'F'},
    {"0K1OSV", 'F'},
    {"0K1OV(", 'F'},
    {"0K1OV,", 'F'},
    {"0K1OVA", 'F'},
    {"0K1OVF", 'F'},
    {"0K1OVK", 'F'},
    {"0K1OVO", 'F'},
    {"0K1OVS", 'F'},
    {"0KF(((", 'F'},
    {"0KF(()", 'F'},
    {"0KF((1", 'F'},
    {"0KF((F", 'F'},
    {"0KF((N", 'F'},
    {"0KF((S", 'F'},
    {"0KF((V", 'F'},
    {"0KF())", 'F'},
    {"0KF(),", 'F'},
    {"0KF()A", 'F'},
    {"0KF()K", 'F'},
    {"0KF()O", 'F'},
    {"0KF(1)", 'F'},
    {"0KF(1O", 'F'},
    {"0KF(F(", 'F'},
    {"0KF(N)", 'F'},
    {"0KF(NO", 'F'},
    {"0KF(S)", 'F'},
    {"0KF(SO", 'F'},
    {"0KF(V)", 'F'},
    {"0KF(VO", 'F'},
    {"0KN,((", 'F'},
    {"0KN,(1", 'F'},
    {"0KN,(F", 'F'},
    {"0KN,(N", 'F'},
    {"0KN,(S", 'F'},
    {"0KN,(V", 'F'},
    {"0KN,F(", 'F'},
    {"0KN,VC", 'F'},
    {"0KN,VO", 'F'},
    {"0KNA((", 'F'},
    {"0KNA(F", 'F'},
    {"0KNA(N", 'F'},
    {"0KNA(S", 'F'},
    {"0KNA(V", 'F'},
    {"0KNAF(", 'F'},
    {"0KNASO", 'F'},
    {"0KNATO", 'F'},
    {"0KNAVO", 'F'},
    {"0KNK((", 'F'},
    {"0KNK(1", 'F'},
    {"0KNK(F", 'F'},
    {"0KNK(N", 'F'},
    {"0KNK(S", 'F'},
    {"0KNK(V", 'F'},
    {"0KNK1O", 'F'},
    {"0KNK1U", 'F'},
    {"0KNKF(", 'F'},
    {"0KNKNU", 'F'},
    {"0KNKSO", 'F'},
    {"0KNKSU", 'F'},
    {"0KNKVO", 'F'},
    {"0KNKVU", 'F'},
    {"0KS,((", 'F'},
    {"0KS,(1", 'F'},
    {"0KS,(F", 'F'},
    {"0KS,(N", 'F'},
    {"0KS,(S", 'F'},
    {"0KS,(V", 'F'},
    {"0KS,F(", 'F'},
    {"0KS,VC", 'F'},
    {"0KS,VO", 'F'},
    {"0KSA((", 'F'},
    {"0KSA(F", 'F'},
    {"0KSA(N", 'F'},
    {"0KSA(S", 'F'},
    {"0KSA(V", 'F'},
    {"0KSAF(", 'F'},
    {"0KSASO", 'F'},
    {"0KSATO", 'F'},
    {"0KSAVO", 'F'},
    {"0KSK((", 'F'},
    {"0KSK(1", 'F'},
    {"0KSK(F", 'F'},
    {"0KSK(N", 'F'},
    {"0KSK(S", 'F'},
    {"0KSK(V", 'F'},
    {"0KSK1O", 'F'},
    {"0KSK1U", 'F'},
    {"0KSKF(", 'F'},
    {"0KSKNU", 'F'},
    {"0KSKSO", 'F'},
    {"0KSKSU", 'F'},
    {"0KSKVO", 'F'},
    {"0KSKVU", 'F'},
    {"0KSO((", 'F'},
    {"0KSO(1", 'F'},
    {"0KSO(F", 'F'},
    {"0KSO(N", 'F'},
    {"0KSO(S", 'F'},
    {"0KSO(V", 'F'},
    {"0KSO1(", 'F'},
    {"0KSO1,", 'F'},
    {"0KSO1A", 'F'},
    {"0KSO1F", 'F'},
    {"0KSO1K", 'F'},
    {"0KSO1N", 'F'},
    {"0KSO1O", 'F'},
    {"0KSO1S", 'F'},
    {"0KSO1V", 'F'},
    {"0KSOF(", 'F'},
    {"0KSON(", 'F'},
    {"0KSON,", 'F'},
    {"0KSON1", 'F'},
    {"0KSONA", 'F'},
    {"0KSONF", 'F'},
    {"0KSONK", 'F'},
    {"0KSONO", 'F'},
    {"0KSOS(", 'F'},
    {"0KSOS,", 'F'},
    {"0KSOS1", 'F'},
    {"0KSOSA", 'F'},
    {"0KSOSF", 'F'},
    {"0KSOSK", 'F'},
    {"0KSOSO", 'F'},
    {"0KSOSV", 'F'},
    {"0KSOV(", 'F'},
    {"0KSOV,", 'F'},
    {"0KSOVA", 'F'},
    {"0KSOVF", 'F'},
    {"0KSOVK", 'F'},
    {"0KSOVO", 'F'},
    {"0KSOVS", 'F'},
    {"0KV,((", 'F'},
    {"0KV,(1", 'F'},
    {"0KV,(F", 'F'},
    {"0KV,(N", 'F'},
    {"0KV,(S", 'F'},
    {"0KV,(V", 'F'},
    {"0KV,1C", 'F'},
    {"0KV,1O", 'F'},
    {"0KV,F(", 'F'},
    {"0KV,NC", 'F'},
    {"0KV,NO", 'F'},
    {"0KV,SC", 'F'},
    {"0KV,SO", 'F'},
    {"0KV,VC", 'F'},
    {"0KV,VO", 'F'},
    {"0KVA((", 'F'},
    {"0KVA(F", 'F'},
    {"0KVA(N", 'F'},
    {"0KVA(S", 'F'},
    {"0KVA(V", 'F'},
    {"0KVAF(", 'F'},
    {"0KVASO", 'F'},
    {"0KVATO", 'F'},
    {"0KVAVO", 'F'},
    {"0KVK((", 'F'},
    {"0KVK(1", 'F'},
    {"0KVK(F", 'F'},
    {"0KVK(N", 'F'},
    {"0KVK(S", 'F'},
    {"0KVK(V", 'F'},
    {"0KVK1O", 'F'},
    {"0KVK1U", 'F'},
    {"0KVKF(", 'F'},
    {"0KVKNU", 'F'},
    {"0KVKSO", 'F'},
    {"0KVKSU", 'F'},
    {"0KVKVO", 'F'},
    {"0KVKVU", 'F'},
    {"0KVO((", 'F'},
    {"0KVO(1", 'F'},
    {"0KVO(F", 'F'},
    {"0KVO(N", 'F'},
    {"0KVO(S", 'F'},
    {"0KVO(V", 'F'},
    {"0KVOF(", 'F'},
    {"0KVOS(", 'F'},
    {"0KVOS,", 'F'},
    {"0KVOS1", 'F'},
    {"0KVOSA", 'F'},
    {"0KVOSF", 'F'},
    {"0KVOSK", 'F'},
    {"0KVOSO", 'F'},
    {"0KVOSV", 'F'},
    {"0N&(((", 'F'},
    {"0N&((1", 'F'},
    {"0N&((E", 'F'},
    {"0N&((F", 'F'},
    {"0N&((N", 'F'},
    {"0N&((O", 'F'},
    {"0N&((S", 'F'},
    {"0N&((V", 'F'},
    {"0N&(1&", 'F'},
    {"0N&(1)", 'F'},
    {"0N&(1,", 'F'},
    {"0N&(1O", 'F'},
    {"0N&(E(", 'F'},
    {"0N&(E1", 'F'},
    {"0N&(EF", 'F'},
    {"0N&(EK", 'F'},
    {"0N&(EN", 'F'},
    {"0N&(EO", 'F'},
    {"0N&(ES", 'F'},
    {"0N&(EV", 'F'},
    {"0N&(F(", 'F'},
    {"0N&(N&", 'F'},
    {"0N&(N)", 'F'},
    {"0N&(N,", 'F'},
    {"0N&(NO", 'F'},
    {"0N&(O(", 'F'},
    {"0N&(O1", 'F'},
    {"0N&(OF", 'F'},
    {"0N&(ON", 'F'},
    {"0N&(OS", 'F'},
    {"0N&(OV", 'F'},
    {"0N&(S&", 'F'},
    {"0N&(S)", 'F'},
    {"0N&(S,", 'F'},
    {"0N&(SO", 'F'},
    {"0N&(V&", 'F'},
    {"0N&(V)", 'F'},
    {"0N&(V,", 'F'},
    {"0N&(VO", 'F'},
    {"0N&1", 'F'},
    {"0N&1&(", 'F'},
    {"0N&1&1", 'F'},
    {"0N&1&F", 'F'},
    {"0N&1&N", 'F'},
    {"0N&1&S", 'F'},
    {"0N&1&V", 'F'},
    {"0N&1)&", 'F'},
    {"0N&1))", 'F'},
    {"0N&1)U", 'F'},
    {"0N&1;", 'F'},
    {"0N&1;C", 'F'},
    {"0N&1;E", 'F'},
    {"0N&1;T", 'F'},
    {"0N&1B(", 'F'},
    {"0N&1B1", 'F'},
    {"0N&1BF", 'F'},
    {"0N&1BN", 'F'},
    {"0N&1BS", 'F'},
    {"0N&1BV", 'F'},
    {"0N&1C", 'F'},
    {"0N&1EK", 'F'},
    {"0N&1EN", 'F'},
    {"0N&1F(", 'F'},
    {"0N&1K(", 'F'},
    {"0N&1K1", 'F'},
    {"0N&1KF", 'F'},
    {"0N&1KN", 'F'},
    {"0N&1KS", 'F'},
    {"0N&1KV", 'F'},
    {"0N&1O(", 'F'},
    {"0N&1OF", 'F'},
    {"0N&1OO", 'F'},
    {"0N&1OS", 'F'},
    {"0N&1OV", 'F'},
    {"0N&1TN", 'F'},
    {"0N&1U", 'F'},
    {"0N&1U(", 'F'},
    {"0N&1U;", 'F'},
    {"0N&1UC", 'F'},
    {"0N&1UE", 'F'},
    {"0N&E((", 'F'},
    {"0N&E(1", 'F'},
    {"0N&E(F", 'F'},
    {"0N&E(N", 'F'},
    {"0N&E(O", 'F'},
    {"0N&E(S", 'F'},
    {"0N&E(V", 'F'},
    {"0N&E1", 'F'},
    {"0N&E1;", 'F'},
    {"0N&E1C", 'F'},
    {"0N&E1K", 'F'},
    {"0N&E1O", 'F'},
    {"0N&EF(", 'F'},
    {"0N&EK(", 'F'},
    {"0N&EK1", 'F'},
    {"0N&EKF", 'F'},
    {"0N&EKN", 'F'},
    {"0N&EKS", 'F'},
    {"0N&EKV", 'F'},
    {"0N&EN;", 'F'},
    {"0N&ENC", 'F'},
    {"0N&ENK", 'F'},
    {"0N&ENO", 'F'},
    {"0N&ES", 'F'},
    {"0N&ES;", 'F'},
    {"0N&ESC", 'F'},
    {"0N&ESK", 'F'},
    {"0N&ESO", 'F'},
    {"0N&EV", 'F'},
    {"0N&EV;", 'F'},
    {"0N&EVC", 'F'},
    {"0N&EVK", 'F'},
    {"0N&EVO", 'F'},
    {"0N&F((", 'F'},
    {"0N&F()", 'F'},
    {"0N&F(1", 'F'},
    {"0N&F(F", 'F'},
    {"0N&F(N", 'F'},
    {"0N&F(S", 'F'},
    {"0N&F(V", 'F'},
    {"0N&K&(", 'F'},
    {"0N&K&1", 'F'},
    {"0N&K&F", 'F'},
    {"0N&K&N", 'F'},
    {"0N&K&S", 'F'},
    {"0N&K&V", 'F'},
    {"0N&K((", 'F'},
    {"0N&K(1", 'F'},
    {"0N&K(F", 'F'},
    {"0N&K(N", 'F'},
    {"0N&K(S", 'F'},
    {"0N&K(V", 'F'},
    {"0N&K1O", 'F'},
    {"0N&KF(", 'F'},
    {"0N&KNK", 'F'},
    {"0N&KO(", 'F'},
    {"0N&KO1", 'F'},
    {"0N&KOF", 'F'},
    {"0N&KOK", 'F'},
    {"0N&KON", 'F'},
    {"0N&KOS", 'F'},
    {"0N&KOV", 'F'},
    {"0N&KSO", 'F'},
    {"0N&KVO", 'F'},
    {"0N&N&(", 'F'},
    {"0N&N&1", 'F'},
    {"0N&N&F", 'F'},
    {"0N&N&S", 'F'},
    {"0N&N&V", 'F'},
    {"0N&N)&", 'F'},
    {"0N&N))", 'F'},
    {"0N&N)U", 'F'},
    {"0N&N;C", 'F'},
    {"0N&N;E", 'F'},
    {"0N&N;T", 'F'},
    {"0N&NB(", 'F'},
    {"0N&NB1", 'F'},
    {"0N&NBF", 'F'},
    {"0N&NBN", 'F'},
    {"0N&NBS", 'F'},
    {"0N&NBV", 'F'},
    {"0N&NF(", 'F'},
    {"0N&NK(", 'F'},
    {"0N&NK1", 'F'},
    {"0N&NKF", 'F'},
    {"0N&NKS", 'F'},
    {"0N&NKV", 'F'},
    {"0N&NO(", 'F'},
    {"0N&NOF", 'F'},
    {"0N&NOS", 'F'},
    {"0N&NOV", 'F'},
    {"0N&NU", 'F'},
    {"0N&NU(", 'F'},
    {"0N&NU;", 'F'},
    {"0N&NUC", 'F'},
    {"0N&NUE", 'F'},
    {"0N&S&(", 'F'},
    {"0N&S&1", 'F'},
    {"0N&S&F", 'F'},
    {"0N&S&N", 'F'},
    {"0N&S&S", 'F'},
    {"0N&S&V", 'F'},
    {"0N&S)&", 'F'},
    {"0N&S))", 'F'},
    {"0N&S)U", 'F'},
    {"0N&S1", 'F'},
    {"0N&S1;", 'F'},
    {"0N&S1C", 'F'},
    {"0N&S1O", 'F'},
    {"0N&S;", 'F'},
    {"0N&S;C", 'F'},
    {"0N&S;E", 'F'},
    {"0N&S;T", 'F'},
    {"0N&SB(", 'F'},
    {"0N&SB1", 'F'},
    {"0N&SBF", 'F'},
    {"0N&SBN", 'F'},
    {"0N&SBS", 'F'},
    {"0N&SBV", 'F'},
    {"0N&SC", 'F'},
    {"0N&SEK", 'F'},
    {"0N&SEN", 'F'},
    {"0N&SF(", 'F'},
    {"0N&SK(", 'F'},
    {"0N&SK1", 'F'},
    {"0N&SKF", 'F'},
    {"0N&SKN", 'F'},
    {"0N&SKS", 'F'},
    {"0N&SKV", 'F'},
    {"0N&SO(", 'F'},
    {"0N&SO1", 'F'},
    {"0N&SOF", 'F'},
    {"0N&SON", 'F'},
    {"0N&SOO", 'F'},
    {"0N&SOS", 'F'},
    {"0N&SOV", 'F'},
    {"0N&STN", 'F'},
    {"0N&SU", 'F'},
    {"0N&SU(", 'F'},
    {"0N&SU;", 'F'},
    {"0N&SUC", 'F'},
    {"0N&SUE", 'F'},
    {"0N&SV", 'F'},
    {"0N&SV;", 'F'},
    {"0N&SVC", 'F'},
    {"0N&SVO", 'F'},
    {"0N&V", 'F'},
    {"0N&V&(", 'F'},
    {"0N&V&1", 'F'},
    {"0N&V&F", 'F'},
    {"0N&V&N", 'F'},
    {"0N&V&S", 'F'},
    {"0N&V&V", 'F'},
    {"0N&V)&", 'F'},
    {"0N&V))", 'F'},
    {"0N&V)U", 'F'},
    {"0N&V;", 'F'},
    {"0N&V;C", 'F'},
    {"0N&V;E", 'F'},
    {"0N&V;T", 'F'},
    {"0N&VB(", 'F'},
    {"0N&VB1", 'F'},
    {"0N&VBF", 'F'},
    {"0N&VBN", 'F'},
    {"0N&VBS", 'F'},
    {"0N&VBV", 'F'},
    {"0N&VC", 'F'},
    {"0N&VEK", 'F'},
    {"0N&VEN", 'F'},
    {"0N&VF(", 'F'},
    {"0N&VK(", 'F'},
    {"0N&VK1", 'F'},
    {"0N&VKF", 'F'},
    {"0N&VKN", 'F'},
    {"0N&VKS", 'F'},
    {"0N&VKV", 'F'},
    {"0N&VO(", 'F'},
    {"0N&VOF", 'F'},
    {"0N&VOO", 'F'},
    {"0N&VOS", 'F'},
    {"0N&VS", 'F'},
    {"0N&VS;", 'F'},
    {"0N&VSC", 'F'},
    {"0N&VSO", 'F'},
    {"0N&VTN", 'F'},
    {"0N&VU", 'F'},
    {"0N&VU(", 'F'},
    {"0N&VU;", 'F'},
    {"0N&VUC", 'F'},
    {"0N&VUE", 'F'},
    {"0N((((", 'F'},
    {"0N(((1", 'F'},
    {"0N(((E", 'F'},
    {"0N(((F", 'F'},
    {"0N(((N", 'F'},
    {"0N(((S", 'F'},
    {"0N(((U", 'F'},
    {"0N(((V", 'F'},
    {"0N((1)", 'F'},
    {"0N((1O", 'F'},
    {"0N((EK", 'F'},
    {"0N((EN", 'F'},
    {"0N((F(", 'F'},
    {"0N((N)", 'F'},
    {"0N((NO", 'F'},
    {"0N((S)", 'F'},
    {"0N((SO", 'F'},
    {"0N((U(", 'F'},
    {"0N((V)", 'F'},
    {"0N((VO", 'F'},
    {"0N(1))", 'F'},
    {"0N(1)F", 'F'},
    {"0N(1)O", 'F'},
    {"0N(1)U", 'F'},
    {"0N(1)V", 'F'},
    {"0N(1O(", 'F'},
    {"0N(1OF", 'F'},
    {"0N(1OS", 'F'},
    {"0N(1OV", 'F'},
    {"0N(EKN", 'F'},
    {"0N(ENK", 'F'},
    {"0N(F((", 'F'},
    {"0N(F()", 'F'},
    {"0N(F(1", 'F'},
    {"0N(F(F", 'F'},
    {"0N(F(N", 'F'},
    {"0N(F(S", 'F'},
    {"0N(F(V", 'F'},
    {"0N(S))", 'F'},
    {"0N(S)1", 'F'},
    {"0N(S)F", 'F'},
    {"0N(S)N", 'F'},
    {"0N(S)O", 'F'},
    {"0N(S)S", 'F'},
    {"0N(S)U", 'F'},
    {"0N(S)V", 'F'},
    {"0N(SO(", 'F'},
    {"0N(SO1", 'F'},
    {"0N(SOF", 'F'},
    {"0N(SON", 'F'},
    {"0N(SOS", 'F'},
    {"0N(SOV", 'F'},
    {"0N(U((", 'F'},
    {"0N(U(E", 'F'},
    {"0N(V))", 'F'},
    {"0N(V)1", 'F'},
    {"0N(V)F", 'F'},
    {"0N(V)N", 'F'},
    {"0N(V)O", 'F'},
    {"0N(V)S", 'F'},
    {"0N(V)U", 'F'},
    {"0N(V)V", 'F'},
    {"0N(VO(", 'F'},
    {"0N(VOF", 'F'},
    {"0N(VOS", 'F'},
    {"0N)&((", 'F'},
    {"0N)&(1", 'F'},
    {"0N)&(E", 'F'},
    {"0N)&(F", 'F'},
    {"0N)&(N", 'F'},
    {"0N)&(S", 'F'},
    {"0N)&(V", 'F'},
    {"0N)&1", 'F'},
    {"0N)&1&", 'F'},
    {"0N)&1)", 'F'},
    {"0N)&1;", 'F'},
    {"0N)&1B", 'F'},
    {"0N)&1C", 'F'},
    {"0N)&1F", 'F'},
    {"0N)&1O", 'F'},
    {"0N)&1U", 'F'},
    {"0N)&F(", 'F'},
    {"0N)&N", 'F'},
    {"0N)&N&", 'F'},
    {"0N)&N)", 'F'},
    {"0N)&N;", 'F'},
    {"0N)&NB", 'F'},
    {"0N)&NC", 'F'},
    {"0N)&NF", 'F'},
    {"0N)&NO", 'F'},
    {"0N)&NU", 'F'},
    {"0N)&S", 'F'},
    {"0N)&S&", 'F'},
    {"0N)&S)", 'F'},
    {"0N)&S;", 'F'},
    {"0N)&SB", 'F'},
    {"0N)&SC", 'F'},
    {"0N)&SF", 'F'},
    {"0N)&SO", 'F'},
    {"0N)&SU", 'F'},
    {"0N)&V", 'F'},
    {"0N)&V&", 'F'},
    {"0N)&V)", 'F'},
    {"0N)&V;", 'F'},
    {"0N)&VB", 'F'},
    {"0N)&VC", 'F'},
    {"0N)&VF", 'F'},
    {"0N)&VO", 'F'},
    {"0N)&VU", 'F'},
    {"0N))&(", 'F'},
    {"0N))&1", 'F'},
    {"0N))&F", 'F'},
    {"0N))&N", 'F'},
    {"0N))&S", 'F'},
    {"0N))&V", 'F'},
    {"0N)))&", 'F'},
    {"0N))))", 'F'},
    {"0N))),", 'F'},
    {"0N)));", 'F'},
    {"0N)))B", 'F'},
    {"0N)))E", 'F'},
    {"0N)))K", 'F'},
    {"0N)))O", 'F'},
    {"0N)))U", 'F'},
    {"0N)),(", 'F'},
    {"0N));E", 'F'},
    {"0N));T", 'F'},
    {"0N))B(", 'F'},
    {"0N))B1", 'F'},
    {"0N))BF", 'F'},
    {"0N))BN", 'F'},
    {"0N))BS", 'F'},
    {"0N))BV", 'F'},
    {"0N))E(", 'F'},
    {"0N))E1", 'F'},
    {"0N))EF", 'F'},
    {"0N))EK", 'F'},
    {"0N))EN", 'F'},
    {"0N))ES", 'F'},
    {"0N))EV", 'F'},
    {"0N))K(", 'F'},
    {"0N))K1", 'F'},
    {"0N))KB", 'F'},
    {"0N))KF", 'F'},
    {"0N))KN", 'F'},
    {"0N))KS", 'F'},
    {"0N))KU", 'F'},
    {"0N))KV", 'F'},
    {"0N))O(", 'F'},
    {"0N))O1", 'F'},
    {"0N))OF", 'F'},
    {"0N))ON", 'F'},
    {"0N))OS", 'F'},
    {"0N))OV", 'F'},
    {"0N))U(", 'F'},
    {"0N))UE", 'F'},
    {"0N),((", 'F'},
    {"0N),(1", 'F'},
    {"0N),(F", 'F'},
    {"0N),(N", 'F'},
    {"0N),(S", 'F'},
    {"0N),(V", 'F'},
    {"0N);E(", 'F'},
    {"0N);E1", 'F'},
    {"0N);EF", 'F'},
    {"0N);EK", 'F'},
    {"0N);EN", 'F'},
    {"0N);EO", 'F'},
    {"0N);ES", 'F'},
    {"0N);EV", 'F'},
    {"0N);T(", 'F'},
    {"0N);T1", 'F'},
    {"0N);TF", 'F'},
    {"0N);TK", 'F'},
    {"0N);TN", 'F'},
    {"0N);TO", 'F'},
    {"0N);TS", 'F'},
    {"0N);TV", 'F'},
    {"0N)B((", 'F'},
    {"0N)B(1", 'F'},
    {"0N)B(F", 'F'},
    {"0N)B(N", 'F'},
    {"0N)B(S", 'F'},
    {"0N)B(V", 'F'},
    {"0N)B1", 'F'},
    {"0N)B1&", 'F'},
    {"0N)B1;", 'F'},
    {"0N)B1C", 'F'},
    {"0N)B1K", 'F'},
    {"0N)B1N", 'F'},
    {"0N)B1O", 'F'},
    {"0N)B1U", 'F'},
    {"0N)BF(", 'F'},
    {"0N)BN", 'F'},
    {"0N)BN&", 'F'},
    {"0N)BN;", 'F'},
    {"0N)BNC", 'F'},
    {"0N)BNK", 'F'},
    {"0N)BNO", 'F'},
    {"0N)BNU", 'F'},
    {"0N)BS", 'F'},
    {"0N)BS&", 'F'},
    {"0N)BS;", 'F'},
    {"0N)BSC", 'F'},
    {"0N)BSK", 'F'},
    {"0N)BSO", 'F'},
    {"0N)BSU", 'F'},
    {"0N)BV", 'F'},
    {"0N)BV&", 'F'},
    {"0N)BV;", 'F'},
    {"0N)BVC", 'F'},
    {"0N)BVK", 'F'},
    {"0N)BVO", 'F'},
    {"0N)BVU", 'F'},
    {"0N)E((", 'F'},
    {"0N)E(1", 'F'},
    {"0N)E(F", 'F'},
    {"0N)E(N", 'F'},
    {"0N)E(S", 'F'},
    {"0N)E(V", 'F'},
    {"0N)E1C", 'F'},
    {"0N)E1O", 'F'},
    {"0N)EF(", 'F'},
    {"0N)EK(", 'F'},
    {"0N)EK1", 'F'},
    {"0N)EKF", 'F'},
    {"0N)EKN", 'F'},
    {"0N)EKS", 'F'},
    {"0N)EKV", 'F'},
    {"0N)ENC", 'F'},
    {"0N)ENO", 'F'},
    {"0N)ESC", 'F'},
    {"0N)ESO", 'F'},
    {"0N)EVC", 'F'},
    {"0N)EVO", 'F'},
    {"0N)K((", 'F'},
    {"0N)K(1", 'F'},
    {"0N)K(F", 'F'},
    {"0N)K(N", 'F'},
    {"0N)K(S", 'F'},
    {"0N)K(V", 'F'},
    {"0N)K1&", 'F'},
    {"0N)K1;", 'F'},
    {"0N)K1B", 'F'},
    {"0N)K1E", 'F'},
    {"0N)K1O", 'F'},
    {"0N)K1U", 'F'},
    {"0N)KB(", 'F'},
    {"0N)KB1", 'F'},
    {"0N)KBF", 'F'},
    {"0N)KBN", 'F'},
    {"0N)KBS", 'F'},
    {"0N)KBV", 'F'},
    {"0N)KF(", 'F'},
    {"0N)KN&", 'F'},
    {"0N)KN;", 'F'},
    {"0N)KNB", 'F'},
    {"0N)KNE", 'F'},
    {"0N)KNK", 'F'},
    {"0N)KNU", 'F'},
    {"0N)KS&", 'F'},
    {"0N)KS;", 'F'},
    {"0N)KSB", 'F'},
    {"0N)KSE", 'F'},
    {"0N)KSO", 'F'},
    {"0N)KSU", 'F'},
    {"0N)KUE", 'F'},
    {"0N)KV&", 'F'},
    {"0N)KV;", 'F'},
    {"0N)KVB", 'F'},
    {"0N)KVE", 'F'},
    {"0N)KVO", 'F'},
    {"0N)KVU", 'F'},
    {"0N)O((", 'F'},
    {"0N)O(1", 'F'},
    {"0N)O(E", 'F'},
    {"0N)O(F", 'F'},
    {"0N)O(N", 'F'},
    {"0N)O(S", 'F'},
    {"0N)O(V", 'F'},
    {"0N)O1&", 'F'},
    {"0N)O1)", 'F'},
    {"0N)O1;", 'F'},
    {"0N)O1B", 'F'},
    {"0N)O1C", 'F'},
    {"0N)O1K", 'F'},
    {"0N)O1O", 'F'},
    {"0N)O1U", 'F'},
    {"0N)OF(", 'F'},
    {"0N)ON", 'F'},
    {"0N)ON&", 'F'},
    {"0N)ON)", 'F'},
    {"0N)ON;", 'F'},
    {"0N)ONB", 'F'},
    {"0N)ONC", 'F'},
    {"0N)ONK", 'F'},
    {"0N)ONO", 'F'},
    {"0N)ONU", 'F'},
    {"0N)OS", 'F'},
    {"0N)OS&", 'F'},
    {"0N)OS)", 'F'},
    {"0N)OS;", 'F'},
    {"0N)OSB", 'F'},
    {"0N)OSC", 'F'},
    {"0N)OSK", 'F'},
    {"0N)OSO", 'F'},
    {"0N)OSU", 'F'},
    {"0N)OV", 'F'},
    {"0N)OV&", 'F'},
    {"0N)OV)", 'F'},
    {"0N)OV;", 'F'},
    {"0N)OVB", 'F'},
    {"0N)OVC", 'F'},
    {"0N)OVK", 'F'},
    {"0N)OVO", 'F'},
    {"0N)OVU", 'F'},
    {"0N)U((", 'F'},
    {"0N)U(E", 'F'},
    {"0N)UE(", 'F'},
    {"0N)UE1", 'F'},
    {"0N)UEF", 'F'},
    {"0N)UEK", 'F'},
    {"0N)UEN", 'F'},
    {"0N)UES", 'F'},
    {"0N)UEV", 'F'},
    {"0N,(((", 'F'},
    {"0N,((1", 'F'},
    {"0N,((E", 'F'},
    {"0N,((F", 'F'},
    {"0N,((N", 'F'},
    {"0N,((S", 'F'},
    {"0N,((V", 'F'},
    {"0N,(1)", 'F'},
    {"0N,(1O", 'F'},
    {"0N,(E(", 'F'},
    {"0N,(E1", 'F'},
    {"0N,(EF", 'F'},
    {"0N,(EK", 'F'},
    {"0N,(EN", 'F'},
    {"0N,(ES", 'F'},
    {"0N,(EV", 'F'},
    {"0N,(F(", 'F'},
    {"0N,(NO", 'F'},
    {"0N,(S)", 'F'},
    {"0N,(SO", 'F'},
    {"0N,(V)", 'F'},
    {"0N,(VO", 'F'},
    {"0N,F((", 'F'},
    {"0N,F()", 'F'},
    {"0N,F(1", 'F'},
    {"0N,F(F", 'F'},
    {"0N,F(N", 'F'},
    {"0N,F(S", 'F'},
    {"0N,F(T", 'F'},
    {"0N,F(V", 'F'},
    {"0N,V))", 'F'},
    {"0N,V),", 'F'},
    {"0N,V)O", 'F'},
    {"0N,V,(", 'F'},
    {"0N,V,1", 'F'},
    {"0N,V,F", 'F'},
    {"0N,V,N", 'F'},
    {"0N,V,S", 'F'},
    {"0N,V,V", 'F'},
    {"0N,VB(", 'F'},
    {"0N,VB1", 'F'},
    {"0N,VBF", 'F'},
    {"0N,VBN", 'F'},
    {"0N,VBS", 'F'},
    {"0N,VBV", 'F'},
    {"0N,VO(", 'F'},
    {"0N,VOF", 'F'},
    {"0N,VOS", 'F'},
    {"0N,VUE", 'F'},
    {"0N1F((", 'F'},
    {"0N1F()", 'F'},
    {"0N1F(1", 'F'},
    {"0N1F(F", 'F'},
    {"0N1F(N", 'F'},
    {"0N1F(S", 'F'},
    {"0N1F(V", 'F'},
    {"0N1O((", 'F'},
    {"0N1O(1", 'F'},
    {"0N1O(F", 'F'},
    {"0N1O(N", 'F'},
    {"0N1O(S", 'F'},
    {"0N1O(V", 'F'},
    {"0N1OF(", 'F'},
    {"0N1OS(", 'F'},
    {"0N1OS1", 'F'},
    {"0N1OSF", 'F'},
    {"0N1OSO", 'F'},
    {"0N1OSU", 'F'},
    {"0N1OSV", 'F'},
    {"0N1OV(", 'F'},
    {"0N1OVF", 'F'},
    {"0N1OVO", 'F'},
    {"0N1OVS", 'F'},
    {"0N1OVU", 'F'},
    {"0N1S;", 'F'},
    {"0N1S;C", 'F'},
    {"0N1SC", 'F'},
    {"0N1UE", 'F'},
    {"0N1UE;", 'F'},
    {"0N1UEC", 'F'},
    {"0N1UEK", 'F'},
    {"0N1V;", 'F'},
    {"0N1V;C", 'F'},
    {"0N1VC", 'F'},
    {"0N1VO(", 'F'},
    {"0N1VOF", 'F'},
    {"0N1VOS", 'F'},
    {"0N;E((", 'F'},
    {"0N;E(1", 'F'},
    {"0N;E(E", 'F'},
    {"0N;E(F", 'F'},
    {"0N;E(N", 'F'},
    {"0N;E(S", 'F'},
    {"0N;E(V", 'F'},
    {"0N;E1,", 'F'},
    {"0N;E1;", 'F'},
    {"0N;E1C", 'F'},
    {"0N;E1O", 'F'},
    {"0N;E1T", 'F'},
    {"0N;EF(", 'F'},
    {"0N;EK(", 'F'},
    {"0N;EK1", 'F'},
    {"0N;EKF", 'F'},
    {"0N;EKN", 'F'},
    {"0N;EKO", 'F'},
    {"0N;EKS", 'F'},
    {"0N;EKV", 'F'},
    {"0N;EN,", 'F'},
    {"0N;EN;", 'F'},
    {"0N;ENC", 'F'},
    {"0N;ENK", 'F'},
    {"0N;ENO", 'F'},
    {"0N;ENT", 'F'},
    {"0N;EO(", 'F'},
    {"0N;ES,", 'F'},
    {"0N;ES;", 'F'},
    {"0N;ESC", 'F'},
    {"0N;ESO", 'F'},
    {"0N;EST", 'F'},
    {"0N;EV,", 'F'},
    {"0N;EV;", 'F'},
    {"0N;EVC", 'F'},
    {"0N;EVO", 'F'},
    {"0N;EVT", 'F'},
    {"0N;N:T", 'F'},
    {"0N;T((", 'F'},
    {"0N;T(1", 'F'},
    {"0N;T(E", 'F'},
    {"0N;T(F", 'F'},
    {"0N;T(N", 'F'},
    {"0N;T(S", 'F'},
    {"0N;T(V", 'F'},
    {"0N;T1,", 'F'},
    {"0N;T1;", 'F'},
    {"0N;T1C", 'F'},
    {"0N;T1F", 'F'},
    {"0N;T1O", 'F'},
    {"0N;T1T", 'F'},
    {"0N;T;", 'F'},
    {"0N;T;C", 'F'},
    {"0N;TF(", 'F'},
    {"0N;TK(", 'F'},
    {"0N;TK1", 'F'},
    {"0N;TKF", 'F'},
    {"0N;TKK", 'F'},
    {"0N;TKN", 'F'},
    {"0N;TKO", 'F'},
    {"0N;TKS", 'F'},
    {"0N;TKV", 'F'},
    {"0N;TN(", 'F'},
    {"0N;TN,", 'F'},
    {"0N;TN1", 'F'},
    {"0N;TN;", 'F'},
    {"0N;TNC", 'F'},
    {"0N;TNE", 'F'},
    {"0N;TNF", 'F'},
    {"0N;TNK", 'F'},
    {"0N;TNN", 'F'},
    {"0N;TNO", 'F'},
    {"0N;TNS", 'F'},
    {"0N;TNT", 'F'},
    {"0N;TNV", 'F'},
    {"0N;TO(", 'F'},
    {"0N;TS,", 'F'},
    {"0N;TS;", 'F'},
    {"0N;TSC", 'F'},
    {"0N;TSF", 'F'},
    {"0N;TSO", 'F'},
    {"0N;TST", 'F'},
    {"0N;TT(", 'F'},
    {"0N;TT1", 'F'},
    {"0N;TTF", 'F'},
    {"0N;TTN", 'F'},
    {"0N;TTS", 'F'},
    {"0N;TTV", 'F'},
    {"0N;TV,", 'F'},
    {"0N;TV;", 'F'},
    {"0N;TVC", 'F'},
    {"0N;TVF", 'F'},
    {"0N;TVO", 'F'},
    {"0N;TVT", 'F'},
    {"0NA(((", 'F'},
    {"0NA((1", 'F'},
    {"0NA((F", 'F'},
    {"0NA((N", 'F'},
    {"0NA((S", 'F'},
    {"0NA((V", 'F'},
    {"0NA(F(", 'F'},
    {"0NA(N)", 'F'},
    {"0NA(NO", 'F'},
    {"0NA(S)", 'F'},
    {"0NA(SO", 'F'},
    {"0NA(V)", 'F'},
    {"0NA(VO", 'F'},
    {"0NAF((", 'F'},
    {"0NAF()", 'F'},
    {"0NAF(1", 'F'},
    {"0NAF(F", 'F'},
    {"0NAF(N", 'F'},
    {"0NAF(S", 'F'},
    {"0NAF(V", 'F'},
    {"0NASO(", 'F'},
    {"0NASO1", 'F'},
    {"0NASOF", 'F'},
    {"0NASON", 'F'},
    {"0NASOS", 'F'},
    {"0NASOV", 'F'},
    {"0NASUE", 'F'},
    {"0NATO(", 'F'},
    {"0NATO1", 'F'},
    {"0NATOF", 'F'},
    {"0NATON", 'F'},
    {"0NATOS", 'F'},
    {"0NATOV", 'F'},
    {"0NATUE", 'F'},
    {"0NAVO(", 'F'},
    {"0NAVOF", 'F'},
    {"0NAVOS", 'F'},
    {"0NAVUE", 'F'},
    {"0NB(((", 'F'},
    {"0NB((1", 'F'},
    {"0NB((F", 'F'},
    {"0NB((N", 'F'},
    {"0NB((S", 'F'},
    {"0NB((V", 'F'},
    {"0NB(1)", 'F'},
    {"0NB(1O", 'F'},
    {"0NB(F(", 'F'},
    {"0NB(N)", 'F'},
    {"0NB(NO", 'F'},
    {"0NB(S)", 'F'},
    {"0NB(SO", 'F'},
    {"0NB(V)", 'F'},
    {"0NB(VO", 'F'},
    {"0NB1", 'F'},
    {"0NB1&(", 'F'},
    {"0NB1&1", 'F'},
    {"0NB1&F", 'F'},
    {"0NB1&N", 'F'},
    {"0NB1&S", 'F'},
    {"0NB1&V", 'F'},
    {"0NB1,(", 'F'},
    {"0NB1,F", 'F'},
    {"0NB1,V", 'F'},
    {"0NB1;", 'F'},
    {"0NB1;C", 'F'},
    {"0NB1B(", 'F'},
    {"0NB1B1", 'F'},
    {"0NB1BF", 'F'},
    {"0NB1BN", 'F'},
    {"0NB1BS", 'F'},
    {"0NB1BV", 'F'},
    {"0NB1C", 'F'},
    {"0NB1K(", 'F'},
    {"0NB1K1", 'F'},
    {"0NB1KF", 'F'},
    {"0NB1KN", 'F'},
    {"0NB1KS", 'F'},
    {"0NB1KV", 'F'},
    {"0NB1O(", 'F'},
    {"0NB1OF", 'F'},
    {"0NB1OS", 'F'},
    {"0NB1OV", 'F'},
    {"0NB1U(", 'F'},
    {"0NB1UE", 'F'},
    {"0NBE((", 'F'},
    {"0NBE(1", 'F'},
    {"0NBE(F", 'F'},
    {"0NBE(N", 'F'},
    {"0NBE(S", 'F'},
    {"0NBE(V", 'F'},
    {"0NBEK(", 'F'},
    {"0NBF((", 'F'},
    {"0NBF()", 'F'},
    {"0NBF(1", 'F'},
    {"0NBF(F", 'F'},
    {"0NBF(N", 'F'},
    {"0NBF(S", 'F'},
    {"0NBF(V", 'F'},
    {"0NBN&(", 'F'},
    {"0NBN&1", 'F'},
    {"0NBN&F", 'F'},
    {"0NBN&N", 'F'},
    {"0NBN&S", 'F'},
    {"0NBN&V", 'F'},
    {"0NBN,(", 'F'},
    {"0NBN,F", 'F'},
    {"0NBN,V", 'F'},
    {"0NBN;", 'F'},
    {"0NBN;C", 'F'},
    {"0NBNB(", 'F'},
    {"0NBNB1", 'F'},
    {"0NBNBF", 'F'},
    {"0NBNBN", 'F'},
    {"0NBNBS", 'F'},
    {"0NBNBV", 'F'},
    {"0NBNC", 'F'},
    {"0NBNK(", 'F'},
    {"0NBNK1", 'F'},
    {"0NBNKF", 'F'},
    {"0NBNKN", 'F'},
    {"0NBNKS", 'F'},
    {"0NBNKV", 'F'},
    {"0NBNO(", 'F'},
    {"0NBNOF", 'F'},
    {"0NBNOS", 'F'},
    {"0NBNOV", 'F'},
    {"0NBNU(", 'F'},
    {"0NBNUE", 'F'},
    {"0NBS", 'F'},
    {"0NBS&(", 'F'},
    {"0NBS&1", 'F'},
    {"0NBS&F", 'F'},
    {"0NBS&N", 'F'},
    {"0NBS&S", 'F'},
    {"0NBS&V", 'F'},
    {"0NBS,(", 'F'},
    {"0NBS,F", 'F'},
    {"0NBS,V", 'F'},
    {"0NBS;", 'F'},
    {"0NBS;C", 'F'},
    {"0NBSB(", 'F'},
    {"0NBSB1", 'F'},
    {"0NBSBF", 'F'},
    {"0NBSBN", 'F'},
    {"0NBSBS", 'F'},
    {"0NBSBV", 'F'},
    {"0NBSC", 'F'},
    {"0NBSK(", 'F'},
    {"0NBSK1", 'F'},
    {"0NBSKF", 'F'},
    {"0NBSKN", 'F'},
    {"0NBSKS", 'F'},
    {"0NBSKV", 'F'},
    {"0NBSO(", 'F'},
    {"0NBSO1", 'F'},
    {"0NBSOF", 'F'},
    {"0NBSON", 'F'},
    {"0NBSOS", 'F'},
    {"0NBSOV", 'F'},
    {"0NBSU(", 'F'},
    {"0NBSUE", 'F'},
    {"0NBV", 'F'},
    {"0NBV&(", 'F'},
    {"0NBV&1", 'F'},
    {"0NBV&F", 'F'},
    {"0NBV&N", 'F'},
    {"0NBV&S", 'F'},
    {"0NBV&V", 'F'},
    {"0NBV,(", 'F'},
    {"0NBV,1", 'F'},
    {"0NBV,F", 'F'},
    {"0NBV,N", 'F'},
    {"0NBV,S", 'F'},
    {"0NBV,V", 'F'},
    {"0NBV;", 'F'},
    {"0NBV;C", 'F'},
    {"0NBVB(", 'F'},
    {"0NBVB1", 'F'},
    {"0NBVBF", 'F'},
    {"0NBVBN", 'F'},
    {"0NBVBS", 'F'},
    {"0NBVBV", 'F'},
    {"0NBVC", 'F'},
    {"0NBVK(", 'F'},
    {"0NBVK1", 'F'},
    {"0NBVKF", 'F'},
    {"0NBVKN", 'F'},
    {"0NBVKS", 'F'},
    {"0NBVKV", 'F'},
    {"0NBVO(", 'F'},
    {"0NBVOF", 'F'},
    {"0NBVOS", 'F'},
    {"0NBVU(", 'F'},
    {"0NBVUE", 'F'},
    {"0NC", 'F'},
    {"0NE(((", 'F'},
    {"0NE((1", 'F'},
    {"0NE((F", 'F'},
    {"0NE((N", 'F'},
    {"0NE((S", 'F'},
    {"0NE((V", 'F'},
    {"0NE(1)", 'F'},
    {"0NE(1O", 'F'},
    {"0NE(F(", 'F'},
    {"0NE(N)", 'F'},
    {"0NE(NO", 'F'},
    {"0NE(S)", 'F'},
    {"0NE(SO", 'F'},
    {"0NE(V)", 'F'},
    {"0NE(VO", 'F'},
    {"0NE1C", 'F'},
    {"0NE1O(", 'F'},
    {"0NE1OF", 'F'},
    {"0NE1OS", 'F'},
    {"0NE1OV", 'F'},
    {"0NE1UE", 'F'},
    {"0NEF((", 'F'},
    {"0NEF()", 'F'},
    {"0NEF(1", 'F'},
    {"0NEF(F", 'F'},
    {"0NEF(N", 'F'},
    {"0NEF(S", 'F'},
    {"0NEF(V", 'F'},
    {"0NENC", 'F'},
    {"0NENO(", 'F'},
    {"0NENOF", 'F'},
    {"0NENOS", 'F'},
    {"0NENOV", 'F'},
    {"0NENUE", 'F'},
    {"0NEOKN", 'F'},
    {"0NESC", 'F'},
    {"0NESO(", 'F'},
    {"0NESO1", 'F'},
    {"0NESOF", 'F'},
    {"0NESON", 'F'},
    {"0NESOS", 'F'},
    {"0NESOV", 'F'},
    {"0NESUE", 'F'},
    {"0NEU((", 'F'},
    {"0NEU(1", 'F'},
    {"0NEU(F", 'F'},
    {"0NEU(N", 'F'},
    {"0NEU(S", 'F'},
    {"0NEU(V", 'F'},
    {"0NEU1,", 'F'},
    {"0NEU1C", 'F'},
    {"0NEU1O", 'F'},
    {"0NEUEF", 'F'},
    {"0NEUEK", 'F'},
    {"0NEUF(", 'F'},
    {"0NEUN,", 'F'},
    {"0NEUNC", 'F'},
    {"0NEUNO", 'F'},
    {"0NEUS,", 'F'},
    {"0NEUSC", 'F'},
    {"0NEUSO", 'F'},
    {"0NEUV,", 'F'},
    {"0NEUVC", 'F'},
    {"0NEUVO", 'F'},
    {"0NEVC", 'F'},
    {"0NEVO(", 'F'},
    {"0NEVOF", 'F'},
    {"0NEVOS", 'F'},
    {"0NEVUE", 'F'},
    {"0NF(((", 'F'},
    {"0NF(()", 'F'},
    {"0NF((1", 'F'},
    {"0NF((F", 'F'},
    {"0NF((N", 'F'},
    {"0NF((S", 'F'},
    {"0NF((V", 'F'},
    {"0NF())", 'F'},
    {"0NF()1", 'F'},
    {"0NF()F", 'F'},
    {"0NF()K", 'F'},
    {"0NF()N", 'F'},
    {"0NF()O", 'F'},
    {"0NF()S", 'F'},
    {"0NF()U", 'F'},
    {"0NF()V", 'F'},
    {"0NF(1)", 'F'},
    {"0NF(1N", 'F'},
    {"0NF(1O", 'F'},
    {"0NF(F(", 'F'},
    {"0NF(N)", 'F'},
    {"0NF(N,", 'F'},
    {"0NF(NO", 'F'},
    {"0NF(S)", 'F'},
    {"0NF(SO", 'F'},
    {"0NF(V)", 'F'},
    {"0NF(VO", 'F'},
    {"0NK(((", 'F'},
    {"0NK((1", 'F'},
    {"0NK((F", 'F'},
    {"0NK((N", 'F'},
    {"0NK((S", 'F'},
    {"0NK((V", 'F'},
    {"0NK(1)", 'F'},
    {"0NK(1O", 'F'},
    {"0NK(F(", 'F'},
    {"0NK(N)", 'F'},
    {"0NK(NO", 'F'},
    {"0NK(S)", 'F'},
    {"0NK(SO", 'F'},
    {"0NK(V)", 'F'},
    {"0NK(VO", 'F'},
    {"0NK)&(", 'F'},
    {"0NK)&1", 'F'},
    {"0NK)&F", 'F'},
    {"0NK)&N", 'F'},
    {"0NK)&S", 'F'},
    {"0NK)&V", 'F'},
    {"0NK))&", 'F'},
    {"0NK)))", 'F'},
    {"0NK));", 'F'},
    {"0NK))B", 'F'},
    {"0NK))E", 'F'},
    {"0NK))K", 'F'},
    {"0NK))O", 'F'},
    {"0NK))U", 'F'},
    {"0NK);E", 'F'},
    {"0NK);T", 'F'},
    {"0NK)B(", 'F'},
    {"0NK)B1", 'F'},
    {"0NK)BF", 'F'},
    {"0NK)BN", 'F'},
    {"0NK)BS", 'F'},
    {"0NK)BV", 'F'},
    {"0NK)E(", 'F'},
    {"0NK)E1", 'F'},
    {"0NK)EF", 'F'},
    {"0NK)EK", 'F'},
    {"0NK)EN", 'F'},
    {"0NK)ES", 'F'},
    {"0NK)EV", 'F'},
    {"0NK)OF", 'F'},
    {"0NK)UE", 'F'},
    {"0NK1", 'F'},
    {"0NK1&(", 'F'},
    {"0NK1&1", 'F'},
    {"0NK1&F", 'F'},
    {"0NK1&N", 'F'},
    {"0NK1&S", 'F'},
    {"0NK1&V", 'F'},
    {"0NK1;C", 'F'},
    {"0NK1;E", 'F'},
    {"0NK1;T", 'F'},
    {"0NK1B(", 'F'},
    {"0NK1B1", 'F'},
    {"0NK1BF", 'F'},
    {"0NK1BN", 'F'},
    {"0NK1BS", 'F'},
    {"0NK1BV", 'F'},
    {"0NK1C", 'F'},
    {"0NK1E(", 'F'},
    {"0NK1E1", 'F'},
    {"0NK1EF", 'F'},
    {"0NK1EK", 'F'},
    {"0NK1EN", 'F'},
    {"0NK1ES", 'F'},
    {"0NK1EV", 'F'},
    {"0NK1O(", 'F'},
    {"0NK1OF", 'F'},
    {"0NK1OS", 'F'},
    {"0NK1OV", 'F'},
    {"0NK1U(", 'F'},
    {"0NK1UE", 'F'},
    {"0NKF((", 'F'},
    {"0NKF()", 'F'},
    {"0NKF(1", 'F'},
    {"0NKF(F", 'F'},
    {"0NKF(N", 'F'},
    {"0NKF(S", 'F'},
    {"0NKF(V", 'F'},
    {"0NKN", 'F'},
    {"0NKN&(", 'F'},
    {"0NKN&1", 'F'},
    {"0NKN&F", 'F'},
    {"0NKN&S", 'F'},
    {"0NKN&V", 'F'},
    {"0NKN;C", 'F'},
    {"0NKN;E", 'F'},
    {"0NKN;T", 'F'},
    {"0NKNB(", 'F'},
    {"0NKNB1", 'F'},
    {"0NKNBF", 'F'},
    {"0NKNBN", 'F'},
    {"0NKNBS", 'F'},
    {"0NKNBV", 'F'},
    {"0NKNC", 'F'},
    {"0NKNE(", 'F'},
    {"0NKNE1", 'F'},
    {"0NKNEF", 'F'},
    {"0NKNES", 'F'},
    {"0NKNEV", 'F'},
    {"0NKNU(", 'F'},
    {"0NKNUE", 'F'},
    {"0NKS", 'F'},
    {"0NKS&(", 'F'},
    {"0NKS&1", 'F'},
    {"0NKS&F", 'F'},
    {"0NKS&N", 'F'},
    {"0NKS&S", 'F'},
    {"0NKS&V", 'F'},
    {"0NKS;", 'F'},
    {"0NKS;C", 'F'},
    {"0NKS;E", 'F'},
    {"0NKS;T", 'F'},
    {"0NKSB(", 'F'},
    {"0NKSB1", 'F'},
    {"0NKSBF", 'F'},
    {"0NKSBN", 'F'},
    {"0NKSBS", 'F'},
    {"0NKSBV", 'F'},
    {"0NKSC", 'F'},
    {"0NKSE(", 'F'},
    {"0NKSE1", 'F'},
    {"0NKSEF", 'F'},
    {"0NKSEK", 'F'},
    {"0NKSEN", 'F'},
    {"0NKSES", 'F'},
    {"0NKSEV", 'F'},
    {"0NKSO(", 'F'},
    {"0NKSO1", 'F'},
    {"0NKSOF", 'F'},
    {"0NKSON", 'F'},
    {"0NKSOS", 'F'},
    {"0NKSOV", 'F'},
    {"0NKSU(", 'F'},
    {"0NKSUE", 'F'},
    {"0NKUE(", 'F'},
    {"0NKUE1", 'F'},
    {"0NKUEF", 'F'},
    {"0NKUEK", 'F'},
    {"0NKUEN", 'F'},
    {"0NKUES", 'F'},
    {"0NKUEV", 'F'},
    {"0NKV", 'F'},
    {"0NKV&(", 'F'},
    {"0NKV&1", 'F'},
    {"0NKV&F", 'F'},
    {"0NKV&N", 'F'},
    {"0NKV&S", 'F'},
    {"0NKV&V", 'F'},
    {"0NKV;", 'F'},
    {"0NKV;C", 'F'},
    {"0NKV;E", 'F'},
    {"0NKV;T", 'F'},
    {"0NKVB(", 'F'},
    {"0NKVB1", 'F'},
    {"0NKVBF", 'F'},
    {"0NKVBN", 'F'},
    {"0NKVBS", 'F'},
    {"0NKVBV", 'F'},
    {"0NKVC", 'F'},
    {"0NKVE(", 'F'},
    {"0NKVE1", 'F'},
    {"0NKVEF", 'F'},
    {"0NKVEK", 'F'},
    {"0NKVEN", 'F'},
    {"0NKVES", 'F'},
    {"0NKVEV", 'F'},
    {"0NKVO(", 'F'},
    {"0NKVOF", 'F'},
    {"0NKVOS", 'F'},
    {"0NKVU(", 'F'},
    {"0NKVUE", 'F'},
    {"0NO(((", 'F'},
    {"0NO((1", 'F'},
    {"0NO((E", 'F'},
    {"0NO((F", 'F'},
    {"0NO((N", 'F'},
    {"0NO((O", 'F'},
    {"0NO((S", 'F'},
    {"0NO((T", 'F'},
    {"0NO((V", 'F'},
    {"0NO(1&", 'F'},
    {"0NO(1)", 'F'},
    {"0NO(1,", 'F'},
    {"0NO(1O", 'F'},
    {"0NO(E(", 'F'},
    {"0NO(E1", 'F'},
    {"0NO(EE", 'F'},
    {"0NO(EF", 'F'},
    {"0NO(EK", 'F'},
    {"0NO(EN", 'F'},
    {"0NO(ES", 'F'},
    {"0NO(EV", 'F'},
    {"0NO(F(", 'F'},
    {"0NO(N&", 'F'},
    {"0NO(N)", 'F'},
    {"0NO(N,", 'F'},
    {"0NO(NO", 'F'},
    {"0NO(O(", 'F'},
    {"0NO(O1", 'F'},
    {"0NO(OF", 'F'},
    {"0NO(ON", 'F'},
    {"0NO(OS", 'F'},
    {"0NO(OV", 'F'},
    {"0NO(S&", 'F'},
    {"0NO(S)", 'F'},
    {"0NO(S,", 'F'},
    {"0NO(SO", 'F'},
    {"0NO(T(", 'F'},
    {"0NO(V&", 'F'},
    {"0NO(V)", 'F'},
    {"0NO(V,", 'F'},
    {"0NO(VO", 'F'},
    {"0NOF((", 'F'},
    {"0NOF()", 'F'},
    {"0NOF(1", 'F'},
    {"0NOF(E", 'F'},
    {"0NOF(F", 'F'},
    {"0NOF(N", 'F'},
    {"0NOF(S", 'F'},
    {"0NOF(V", 'F'},
    {"0NOK&(", 'F'},
    {"0NOK&1", 'F'},
    {"0NOK&F", 'F'},
    {"0NOK&N", 'F'},
    {"0NOK&S", 'F'},
    {"0NOK&V", 'F'},
    {"0NOK((", 'F'},
    {"0NOK(1", 'F'},
    {"0NOK(F", 'F'},
    {"0NOK(N", 'F'},
    {"0NOK(S", 'F'},
    {"0NOK(V", 'F'},
    {"0NOK1C", 'F'},
    {"0NOK1O", 'F'},
    {"0NOKF(", 'F'},
    {"0NOKNC", 'F'},
    {"0NOKO(", 'F'},
    {"0NOKO1", 'F'},
    {"0NOKOF", 'F'},
    {"0NOKON", 'F'},
    {"0NOKOS", 'F'},
    {"0NOKOV", 'F'},
    {"0NOKSC", 'F'},
    {"0NOKSO", 'F'},
    {"0NOKVC", 'F'},
    {"0NOKVO", 'F'},
    {"0NONSU", 'F'},
    {"0NOS&(", 'F'},
    {"0NOS&1", 'F'},
    {"0NOS&E", 'F'},
    {"0NOS&F", 'F'},
    {"0NOS&K", 'F'},
    {"0NOS&N", 'F'},
    {"0NOS&S", 'F'},
    {"0NOS&U", 'F'},
    {"0NOS&V", 'F'},
    {"0NOS((", 'F'},
    {"0NOS(E", 'F'},
    {"0NOS(U", 'F'},
    {"0NOS)&", 'F'},
    {"0NOS))", 'F'},
    {"0NOS),", 'F'},
    {"0NOS);", 'F'},
    {"0NOS)B", 'F'},
    {"0NOS)E", 'F'},
    {"0NOS)K", 'F'},
    {"0NOS)O", 'F'},
    {"0NOS)U", 'F'},
    {"0NOS,(", 'F'},
    {"0NOS,F", 'F'},
    {"0NOS,V", 'F'},
    {"0NOS1(", 'F'},
    {"0NOS1F", 'F'},
    {"0NOS1N", 'F'},
    {"0NOS1O", 'F'},
    {"0NOS1S", 'F'},
    {"0NOS1U", 'F'},
    {"0NOS1V", 'F'},
    {"0NOS;", 'F'},
    {"0NOS;C", 'F'},
    {"0NOS;E", 'F'},
    {"0NOS;T", 'F'},
    {"0NOSA(", 'F'},
    {"0NOSAF", 'F'},
    {"0NOSAS", 'F'},
    {"0NOSAT", 'F'},
    {"0NOSAV", 'F'},
    {"0NOSB(", 'F'},
    {"0NOSB1", 'F'},
    {"0NOSBE", 'F'},
    {"0NOSBF", 'F'},
    {"0NOSBN", 'F'},
    {"0NOSBS", 'F'},
    {"0NOSBV", 'F'},
    {"0NOSC", 'F'},
    {"0NOSE(", 'F'},
    {"0NOSE1", 'F'},
    {"0NOSEF", 'F'},
    {"0NOSEK", 'F'},
    {"0NOSEN", 'F'},
    {"0NOSEO", 'F'},
    {"0NOSES", 'F'},
    {"0NOSEU", 'F'},
    {"0NOSEV", 'F'},
    {"0NOSF(", 'F'},
    {"0NOSK(", 'F'},
    {"0NOSK)", 'F'},
    {"0NOSK1", 'F'},
    {"0NOSKB", 'F'},
    {"0NOSKF", 'F'},
    {"0NOSKN", 'F'},
    {"0NOSKS", 'F'},
    {"0NOSKU", 'F'},
    {"0NOSKV", 'F'},
    {"0NOSO(", 'F'},
    {"0NOSO1", 'F'},
    {"0NOSOF", 'F'},
    {"0NOSOK", 'F'},
    {"0NOSON", 'F'},
    {"0NOSOS", 'F'},
    {"0NOSOT", 'F'},
    {"0NOSOU", 'F'},
    {"0NOSOV", 'F'},
    {"0NOSU", 'F'},
    {"0NOSU(", 'F'},
    {"0NOSU1", 'F'},
    {"0NOSU;", 'F'},
    {"0NOSUC", 'F'},
    {"0NOSUE", 'F'},
    {"0NOSUF", 'F'},
    {"0NOSUK", 'F'},
    {"0NOSUN", 'F'},
    {"0NOSUO", 'F'},
    {"0NOSUS", 'F'},
    {"0NOSUT", 'F'},
    {"0NOSUV", 'F'},
    {"0NOSV(", 'F'},
    {"0NOSVF", 'F'},
    {"0NOSVO", 'F'},
    {"0NOSVS", 'F'},
    {"0NOSVU", 'F'},
    {"0NOT((", 'F'},
    {"0NOT(1", 'F'},
    {"0NOT(F", 'F'},
    {"0NOT(N", 'F'},
    {"0NOT(S", 'F'},
    {"0NOT(V", 'F'},
    {"0NOU((", 'F'},
    {"0NOU(E", 'F'},
    {"0NOUEK", 'F'},
    {"0NOUEN", 'F'},
    {"0NOV&(", 'F'},
    {"0NOV&1", 'F'},
    {"0NOV&E", 'F'},
    {"0NOV&F", 'F'},
    {"0NOV&K", 'F'},
    {"0NOV&N", 'F'},
    {"0NOV&S", 'F'},
    {"0NOV&U", 'F'},
    {"0NOV&V", 'F'},
    {"0NOV((", 'F'},
    {"0NOV(E", 'F'},
    {"0NOV(U", 'F'},
    {"0NOV)&", 'F'},
    {"0NOV))", 'F'},
    {"0NOV),", 'F'},
    {"0NOV);", 'F'},
    {"0NOV)B", 'F'},
    {"0NOV)E", 'F'},
    {"0NOV)K", 'F'},
    {"0NOV)O", 'F'},
    {"0NOV)U", 'F'},
    {"0NOV,(", 'F'},
    {"0NOV,1", 'F'},
    {"0NOV,F", 'F'},
    {"0NOV,N", 'F'},
    {"0NOV,S", 'F'},
    {"0NOV,V", 'F'},
    {"0NOV;", 'F'},
    {"0NOV;C", 'F'},
    {"0NOV;E", 'F'},
    {"0NOV;N", 'F'},
    {"0NOV;T", 'F'},
    {"0NOVA(", 'F'},
    {"0NOVAF", 'F'},
    {"0NOVAS", 'F'},
    {"0NOVAT", 'F'},
    {"0NOVAV", 'F'},
    {"0NOVB(", 'F'},
    {"0NOVB1", 'F'},
    {"0NOVBE", 'F'},
    {"0NOVBF", 'F'},
    {"0NOVBN", 'F'},
    {"0NOVBS", 'F'},
    {"0NOVBV", 'F'},
    {"0NOVC", 'F'},
    {"0NOVE(", 'F'},
    {"0NOVE1", 'F'},
    {"0NOVEF", 'F'},
    {"0NOVEK", 'F'},
    {"0NOVEN", 'F'},
    {"0NOVEO", 'F'},
    {"0NOVES", 'F'},
    {"0NOVEU", 'F'},
    {"0NOVEV", 'F'},
    {"0NOVF(", 'F'},
    {"0NOVK(", 'F'},
    {"0NOVK)", 'F'},
    {"0NOVK1", 'F'},
    {"0NOVKB", 'F'},
    {"0NOVKF", 'F'},
    {"0NOVKN", 'F'},
    {"0NOVKS", 'F'},
    {"0NOVKU", 'F'},
    {"0NOVKV", 'F'},
    {"0NOVO(", 'F'},
    {"0NOVOF", 'F'},
    {"0NOVOK", 'F'},
    {"0NOVOS", 'F'},
    {"0NOVOT", 'F'},
    {"0NOVOU", 'F'},
    {"0NOVS(", 'F'},
    {"0NOVS1", 'F'},
    {"0NOVSF", 'F'},
    {"0NOVSO", 'F'},
    {"0NOVSU", 'F'},
    {"0NOVSV", 'F'},
    {"0NOVU", 'F'},
    {"0NOVU(", 'F'},
    {"0NOVU1", 'F'},
    {"0NOVU;", 'F'},
    {"0NOVUC", 'F'},
    {"0NOVUE", 'F'},
    {"0NOVUF", 'F'},
    {"0NOVUK", 'F'},
    {"0NOVUN", 'F'},
    {"0NOVUO", 'F'},
    {"0NOVUS", 'F'},
    {"0NOVUT", 'F'},
    {"0NOVUV", 'F'},
    {"0NSO1U", 'F'},
    {"0NSONU", 'F'},
    {"0NSOSU", 'F'},
    {"0NSOVU", 'F'},
    {"0NSUE", 'F'},
    {"0NSUE;", 'F'},
    {"0NSUEC", 'F'},
    {"0NSUEK", 'F'},
    {"0NU(((", 'F'},
    {"0NU((1", 'F'},
    {"0NU((E", 'F'},
    {"0NU((F", 'F'},
    {"0NU((N", 'F'},
    {"0NU((S", 'F'},
    {"0NU((V", 'F'},
    {"0NU(1)", 'F'},
    {"0NU(1O", 'F'},
    {"0NU(E(", 'F'},
    {"0NU(E1", 'F'},
    {"0NU(EF", 'F'},
    {"0NU(EK", 'F'},
    {"0NU(EN", 'F'},
    {"0NU(ES", 'F'},
    {"0NU(EV", 'F'},
    {"0NU(F(", 'F'},
    {"0NU(N)", 'F'},
    {"0NU(NO", 'F'},
    {"0NU(S)", 'F'},
    {"0NU(SO", 'F'},
    {"0NU(V)", 'F'},
    {"0NU(VO", 'F'},
    {"0NU1,(", 'F'},
    {"0NU1,F", 'F'},
    {"0NU1,V", 'F'},
    {"0NU1C", 'F'},
    {"0NU1O(", 'F'},
    {"0NU1OF", 'F'},
    {"0NU1OS", 'F'},
    {"0NU1OV", 'F'},
    {"0NU;", 'F'},
    {"0NU;C", 'F'},
    {"0NUC", 'F'},
    {"0NUE", 'F'},
    {"0NUE((", 'F'},
    {"0NUE(1", 'F'},
    {"0NUE(E", 'F'},
    {"0NUE(F", 'F'},
    {"0NUE(N", 'F'},
    {"0NUE(O", 'F'},
    {"0NUE(S", 'F'},
    {"0NUE(V", 'F'},
    {"0NUE1", 'F'},
    {"0NUE1&", 'F'},
    {"0NUE1(", 'F'},
    {"0NUE1)", 'F'},
    {"0NUE1,", 'F'},
    {"0NUE1;", 'F'},
    {"0NUE1B", 'F'},
    {"0NUE1C", 'F'},
    {"0NUE1F", 'F'},
    {"0NUE1K", 'F'},
    {"0NUE1N", 'F'},
    {"0NUE1O", 'F'},
    {"0NUE1S", 'F'},
    {"0NUE1U", 'F'},
    {"0NUE1V", 'F'},
    {"0NUE;", 'F'},
    {"0NUE;C", 'F'},
    {"0NUEC", 'F'},
    {"0NUEF", 'F'},
    {"0NUEF(", 'F'},
    {"0NUEF,", 'F'},
    {"0NUEF;", 'F'},
    {"0NUEFC", 'F'},
    {"0NUEK", 'F'},
    {"0NUEK(", 'F'},
    {"0NUEK1", 'F'},
    {"0NUEK;", 'F'},
    {"0NUEKC", 'F'},
    {"0NUEKF", 'F'},
    {"0NUEKN", 'F'},
    {"0NUEKO", 'F'},
    {"0NUEKS", 'F'},
    {"0NUEKV", 'F'},
    {"0NUEN", 'F'},
    {"0NUEN&", 'F'},
    {"0NUEN(", 'F'},
    {"0NUEN)", 'F'},
    {"0NUEN,", 'F'},
    {"0NUEN1", 'F'},
    {"0NUEN;", 'F'},
    {"0NUENB", 'F'},
    {"0NUENC", 'F'},
    {"0NUENF", 'F'},
    {"0NUENK", 'F'},
    {"0NUENO", 'F'},
    {"0NUENS", 'F'},
    {"0NUENU", 'F'},
    {"0NUEOK", 'F'},
    {"0NUEON", 'F'},
    {"0NUEOO", 'F'},
    {"0NUES", 'F'},
    {"0NUES&", 'F'},
    {"0NUES(", 'F'},
    {"0NUES)", 'F'},
    {"0NUES,", 'F'},
    {"0NUES1", 'F'},
    {"0NUES;", 'F'},
    {"0NUESB", 'F'},
    {"0NUESC", 'F'},
    {"0NUESF", 'F'},
    {"0NUESK", 'F'},
    {"0NUESO", 'F'},
    {"0NUESU", 'F'},
    {"0NUESV", 'F'},
    {"0NUEV", 'F'},
    {"0NUEV&", 'F'},
    {"0NUEV(", 'F'},
    {"0NUEV)", 'F'},
    {"0NUEV,", 'F'},
    {"0NUEV;", 'F'},
    {"0NUEVB", 'F'},
    {"0NUEVC", 'F'},
    {"0NUEVF", 'F'},
    {"0NUEVK", 'F'},
    {"0NUEVN", 'F'},
    {"0NUEVO", 'F'},
    {"0NUEVS", 'F'},
    {"0NUEVU", 'F'},
    {"0NUF((", 'F'},
    {"0NUF()", 'F'},
    {"0NUF(1", 'F'},
    {"0NUF(F", 'F'},
    {"0NUF(N", 'F'},
    {"0NUF(S", 'F'},
    {"0NUF(V", 'F'},
    {"0NUK((", 'F'},
    {"0NUK(E", 'F'},
    {"0NUN((", 'F'},
    {"0NUN(1", 'F'},
    {"0NUN(F", 'F'},
    {"0NUN(S", 'F'},
    {"0NUN(V", 'F'},
    {"0NUN,(", 'F'},
    {"0NUN,F", 'F'},
    {"0NUN,V", 'F'},
    {"0NUN1(", 'F'},
    {"0NUN1,", 'F'},
    {"0NUN1O", 'F'},
    {"0NUNC", 'F'},
    {"0NUNE(", 'F'},
    {"0NUNE1", 'F'},
    {"0NUNEF", 'F'},
    {"0NUNEN", 'F'},
    {"0NUNES", 'F'},
    {"0NUNEV", 'F'},
    {"0NUNF(", 'F'},
    {"0NUNO(", 'F'},
    {"0NUNOF", 'F'},
    {"0NUNOS", 'F'},
    {"0NUNOV", 'F'},
    {"0NUNS(", 'F'},
    {"0NUNS,", 'F'},
    {"0NUNSO", 'F'},
    {"0NUO((", 'F'},
    {"0NUO(E", 'F'},
    {"0NUON(", 'F'},
    {"0NUON1", 'F'},
    {"0NUONF", 'F'},
    {"0NUONS", 'F'},
    {"0NUS,(", 'F'},
    {"0NUS,F", 'F'},
    {"0NUS,V", 'F'},
    {"0NUSC", 'F'},
    {"0NUSO(", 'F'},
    {"0NUSO1", 'F'},
    {"0NUSOF", 'F'},
    {"0NUSON", 'F'},
    {"0NUSOS", 'F'},
    {"0NUSOV", 'F'},
    {"0NUTN(", 'F'},
    {"0NUTN1", 'F'},
    {"0NUTNF", 'F'},
    {"0NUTNS", 'F'},
    {"0NUV,(", 'F'},
    {"0NUV,1", 'F'},
    {"0NUV,F", 'F'},
    {"0NUV,N", 'F'},
    {"0NUV,S", 'F'},
    {"0NUV,V", 'F'},
    {"0NUVC", 'F'},
    {"0NUVO(", 'F'},
    {"0NUVOF", 'F'},
    {"0NUVOS", 'F'},
    {"0OF(((", 'F'},
    {"0OF((1", 'F'},
    {"0OF((F", 'F'},
    {"0OF((N", 'F'},
    {"0OF((S", 'F'},
    {"0OF((V", 'F'},
    {"0OF(1O", 'F'},
    {"0OF(F(", 'F'},
    {"0OF(NO", 'F'},
    {"0OF(SO", 'F'},
    {"0OF(VO", 'F'},
    {"0OUE((", 'F'},
    {"0OUE(1", 'F'},
    {"0OUE(F", 'F'},
    {"0OUE(N", 'F'},
    {"0OUE(S", 'F'},
    {"0OUE(V", 'F'},
    {"0OUE1,", 'F'},
    {"0OUE1O", 'F'},
    {"0OUEF(", 'F'},
    {"0OUEK(", 'F'},
    {"0OUEK1", 'F'},
    {"0OUEKF", 'F'},
    {"0OUEKN", 'F'},
    {"0OUEKS", 'F'},
    {"0OUEKV", 'F'},
    {"0OUEN,", 'F'},
    {"0OUENO", 'F'},
    {"0OUES,", 'F'},
    {"0OUESO", 'F'},
    {"0OUEV,", 'F'},
    {"0OUEVO", 'F'},
    {"0S&(((", 'F'},
    {"0S&((1", 'F'},
    {"0S&((E", 'F'},
    {"0S&((F", 'F'},
    {"0S&((N", 'F'},
    {"0S&((S", 'F'},
    {"0S&((V", 'F'},
    {"0S&(1&", 'F'},
    {"0S&(1)", 'F'},
    {"0S&(1,", 'F'},
    {"0S&(1O", 'F'},
    {"0S&(E(", 'F'},
    {"0S&(E1", 'F'},
    {"0S&(EF", 'F'},
    {"0S&(EK", 'F'},
    {"0S&(EN", 'F'},
    {"0S&(EO", 'F'},
    {"0S&(ES", 'F'},
    {"0S&(EV", 'F'},
    {"0S&(F(", 'F'},
    {"0S&(N&", 'F'},
    {"0S&(N)", 'F'},
    {"0S&(N,", 'F'},
    {"0S&(NO", 'F'},
    {"0S&(S&", 'F'},
    {"0S&(S)", 'F'},
    {"0S&(S,", 'F'},
    {"0S&(SO", 'F'},
    {"0S&(V&", 'F'},
    {"0S&(V)", 'F'},
    {"0S&(V,", 'F'},
    {"0S&(VO", 'F'},
    {"0S&1", 'F'},
    {"0S&1&(", 'F'},
    {"0S&1&1", 'F'},
    {"0S&1&F", 'F'},
    {"0S&1&N", 'F'},
    {"0S&1&S", 'F'},
    {"0S&1&V", 'F'},
    {"0S&1)&", 'F'},
    {"0S&1))", 'F'},
    {"0S&1)U", 'F'},
    {"0S&1;", 'F'},
    {"0S&1;C", 'F'},
    {"0S&1;E", 'F'},
    {"0S&1;T", 'F'},
    {"0S&1B(", 'F'},
    {"0S&1B1", 'F'},
    {"0S&1BF", 'F'},
    {"0S&1BN", 'F'},
    {"0S&1BS", 'F'},
    {"0S&1BV", 'F'},
    {"0S&1C", 'F'},
    {"0S&1EK", 'F'},
    {"0S&1EN", 'F'},
    {"0S&1F(", 'F'},
    {"0S&1K(", 'F'},
    {"0S&1K1", 'F'},
    {"0S&1KF", 'F'},
    {"0S&1KN", 'F'},
    {"0S&1KS", 'F'},
    {"0S&1KV", 'F'},
    {"0S&1O(", 'F'},
    {"0S&1OF", 'F'},
    {"0S&1OO", 'F'},
    {"0S&1OS", 'F'},
    {"0S&1OV", 'F'},
    {"0S&1S", 'F'},
    {"0S&1TN", 'F'},
    {"0S&1U", 'F'},
    {"0S&1U(", 'F'},
    {"0S&1U;", 'F'},
    {"0S&1UC", 'F'},
    {"0S&1UE", 'F'},
    {"0S&E((", 'F'},
    {"0S&E(1", 'F'},
    {"0S&E(F", 'F'},
    {"0S&E(N", 'F'},
    {"0S&E(O", 'F'},
    {"0S&E(S", 'F'},
    {"0S&E(V", 'F'},
    {"0S&E1", 'F'},
    {"0S&E1;", 'F'},
    {"0S&E1C", 'F'},
    {"0S&E1K", 'F'},
    {"0S&E1O", 'F'},
    {"0S&EF(", 'F'},
    {"0S&EK(", 'F'},
    {"0S&EK1", 'F'},
    {"0S&EKF", 'F'},
    {"0S&EKN", 'F'},
    {"0S&EKS", 'F'},
    {"0S&EKV", 'F'},
    {"0S&EN", 'F'},
    {"0S&EN;", 'F'},
    {"0S&ENC", 'F'},
    {"0S&ENK", 'F'},
    {"0S&ENO", 'F'},
    {"0S&ES", 'F'},
    {"0S&ES;", 'F'},
    {"0S&ESC", 'F'},
    {"0S&ESK", 'F'},
    {"0S&ESO", 'F'},
    {"0S&EV", 'F'},
    {"0S&EV;", 'F'},
    {"0S&EVC", 'F'},
    {"0S&EVK", 'F'},
    {"0S&EVO", 'F'},
    {"0S&F((", 'F'},
    {"0S&F()", 'F'},
    {"0S&F(1", 'F'},
    {"0S&F(F", 'F'},
    {"0S&F(N", 'F'},
    {"0S&F(S", 'F'},
    {"0S&F(V", 'F'},
    {"0S&K&(", 'F'},
    {"0S&K&1", 'F'},
    {"0S&K&F", 'F'},
    {"0S&K&N", 'F'},
    {"0S&K&S", 'F'},
    {"0S&K&V", 'F'},
    {"0S&K((", 'F'},
    {"0S&K(1", 'F'},
    {"0S&K(F", 'F'},
    {"0S&K(N", 'F'},
    {"0S&K(S", 'F'},
    {"0S&K(V", 'F'},
    {"0S&K1O", 'F'},
    {"0S&KF(", 'F'},
    {"0S&KNK", 'F'},
    {"0S&KO(", 'F'},
    {"0S&KO1", 'F'},
    {"0S&KOF", 'F'},
    {"0S&KOK", 'F'},
    {"0S&KON", 'F'},
    {"0S&KOS", 'F'},
    {"0S&KOV", 'F'},
    {"0S&KSO", 'F'},
    {"0S&KVO", 'F'},
    {"0S&N", 'F'},
    {"0S&N&(", 'F'},
    {"0S&N&1", 'F'},
    {"0S&N&F", 'F'},
    {"0S&N&N", 'F'},
    {"0S&N&S", 'F'},
    {"0S&N&V", 'F'},
    {"0S&N)&", 'F'},
    {"0S&N))", 'F'},
    {"0S&N)U", 'F'},
    {"0S&N;", 'F'},
    {"0S&N;C", 'F'},
    {"0S&N;E", 'F'},
    {"0S&N;T", 'F'},
    {"0S&NB(", 'F'},
    {"0S&NB1", 'F'},
    {"0S&NBF", 'F'},
    {"0S&NBN", 'F'},
    {"0S&NBS", 'F'},
    {"0S&NBV", 'F'},
    {"0S&NC", 'F'},
    {"0S&NEN", 'F'},
    {"0S&NF(", 'F'},
    {"0S&NK(", 'F'},
    {"0S&NK1", 'F'},
    {"0S&NKF", 'F'},
    {"0S&NKN", 'F'},
    {"0S&NKS", 'F'},
    {"0S&NKV", 'F'},
    {"0S&NO(", 'F'},
    {"0S&NOF", 'F'},
    {"0S&NOS", 'F'},
    {"0S&NOV", 'F'},
    {"0S&NTN", 'F'},
    {"0S&NU", 'F'},
    {"0S&NU(", 'F'},
    {"0S&NU;", 'F'},
    {"0S&NUC", 'F'},
    {"0S&NUE", 'F'},
    {"0S&S", 'F'},
    {"0S&S&(", 'F'},
    {"0S&S&1", 'F'},
    {"0S&S&F", 'F'},
    {"0S&S&N", 'F'},
    {"0S&S&S", 'F'},
    {"0S&S&V", 'F'},
    {"0S&S)&", 'F'},
    {"0S&S))", 'F'},
    {"0S&S)U", 'F'},
    {"0S&S1", 'F'},
    {"0S&S1;", 'F'},
    {"0S&S1C", 'F'},
    {"0S&S1O", 'F'},
    {"0S&S;", 'F'},
    {"0S&S;C", 'F'},
    {"0S&S;E", 'F'},
    {"0S&S;T", 'F'},
    {"0S&SB(", 'F'},
    {"0S&SB1", 'F'},
    {"0S&SBF", 'F'},
    {"0S&SBN", 'F'},
    {"0S&SBS", 'F'},
    {"0S&SBV", 'F'},
    {"0S&SC", 'F'},
    {"0S&SEK", 'F'},
    {"0S&SEN", 'F'},
    {"0S&SF(", 'F'},
    {"0S&SK(", 'F'},
    {"0S&SK1", 'F'},
    {"0S&SKF", 'F'},
    {"0S&SKN", 'F'},
    {"0S&SKS", 'F'},
    {"0S&SKV", 'F'},
    {"0S&SO(", 'F'},
    {"0S&SO1", 'F'},
    {"0S&SOF", 'F'},
    {"0S&SON", 'F'},
    {"0S&SOO", 'F'},
    {"0S&SOS", 'F'},
    {"0S&SOV", 'F'},
    {"0S&STN", 'F'},
    {"0S&SU", 'F'},
    {"0S&SU(", 'F'},
    {"0S&SU;", 'F'},
    {"0S&SUC", 'F'},
    {"0S&SUE", 'F'},
    {"0S&SV", 'F'},
    {"0S&SV;", 'F'},
    {"0S&SVC", 'F'},
    {"0S&SVO", 'F'},
    {"0S&V", 'F'},
    {"0S&V&(", 'F'},
    {"0S&V&1", 'F'},
    {"0S&V&F", 'F'},
    {"0S&V&N", 'F'},
    {"0S&V&S", 'F'},
    {"0S&V&V", 'F'},
    {"0S&V)&", 'F'},
    {"0S&V))", 'F'},
    {"0S&V)U", 'F'},
    {"0S&V;", 'F'},
    {"0S&V;C", 'F'},
    {"0S&V;E", 'F'},
    {"0S&V;T", 'F'},
    {"0S&VB(", 'F'},
    {"0S&VB1", 'F'},
    {"0S&VBF", 'F'},
    {"0S&VBN", 'F'},
    {"0S&VBS", 'F'},
    {"0S&VBV", 'F'},
    {"0S&VC", 'F'},
    {"0S&VEK", 'F'},
    {"0S&VEN", 'F'},
    {"0S&VF(", 'F'},
    {"0S&VK(", 'F'},
    {"0S&VK1", 'F'},
    {"0S&VKF", 'F'},
    {"0S&VKN", 'F'},
    {"0S&VKS", 'F'},
    {"0S&VKV", 'F'},
    {"0S&VO(", 'F'},
    {"0S&VOF", 'F'},
    {"0S&VOO", 'F'},
    {"0S&VOS", 'F'},
    {"0S&VS", 'F'},
    {"0S&VS;", 'F'},
    {"0S&VSC", 'F'},
    {"0S&VSO", 'F'},
    {"0S&VTN", 'F'},
    {"0S&VU", 'F'},
    {"0S&VU(", 'F'},
    {"0S&VU;", 'F'},
    {"0S&VUC", 'F'},
    {"0S&VUE", 'F'},
    {"0S((((", 'F'},
    {"0S(((E", 'F'},
    {"0S(((U", 'F'},
    {"0S((EK", 'F'},
    {"0S((EN", 'F'},
    {"0S((U(", 'F'},
    {"0S(EKN", 'F'},
    {"0S(ENK", 'F'},
    {"0S(U((", 'F'},
    {"0S(U(E", 'F'},
    {"0S)&((", 'F'},
    {"0S)&(1", 'F'},
    {"0S)&(E", 'F'},
    {"0S)&(F", 'F'},
    {"0S)&(N", 'F'},
    {"0S)&(S", 'F'},
    {"0S)&(V", 'F'},
    {"0S)&1", 'F'},
    {"0S)&1&", 'F'},
    {"0S)&1)", 'F'},
    {"0S)&1;", 'F'},
    {"0S)&1B", 'F'},
    {"0S)&1C", 'F'},
    {"0S)&1F", 'F'},
    {"0S)&1O", 'F'},
    {"0S)&1U", 'F'},
    {"0S)&F(", 'F'},
    {"0S)&N", 'F'},
    {"0S)&N&", 'F'},
    {"0S)&N)", 'F'},
    {"0S)&N;", 'F'},
    {"0S)&NB", 'F'},
    {"0S)&NC", 'F'},
    {"0S)&NF", 'F'},
    {"0S)&NO", 'F'},
    {"0S)&NU", 'F'},
    {"0S)&S", 'F'},
    {"0S)&S&", 'F'},
    {"0S)&S)", 'F'},
    {"0S)&S;", 'F'},
    {"0S)&SB", 'F'},
    {"0S)&SC", 'F'},
    {"0S)&SF", 'F'},
    {"0S)&SO", 'F'},
    {"0S)&SU", 'F'},
    {"0S)&V", 'F'},
    {"0S)&V&", 'F'},
    {"0S)&V)", 'F'},
    {"0S)&V;", 'F'},
    {"0S)&VB", 'F'},
    {"0S)&VC", 'F'},
    {"0S)&VF", 'F'},
    {"0S)&VO", 'F'},
    {"0S)&VU", 'F'},
    {"0S))&(", 'F'},
    {"0S))&1", 'F'},
    {"0S))&F", 'F'},
    {"0S))&N", 'F'},
    {"0S))&S", 'F'},
    {"0S))&V", 'F'},
    {"0S)))&", 'F'},
    {"0S))))", 'F'},
    {"0S))),", 'F'},
    {"0S)));", 'F'},
    {"0S)))B", 'F'},
    {"0S)))E", 'F'},
    {"0S)))K", 'F'},
    {"0S)))O", 'F'},
    {"0S)))U", 'F'},
    {"0S)),(", 'F'},
    {"0S));E", 'F'},
    {"0S));T", 'F'},
    {"0S))B(", 'F'},
    {"0S))B1", 'F'},
    {"0S))BF", 'F'},
    {"0S))BN", 'F'},
    {"0S))BS", 'F'},
    {"0S))BV", 'F'},
    {"0S))E(", 'F'},
    {"0S))E1", 'F'},
    {"0S))EF", 'F'},
    {"0S))EK", 'F'},
    {"0S))EN", 'F'},
    {"0S))ES", 'F'},
    {"0S))EV", 'F'},
    {"0S))K(", 'F'},
    {"0S))K1", 'F'},
    {"0S))KB", 'F'},
    {"0S))KF", 'F'},
    {"0S))KN", 'F'},
    {"0S))KS", 'F'},
    {"0S))KU", 'F'},
    {"0S))KV", 'F'},
    {"0S))O(", 'F'},
    {"0S))O1", 'F'},
    {"0S))OF", 'F'},
    {"0S))ON", 'F'},
    {"0S))OS", 'F'},
    {"0S))OV", 'F'},
    {"0S))U(", 'F'},
    {"0S))UE", 'F'},
    {"0S),((", 'F'},
    {"0S),(1", 'F'},
    {"0S),(F", 'F'},
    {"0S),(N", 'F'},
    {"0S),(S", 'F'},
    {"0S),(V", 'F'},
    {"0S);E(", 'F'},
    {"0S);E1", 'F'},
    {"0S);EF", 'F'},
    {"0S);EK", 'F'},
    {"0S);EN", 'F'},
    {"0S);EO", 'F'},
    {"0S);ES", 'F'},
    {"0S);EV", 'F'},
    {"0S);T(", 'F'},
    {"0S);T1", 'F'},
    {"0S);TF", 'F'},
    {"0S);TK", 'F'},
    {"0S);TN", 'F'},
    {"0S);TO", 'F'},
    {"0S);TS", 'F'},
    {"0S);TV", 'F'},
    {"0S)B((", 'F'},
    {"0S)B(1", 'F'},
    {"0S)B(F", 'F'},
    {"0S)B(N", 'F'},
    {"0S)B(S", 'F'},
    {"0S)B(V", 'F'},
    {"0S)B1", 'F'},
    {"0S)B1&", 'F'},
    {"0S)B1;", 'F'},
    {"0S)B1C", 'F'},
    {"0S)B1K", 'F'},
    {"0S)B1N", 'F'},
    {"0S)B1O", 'F'},
    {"0S)B1U", 'F'},
    {"0S)BF(", 'F'},
    {"0S)BN", 'F'},
    {"0S)BN&", 'F'},
    {"0S)BN;", 'F'},
    {"0S)BNC", 'F'},
    {"0S)BNK", 'F'},
    {"0S)BNO", 'F'},
    {"0S)BNU", 'F'},
    {"0S)BS", 'F'},
    {"0S)BS&", 'F'},
    {"0S)BS;", 'F'},
    {"0S)BSC", 'F'},
    {"0S)BSK", 'F'},
    {"0S)BSO", 'F'},
    {"0S)BSU", 'F'},
    {"0S)BV", 'F'},
    {"0S)BV&", 'F'},
    {"0S)BV;", 'F'},
    {"0S)BVC", 'F'},
    {"0S)BVK", 'F'},
    {"0S)BVO", 'F'},
    {"0S)BVU", 'F'},
    {"0S)E((", 'F'},
    {"0S)E(1", 'F'},
    {"0S)E(F", 'F'},
    {"0S)E(N", 'F'},
    {"0S)E(S", 'F'},
    {"0S)E(V", 'F'},
    {"0S)E1C", 'F'},
    {"0S)E1O", 'F'},
    {"0S)EF(", 'F'},
    {"0S)EK(", 'F'},
    {"0S)EK1", 'F'},
    {"0S)EKF", 'F'},
    {"0S)EKN", 'F'},
    {"0S)EKS", 'F'},
    {"0S)EKV", 'F'},
    {"0S)ENC", 'F'},
    {"0S)ENO", 'F'},
    {"0S)ESC", 'F'},
    {"0S)ESO", 'F'},
    {"0S)EVC", 'F'},
    {"0S)EVO", 'F'},
    {"0S)K((", 'F'},
    {"0S)K(1", 'F'},
    {"0S)K(F", 'F'},
    {"0S)K(N", 'F'},
    {"0S)K(S", 'F'},
    {"0S)K(V", 'F'},
    {"0S)K1&", 'F'},
    {"0S)K1;", 'F'},
    {"0S)K1B", 'F'},
    {"0S)K1E", 'F'},
    {"0S)K1O", 'F'},
    {"0S)K1U", 'F'},
    {"0S)KB(", 'F'},
    {"0S)KB1", 'F'},
    {"0S)KBF", 'F'},
    {"0S)KBN", 'F'},
    {"0S)KBS", 'F'},
    {"0S)KBV", 'F'},
    {"0S)KF(", 'F'},
    {"0S)KN&", 'F'},
    {"0S)KN;", 'F'},
    {"0S)KNB", 'F'},
    {"0S)KNE", 'F'},
    {"0S)KNK", 'F'},
    {"0S)KNU", 'F'},
    {"0S)KS&", 'F'},
    {"0S)KS;", 'F'},
    {"0S)KSB", 'F'},
    {"0S)KSE", 'F'},
    {"0S)KSO", 'F'},
    {"0S)KSU", 'F'},
    {"0S)KUE", 'F'},
    {"0S)KV&", 'F'},
    {"0S)KV;", 'F'},
    {"0S)KVB", 'F'},
    {"0S)KVE", 'F'},
    {"0S)KVO", 'F'},
    {"0S)KVU", 'F'},
    {"0S)O((", 'F'},
    {"0S)O(1", 'F'},
    {"0S)O(E", 'F'},
    {"0S)O(F", 'F'},
    {"0S)O(N", 'F'},
    {"0S)O(S", 'F'},
    {"0S)O(V", 'F'},
    {"0S)O1", 'F'},
    {"0S)O1&", 'F'},
    {"0S)O1)", 'F'},
    {"0S)O1;", 'F'},
    {"0S)O1B", 'F'},
    {"0S)O1C", 'F'},
    {"0S)O1K", 'F'},
    {"0S)O1O", 'F'},
    {"0S)O1U", 'F'},
    {"0S)OF(", 'F'},
    {"0S)ON", 'F'},
    {"0S)ON&", 'F'},
    {"0S)ON)", 'F'},
    {"0S)ON;", 'F'},
    {"0S)ONB", 'F'},
    {"0S)ONC", 'F'},
    {"0S)ONK", 'F'},
    {"0S)ONO", 'F'},
    {"0S)ONU", 'F'},
    {"0S)OS", 'F'},
    {"0S)OS&", 'F'},
    {"0S)OS)", 'F'},
    {"0S)OS;", 'F'},
    {"0S)OSB", 'F'},
    {"0S)OSC", 'F'},
    {"0S)OSK", 'F'},
    {"0S)OSO", 'F'},
    {"0S)OSU", 'F'},
    {"0S)OV", 'F'},
    {"0S)OV&", 'F'},
    {"0S)OV)", 'F'},
    {"0S)OV;", 'F'},
    {"0S)OVB", 'F'},
    {"0S)OVC", 'F'},
    {"0S)OVK", 'F'},
    {"0S)OVO", 'F'},
    {"0S)OVU", 'F'},
    {"0S)U((", 'F'},
    {"0S)U(E", 'F'},
    {"0S)UE(", 'F'},
    {"0S)UE1", 'F'},
    {"0S)UEF", 'F'},
    {"0S)UEK", 'F'},
    {"0S)UEN", 'F'},
    {"0S)UES", 'F'},
    {"0S)UEV", 'F'},
    {"0S,(((", 'F'},
    {"0S,((1", 'F'},
    {"0S,((E", 'F'},
    {"0S,((F", 'F'},
    {"0S,((N", 'F'},
    {"0S,((S", 'F'},
    {"0S,((V", 'F'},
    {"0S,(1)", 'F'},
    {"0S,(1O", 'F'},
    {"0S,(E(", 'F'},
    {"0S,(E1", 'F'},
    {"0S,(EF", 'F'},
    {"0S,(EK", 'F'},
    {"0S,(EN", 'F'},
    {"0S,(ES", 'F'},
    {"0S,(EV", 'F'},
    {"0S,(F(", 'F'},
    {"0S,(N)", 'F'},
    {"0S,(NO", 'F'},
    {"0S,(S)", 'F'},
    {"0S,(SO", 'F'},
    {"0S,(V)", 'F'},
    {"0S,(VO", 'F'},
    {"0S,F((", 'F'},
    {"0S,F()", 'F'},
    {"0S,F(1", 'F'},
    {"0S,F(F", 'F'},
    {"0S,F(N", 'F'},
    {"0S,F(S", 'F'},
    {"0S,F(T", 'F'},
    {"0S,F(V", 'F'},
    {"0S,V))", 'F'},
    {"0S,V),", 'F'},
    {"0S,V)O", 'F'},
    {"0S,VB(", 'F'},
    {"0S,VB1", 'F'},
    {"0S,VBF", 'F'},
    {"0S,VBN", 'F'},
    {"0S,VBS", 'F'},
    {"0S,VBV", 'F'},
    {"0S,VO(", 'F'},
    {"0S,VOF", 'F'},
    {"0S,VOS", 'F'},
    {"0S,VUE", 'F'},
    {"0S1F((", 'F'},
    {"0S1F()", 'F'},
    {"0S1F(1", 'F'},
    {"0S1F(F", 'F'},
    {"0S1F(N", 'F'},
    {"0S1F(S", 'F'},
    {"0S1F(V", 'F'},
    {"0S1NC", 'F'},
    {"0S1NO(", 'F'},
    {"0S1NOF", 'F'},
    {"0S1NOS", 'F'},
    {"0S1NOV", 'F'},
    {"0S1O((", 'F'},
    {"0S1O(1", 'F'},
    {"0S1O(F", 'F'},
    {"0S1O(N", 'F'},
    {"0S1O(S", 'F'},
    {"0S1O(V", 'F'},
    {"0S1OF(", 'F'},
    {"0S1OS(", 'F'},
    {"0S1OS1", 'F'},
    {"0S1OSF", 'F'},
    {"0S1OSO", 'F'},
    {"0S1OSU", 'F'},
    {"0S1OSV", 'F'},
    {"0S1OV(", 'F'},
    {"0S1OVF", 'F'},
    {"0S1OVO", 'F'},
    {"0S1OVS", 'F'},
    {"0S1OVU", 'F'},
    {"0S1S;", 'F'},
    {"0S1S;C", 'F'},
    {"0S1SC", 'F'},
    {"0S1UE", 'F'},
    {"0S1UE;", 'F'},
    {"0S1UEC", 'F'},
    {"0S1UEK", 'F'},
    {"0S1V", 'F'},
    {"0S1V;", 'F'},
    {"0S1V;C", 'F'},
    {"0S1VC", 'F'},
    {"0S1VO(", 'F'},
    {"0S1VOF", 'F'},
    {"0S1VOS", 'F'},
    {"0S;E((", 'F'},
    {"0S;E(1", 'F'},
    {"0S;E(E", 'F'},
    {"0S;E(F", 'F'},
    {"0S;E(N", 'F'},
    {"0S;E(S", 'F'},
    {"0S;E(V", 'F'},
    {"0S;E1,", 'F'},
    {"0S;E1;", 'F'},
    {"0S;E1C", 'F'},
    {"0S;E1O", 'F'},
    {"0S;E1T", 'F'},
    {"0S;EF(", 'F'},
    {"0S;EK(", 'F'},
    {"0S;EK1", 'F'},
    {"0S;EKF", 'F'},
    {"0S;EKN", 'F'},
    {"0S;EKO", 'F'},
    {"0S;EKS", 'F'},
    {"0S;EKV", 'F'},
    {"0S;EN,", 'F'},
    {"0S;EN;", 'F'},
    {"0S;ENC", 'F'},
    {"0S;ENK", 'F'},
    {"0S;ENO", 'F'},
    {"0S;ENT", 'F'},
    {"0S;EO(", 'F'},
    {"0S;ES,", 'F'},
    {"0S;ES;", 'F'},
    {"0S;ESC", 'F'},
    {"0S;ESO", 'F'},
    {"0S;EST", 'F'},
    {"0S;EV,", 'F'},
    {"0S;EV;", 'F'},
    {"0S;EVC", 'F'},
    {"0S;EVO", 'F'},
    {"0S;EVT", 'F'},
    {"0S;N:T", 'F'},
    {"0S;T((", 'F'},
    {"0S;T(1", 'F'},
    {"0S;T(E", 'F'},
    {"0S;T(F", 'F'},
    {"0S;T(N", 'F'},
    {"0S;T(S", 'F'},
    {"0S;T(V", 'F'},
    {"0S;T1,", 'F'},
    {"0S;T1;", 'F'},
    {"0S;T1C", 'F'},
    {"0S;T1F", 'F'},
    {"0S;T1O", 'F'},
    {"0S;T1T", 'F'},
    {"0S;T;", 'F'},
    {"0S;T;C", 'F'},
    {"0S;TF(", 'F'},
    {"0S;TK(", 'F'},
    {"0S;TK1", 'F'},
    {"0S;TKF", 'F'},
    {"0S;TKK", 'F'},
    {"0S;TKN", 'F'},
    {"0S;TKO", 'F'},
    {"0S;TKS", 'F'},
    {"0S;TKV", 'F'},
    {"0S;TN(", 'F'},
    {"0S;TN,", 'F'},
    {"0S;TN1", 'F'},
    {"0S;TN;", 'F'},
    {"0S;TNC", 'F'},
    {"0S;TNE", 'F'},
    {"0S;TNF", 'F'},
    {"0S;TNK", 'F'},
    {"0S;TNN", 'F'},
    {"0S;TNO", 'F'},
    {"0S;TNS", 'F'},
    {"0S;TNT", 'F'},
    {"0S;TNV", 'F'},
    {"0S;TO(", 'F'},
    {"0S;TS,", 'F'},
    {"0S;TS;", 'F'},
    {"0S;TSC", 'F'},
    {"0S;TSF", 'F'},
    {"0S;TSO", 'F'},
    {"0S;TST", 'F'},
    {"0S;TT(", 'F'},
    {"0S;TT1", 'F'},
    {"0S;TTF", 'F'},
    {"0S;TTN", 'F'},
    {"0S;TTS", 'F'},
    {"0S;TTV", 'F'},
    {"0S;TV,", 'F'},
    {"0S;TV;", 'F'},
    {"0S;TVC", 'F'},
    {"0S;TVF", 'F'},
    {"0S;TVO", 'F'},
    {"0S;TVT", 'F'},
    {"0SA(((", 'F'},
    {"0SA((1", 'F'},
    {"0SA((F", 'F'},
    {"0SA((N", 'F'},
    {"0SA((S", 'F'},
    {"0SA((V", 'F'},
    {"0SA(F(", 'F'},
    {"0SA(N)", 'F'},
    {"0SA(NO", 'F'},
    {"0SA(S)", 'F'},
    {"0SA(SO", 'F'},
    {"0SA(V)", 'F'},
    {"0SA(VO", 'F'},
    {"0SAF((", 'F'},
    {"0SAF()", 'F'},
    {"0SAF(1", 'F'},
    {"0SAF(F", 'F'},
    {"0SAF(N", 'F'},
    {"0SAF(S", 'F'},
    {"0SAF(V", 'F'},
    {"0SASO(", 'F'},
    {"0SASO1", 'F'},
    {"0SASOF", 'F'},
    {"0SASON", 'F'},
    {"0SASOS", 'F'},
    {"0SASOV", 'F'},
    {"0SASUE", 'F'},
    {"0SATO(", 'F'},
    {"0SATO1", 'F'},
    {"0SATOF", 'F'},
    {"0SATON", 'F'},
    {"0SATOS", 'F'},
    {"0SATOV", 'F'},
    {"0SATUE", 'F'},
    {"0SAVO(", 'F'},
    {"0SAVOF", 'F'},
    {"0SAVOS", 'F'},
    {"0SAVUE", 'F'},
    {"0SB(((", 'F'},
    {"0SB((1", 'F'},
    {"0SB((F", 'F'},
    {"0SB((N", 'F'},
    {"0SB((S", 'F'},
    {"0SB((V", 'F'},
    {"0SB(1)", 'F'},
    {"0SB(1O", 'F'},
    {"0SB(F(", 'F'},
    {"0SB(N)", 'F'},
    {"0SB(NO", 'F'},
    {"0SB(S)", 'F'},
    {"0SB(SO", 'F'},
    {"0SB(V)", 'F'},
    {"0SB(VO", 'F'},
    {"0SB1", 'F'},
    {"0SB1&(", 'F'},
    {"0SB1&1", 'F'},
    {"0SB1&F", 'F'},
    {"0SB1&N", 'F'},
    {"0SB1&S", 'F'},
    {"0SB1&V", 'F'},
    {"0SB1,(", 'F'},
    {"0SB1,F", 'F'},
    {"0SB1,V", 'F'},
    {"0SB1;", 'F'},
    {"0SB1;C", 'F'},
    {"0SB1B(", 'F'},
    {"0SB1B1", 'F'},
    {"0SB1BF", 'F'},
    {"0SB1BN", 'F'},
    {"0SB1BS", 'F'},
    {"0SB1BV", 'F'},
    {"0SB1C", 'F'},
    {"0SB1K(", 'F'},
    {"0SB1K1", 'F'},
    {"0SB1KF", 'F'},
    {"0SB1KN", 'F'},
    {"0SB1KS", 'F'},
    {"0SB1KV", 'F'},
    {"0SB1O(", 'F'},
    {"0SB1OF", 'F'},
    {"0SB1OS", 'F'},
    {"0SB1OV", 'F'},
    {"0SB1U(", 'F'},
    {"0SB1UE", 'F'},
    {"0SBE((", 'F'},
    {"0SBE(1", 'F'},
    {"0SBE(F", 'F'},
    {"0SBE(N", 'F'},
    {"0SBE(S", 'F'},
    {"0SBE(V", 'F'},
    {"0SBEK(", 'F'},
    {"0SBF((", 'F'},
    {"0SBF()", 'F'},
    {"0SBF(1", 'F'},
    {"0SBF(F", 'F'},
    {"0SBF(N", 'F'},
    {"0SBF(S", 'F'},
    {"0SBF(V", 'F'},
    {"0SBN", 'F'},
    {"0SBN&(", 'F'},
    {"0SBN&1", 'F'},
    {"0SBN&F", 'F'},
    {"0SBN&N", 'F'},
    {"0SBN&S", 'F'},
    {"0SBN&V", 'F'},
    {"0SBN,(", 'F'},
    {"0SBN,F", 'F'},
    {"0SBN,V", 'F'},
    {"0SBN;", 'F'},
    {"0SBN;C", 'F'},
    {"0SBNB(", 'F'},
    {"0SBNB1", 'F'},
    {"0SBNBF", 'F'},
    {"0SBNBN", 'F'},
    {"0SBNBS", 'F'},
    {"0SBNBV", 'F'},
    {"0SBNC", 'F'},
    {"0SBNK(", 'F'},
    {"0SBNK1", 'F'},
    {"0SBNKF", 'F'},
    {"0SBNKN", 'F'},
    {"0SBNKS", 'F'},
    {"0SBNKV", 'F'},
    {"0SBNO(", 'F'},
    {"0SBNOF", 'F'},
    {"0SBNOS", 'F'},
    {"0SBNOV", 'F'},
    {"0SBNU(", 'F'},
    {"0SBNUE", 'F'},
    {"0SBS", 'F'},
    {"0SBS&(", 'F'},
    {"0SBS&1", 'F'},
    {"0SBS&F", 'F'},
    {"0SBS&N", 'F'},
    {"0SBS&S", 'F'},
    {"0SBS&V", 'F'},
    {"0SBS,(", 'F'},
    {"0SBS,F", 'F'},
    {"0SBS,V", 'F'},
    {"0SBS;", 'F'},
    {"0SBS;C", 'F'},
    {"0SBSB(", 'F'},
    {"0SBSB1", 'F'},
    {"0SBSBF", 'F'},
    {"0SBSBN", 'F'},
    {"0SBSBS", 'F'},
    {"0SBSBV", 'F'},
    {"0SBSC", 'F'},
    {"0SBSK(", 'F'},
    {"0SBSK1", 'F'},
    {"0SBSKF", 'F'},
    {"0SBSKN", 'F'},
    {"0SBSKS", 'F'},
    {"0SBSKV", 'F'},
    {"0SBSO(", 'F'},
    {"0SBSO1", 'F'},
    {"0SBSOF", 'F'},
    {"0SBSON", 'F'},
    {"0SBSOS", 'F'},
    {"0SBSOV", 'F'},
    {"0SBSU(", 'F'},
    {"0SBSUE", 'F'},
    {"0SBV", 'F'},
    {"0SBV&(", 'F'},
    {"0SBV&1", 'F'},
    {"0SBV&F", 'F'},
    {"0SBV&N", 'F'},
    {"0SBV&S", 'F'},
    {"0SBV&V", 'F'},
    {"0SBV,(", 'F'},
    {"0SBV,1", 'F'},
    {"0SBV,F", 'F'},
    {"0SBV,N", 'F'},
    {"0SBV,S", 'F'},
    {"0SBV,V", 'F'},
    {"0SBV;", 'F'},
    {"0SBV;C", 'F'},
    {"0SBVB(", 'F'},
    {"0SBVB1", 'F'},
    {"0SBVBF", 'F'},
    {"0SBVBN", 'F'},
    {"0SBVBS", 'F'},
    {"0SBVBV", 'F'},
    {"0SBVC", 'F'},
    {"0SBVK(", 'F'},
    {"0SBVK1", 'F'},
    {"0SBVKF", 'F'},
    {"0SBVKN", 'F'},
    {"0SBVKS", 'F'},
    {"0SBVKV", 'F'},
    {"0SBVO(", 'F'},
    {"0SBVOF", 'F'},
    {"0SBVOS", 'F'},
    {"0SBVU(", 'F'},
    {"0SBVUE", 'F'},
    {"0SC", 'F'},
    {"0SE(((", 'F'},
    {"0SE((1", 'F'},
    {"0SE((F", 'F'},
    {"0SE((N", 'F'},
    {"0SE((S", 'F'},
    {"0SE((V", 'F'},
    {"0SE(1)", 'F'},
    {"0SE(1O", 'F'},
    {"0SE(F(", 'F'},
    {"0SE(N)", 'F'},
    {"0SE(NO", 'F'},
    {"0SE(S)", 'F'},
    {"0SE(SO", 'F'},
    {"0SE(V)", 'F'},
    {"0SE(VO", 'F'},
    {"0SE1C", 'F'},
    {"0SE1O(", 'F'},
    {"0SE1OF", 'F'},
    {"0SE1OS", 'F'},
    {"0SE1OV", 'F'},
    {"0SE1UE", 'F'},
    {"0SEF((", 'F'},
    {"0SEF()", 'F'},
    {"0SEF(1", 'F'},
    {"0SEF(F", 'F'},
    {"0SEF(N", 'F'},
    {"0SEF(S", 'F'},
    {"0SEF(V", 'F'},
    {"0SEK((", 'F'},
    {"0SEK(1", 'F'},
    {"0SEK(E", 'F'},
    {"0SEK(F", 'F'},
    {"0SEK(N", 'F'},
    {"0SEK(S", 'F'},
    {"0SEK(V", 'F'},
    {"0SEK1C", 'F'},
    {"0SEK1O", 'F'},
    {"0SEK1U", 'F'},
    {"0SEKF(", 'F'},
    {"0SEKNC", 'F'},
    {"0SEKNE", 'F'},
    {"0SEKNU", 'F'},
    {"0SEKOK", 'F'},
    {"0SEKSC", 'F'},
    {"0SEKSO", 'F'},
    {"0SEKSU", 'F'},
    {"0SEKU(", 'F'},
    {"0SEKU1", 'F'},
    {"0SEKUE", 'F'},
    {"0SEKUF", 'F'},
    {"0SEKUN", 'F'},
    {"0SEKUS", 'F'},
    {"0SEKUV", 'F'},
    {"0SEKVC", 'F'},
    {"0SEKVO", 'F'},
    {"0SEKVU", 'F'},
    {"0SENC", 'F'},
    {"0SENEN", 'F'},
    {"0SENO(", 'F'},
    {"0SENOF", 'F'},
    {"0SENOS", 'F'},
    {"0SENOV", 'F'},
    {"0SENUE", 'F'},
    {"0SEOKN", 'F'},
    {"0SESC", 'F'},
    {"0SESO(", 'F'},
    {"0SESO1", 'F'},
    {"0SESOF", 'F'},
    {"0SESON", 'F'},
    {"0SESOS", 'F'},
    {"0SESOV", 'F'},
    {"0SESUE", 'F'},
    {"0SEU((", 'F'},
    {"0SEU(1", 'F'},
    {"0SEU(F", 'F'},
    {"0SEU(N", 'F'},
    {"0SEU(S", 'F'},
    {"0SEU(V", 'F'},
    {"0SEU1,", 'F'},
    {"0SEU1C", 'F'},
    {"0SEU1O", 'F'},
    {"0SEUEF", 'F'},
    {"0SEUEK", 'F'},
    {"0SEUF(", 'F'},
    {"0SEUN,", 'F'},
    {"0SEUNC", 'F'},
    {"0SEUNO", 'F'},
    {"0SEUS,", 'F'},
    {"0SEUSC", 'F'},
    {"0SEUSO", 'F'},
    {"0SEUV,", 'F'},
    {"0SEUVC", 'F'},
    {"0SEUVO", 'F'},
    {"0SEVC", 'F'},
    {"0SEVO(", 'F'},
    {"0SEVOF", 'F'},
    {"0SEVOS", 'F'},
    {"0SEVUE", 'F'},
    {"0SF(((", 'F'},
    {"0SF(()", 'F'},
    {"0SF((1", 'F'},
    {"0SF((F", 'F'},
    {"0SF((N", 'F'},
    {"0SF((S", 'F'},
    {"0SF((V", 'F'},
    {"0SF())", 'F'},
    {"0SF()1", 'F'},
    {"0SF()F", 'F'},
    {"0SF()K", 'F'},
    {"0SF()N", 'F'},
    {"0SF()O", 'F'},
    {"0SF()S", 'F'},
    {"0SF()U", 'F'},
    {"0SF()V", 'F'},
    {"0SF(1)", 'F'},
    {"0SF(1N", 'F'},
    {"0SF(1O", 'F'},
    {"0SF(F(", 'F'},
    {"0SF(N)", 'F'},
    {"0SF(N,", 'F'},
    {"0SF(NO", 'F'},
    {"0SF(S)", 'F'},
    {"0SF(SO", 'F'},
    {"0SF(V)", 'F'},
    {"0SF(VO", 'F'},
    {"0SK(((", 'F'},
    {"0SK((1", 'F'},
    {"0SK((F", 'F'},
    {"0SK((N", 'F'},
    {"0SK((S", 'F'},
    {"0SK((V", 'F'},
    {"0SK(1)", 'F'},
    {"0SK(1O", 'F'},
    {"0SK(F(", 'F'},
    {"0SK(N)", 'F'},
    {"0SK(NO", 'F'},
    {"0SK(S)", 'F'},
    {"0SK(SO", 'F'},
    {"0SK(V)", 'F'},
    {"0SK(VO", 'F'},
    {"0SK)&(", 'F'},
    {"0SK)&1", 'F'},
    {"0SK)&F", 'F'},
    {"0SK)&N", 'F'},
    {"0SK)&S", 'F'},
    {"0SK)&V", 'F'},
    {"0SK))&", 'F'},
    {"0SK)))", 'F'},
    {"0SK));", 'F'},
    {"0SK))B", 'F'},
    {"0SK))E", 'F'},
    {"0SK))K", 'F'},
    {"0SK))O", 'F'},
    {"0SK))U", 'F'},
    {"0SK);E", 'F'},
    {"0SK);T", 'F'},
    {"0SK)B(", 'F'},
    {"0SK)B1", 'F'},
    {"0SK)BF", 'F'},
    {"0SK)BN", 'F'},
    {"0SK)BS", 'F'},
    {"0SK)BV", 'F'},
    {"0SK)E(", 'F'},
    {"0SK)E1", 'F'},
    {"0SK)EF", 'F'},
    {"0SK)EK", 'F'},
    {"0SK)EN", 'F'},
    {"0SK)ES", 'F'},
    {"0SK)EV", 'F'},
    {"0SK)OF", 'F'},
    {"0SK)UE", 'F'},
    {"0SK1", 'F'},
    {"0SK1&(", 'F'},
    {"0SK1&1", 'F'},
    {"0SK1&F", 'F'},
    {"0SK1&N", 'F'},
    {"0SK1&S", 'F'},
    {"0SK1&V", 'F'},
    {"0SK1;", 'F'},
    {"0SK1;C", 'F'},
    {"0SK1;E", 'F'},
    {"0SK1;T", 'F'},
    {"0SK1B(", 'F'},
    {"0SK1B1", 'F'},
    {"0SK1BF", 'F'},
    {"0SK1BN", 'F'},
    {"0SK1BS", 'F'},
    {"0SK1BV", 'F'},
    {"0SK1C", 'F'},
    {"0SK1E(", 'F'},
    {"0SK1E1", 'F'},
    {"0SK1EF", 'F'},
    {"0SK1EK", 'F'},
    {"0SK1EN", 'F'},
    {"0SK1ES", 'F'},
    {"0SK1EV", 'F'},
    {"0SK1O(", 'F'},
    {"0SK1OF", 'F'},
    {"0SK1OS", 'F'},
    {"0SK1OV", 'F'},
    {"0SK1U(", 'F'},
    {"0SK1UE", 'F'},
    {"0SKF((", 'F'},
    {"0SKF()", 'F'},
    {"0SKF(1", 'F'},
    {"0SKF(F", 'F'},
    {"0SKF(N", 'F'},
    {"0SKF(S", 'F'},
    {"0SKF(V", 'F'},
    {"0SKN", 'F'},
    {"0SKN&(", 'F'},
    {"0SKN&1", 'F'},
    {"0SKN&F", 'F'},
    {"0SKN&N", 'F'},
    {"0SKN&S", 'F'},
    {"0SKN&V", 'F'},
    {"0SKN;", 'F'},
    {"0SKN;C", 'F'},
    {"0SKN;E", 'F'},
    {"0SKN;T", 'F'},
    {"0SKNB(", 'F'},
    {"0SKNB1", 'F'},
    {"0SKNBF", 'F'},
    {"0SKNBN", 'F'},
    {"0SKNBS", 'F'},
    {"0SKNBV", 'F'},
    {"0SKNC", 'F'},
    {"0SKNE(", 'F'},
    {"0SKNE1", 'F'},
    {"0SKNEF", 'F'},
    {"0SKNEN", 'F'},
    {"0SKNES", 'F'},
    {"0SKNEV", 'F'},
    {"0SKNU(", 'F'},
    {"0SKNUE", 'F'},
    {"0SKS", 'F'},
    {"0SKS&(", 'F'},
    {"0SKS&1", 'F'},
    {"0SKS&F", 'F'},
    {"0SKS&N", 'F'},
    {"0SKS&S", 'F'},
    {"0SKS&V", 'F'},
    {"0SKS;", 'F'},
    {"0SKS;C", 'F'},
    {"0SKS;E", 'F'},
    {"0SKS;T", 'F'},
    {"0SKSB(", 'F'},
    {"0SKSB1", 'F'},
    {"0SKSBF", 'F'},
    {"0SKSBN", 'F'},
    {"0SKSBS", 'F'},
    {"0SKSBV", 'F'},
    {"0SKSC", 'F'},
    {"0SKSE(", 'F'},
    {"0SKSE1", 'F'},
    {"0SKSEF", 'F'},
    {"0SKSEK", 'F'},
    {"0SKSEN", 'F'},
    {"0SKSES", 'F'},
    {"0SKSEV", 'F'},
    {"0SKSO(", 'F'},
    {"0SKSO1", 'F'},
    {"0SKSOF", 'F'},
    {"0SKSON", 'F'},
    {"0SKSOS", 'F'},
    {"0SKSOV", 'F'},
    {"0SKSU(", 'F'},
    {"0SKSUE", 'F'},
    {"0SKUE(", 'F'},
    {"0SKUE1", 'F'},
    {"0SKUEF", 'F'},
    {"0SKUEK", 'F'},
    {"0SKUEN", 'F'},
    {"0SKUES", 'F'},
    {"0SKUEV", 'F'},
    {"0SKV", 'F'},
    {"0SKV&(", 'F'},
    {"0SKV&1", 'F'},
    {"0SKV&F", 'F'},
    {"0SKV&N", 'F'},
    {"0SKV&S", 'F'},
    {"0SKV&V", 'F'},
    {"0SKV;", 'F'},
    {"0SKV;C", 'F'},
    {"0SKV;E", 'F'},
    {"0SKV;T", 'F'},
    {"0SKVB(", 'F'},
    {"0SKVB1", 'F'},
    {"0SKVBF", 'F'},
    {"0SKVBN", 'F'},
    {"0SKVBS", 'F'},
    {"0SKVBV", 'F'},
    {"0SKVC", 'F'},
    {"0SKVE(", 'F'},
    {"0SKVE1", 'F'},
    {"0SKVEF", 'F'},
    {"0SKVEK", 'F'},
    {"0SKVEN", 'F'},
    {"0SKVES", 'F'},
    {"0SKVEV", 'F'},
    {"0SKVO(", 'F'},
    {"0SKVOF", 'F'},
    {"0SKVOS", 'F'},
    {"0SKVU(", 'F'},
    {"0SKVUE", 'F'},
    {"0SO(((", 'F'},
    {"0SO((1", 'F'},
    {"0SO((E", 'F'},
    {"0SO((F", 'F'},
    {"0SO((N", 'F'},
    {"0SO((O", 'F'},
    {"0SO((S", 'F'},
    {"0SO((T", 'F'},
    {"0SO((V", 'F'},
    {"0SO(1&", 'F'},
    {"0SO(1)", 'F'},
    {"0SO(1,", 'F'},
    {"0SO(1O", 'F'},
    {"0SO(E(", 'F'},
    {"0SO(E1", 'F'},
    {"0SO(EE", 'F'},
    {"0SO(EF", 'F'},
    {"0SO(EK", 'F'},
    {"0SO(EN", 'F'},
    {"0SO(ES", 'F'},
    {"0SO(EV", 'F'},
    {"0SO(F(", 'F'},
    {"0SO(N&", 'F'},
    {"0SO(N)", 'F'},
    {"0SO(N,", 'F'},
    {"0SO(NO", 'F'},
    {"0SO(O(", 'F'},
    {"0SO(O1", 'F'},
    {"0SO(OF", 'F'},
    {"0SO(ON", 'F'},
    {"0SO(OS", 'F'},
    {"0SO(OV", 'F'},
    {"0SO(S&", 'F'},
    {"0SO(S)", 'F'},
    {"0SO(S,", 'F'},
    {"0SO(SO", 'F'},
    {"0SO(T(", 'F'},
    {"0SO(V&", 'F'},
    {"0SO(V)", 'F'},
    {"0SO(V,", 'F'},
    {"0SO(VO", 'F'},
    {"0SO1&(", 'F'},
    {"0SO1&1", 'F'},
    {"0SO1&E", 'F'},
    {"0SO1&F", 'F'},
    {"0SO1&K", 'F'},
    {"0SO1&N", 'F'},
    {"0SO1&S", 'F'},
    {"0SO1&U", 'F'},
    {"0SO1&V", 'F'},
    {"0SO1((", 'F'},
    {"0SO1(E", 'F'},
    {"0SO1(U", 'F'},
    {"0SO1)&", 'F'},
    {"0SO1))", 'F'},
    {"0SO1),", 'F'},
    {"0SO1);", 'F'},
    {"0SO1)B", 'F'},
    {"0SO1)E", 'F'},
    {"0SO1)K", 'F'},
    {"0SO1)O", 'F'},
    {"0SO1)U", 'F'},
    {"0SO1,(", 'F'},
    {"0SO1,F", 'F'},
    {"0SO1,V", 'F'},
    {"0SO1;", 'F'},
    {"0SO1;C", 'F'},
    {"0SO1;E", 'F'},
    {"0SO1;N", 'F'},
    {"0SO1;T", 'F'},
    {"0SO1A(", 'F'},
    {"0SO1AF", 'F'},
    {"0SO1AS", 'F'},
    {"0SO1AT", 'F'},
    {"0SO1AV", 'F'},
    {"0SO1B(", 'F'},
    {"0SO1B1", 'F'},
    {"0SO1BE", 'F'},
    {"0SO1BF", 'F'},
    {"0SO1BN", 'F'},
    {"0SO1BS", 'F'},
    {"0SO1BV", 'F'},
    {"0SO1C", 'F'},
    {"0SO1E(", 'F'},
    {"0SO1E1", 'F'},
    {"0SO1EF", 'F'},
    {"0SO1EK", 'F'},
    {"0SO1EN", 'F'},
    {"0SO1EO", 'F'},
    {"0SO1ES", 'F'},
    {"0SO1EU", 'F'},
    {"0SO1EV", 'F'},
    {"0SO1F(", 'F'},
    {"0SO1K(", 'F'},
    {"0SO1K)", 'F'},
    {"0SO1K1", 'F'},
    {"0SO1KB", 'F'},
    {"0SO1KF", 'F'},
    {"0SO1KN", 'F'},
    {"0SO1KS", 'F'},
    {"0SO1KU", 'F'},
    {"0SO1KV", 'F'},
    {"0SO1N&", 'F'},
    {"0SO1N(", 'F'},
    {"0SO1N,", 'F'},
    {"0SO1NE", 'F'},
    {"0SO1NF", 'F'},
    {"0SO1NO", 'F'},
    {"0SO1NU", 'F'},
    {"0SO1O(", 'F'},
    {"0SO1OF", 'F'},
    {"0SO1OK", 'F'},
    {"0SO1OS", 'F'},
    {"0SO1OT", 'F'},
    {"0SO1OU", 'F'},
    {"0SO1OV", 'F'},
    {"0SO1S(", 'F'},
    {"0SO1SF", 'F'},
    {"0SO1SU", 'F'},
    {"0SO1SV", 'F'},
    {"0SO1U", 'F'},
    {"0SO1U(", 'F'},
    {"0SO1U1", 'F'},
    {"0SO1U;", 'F'},
    {"0SO1UC", 'F'},
    {"0SO1UE", 'F'},
    {"0SO1UF", 'F'},
    {"0SO1UK", 'F'},
    {"0SO1UN", 'F'},
    {"0SO1UO", 'F'},
    {"0SO1US", 'F'},
    {"0SO1UT", 'F'},
    {"0SO1UV", 'F'},
    {"0SO1V(", 'F'},
    {"0SO1VF", 'F'},
    {"0SO1VO", 'F'},
    {"0SO1VS", 'F'},
    {"0SO1VU", 'F'},
    {"0SOF((", 'F'},
    {"0SOF()", 'F'},
    {"0SOF(1", 'F'},
    {"0SOF(E", 'F'},
    {"0SOF(F", 'F'},
    {"0SOF(N", 'F'},
    {"0SOF(S", 'F'},
    {"0SOF(V", 'F'},
    {"0SOK&(", 'F'},
    {"0SOK&1", 'F'},
    {"0SOK&F", 'F'},
    {"0SOK&N", 'F'},
    {"0SOK&S", 'F'},
    {"0SOK&V", 'F'},
    {"0SOK((", 'F'},
    {"0SOK(1", 'F'},
    {"0SOK(F", 'F'},
    {"0SOK(N", 'F'},
    {"0SOK(S", 'F'},
    {"0SOK(V", 'F'},
    {"0SOK1C", 'F'},
    {"0SOK1O", 'F'},
    {"0SOKF(", 'F'},
    {"0SOKNC", 'F'},
    {"0SOKO(", 'F'},
    {"0SOKO1", 'F'},
    {"0SOKOF", 'F'},
    {"0SOKON", 'F'},
    {"0SOKOS", 'F'},
    {"0SOKOV", 'F'},
    {"0SOKSC", 'F'},
    {"0SOKSO", 'F'},
    {"0SOKVC", 'F'},
    {"0SOKVO", 'F'},
    {"0SON&(", 'F'},
    {"0SON&1", 'F'},
    {"0SON&E", 'F'},
    {"0SON&F", 'F'},
    {"0SON&K", 'F'},
    {"0SON&N", 'F'},
    {"0SON&S", 'F'},
    {"0SON&U", 'F'},
    {"0SON&V", 'F'},
    {"0SON((", 'F'},
    {"0SON(1", 'F'},
    {"0SON(E", 'F'},
    {"0SON(F", 'F'},
    {"0SON(S", 'F'},
    {"0SON(U", 'F'},
    {"0SON(V", 'F'},
    {"0SON)&", 'F'},
    {"0SON))", 'F'},
    {"0SON),", 'F'},
    {"0SON);", 'F'},
    {"0SON)B", 'F'},
    {"0SON)E", 'F'},
    {"0SON)K", 'F'},
    {"0SON)O", 'F'},
    {"0SON)U", 'F'},
    {"0SON,(", 'F'},
    {"0SON,F", 'F'},
    {"0SON,V", 'F'},
    {"0SON1(", 'F'},
    {"0SON1F", 'F'},
    {"0SON1N", 'F'},
    {"0SON1O", 'F'},
    {"0SON1S", 'F'},
    {"0SON1U", 'F'},
    {"0SON1V", 'F'},
    {"0SON;", 'F'},
    {"0SON;C", 'F'},
    {"0SON;E", 'F'},
    {"0SON;N", 'F'},
    {"0SON;T", 'F'},
    {"0SONA(", 'F'},
    {"0SONAF", 'F'},
    {"0SONAS", 'F'},
    {"0SONAT", 'F'},
    {"0SONAV", 'F'},
    {"0SONB(", 'F'},
    {"0SONB1", 'F'},
    {"0SONBE", 'F'},
    {"0SONBF", 'F'},
    {"0SONBN", 'F'},
    {"0SONBS", 'F'},
    {"0SONBV", 'F'},
    {"0SONE(", 'F'},
    {"0SONE1", 'F'},
    {"0SONEF", 'F'},
    {"0SONEN", 'F'},
    {"0SONEO", 'F'},
    {"0SONES", 'F'},
    {"0SONEU", 'F'},
    {"0SONEV", 'F'},
    {"0SONF(", 'F'},
    {"0SONK(", 'F'},
    {"0SONK)", 'F'},
    {"0SONK1", 'F'},
    {"0SONKB", 'F'},
    {"0SONKF", 'F'},
    {"0SONKS", 'F'},
    {"0SONKU", 'F'},
    {"0SONKV", 'F'},
    {"0SONO(", 'F'},
    {"0SONOF", 'F'},
    {"0SONOK", 'F'},
    {"0SONOS", 'F'},
    {"0SONOT", 'F'},
    {"0SONOU", 'F'},
    {"0SONOV", 'F'},
    {"0SONSU", 'F'},
    {"0SONU", 'F'},
    {"0SONU(", 'F'},
    {"0SONU1", 'F'},
    {"0SONU;", 'F'},
    {"0SONUC", 'F'},
    {"0SONUE", 'F'},
    {"0SONUF", 'F'},
    {"0SONUK", 'F'},
    {"0SONUN", 'F'},
    {"0SONUO", 'F'},
    {"0SONUS", 'F'},
    {"0SONUT", 'F'},
    {"0SONUV", 'F'},
    {"0SOS", 'F'},
    {"0SOS&(", 'F'},
    {"0SOS&1", 'F'},
    {"0SOS&E", 'F'},
    {"0SOS&F", 'F'},
    {"0SOS&K", 'F'},
    {"0SOS&N", 'F'},
    {"0SOS&S", 'F'},
    {"0SOS&U", 'F'},
    {"0SOS&V", 'F'},
    {"0SOS((", 'F'},
    {"0SOS(E", 'F'},
    {"0SOS(U", 'F'},
    {"0SOS)&", 'F'},
    {"0SOS))", 'F'},
    {"0SOS),", 'F'},
    {"0SOS);", 'F'},
    {"0SOS)B", 'F'},
    {"0SOS)E", 'F'},
    {"0SOS)K", 'F'},
    {"0SOS)O", 'F'},
    {"0SOS)U", 'F'},
    {"0SOS,(", 'F'},
    {"0SOS,F", 'F'},
    {"0SOS,V", 'F'},
    {"0SOS1(", 'F'},
    {"0SOS1F", 'F'},
    {"0SOS1N", 'F'},
    {"0SOS1O", 'F'},
    {"0SOS1S", 'F'},
    {"0SOS1U", 'F'},
    {"0SOS1V", 'F'},
    {"0SOS;", 'F'},
    {"0SOS;C", 'F'},
    {"0SOS;E", 'F'},
    {"0SOS;N", 'F'},
    {"0SOS;T", 'F'},
    {"0SOSA(", 'F'},
    {"0SOSAF", 'F'},
    {"0SOSAS", 'F'},
    {"0SOSAT", 'F'},
    {"0SOSAV", 'F'},
    {"0SOSB(", 'F'},
    {"0SOSB1", 'F'},
    {"0SOSBE", 'F'},
    {"0SOSBF", 'F'},
    {"0SOSBN", 'F'},
    {"0SOSBS", 'F'},
    {"0SOSBV", 'F'},
    {"0SOSC", 'F'},
    {"0SOSE(", 'F'},
    {"0SOSE1", 'F'},
    {"0SOSEF", 'F'},
    {"0SOSEK", 'F'},
    {"0SOSEN", 'F'},
    {"0SOSEO", 'F'},
    {"0SOSES", 'F'},
    {"0SOSEU", 'F'},
    {"0SOSEV", 'F'},
    {"0SOSF(", 'F'},
    {"0SOSK(", 'F'},
    {"0SOSK)", 'F'},
    {"0SOSK1", 'F'},
    {"0SOSKB", 'F'},
    {"0SOSKF", 'F'},
    {"0SOSKN", 'F'},
    {"0SOSKS", 'F'},
    {"0SOSKU", 'F'},
    {"0SOSKV", 'F'},
    {"0SOSO(", 'F'},
    {"0SOSO1", 'F'},
    {"0SOSOF", 'F'},
    {"0SOSOK", 'F'},
    {"0SOSON", 'F'},
    {"0SOSOS", 'F'},
    {"0SOSOT", 'F'},
    {"0SOSOU", 'F'},
    {"0SOSOV", 'F'},
    {"0SOSU", 'F'},
    {"0SOSU(", 'F'},
    {"0SOSU1", 'F'},
    {"0SOSU;", 'F'},
    {"0SOSUC", 'F'},
    {"0SOSUE", 'F'},
    {"0SOSUF", 'F'},
    {"0SOSUK", 'F'},
    {"0SOSUN", 'F'},
    {"0SOSUO", 'F'},
    {"0SOSUS", 'F'},
    {"0SOSUT", 'F'},
    {"0SOSUV", 'F'},
    {"0SOSV(", 'F'},
    {"0SOSVF", 'F'},
    {"0SOSVO", 'F'},
    {"0SOSVS", 'F'},
    {"0SOSVU", 'F'},
    {"0SOT((", 'F'},
    {"0SOT(1", 'F'},
    {"0SOT(F", 'F'},
    {"0SOT(N", 'F'},
    {"0SOT(S", 'F'},
    {"0SOT(V", 'F'},
    {"0SOU((", 'F'},
    {"0SOU(E", 'F'},
    {"0SOUEK", 'F'},
    {"0SOUEN", 'F'},
    {"0SOV", 'F'},
    {"0SOV&(", 'F'},
    {"0SOV&1", 'F'},
    {"0SOV&E", 'F'},
    {"0SOV&F", 'F'},
    {"0SOV&K", 'F'},
    {"0SOV&N", 'F'},
    {"0SOV&S", 'F'},
    {"0SOV&U", 'F'},
    {"0SOV&V", 'F'},
    {"0SOV((", 'F'},
    {"0SOV(E", 'F'},
    {"0SOV(U", 'F'},
    {"0SOV)&", 'F'},
    {"0SOV))", 'F'},
    {"0SOV),", 'F'},
    {"0SOV);", 'F'},
    {"0SOV)B", 'F'},
    {"0SOV)E", 'F'},
    {"0SOV)K", 'F'},
    {"0SOV)O", 'F'},
    {"0SOV)U", 'F'},
    {"0SOV,(", 'F'},
    {"0SOV,1", 'F'},
    {"0SOV,F", 'F'},
    {"0SOV,N", 'F'},
    {"0SOV,S", 'F'},
    {"0SOV,V", 'F'},
    {"0SOV;", 'F'},
    {"0SOV;C", 'F'},
    {"0SOV;E", 'F'},
    {"0SOV;N", 'F'},
    {"0SOV;T", 'F'},
    {"0SOVA(", 'F'},
    {"0SOVAF", 'F'},
    {"0SOVAS", 'F'},
    {"0SOVAT", 'F'},
    {"0SOVAV", 'F'},
    {"0SOVB(", 'F'},
    {"0SOVB1", 'F'},
    {"0SOVBE", 'F'},
    {"0SOVBF", 'F'},
    {"0SOVBN", 'F'},
    {"0SOVBS", 'F'},
    {"0SOVBV", 'F'},
    {"0SOVC", 'F'},
    {"0SOVE(", 'F'},
    {"0SOVE1", 'F'},
    {"0SOVEF", 'F'},
    {"0SOVEK", 'F'},
    {"0SOVEN", 'F'},
    {"0SOVEO", 'F'},
    {"0SOVES", 'F'},
    {"0SOVEU", 'F'},
    {"0SOVEV", 'F'},
    {"0SOVF(", 'F'},
    {"0SOVK(", 'F'},
    {"0SOVK)", 'F'},
    {"0SOVK1", 'F'},
    {"0SOVKB", 'F'},
    {"0SOVKF", 'F'},
    {"0SOVKN", 'F'},
    {"0SOVKS", 'F'},
    {"0SOVKU", 'F'},
    {"0SOVKV", 'F'},
    {"0SOVO(", 'F'},
    {"0SOVOF", 'F'},
    {"0SOVOK", 'F'},
    {"0SOVOS", 'F'},
    {"0SOVOT", 'F'},
    {"0SOVOU", 'F'},
    {"0SOVS(", 'F'},
    {"0SOVS1", 'F'},
    {"0SOVSF", 'F'},
    {"0SOVSO", 'F'},
    {"0SOVSU", 'F'},
    {"0SOVSV", 'F'},
    {"0SOVU", 'F'},
    {"0SOVU(", 'F'},
    {"0SOVU1", 'F'},
    {"0SOVU;", 'F'},
    {"0SOVUC", 'F'},
    {"0SOVUE", 'F'},
    {"0SOVUF", 'F'},
    {"0SOVUK", 'F'},
    {"0SOVUN", 'F'},
    {"0SOVUO", 'F'},
    {"0SOVUS", 'F'},
    {"0SOVUT", 'F'},
    {"0SOVUV", 'F'},
    {"0SU(((", 'F'},
    {"0SU((1", 'F'},
    {"0SU((E", 'F'},
    {"0SU((F", 'F'},
    {"0SU((N", 'F'},
    {"0SU((S", 'F'},
    {"0SU((V", 'F'},
    {"0SU(1)", 'F'},
    {"0SU(1O", 'F'},
    {"0SU(E(", 'F'},
    {"0SU(E1", 'F'},
    {"0SU(EF", 'F'},
    {"0SU(EK", 'F'},
    {"0SU(EN", 'F'},
    {"0SU(ES", 'F'},
    {"0SU(EV", 'F'},
    {"0SU(F(", 'F'},
    {"0SU(N)", 'F'},
    {"0SU(NO", 'F'},
    {"0SU(S)", 'F'},
    {"0SU(SO", 'F'},
    {"0SU(V)", 'F'},
    {"0SU(VO", 'F'},
    {"0SU1,(", 'F'},
    {"0SU1,F", 'F'},
    {"0SU1,V", 'F'},
    {"0SU1C", 'F'},
    {"0SU1O(", 'F'},
    {"0SU1OF", 'F'},
    {"0SU1OS", 'F'},
    {"0SU1OV", 'F'},
    {"0SU;", 'F'},
    {"0SU;C", 'F'},
    {"0SUC", 'F'},
    {"0SUE", 'F'},
    {"0SUE((", 'F'},
    {"0SUE(1", 'F'},
    {"0SUE(E", 'F'},
    {"0SUE(F", 'F'},
    {"0SUE(N", 'F'},
    {"0SUE(O", 'F'},
    {"0SUE(S", 'F'},
    {"0SUE(V", 'F'},
    {"0SUE1", 'F'},
    {"0SUE1&", 'F'},
    {"0SUE1(", 'F'},
    {"0SUE1)", 'F'},
    {"0SUE1,", 'F'},
    {"0SUE1;", 'F'},
    {"0SUE1B", 'F'},
    {"0SUE1C", 'F'},
    {"0SUE1F", 'F'},
    {"0SUE1K", 'F'},
    {"0SUE1N", 'F'},
    {"0SUE1O", 'F'},
    {"0SUE1S", 'F'},
    {"0SUE1U", 'F'},
    {"0SUE1V", 'F'},
    {"0SUE;", 'F'},
    {"0SUE;C", 'F'},
    {"0SUEC", 'F'},
    {"0SUEF", 'F'},
    {"0SUEF(", 'F'},
    {"0SUEF,", 'F'},
    {"0SUEF;", 'F'},
    {"0SUEFC", 'F'},
    {"0SUEK", 'F'},
    {"0SUEK(", 'F'},
    {"0SUEK1", 'F'},
    {"0SUEK;", 'F'},
    {"0SUEKC", 'F'},
    {"0SUEKF", 'F'},
    {"0SUEKN", 'F'},
    {"0SUEKO", 'F'},
    {"0SUEKS", 'F'},
    {"0SUEKV", 'F'},
    {"0SUEN", 'F'},
    {"0SUEN&", 'F'},
    {"0SUEN(", 'F'},
    {"0SUEN)", 'F'},
    {"0SUEN,", 'F'},
    {"0SUEN1", 'F'},
    {"0SUEN;", 'F'},
    {"0SUENB", 'F'},
    {"0SUENC", 'F'},
    {"0SUENF", 'F'},
    {"0SUENK", 'F'},
    {"0SUENO", 'F'},
    {"0SUENS", 'F'},
    {"0SUENU", 'F'},
    {"0SUEOK", 'F'},
    {"0SUEON", 'F'},
    {"0SUEOO", 'F'},
    {"0SUES", 'F'},
    {"0SUES&", 'F'},
    {"0SUES(", 'F'},
    {"0SUES)", 'F'},
    {"0SUES,", 'F'},
    {"0SUES1", 'F'},
    {"0SUES;", 'F'},
    {"0SUESB", 'F'},
    {"0SUESC", 'F'},
    {"0SUESF", 'F'},
    {"0SUESK", 'F'},
    {"0SUESO", 'F'},
    {"0SUESU", 'F'},
    {"0SUESV", 'F'},
    {"0SUEV", 'F'},
    {"0SUEV&", 'F'},
    {"0SUEV(", 'F'},
    {"0SUEV)", 'F'},
    {"0SUEV,", 'F'},
    {"0SUEV;", 'F'},
    {"0SUEVB", 'F'},
    {"0SUEVC", 'F'},
    {"0SUEVF", 'F'},
    {"0SUEVK", 'F'},
    {"0SUEVN", 'F'},
    {"0SUEVO", 'F'},
    {"0SUEVS", 'F'},
    {"0SUEVU", 'F'},
    {"0SUF((", 'F'},
    {"0SUF()", 'F'},
    {"0SUF(1", 'F'},
    {"0SUF(F", 'F'},
    {"0SUF(N", 'F'},
    {"0SUF(S", 'F'},
    {"0SUF(V", 'F'},
    {"0SUK((", 'F'},
    {"0SUK(E", 'F'},
    {"0SUN((", 'F'},
    {"0SUN(1", 'F'},
    {"0SUN(F", 'F'},
    {"0SUN(S", 'F'},
    {"0SUN(V", 'F'},
    {"0SUN,(", 'F'},
    {"0SUN,F", 'F'},
    {"0SUN,V", 'F'},
    {"0SUN1(", 'F'},
    {"0SUN1,", 'F'},
    {"0SUN1O", 'F'},
    {"0SUNC", 'F'},
    {"0SUNE(", 'F'},
    {"0SUNE1", 'F'},
    {"0SUNEF", 'F'},
    {"0SUNEN", 'F'},
    {"0SUNES", 'F'},
    {"0SUNEV", 'F'},
    {"0SUNF(", 'F'},
    {"0SUNO(", 'F'},
    {"0SUNOF", 'F'},
    {"0SUNOS", 'F'},
    {"0SUNOV", 'F'},
    {"0SUNS(", 'F'},
    {"0SUNS,", 'F'},
    {"0SUNSO", 'F'},
    {"0SUO((", 'F'},
    {"0SUO(E", 'F'},
    {"0SUON(", 'F'},
    {"0SUON1", 'F'},
    {"0SUONF", 'F'},
    {"0SUONS", 'F'},
    {"0SUS,(", 'F'},
    {"0SUS,F", 'F'},
    {"0SUS,V", 'F'},
    {"0SUSC", 'F'},
    {"0SUSO(", 'F'},
    {"0SUSO1", 'F'},
    {"0SUSOF", 'F'},
    {"0SUSON", 'F'},
    {"0SUSOS", 'F'},
    {"0SUSOV", 'F'},
    {"0SUTN(", 'F'},
    {"0SUTN1", 'F'},
    {"0SUTNF", 'F'},
    {"0SUTNS", 'F'},
    {"0SUV,(", 'F'},
    {"0SUV,1", 'F'},
    {"0SUV,F", 'F'},
    {"0SUV,N", 'F'},
    {"0SUV,S", 'F'},
    {"0SUV,V", 'F'},
    {"0SUVC", 'F'},
    {"0SUVO(", 'F'},
    {"0SUVOF", 'F'},
    {"0SUVOS", 'F'},
    {"0SVF((", 'F'},
    {"0SVF()", 'F'},
    {"0SVF(1", 'F'},
    {"0SVF(F", 'F'},
    {"0SVF(N", 'F'},
    {"0SVF(S", 'F'},
    {"0SVF(V", 'F'},
    {"0SVO((", 'F'},
    {"0SVO(1", 'F'},
    {"0SVO(F", 'F'},
    {"0SVO(N", 'F'},
    {"0SVO(S", 'F'},
    {"0SVO(V", 'F'},
    {"0SVOF(", 'F'},
    {"0SVOS(", 'F'},
    {"0SVOS1", 'F'},
    {"0SVOSF", 'F'},
    {"0SVOSO", 'F'},
    {"0SVOSU", 'F'},
    {"0SVOSV", 'F'},
    {"0SVS", 'F'},
    {"0SVS;", 'F'},
    {"0SVS;C", 'F'},
    {"0SVSC", 'F'},
    {"0SVSO(", 'F'},
    {"0SVSO1", 'F'},
    {"0SVSOF", 'F'},
    {"0SVSON", 'F'},
    {"0SVSOS", 'F'},
    {"0SVSOV", 'F'},
    {"0SVUE", 'F'},
    {"0SVUE;", 'F'},
    {"0SVUEC", 'F'},
    {"0SVUEK", 'F'},
    {"0T((((", 'F'},
    {"0T(((1", 'F'},
    {"0T(((F", 'F'},
    {"0T(((N", 'F'},
    {"0T(((S", 'F'},
    {"0T(((V", 'F'},
    {"0T((1(", 'F'},
    {"0T((1)", 'F'},
    {"0T((1F", 'F'},
    {"0T((1N", 'F'},
    {"0T((1O", 'F'},
    {"0T((1S", 'F'},
    {"0T((1V", 'F'},
    {"0T((F(", 'F'},
    {"0T((N(", 'F'},
    {"0T((N)", 'F'},
    {"0T((N1", 'F'},
    {"0T((NF", 'F'},
    {"0T((NO", 'F'},
    {"0T((NS", 'F'},
    {"0T((S(", 'F'},
    {"0T((S)", 'F'},
    {"0T((S1", 'F'},
    {"0T((SF", 'F'},
    {"0T((SN", 'F'},
    {"0T((SO", 'F'},
    {"0T((SV", 'F'},
    {"0T((V(", 'F'},
    {"0T((V)", 'F'},
    {"0T((VF", 'F'},
    {"0T((VO", 'F'},
    {"0T((VS", 'F'},
    {"0T(1))", 'F'},
    {"0T(1)F", 'F'},
    {"0T(1)O", 'F'},
    {"0T(1)U", 'F'},
    {"0T(1F(", 'F'},
    {"0T(1N)", 'F'},
    {"0T(1NO", 'F'},
    {"0T(1O(", 'F'},
    {"0T(1OF", 'F'},
    {"0T(1OS", 'F'},
    {"0T(1OV", 'F'},
    {"0T(1S)", 'F'},
    {"0T(1V)", 'F'},
    {"0T(1VO", 'F'},
    {"0T(F((", 'F'},
    {"0T(F()", 'F'},
    {"0T(F(1", 'F'},
    {"0T(F(F", 'F'},
    {"0T(F(N", 'F'},
    {"0T(F(S", 'F'},
    {"0T(F(V", 'F'},
    {"0T(N((", 'F'},
    {"0T(N(1", 'F'},
    {"0T(N(F", 'F'},
    {"0T(N(S", 'F'},
    {"0T(N(V", 'F'},
    {"0T(N))", 'F'},
    {"0T(N)F", 'F'},
    {"0T(N)O", 'F'},
    {"0T(N)U", 'F'},
    {"0T(N1)", 'F'},
    {"0T(N1O", 'F'},
    {"0T(NF(", 'F'},
    {"0T(NO(", 'F'},
    {"0T(NOF", 'F'},
    {"0T(NOS", 'F'},
    {"0T(NOV", 'F'},
    {"0T(NS)", 'F'},
    {"0T(NSO", 'F'},
    {"0T(S))", 'F'},
    {"0T(S)F", 'F'},
    {"0T(S)O", 'F'},
    {"0T(S)U", 'F'},
    {"0T(S1)", 'F'},
    {"0T(S1O", 'F'},
    {"0T(SF(", 'F'},
    {"0T(SN)", 'F'},
    {"0T(SNO", 'F'},
    {"0T(SO(", 'F'},
    {"0T(SO1", 'F'},
    {"0T(SOF", 'F'},
    {"0T(SON", 'F'},
    {"0T(SOS", 'F'},
    {"0T(SOV", 'F'},
    {"0T(SV)", 'F'},
    {"0T(SVO", 'F'},
    {"0T(V))", 'F'},
    {"0T(V)F", 'F'},
    {"0T(V)O", 'F'},
    {"0T(V)U", 'F'},
    {"0T(VF(", 'F'},
    {"0T(VO(", 'F'},
    {"0T(VOF", 'F'},
    {"0T(VOS", 'F'},
    {"0T(VS)", 'F'},
    {"0T(VSO", 'F'},
    {"0T(VV)", 'F'},
    {"0T1F((", 'F'},
    {"0T1F(1", 'F'},
    {"0T1F(F", 'F'},
    {"0T1F(N", 'F'},
    {"0T1F(S", 'F'},
    {"0T1F(V", 'F'},
    {"0T1O((", 'F'},
    {"0T1O(1", 'F'},
    {"0T1O(F", 'F'},
    {"0T1O(N", 'F'},
    {"0T1O(S", 'F'},
    {"0T1O(V", 'F'},
    {"0T1OF(", 'F'},
    {"0T1OSF", 'F'},
    {"0T1OSO", 'F'},
    {"0T1OVF", 'F'},
    {"0T1OVO", 'F'},
    {"0TF(((", 'F'},
    {"0TF(()", 'F'},
    {"0TF((1", 'F'},
    {"0TF((F", 'F'},
    {"0TF((N", 'F'},
    {"0TF((S", 'F'},
    {"0TF((V", 'F'},
    {"0TF())", 'F'},
    {"0TF()F", 'F'},
    {"0TF()O", 'F'},
    {"0TF(1)", 'F'},
    {"0TF(1O", 'F'},
    {"0TF(F(", 'F'},
    {"0TF(N)", 'F'},
    {"0TF(NO", 'F'},
    {"0TF(S)", 'F'},
    {"0TF(SO", 'F'},
    {"0TF(V)", 'F'},
    {"0TF(VO", 'F'},
    {"0TN(((", 'F'},
    {"0TN((1", 'F'},
    {"0TN((F", 'F'},
    {"0TN((N", 'F'},
    {"0TN((S", 'F'},
    {"0TN((V", 'F'},
    {"0TN(1)", 'F'},
    {"0TN(1O", 'F'},
    {"0TN(F(", 'F'},
    {"0TN(S)", 'F'},
    {"0TN(SO", 'F'},
    {"0TN(V)", 'F'},
    {"0TN(VO", 'F'},
    {"0TN1;", 'F'},
    {"0TN1;C", 'F'},
    {"0TN1O(", 'F'},
    {"0TN1OF", 'F'},
    {"0TN1OS", 'F'},
    {"0TN1OV", 'F'},
    {"0TNF((", 'F'},
    {"0TNF()", 'F'},
    {"0TNF(1", 'F'},
    {"0TNF(F", 'F'},
    {"0TNF(N", 'F'},
    {"0TNF(S", 'F'},
    {"0TNF(V", 'F'},
    {"0TNO((", 'F'},
    {"0TNO(1", 'F'},
    {"0TNO(F", 'F'},
    {"0TNO(N", 'F'},
    {"0TNO(S", 'F'},
    {"0TNO(V", 'F'},
    {"0TNOF(", 'F'},
    {"0TNOSF", 'F'},
    {"0TNOSO", 'F'},
    {"0TNOVF", 'F'},
    {"0TNOVO", 'F'},
    {"0TNS;", 'F'},
    {"0TNS;C", 'F'},
    {"0TNSO(", 'F'},
    {"0TNSO1", 'F'},
    {"0TNSOF", 'F'},
    {"0TNSON", 'F'},
    {"0TNSOS", 'F'},
    {"0TNSOV", 'F'},
    {"0TNV;", 'F'},
    {"0TNVOS", 'F'},
    {"0TO(((", 'F'},
    {"0TO((1", 'F'},
    {"0TO((F", 'F'},
    {"0TO((N", 'F'},
    {"0TO((S", 'F'},
    {"0TO((V", 'F'},
    {"0TO(1)", 'F'},
    {"0TO(1O", 'F'},
    {"0TO(F(", 'F'},
    {"0TO(N)", 'F'},
    {"0TO(NO", 'F'},
    {"0TO(S)", 'F'},
    {"0TO(SO", 'F'},
    {"0TO(V)", 'F'},
    {"0TO(VO", 'F'},
    {"0TO1O(", 'F'},
    {"0TO1OF", 'F'},
    {"0TO1OS", 'F'},
    {"0TO1OV", 'F'},
    {"0TO1UE", 'F'},
    {"0TOF((", 'F'},
    {"0TOF()", 'F'},
    {"0TOF(1", 'F'},
    {"0TOF(F", 'F'},
    {"0TOF(N", 'F'},
    {"0TOF(S", 'F'},
    {"0TOF(V", 'F'},
    {"0TONO(", 'F'},
    {"0TONOF", 'F'},
    {"0TONOS", 'F'},
    {"0TONOV", 'F'},
    {"0TONUE", 'F'},
    {"0TOSO(", 'F'},
    {"0TOSO1", 'F'},
    {"0TOSOF", 'F'},
    {"0TOSON", 'F'},
    {"0TOSOS", 'F'},
    {"0TOSOV", 'F'},
    {"0TOSUE", 'F'},
    {"0TOVO(", 'F'},
    {"0TOVOF", 'F'},
    {"0TOVOS", 'F'},
    {"0TOVUE", 'F'},
    {"0TSF((", 'F'},
    {"0TSF(1", 'F'},
    {"0TSF(F", 'F'},
    {"0TSF(N", 'F'},
    {"0TSF(S", 'F'},
    {"0TSF(V", 'F'},
    {"0TSO((", 'F'},
    {"0TSO(1", 'F'},
    {"0TSO(F", 'F'},
    {"0TSO(N", 'F'},
    {"0TSO(S", 'F'},
    {"0TSO(V", 'F'},
    {"0TSO1F", 'F'},
    {"0TSO1O", 'F'},
    {"0TSOF(", 'F'},
    {"0TSONF", 'F'},
    {"0TSONO", 'F'},
    {"0TSOSF", 'F'},
    {"0TSOSO", 'F'},
    {"0TSOVF", 'F'},
    {"0TSOVO", 'F'},
    {"0TVF((", 'F'},
    {"0TVF(1", 'F'},
    {"0TVF(F", 'F'},
    {"0TVF(N", 'F'},
    {"0TVF(S", 'F'},
    {"0TVF(V", 'F'},
    {"0TVO((", 'F'},
    {"0TVO(1", 'F'},
    {"0TVO(F", 'F'},
    {"0TVO(N", 'F'},
    {"0TVO(S", 'F'},
    {"0TVO(V", 'F'},
    {"0TVOF(", 'F'},
    {"0TVOSF", 'F'},
    {"0TVOSO", 'F'},
    {"0U((((", 'F'},
    {"0U(((E", 'F'},
    {"0U((E(", 'F'},
    {"0U((E1", 'F'},
    {"0U((EF", 'F'},
    {"0U((EK", 'F'},
    {"0U((EN", 'F'},
    {"0U((EO", 'F'},
    {"0U((ES", 'F'},
    {"0U((EV", 'F'},
    {"0U(E((", 'F'},
    {"0U(E(1", 'F'},
    {"0U(E(F", 'F'},
    {"0U(E(K", 'F'},
    {"0U(E(N", 'F'},
    {"0U(E(S", 'F'},
    {"0U(E(V", 'F'},
    {"0U(E1)", 'F'},
    {"0U(E1O", 'F'},
    {"0U(EF(", 'F'},
    {"0U(EK(", 'F'},
    {"0U(EK1", 'F'},
    {"0U(EKF", 'F'},
    {"0U(EKN", 'F'},
    {"0U(EKO", 'F'},
    {"0U(EKS", 'F'},
    {"0U(EKV", 'F'},
    {"0U(EN)", 'F'},
    {"0U(ENK", 'F'},
    {"0U(ENO", 'F'},
    {"0U(EOK", 'F'},
    {"0U(ES)", 'F'},
    {"0U(ESO", 'F'},
    {"0U(EV)", 'F'},
    {"0U(EVO", 'F'},
    {"0UE(((", 'F'},
    {"0UE((1", 'F'},
    {"0UE((F", 'F'},
    {"0UE((N", 'F'},
    {"0UE((S", 'F'},
    {"0UE((V", 'F'},
    {"0UE(1)", 'F'},
    {"0UE(1,", 'F'},
    {"0UE(1O", 'F'},
    {"0UE(F(", 'F'},
    {"0UE(N)", 'F'},
    {"0UE(N,", 'F'},
    {"0UE(NO", 'F'},
    {"0UE(S)", 'F'},
    {"0UE(S,", 'F'},
    {"0UE(SO", 'F'},
    {"0UE(V)", 'F'},
    {"0UE(V,", 'F'},
    {"0UE(VO", 'F'},
    {"0UE1", 'F'},
    {"0UE1,(", 'F'},
    {"0UE1,F", 'F'},
    {"0UE1,V", 'F'},
    {"0UE1;", 'F'},
    {"0UE1;C", 'F'},
    {"0UE1C", 'F'},
    {"0UE1K(", 'F'},
    {"0UE1K1", 'F'},
    {"0UE1KF", 'F'},
    {"0UE1KN", 'F'},
    {"0UE1KS", 'F'},
    {"0UE1KV", 'F'},
    {"0UE1O(", 'F'},
    {"0UE1OF", 'F'},
    {"0UE1OS", 'F'},
    {"0UE1OV", 'F'},
    {"0UEF((", 'F'},
    {"0UEF()", 'F'},
    {"0UEF(1", 'F'},
    {"0UEF(F", 'F'},
    {"0UEF(N", 'F'},
    {"0UEF(S", 'F'},
    {"0UEF(V", 'F'},
    {"0UEK((", 'F'},
    {"0UEK(1", 'F'},
    {"0UEK(F", 'F'},
    {"0UEK(N", 'F'},
    {"0UEK(S", 'F'},
    {"0UEK(V", 'F'},
    {"0UEK1", 'F'},
    {"0UEK1,", 'F'},
    {"0UEK1;", 'F'},
    {"0UEK1C", 'F'},
    {"0UEK1K", 'F'},
    {"0UEK1O", 'F'},
    {"0UEKF(", 'F'},
    {"0UEKN", 'F'},
    {"0UEKN(", 'F'},
    {"0UEKN,", 'F'},
    {"0UEKN;", 'F'},
    {"0UEKNC", 'F'},
    {"0UEKNK", 'F'},
    {"0UEKS", 'F'},
    {"0UEKS,", 'F'},
    {"0UEKS;", 'F'},
    {"0UEKSC", 'F'},
    {"0UEKSK", 'F'},
    {"0UEKSO", 'F'},
    {"0UEKV", 'F'},
    {"0UEKV,", 'F'},
    {"0UEKV;", 'F'},
    {"0UEKVC", 'F'},
    {"0UEKVK", 'F'},
    {"0UEKVO", 'F'},
    {"0UEN", 'F'},
    {"0UEN((", 'F'},
    {"0UEN()", 'F'},
    {"0UEN,(", 'F'},
    {"0UEN,F", 'F'},
    {"0UEN,V", 'F'},
    {"0UEN;", 'F'},
    {"0UEN;C", 'F'},
    {"0UENC", 'F'},
    {"0UENK(", 'F'},
    {"0UENK1", 'F'},
    {"0UENKF", 'F'},
    {"0UENKN", 'F'},
    {"0UENKS", 'F'},
    {"0UENKV", 'F'},
    {"0UENO(", 'F'},
    {"0UENOF", 'F'},
    {"0UENOS", 'F'},
    {"0UENOV", 'F'},
    {"0UES", 'F'},
    {"0UES,(", 'F'},
    {"0UES,F", 'F'},
    {"0UES,V", 'F'},
    {"0UES;", 'F'},
    {"0UES;C", 'F'},
    {"0UESC", 'F'},
    {"0UESK(", 'F'},
    {"0UESK1", 'F'},
    {"0UESKF", 'F'},
    {"0UESKN", 'F'},
    {"0UESKS", 'F'},
    {"0UESKV", 'F'},
    {"0UESO(", 'F'},
    {"0UESO1", 'F'},
    {"0UESOF", 'F'},
    {"0UESON", 'F'},
    {"0UESOS", 'F'},
    {"0UESOV", 'F'},
    {"0UEV", 'F'},
    {"0UEV,(", 'F'},
    {"0UEV,1", 'F'},
    {"0UEV,F", 'F'},
    {"0UEV,N", 'F'},
    {"0UEV,S", 'F'},
    {"0UEV,V", 'F'},
    {"0UEV;", 'F'},
    {"0UEV;C", 'F'},
    {"0UEVC", 'F'},
    {"0UEVK(", 'F'},
    {"0UEVK1", 'F'},
    {"0UEVKF", 'F'},
    {"0UEVKN", 'F'},
    {"0UEVKS", 'F'},
    {"0UEVKV", 'F'},
    {"0UEVO(", 'F'},
    {"0UEVOF", 'F'},
    {"0UEVOS", 'F'},
    {"0UF(((", 'F'},
    {"0UF((1", 'F'},
    {"0UF((F", 'F'},
    {"0UF((N", 'F'},
    {"0UF((S", 'F'},
    {"0UF((V", 'F'},
    {"0UF(1O", 'F'},
    {"0UF(F(", 'F'},
    {"0UF(NO", 'F'},
    {"0UF(SO", 'F'},
    {"0UF(VO", 'F'},
    {"0V&(((", 'F'},
    {"0V&((1", 'F'},
    {"0V&((E", 'F'},
    {"0V&((F", 'F'},
    {"0V&((N", 'F'},
    {"0V&((S", 'F'},
    {"0V&((V", 'F'},
    {"0V&(1&", 'F'},
    {"0V&(1)", 'F'},
    {"0V&(1,", 'F'},
    {"0V&(1O", 'F'},
    {"0V&(E(", 'F'},
    {"0V&(E1", 'F'},
    {"0V&(EF", 'F'},
    {"0V&(EK", 'F'},
    {"0V&(EN", 'F'},
    {"0V&(EO", 'F'},
    {"0V&(ES", 'F'},
    {"0V&(EV", 'F'},
    {"0V&(F(", 'F'},
    {"0V&(N&", 'F'},
    {"0V&(N)", 'F'},
    {"0V&(N,", 'F'},
    {"0V&(NO", 'F'},
    {"0V&(S&", 'F'},
    {"0V&(S)", 'F'},
    {"0V&(S,", 'F'},
    {"0V&(SO", 'F'},
    {"0V&(V&", 'F'},
    {"0V&(V)", 'F'},
    {"0V&(V,", 'F'},
    {"0V&(VO", 'F'},
    {"0V&1", 'F'},
    {"0V&1&(", 'F'},
    {"0V&1&1", 'F'},
    {"0V&1&F", 'F'},
    {"0V&1&N", 'F'},
    {"0V&1&S", 'F'},
    {"0V&1&V", 'F'},
    {"0V&1)&", 'F'},
    {"0V&1))", 'F'},
    {"0V&1)U", 'F'},
    {"0V&1;", 'F'},
    {"0V&1;C", 'F'},
    {"0V&1;E", 'F'},
    {"0V&1;T", 'F'},
    {"0V&1B(", 'F'},
    {"0V&1B1", 'F'},
    {"0V&1BF", 'F'},
    {"0V&1BN", 'F'},
    {"0V&1BS", 'F'},
    {"0V&1BV", 'F'},
    {"0V&1C", 'F'},
    {"0V&1EK", 'F'},
    {"0V&1EN", 'F'},
    {"0V&1F(", 'F'},
    {"0V&1K(", 'F'},
    {"0V&1K1", 'F'},
    {"0V&1KF", 'F'},
    {"0V&1KN", 'F'},
    {"0V&1KS", 'F'},
    {"0V&1KV", 'F'},
    {"0V&1O(", 'F'},
    {"0V&1OF", 'F'},
    {"0V&1OO", 'F'},
    {"0V&1OS", 'F'},
    {"0V&1OV", 'F'},
    {"0V&1TN", 'F'},
    {"0V&1U", 'F'},
    {"0V&1U(", 'F'},
    {"0V&1U;", 'F'},
    {"0V&1UC", 'F'},
    {"0V&1UE", 'F'},
    {"0V&E((", 'F'},
    {"0V&E(1", 'F'},
    {"0V&E(F", 'F'},
    {"0V&E(N", 'F'},
    {"0V&E(O", 'F'},
    {"0V&E(S", 'F'},
    {"0V&E(V", 'F'},
    {"0V&E1", 'F'},
    {"0V&E1;", 'F'},
    {"0V&E1C", 'F'},
    {"0V&E1K", 'F'},
    {"0V&E1O", 'F'},
    {"0V&EF(", 'F'},
    {"0V&EK(", 'F'},
    {"0V&EK1", 'F'},
    {"0V&EKF", 'F'},
    {"0V&EKN", 'F'},
    {"0V&EKS", 'F'},
    {"0V&EKV", 'F'},
    {"0V&EN", 'F'},
    {"0V&EN;", 'F'},
    {"0V&ENC", 'F'},
    {"0V&ENK", 'F'},
    {"0V&ENO", 'F'},
    {"0V&ES", 'F'},
    {"0V&ES;", 'F'},
    {"0V&ESC", 'F'},
    {"0V&ESK", 'F'},
    {"0V&ESO", 'F'},
    {"0V&EV", 'F'},
    {"0V&EV;", 'F'},
    {"0V&EVC", 'F'},
    {"0V&EVK", 'F'},
    {"0V&EVO", 'F'},
    {"0V&F((", 'F'},
    {"0V&F()", 'F'},
    {"0V&F(1", 'F'},
    {"0V&F(F", 'F'},
    {"0V&F(N", 'F'},
    {"0V&F(S", 'F'},
    {"0V&F(V", 'F'},
    {"0V&K&(", 'F'},
    {"0V&K&1", 'F'},
    {"0V&K&F", 'F'},
    {"0V&K&N", 'F'},
    {"0V&K&S", 'F'},
    {"0V&K&V", 'F'},
    {"0V&K((", 'F'},
    {"0V&K(1", 'F'},
    {"0V&K(F", 'F'},
    {"0V&K(N", 'F'},
    {"0V&K(S", 'F'},
    {"0V&K(V", 'F'},
    {"0V&K1O", 'F'},
    {"0V&KF(", 'F'},
    {"0V&KNK", 'F'},
    {"0V&KO(", 'F'},
    {"0V&KO1", 'F'},
    {"0V&KOF", 'F'},
    {"0V&KOK", 'F'},
    {"0V&KON", 'F'},
    {"0V&KOS", 'F'},
    {"0V&KOV", 'F'},
    {"0V&KSO", 'F'},
    {"0V&KVO", 'F'},
    {"0V&N", 'F'},
    {"0V&N&(", 'F'},
    {"0V&N&1", 'F'},
    {"0V&N&F", 'F'},
    {"0V&N&N", 'F'},
    {"0V&N&S", 'F'},
    {"0V&N&V", 'F'},
    {"0V&N)&", 'F'},
    {"0V&N))", 'F'},
    {"0V&N)U", 'F'},
    {"0V&N;", 'F'},
    {"0V&N;C", 'F'},
    {"0V&N;E", 'F'},
    {"0V&N;T", 'F'},
    {"0V&NB(", 'F'},
    {"0V&NB1", 'F'},
    {"0V&NBF", 'F'},
    {"0V&NBN", 'F'},
    {"0V&NBS", 'F'},
    {"0V&NBV", 'F'},
    {"0V&NC", 'F'},
    {"0V&NEN", 'F'},
    {"0V&NF(", 'F'},
    {"0V&NK(", 'F'},
    {"0V&NK1", 'F'},
    {"0V&NKF", 'F'},
    {"0V&NKN", 'F'},
    {"0V&NKS", 'F'},
    {"0V&NKV", 'F'},
    {"0V&NO(", 'F'},
    {"0V&NOF", 'F'},
    {"0V&NOS", 'F'},
    {"0V&NOV", 'F'},
    {"0V&NTN", 'F'},
    {"0V&NU", 'F'},
    {"0V&NU(", 'F'},
    {"0V&NU;", 'F'},
    {"0V&NUC", 'F'},
    {"0V&NUE", 'F'},
    {"0V&S", 'F'},
    {"0V&S&(", 'F'},
    {"0V&S&1", 'F'},
    {"0V&S&F", 'F'},
    {"0V&S&N", 'F'},
    {"0V&S&S", 'F'},
    {"0V&S&V", 'F'},
    {"0V&S)&", 'F'},
    {"0V&S))", 'F'},
    {"0V&S)U", 'F'},
    {"0V&S1", 'F'},
    {"0V&S1;", 'F'},
    {"0V&S1C", 'F'},
    {"0V&S1O", 'F'},
    {"0V&S;", 'F'},
    {"0V&S;C", 'F'},
    {"0V&S;E", 'F'},
    {"0V&S;T", 'F'},
    {"0V&SB(", 'F'},
    {"0V&SB1", 'F'},
    {"0V&SBF", 'F'},
    {"0V&SBN", 'F'},
    {"0V&SBS", 'F'},
    {"0V&SBV", 'F'},
    {"0V&SC", 'F'},
    {"0V&SEK", 'F'},
    {"0V&SEN", 'F'},
    {"0V&SF(", 'F'},
    {"0V&SK(", 'F'},
    {"0V&SK1", 'F'},
    {"0V&SKF", 'F'},
    {"0V&SKN", 'F'},
    {"0V&SKS", 'F'},
    {"0V&SKV", 'F'},
    {"0V&SO(", 'F'},
    {"0V&SO1", 'F'},
    {"0V&SOF", 'F'},
    {"0V&SON", 'F'},
    {"0V&SOO", 'F'},
    {"0V&SOS", 'F'},
    {"0V&SOV", 'F'},
    {"0V&STN", 'F'},
    {"0V&SU", 'F'},
    {"0V&SU(", 'F'},
    {"0V&SU;", 'F'},
    {"0V&SUC", 'F'},
    {"0V&SUE", 'F'},
    {"0V&SV", 'F'},
    {"0V&SV;", 'F'},
    {"0V&SVC", 'F'},
    {"0V&SVO", 'F'},
    {"0V&V", 'F'},
    {"0V&V&(", 'F'},
    {"0V&V&1", 'F'},
    {"0V&V&F", 'F'},
    {"0V&V&N", 'F'},
    {"0V&V&S", 'F'},
    {"0V&V&V", 'F'},
    {"0V&V)&", 'F'},
    {"0V&V))", 'F'},
    {"0V&V)U", 'F'},
    {"0V&V;", 'F'},
    {"0V&V;C", 'F'},
    {"0V&V;E", 'F'},
    {"0V&V;T", 'F'},
    {"0V&VB(", 'F'},
    {"0V&VB1", 'F'},
    {"0V&VBF", 'F'},
    {"0V&VBN", 'F'},
    {"0V&VBS", 'F'},
    {"0V&VBV", 'F'},
    {"0V&VC", 'F'},
    {"0V&VEK", 'F'},
    {"0V&VEN", 'F'},
    {"0V&VF(", 'F'},
    {"0V&VK(", 'F'},
    {"0V&VK1", 'F'},
    {"0V&VKF", 'F'},
    {"0V&VKN", 'F'},
    {"0V&VKS", 'F'},
    {"0V&VKV", 'F'},
    {"0V&VO(", 'F'},
    {"0V&VOF", 'F'},
    {"0V&VOO", 'F'},
    {"0V&VOS", 'F'},
    {"0V&VS", 'F'},
    {"0V&VS;", 'F'},
    {"0V&VSC", 'F'},
    {"0V&VSO", 'F'},
    {"0V&VTN", 'F'},
    {"0V&VU", 'F'},
    {"0V&VU(", 'F'},
    {"0V&VU;", 'F'},
    {"0V&VUC", 'F'},
    {"0V&VUE", 'F'},
    {"0V((((", 'F'},
    {"0V(((E", 'F'},
    {"0V(((U", 'F'},
    {"0V((EK", 'F'},
    {"0V((EN", 'F'},
    {"0V((U(", 'F'},
    {"0V(EKN", 'F'},
    {"0V(ENK", 'F'},
    {"0V(U((", 'F'},
    {"0V(U(E", 'F'},
    {"0V)&((", 'F'},
    {"0V)&(1", 'F'},
    {"0V)&(E", 'F'},
    {"0V)&(F", 'F'},
    {"0V)&(N", 'F'},
    {"0V)&(S", 'F'},
    {"0V)&(V", 'F'},
    {"0V)&1", 'F'},
    {"0V)&1&", 'F'},
    {"0V)&1)", 'F'},
    {"0V)&1;", 'F'},
    {"0V)&1B", 'F'},
    {"0V)&1C", 'F'},
    {"0V)&1F", 'F'},
    {"0V)&1O", 'F'},
    {"0V)&1U", 'F'},
    {"0V)&F(", 'F'},
    {"0V)&N", 'F'},
    {"0V)&N&", 'F'},
    {"0V)&N)", 'F'},
    {"0V)&N;", 'F'},
    {"0V)&NB", 'F'},
    {"0V)&NC", 'F'},
    {"0V)&NF", 'F'},
    {"0V)&NO", 'F'},
    {"0V)&NU", 'F'},
    {"0V)&S", 'F'},
    {"0V)&S&", 'F'},
    {"0V)&S)", 'F'},
    {"0V)&S;", 'F'},
    {"0V)&SB", 'F'},
    {"0V)&SC", 'F'},
    {"0V)&SF", 'F'},
    {"0V)&SO", 'F'},
    {"0V)&SU", 'F'},
    {"0V)&V", 'F'},
    {"0V)&V&", 'F'},
    {"0V)&V)", 'F'},
    {"0V)&V;", 'F'},
    {"0V)&VB", 'F'},
    {"0V)&VC", 'F'},
    {"0V)&VF", 'F'},
    {"0V)&VO", 'F'},
    {"0V)&VU", 'F'},
    {"0V))&(", 'F'},
    {"0V))&1", 'F'},
    {"0V))&F", 'F'},
    {"0V))&N", 'F'},
    {"0V))&S", 'F'},
    {"0V))&V", 'F'},
    {"0V)))&", 'F'},
    {"0V))))", 'F'},
    {"0V))),", 'F'},
    {"0V)));", 'F'},
    {"0V)))B", 'F'},
    {"0V)))E", 'F'},
    {"0V)))K", 'F'},
    {"0V)))O", 'F'},
    {"0V)))U", 'F'},
    {"0V)),(", 'F'},
    {"0V));E", 'F'},
    {"0V));T", 'F'},
    {"0V))B(", 'F'},
    {"0V))B1", 'F'},
    {"0V))BF", 'F'},
    {"0V))BN", 'F'},
    {"0V))BS", 'F'},
    {"0V))BV", 'F'},
    {"0V))E(", 'F'},
    {"0V))E1", 'F'},
    {"0V))EF", 'F'},
    {"0V))EK", 'F'},
    {"0V))EN", 'F'},
    {"0V))ES", 'F'},
    {"0V))EV", 'F'},
    {"0V))K(", 'F'},
    {"0V))K1", 'F'},
    {"0V))KB", 'F'},
    {"0V))KF", 'F'},
    {"0V))KN", 'F'},
    {"0V))KS", 'F'},
    {"0V))KU", 'F'},
    {"0V))KV", 'F'},
    {"0V))O(", 'F'},
    {"0V))O1", 'F'},
    {"0V))OF", 'F'},
    {"0V))ON", 'F'},
    {"0V))OS", 'F'},
    {"0V))OV", 'F'},
    {"0V))U(", 'F'},
    {"0V))UE", 'F'},
    {"0V),((", 'F'},
    {"0V),(1", 'F'},
    {"0V),(F", 'F'},
    {"0V),(N", 'F'},
    {"0V),(S", 'F'},
    {"0V),(V", 'F'},
    {"0V);E(", 'F'},
    {"0V);E1", 'F'},
    {"0V);EF", 'F'},
    {"0V);EK", 'F'},
    {"0V);EN", 'F'},
    {"0V);EO", 'F'},
    {"0V);ES", 'F'},
    {"0V);EV", 'F'},
    {"0V);T(", 'F'},
    {"0V);T1", 'F'},
    {"0V);TF", 'F'},
    {"0V);TK", 'F'},
    {"0V);TN", 'F'},
    {"0V);TO", 'F'},
    {"0V);TS", 'F'},
    {"0V);TV", 'F'},
    {"0V)B((", 'F'},
    {"0V)B(1", 'F'},
    {"0V)B(F", 'F'},
    {"0V)B(N", 'F'},
    {"0V)B(S", 'F'},
    {"0V)B(V", 'F'},
    {"0V)B1", 'F'},
    {"0V)B1&", 'F'},
    {"0V)B1;", 'F'},
    {"0V)B1C", 'F'},
    {"0V)B1K", 'F'},
    {"0V)B1N", 'F'},
    {"0V)B1O", 'F'},
    {"0V)B1U", 'F'},
    {"0V)BF(", 'F'},
    {"0V)BN", 'F'},
    {"0V)BN&", 'F'},
    {"0V)BN;", 'F'},
    {"0V)BNC", 'F'},
    {"0V)BNK", 'F'},
    {"0V)BNO", 'F'},
    {"0V)BNU", 'F'},
    {"0V)BS", 'F'},
    {"0V)BS&", 'F'},
    {"0V)BS;", 'F'},
    {"0V)BSC", 'F'},
    {"0V)BSK", 'F'},
    {"0V)BSO", 'F'},
    {"0V)BSU", 'F'},
    {"0V)BV", 'F'},
    {"0V)BV&", 'F'},
    {"0V)BV;", 'F'},
    {"0V)BVC", 'F'},
    {"0V)BVK", 'F'},
    {"0V)BVO", 'F'},
    {"0V)BVU", 'F'},
    {"0V)E((", 'F'},
    {"0V)E(1", 'F'},
    {"0V)E(F", 'F'},
    {"0V)E(N", 'F'},
    {"0V)E(S", 'F'},
    {"0V)E(V", 'F'},
    {"0V)E1C", 'F'},
    {"0V)E1O", 'F'},
    {"0V)EF(", 'F'},
    {"0V)EK(", 'F'},
    {"0V)EK1", 'F'},
    {"0V)EKF", 'F'},
    {"0V)EKN", 'F'},
    {"0V)EKS", 'F'},
    {"0V)EKV", 'F'},
    {"0V)ENC", 'F'},
    {"0V)ENO", 'F'},
    {"0V)ESC", 'F'},
    {"0V)ESO", 'F'},
    {"0V)EVC", 'F'},
    {"0V)EVO", 'F'},
    {"0V)K((", 'F'},
    {"0V)K(1", 'F'},
    {"0V)K(F", 'F'},
    {"0V)K(N", 'F'},
    {"0V)K(S", 'F'},
    {"0V)K(V", 'F'},
    {"0V)K1&", 'F'},
    {"0V)K1;", 'F'},
    {"0V)K1B", 'F'},
    {"0V)K1E", 'F'},
    {"0V)K1O", 'F'},
    {"0V)K1U", 'F'},
    {"0V)KB(", 'F'},
    {"0V)KB1", 'F'},
    {"0V)KBF", 'F'},
    {"0V)KBN", 'F'},
    {"0V)KBS", 'F'},
    {"0V)KBV", 'F'},
    {"0V)KF(", 'F'},
    {"0V)KN&", 'F'},
    {"0V)KN;", 'F'},
    {"0V)KNB", 'F'},
    {"0V)KNE", 'F'},
    {"0V)KNK", 'F'},
    {"0V)KNU", 'F'},
    {"0V)KS&", 'F'},
    {"0V)KS;", 'F'},
    {"0V)KSB", 'F'},
    {"0V)KSE", 'F'},
    {"0V)KSO", 'F'},
    {"0V)KSU", 'F'},
    {"0V)KUE", 'F'},
    {"0V)KV&", 'F'},
    {"0V)KV;", 'F'},
    {"0V)KVB", 'F'},
    {"0V)KVE", 'F'},
    {"0V)KVO", 'F'},
    {"0V)KVU", 'F'},
    {"0V)O((", 'F'},
    {"0V)O(1", 'F'},
    {"0V)O(E", 'F'},
    {"0V)O(F", 'F'},
    {"0V)O(N", 'F'},
    {"0V)O(S", 'F'},
    {"0V)O(V", 'F'},
    {"0V)O1", 'F'},
    {"0V)O1&", 'F'},
    {"0V)O1)", 'F'},
    {"0V)O1;", 'F'},
    {"0V)O1B", 'F'},
    {"0V)O1C", 'F'},
    {"0V)O1K", 'F'},
    {"0V)O1O", 'F'},
    {"0V)O1U", 'F'},
    {"0V)OF(", 'F'},
    {"0V)ON", 'F'},
    {"0V)ON&", 'F'},
    {"0V)ON)", 'F'},
    {"0V)ON;", 'F'},
    {"0V)ONB", 'F'},
    {"0V)ONC", 'F'},
    {"0V)ONK", 'F'},
    {"0V)ONO", 'F'},
    {"0V)ONU", 'F'},
    {"0V)OS", 'F'},
    {"0V)OS&", 'F'},
    {"0V)OS)", 'F'},
    {"0V)OS;", 'F'},
    {"0V)OSB", 'F'},
    {"0V)OSC", 'F'},
    {"0V)OSK", 'F'},
    {"0V)OSO", 'F'},
    {"0V)OSU", 'F'},
    {"0V)OV", 'F'},
    {"0V)OV&", 'F'},
    {"0V)OV)", 'F'},
    {"0V)OV;", 'F'},
    {"0V)OVB", 'F'},
    {"0V)OVC", 'F'},
    {"0V)OVK", 'F'},
    {"0V)OVO", 'F'},
    {"0V)OVU", 'F'},
    {"0V)U((", 'F'},
    {"0V)U(E", 'F'},
    {"0V)UE(", 'F'},
    {"0V)UE1", 'F'},
    {"0V)UEF", 'F'},
    {"0V)UEK", 'F'},
    {"0V)UEN", 'F'},
    {"0V)UES", 'F'},
    {"0V)UEV", 'F'},
    {"0V,(((", 'F'},
    {"0V,((1", 'F'},
    {"0V,((E", 'F'},
    {"0V,((F", 'F'},
    {"0V,((N", 'F'},
    {"0V,((S", 'F'},
    {"0V,((V", 'F'},
    {"0V,(1)", 'F'},
    {"0V,(1O", 'F'},
    {"0V,(E(", 'F'},
    {"0V,(E1", 'F'},
    {"0V,(EF", 'F'},
    {"0V,(EK", 'F'},
    {"0V,(EN", 'F'},
    {"0V,(ES", 'F'},
    {"0V,(EV", 'F'},
    {"0V,(F(", 'F'},
    {"0V,(N)", 'F'},
    {"0V,(NO", 'F'},
    {"0V,(S)", 'F'},
    {"0V,(SO", 'F'},
    {"0V,(V)", 'F'},
    {"0V,(VO", 'F'},
    {"0V,1))", 'F'},
    {"0V,1),", 'F'},
    {"0V,1)O", 'F'},
    {"0V,1B(", 'F'},
    {"0V,1B1", 'F'},
    {"0V,1BF", 'F'},
    {"0V,1BN", 'F'},
    {"0V,1BS", 'F'},
    {"0V,1BV", 'F'},
    {"0V,1O(", 'F'},
    {"0V,1OF", 'F'},
    {"0V,1OS", 'F'},
    {"0V,1OV", 'F'},
    {"0V,1UE", 'F'},
    {"0V,F((", 'F'},
    {"0V,F()", 'F'},
    {"0V,F(1", 'F'},
    {"0V,F(F", 'F'},
    {"0V,F(N", 'F'},
    {"0V,F(S", 'F'},
    {"0V,F(T", 'F'},
    {"0V,F(V", 'F'},
    {"0V,N))", 'F'},
    {"0V,N),", 'F'},
    {"0V,N)O", 'F'},
    {"0V,NB(", 'F'},
    {"0V,NB1", 'F'},
    {"0V,NBF", 'F'},
    {"0V,NBN", 'F'},
    {"0V,NBS", 'F'},
    {"0V,NBV", 'F'},
    {"0V,NO(", 'F'},
    {"0V,NOF", 'F'},
    {"0V,NOS", 'F'},
    {"0V,NOV", 'F'},
    {"0V,NUE", 'F'},
    {"0V,S))", 'F'},
    {"0V,S),", 'F'},
    {"0V,S)O", 'F'},
    {"0V,SB(", 'F'},
    {"0V,SB1", 'F'},
    {"0V,SBF", 'F'},
    {"0V,SBN", 'F'},
    {"0V,SBS", 'F'},
    {"0V,SBV", 'F'},
    {"0V,SO(", 'F'},
    {"0V,SO1", 'F'},
    {"0V,SOF", 'F'},
    {"0V,SON", 'F'},
    {"0V,SOS", 'F'},
    {"0V,SOV", 'F'},
    {"0V,SUE", 'F'},
    {"0V,V))", 'F'},
    {"0V,V),", 'F'},
    {"0V,V)O", 'F'},
    {"0V,VB(", 'F'},
    {"0V,VB1", 'F'},
    {"0V,VBF", 'F'},
    {"0V,VBN", 'F'},
    {"0V,VBS", 'F'},
    {"0V,VBV", 'F'},
    {"0V,VO(", 'F'},
    {"0V,VOF", 'F'},
    {"0V,VOS", 'F'},
    {"0V,VUE", 'F'},
    {"0V;E((", 'F'},
    {"0V;E(1", 'F'},
    {"0V;E(E", 'F'},
    {"0V;E(F", 'F'},
    {"0V;E(N", 'F'},
    {"0V;E(S", 'F'},
    {"0V;E(V", 'F'},
    {"0V;E1,", 'F'},
    {"0V;E1;", 'F'},
    {"0V;E1C", 'F'},
    {"0V;E1O", 'F'},
    {"0V;E1T", 'F'},
    {"0V;EF(", 'F'},
    {"0V;EK(", 'F'},
    {"0V;EK1", 'F'},
    {"0V;EKF", 'F'},
    {"0V;EKN", 'F'},
    {"0V;EKO", 'F'},
    {"0V;EKS", 'F'},
    {"0V;EKV", 'F'},
    {"0V;EN,", 'F'},
    {"0V;EN;", 'F'},
    {"0V;ENC", 'F'},
    {"0V;ENK", 'F'},
    {"0V;ENO", 'F'},
    {"0V;ENT", 'F'},
    {"0V;EO(", 'F'},
    {"0V;ES,", 'F'},
    {"0V;ES;", 'F'},
    {"0V;ESC", 'F'},
    {"0V;ESO", 'F'},
    {"0V;EST", 'F'},
    {"0V;EV,", 'F'},
    {"0V;EV;", 'F'},
    {"0V;EVC", 'F'},
    {"0V;EVO", 'F'},
    {"0V;EVT", 'F'},
    {"0V;N:T", 'F'},
    {"0V;T((", 'F'},
    {"0V;T(1", 'F'},
    {"0V;T(E", 'F'},
    {"0V;T(F", 'F'},
    {"0V;T(N", 'F'},
    {"0V;T(S", 'F'},
    {"0V;T(V", 'F'},
    {"0V;T1,", 'F'},
    {"0V;T1;", 'F'},
    {"0V;T1C", 'F'},
    {"0V;T1F", 'F'},
    {"0V;T1O", 'F'},
    {"0V;T1T", 'F'},
    {"0V;T;", 'F'},
    {"0V;T;C", 'F'},
    {"0V;TF(", 'F'},
    {"0V;TK(", 'F'},
    {"0V;TK1", 'F'},
    {"0V;TKF", 'F'},
    {"0V;TKK", 'F'},
    {"0V;TKN", 'F'},
    {"0V;TKO", 'F'},
    {"0V;TKS", 'F'},
    {"0V;TKV", 'F'},
    {"0V;TN(", 'F'},
    {"0V;TN,", 'F'},
    {"0V;TN1", 'F'},
    {"0V;TN;", 'F'},
    {"0V;TNC", 'F'},
    {"0V;TNE", 'F'},
    {"0V;TNF", 'F'},
    {"0V;TNK", 'F'},
    {"0V;TNN", 'F'},
    {"0V;TNO", 'F'},
    {"0V;TNS", 'F'},
    {"0V;TNT", 'F'},
    {"0V;TNV", 'F'},
    {"0V;TO(", 'F'},
    {"0V;TS,", 'F'},
    {"0V;TS;", 'F'},
    {"0V;TSC", 'F'},
    {"0V;TSF", 'F'},
    {"0V;TSO", 'F'},
    {"0V;TST", 'F'},
    {"0V;TT(", 'F'},
    {"0V;TT1", 'F'},
    {"0V;TTF", 'F'},
    {"0V;TTN", 'F'},
    {"0V;TTS", 'F'},
    {"0V;TTV", 'F'},
    {"0V;TV,", 'F'},
    {"0V;TV;", 'F'},
    {"0V;TVC", 'F'},
    {"0V;TVF", 'F'},
    {"0V;TVO", 'F'},
    {"0V;TVT", 'F'},
    {"0VA(((", 'F'},
    {"0VA((1", 'F'},
    {"0VA((F", 'F'},
    {"0VA((N", 'F'},
    {"0VA((S", 'F'},
    {"0VA((V", 'F'},
    {"0VA(F(", 'F'},
    {"0VA(N)", 'F'},
    {"0VA(NO", 'F'},
    {"0VA(S)", 'F'},
    {"0VA(SO", 'F'},
    {"0VA(V)", 'F'},
    {"0VA(VO", 'F'},
    {"0VAF((", 'F'},
    {"0VAF()", 'F'},
    {"0VAF(1", 'F'},
    {"0VAF(F", 'F'},
    {"0VAF(N", 'F'},
    {"0VAF(S", 'F'},
    {"0VAF(V", 'F'},
    {"0VASO(", 'F'},
    {"0VASO1", 'F'},
    {"0VASOF", 'F'},
    {"0VASON", 'F'},
    {"0VASOS", 'F'},
    {"0VASOV", 'F'},
    {"0VASUE", 'F'},
    {"0VATO(", 'F'},
    {"0VATO1", 'F'},
    {"0VATOF", 'F'},
    {"0VATON", 'F'},
    {"0VATOS", 'F'},
    {"0VATOV", 'F'},
    {"0VATUE", 'F'},
    {"0VAVO(", 'F'},
    {"0VAVOF", 'F'},
    {"0VAVOS", 'F'},
    {"0VAVUE", 'F'},
    {"0VB(((", 'F'},
    {"0VB((1", 'F'},
    {"0VB((F", 'F'},
    {"0VB((N", 'F'},
    {"0VB((S", 'F'},
    {"0VB((V", 'F'},
    {"0VB(1)", 'F'},
    {"0VB(1O", 'F'},
    {"0VB(F(", 'F'},
    {"0VB(N)", 'F'},
    {"0VB(NO", 'F'},
    {"0VB(S)", 'F'},
    {"0VB(SO", 'F'},
    {"0VB(V)", 'F'},
    {"0VB(VO", 'F'},
    {"0VB1", 'F'},
    {"0VB1&(", 'F'},
    {"0VB1&1", 'F'},
    {"0VB1&F", 'F'},
    {"0VB1&N", 'F'},
    {"0VB1&S", 'F'},
    {"0VB1&V", 'F'},
    {"0VB1,(", 'F'},
    {"0VB1,F", 'F'},
    {"0VB1,V", 'F'},
    {"0VB1;", 'F'},
    {"0VB1;C", 'F'},
    {"0VB1B(", 'F'},
    {"0VB1B1", 'F'},
    {"0VB1BF", 'F'},
    {"0VB1BN", 'F'},
    {"0VB1BS", 'F'},
    {"0VB1BV", 'F'},
    {"0VB1C", 'F'},
    {"0VB1K(", 'F'},
    {"0VB1K1", 'F'},
    {"0VB1KF", 'F'},
    {"0VB1KN", 'F'},
    {"0VB1KS", 'F'},
    {"0VB1KV", 'F'},
    {"0VB1O(", 'F'},
    {"0VB1OF", 'F'},
    {"0VB1OS", 'F'},
    {"0VB1OV", 'F'},
    {"0VB1U(", 'F'},
    {"0VB1UE", 'F'},
    {"0VBE((", 'F'},
    {"0VBE(1", 'F'},
    {"0VBE(F", 'F'},
    {"0VBE(N", 'F'},
    {"0VBE(S", 'F'},
    {"0VBE(V", 'F'},
    {"0VBEK(", 'F'},
    {"0VBF((", 'F'},
    {"0VBF()", 'F'},
    {"0VBF(1", 'F'},
    {"0VBF(F", 'F'},
    {"0VBF(N", 'F'},
    {"0VBF(S", 'F'},
    {"0VBF(V", 'F'},
    {"0VBN", 'F'},
    {"0VBN&(", 'F'},
    {"0VBN&1", 'F'},
    {"0VBN&F", 'F'},
    {"0VBN&N", 'F'},
    {"0VBN&S", 'F'},
    {"0VBN&V", 'F'},
    {"0VBN,(", 'F'},
    {"0VBN,F", 'F'},
    {"0VBN,V", 'F'},
    {"0VBN;", 'F'},
    {"0VBN;C", 'F'},
    {"0VBNB(", 'F'},
    {"0VBNB1", 'F'},
    {"0VBNBF", 'F'},
    {"0VBNBN", 'F'},
    {"0VBNBS", 'F'},
    {"0VBNBV", 'F'},
    {"0VBNC", 'F'},
    {"0VBNK(", 'F'},
    {"0VBNK1", 'F'},
    {"0VBNKF", 'F'},
    {"0VBNKN", 'F'},
    {"0VBNKS", 'F'},
    {"0VBNKV", 'F'},
    {"0VBNO(", 'F'},
    {"0VBNOF", 'F'},
    {"0VBNOS", 'F'},
    {"0VBNOV", 'F'},
    {"0VBNU(", 'F'},
    {"0VBNUE", 'F'},
    {"0VBS", 'F'},
    {"0VBS&(", 'F'},
    {"0VBS&1", 'F'},
    {"0VBS&F", 'F'},
    {"0VBS&N", 'F'},
    {"0VBS&S", 'F'},
    {"0VBS&V", 'F'},
    {"0VBS,(", 'F'},
    {"0VBS,F", 'F'},
    {"0VBS,V", 'F'},
    {"0VBS;", 'F'},
    {"0VBS;C", 'F'},
    {"0VBSB(", 'F'},
    {"0VBSB1", 'F'},
    {"0VBSBF", 'F'},
    {"0VBSBN", 'F'},
    {"0VBSBS", 'F'},
    {"0VBSBV", 'F'},
    {"0VBSC", 'F'},
    {"0VBSK(", 'F'},
    {"0VBSK1", 'F'},
    {"0VBSKF", 'F'},
    {"0VBSKN", 'F'},
    {"0VBSKS", 'F'},
    {"0VBSKV", 'F'},
    {"0VBSO(", 'F'},
    {"0VBSO1", 'F'},
    {"0VBSOF", 'F'},
    {"0VBSON", 'F'},
    {"0VBSOS", 'F'},
    {"0VBSOV", 'F'},
    {"0VBSU(", 'F'},
    {"0VBSUE", 'F'},
    {"0VBV", 'F'},
    {"0VBV&(", 'F'},
    {"0VBV&1", 'F'},
    {"0VBV&F", 'F'},
    {"0VBV&N", 'F'},
    {"0VBV&S", 'F'},
    {"0VBV&V", 'F'},
    {"0VBV,(", 'F'},
    {"0VBV,1", 'F'},
    {"0VBV,F", 'F'},
    {"0VBV,N", 'F'},
    {"0VBV,S", 'F'},
    {"0VBV,V", 'F'},
    {"0VBV;", 'F'},
    {"0VBV;C", 'F'},
    {"0VBVB(", 'F'},
    {"0VBVB1", 'F'},
    {"0VBVBF", 'F'},
    {"0VBVBN", 'F'},
    {"0VBVBS", 'F'},
    {"0VBVBV", 'F'},
    {"0VBVC", 'F'},
    {"0VBVK(", 'F'},
    {"0VBVK1", 'F'},
    {"0VBVKF", 'F'},
    {"0VBVKN", 'F'},
    {"0VBVKS", 'F'},
    {"0VBVKV", 'F'},
    {"0VBVO(", 'F'},
    {"0VBVOF", 'F'},
    {"0VBVOS", 'F'},
    {"0VBVU(", 'F'},
    {"0VBVUE", 'F'},
    {"0VC", 'F'},
    {"0VE(((", 'F'},
    {"0VE((1", 'F'},
    {"0VE((F", 'F'},
    {"0VE((N", 'F'},
    {"0VE((S", 'F'},
    {"0VE((V", 'F'},
    {"0VE(1)", 'F'},
    {"0VE(1O", 'F'},
    {"0VE(F(", 'F'},
    {"0VE(N)", 'F'},
    {"0VE(NO", 'F'},
    {"0VE(S)", 'F'},
    {"0VE(SO", 'F'},
    {"0VE(V)", 'F'},
    {"0VE(VO", 'F'},
    {"0VE1C", 'F'},
    {"0VE1O(", 'F'},
    {"0VE1OF", 'F'},
    {"0VE1OS", 'F'},
    {"0VE1OV", 'F'},
    {"0VE1UE", 'F'},
    {"0VEF((", 'F'},
    {"0VEF()", 'F'},
    {"0VEF(1", 'F'},
    {"0VEF(F", 'F'},
    {"0VEF(N", 'F'},
    {"0VEF(S", 'F'},
    {"0VEF(V", 'F'},
    {"0VEK((", 'F'},
    {"0VEK(1", 'F'},
    {"0VEK(E", 'F'},
    {"0VEK(F", 'F'},
    {"0VEK(N", 'F'},
    {"0VEK(S", 'F'},
    {"0VEK(V", 'F'},
    {"0VEK1C", 'F'},
    {"0VEK1O", 'F'},
    {"0VEK1U", 'F'},
    {"0VEKF(", 'F'},
    {"0VEKNC", 'F'},
    {"0VEKNE", 'F'},
    {"0VEKNU", 'F'},
    {"0VEKOK", 'F'},
    {"0VEKSC", 'F'},
    {"0VEKSO", 'F'},
    {"0VEKSU", 'F'},
    {"0VEKU(", 'F'},
    {"0VEKU1", 'F'},
    {"0VEKUE", 'F'},
    {"0VEKUF", 'F'},
    {"0VEKUN", 'F'},
    {"0VEKUS", 'F'},
    {"0VEKUV", 'F'},
    {"0VEKVC", 'F'},
    {"0VEKVO", 'F'},
    {"0VEKVU", 'F'},
    {"0VENC", 'F'},
    {"0VENEN", 'F'},
    {"0VENO(", 'F'},
    {"0VENOF", 'F'},
    {"0VENOS", 'F'},
    {"0VENOV", 'F'},
    {"0VENUE", 'F'},
    {"0VEOKN", 'F'},
    {"0VESC", 'F'},
    {"0VESO(", 'F'},
    {"0VESO1", 'F'},
    {"0VESOF", 'F'},
    {"0VESON", 'F'},
    {"0VESOS", 'F'},
    {"0VESOV", 'F'},
    {"0VESUE", 'F'},
    {"0VEU((", 'F'},
    {"0VEU(1", 'F'},
    {"0VEU(F", 'F'},
    {"0VEU(N", 'F'},
    {"0VEU(S", 'F'},
    {"0VEU(V", 'F'},
    {"0VEU1,", 'F'},
    {"0VEU1C", 'F'},
    {"0VEU1O", 'F'},
    {"0VEUEF", 'F'},
    {"0VEUEK", 'F'},
    {"0VEUF(", 'F'},
    {"0VEUN,", 'F'},
    {"0VEUNC", 'F'},
    {"0VEUNO", 'F'},
    {"0VEUS,", 'F'},
    {"0VEUSC", 'F'},
    {"0VEUSO", 'F'},
    {"0VEUV,", 'F'},
    {"0VEUVC", 'F'},
    {"0VEUVO", 'F'},
    {"0VEVC", 'F'},
    {"0VEVO(", 'F'},
    {"0VEVOF", 'F'},
    {"0VEVOS", 'F'},
    {"0VEVUE", 'F'},
    {"0VF(((", 'F'},
    {"0VF(()", 'F'},
    {"0VF((1", 'F'},
    {"0VF((F", 'F'},
    {"0VF((N", 'F'},
    {"0VF((S", 'F'},
    {"0VF((V", 'F'},
    {"0VF())", 'F'},
    {"0VF()1", 'F'},
    {"0VF()F", 'F'},
    {"0VF()K", 'F'},
    {"0VF()N", 'F'},
    {"0VF()O", 'F'},
    {"0VF()S", 'F'},
    {"0VF()U", 'F'},
    {"0VF()V", 'F'},
    {"0VF(1)", 'F'},
    {"0VF(1N", 'F'},
    {"0VF(1O", 'F'},
    {"0VF(F(", 'F'},
    {"0VF(N)", 'F'},
    {"0VF(N,", 'F'},
    {"0VF(NO", 'F'},
    {"0VF(S)", 'F'},
    {"0VF(SO", 'F'},
    {"0VF(V)", 'F'},
    {"0VF(VO", 'F'},
    {"0VK(((", 'F'},
    {"0VK((1", 'F'},
    {"0VK((F", 'F'},
    {"0VK((N", 'F'},
    {"0VK((S", 'F'},
    {"0VK((V", 'F'},
    {"0VK(1)", 'F'},
    {"0VK(1O", 'F'},
    {"0VK(F(", 'F'},
    {"0VK(N)", 'F'},
    {"0VK(NO", 'F'},
    {"0VK(S)", 'F'},
    {"0VK(SO", 'F'},
    {"0VK(V)", 'F'},
    {"0VK(VO", 'F'},
    {"0VK)&(", 'F'},
    {"0VK)&1", 'F'},
    {"0VK)&F", 'F'},
    {"0VK)&N", 'F'},
    {"0VK)&S", 'F'},
    {"0VK)&V", 'F'},
    {"0VK))&", 'F'},
    {"0VK)))", 'F'},
    {"0VK));", 'F'},
    {"0VK))B", 'F'},
    {"0VK))E", 'F'},
    {"0VK))K", 'F'},
    {"0VK))O", 'F'},
    {"0VK))U", 'F'},
    {"0VK);E", 'F'},
    {"0VK);T", 'F'},
    {"0VK)B(", 'F'},
    {"0VK)B1", 'F'},
    {"0VK)BF", 'F'},
    {"0VK)BN", 'F'},
    {"0VK)BS", 'F'},
    {"0VK)BV", 'F'},
    {"0VK)E(", 'F'},
    {"0VK)E1", 'F'},
    {"0VK)EF", 'F'},
    {"0VK)EK", 'F'},
    {"0VK)EN", 'F'},
    {"0VK)ES", 'F'},
    {"0VK)EV", 'F'},
    {"0VK)OF", 'F'},
    {"0VK)UE", 'F'},
    {"0VK1", 'F'},
    {"0VK1&(", 'F'},
    {"0VK1&1", 'F'},
    {"0VK1&F", 'F'},
    {"0VK1&N", 'F'},
    {"0VK1&S", 'F'},
    {"0VK1&V", 'F'},
    {"0VK1;", 'F'},
    {"0VK1;C", 'F'},
    {"0VK1;E", 'F'},
    {"0VK1;T", 'F'},
    {"0VK1B(", 'F'},
    {"0VK1B1", 'F'},
    {"0VK1BF", 'F'},
    {"0VK1BN", 'F'},
    {"0VK1BS", 'F'},
    {"0VK1BV", 'F'},
    {"0VK1C", 'F'},
    {"0VK1E(", 'F'},
    {"0VK1E1", 'F'},
    {"0VK1EF", 'F'},
    {"0VK1EK", 'F'},
    {"0VK1EN", 'F'},
    {"0VK1ES", 'F'},
    {"0VK1EV", 'F'},
    {"0VK1O(", 'F'},
    {"0VK1OF", 'F'},
    {"0VK1OS", 'F'},
    {"0VK1OV", 'F'},
    {"0VK1U(", 'F'},
    {"0VK1UE", 'F'},
    {"0VKF((", 'F'},
    {"0VKF()", 'F'},
    {"0VKF(1", 'F'},
    {"0VKF(F", 'F'},
    {"0VKF(N", 'F'},
    {"0VKF(S", 'F'},
    {"0VKF(V", 'F'},
    {"0VKN", 'F'},
    {"0VKN&(", 'F'},
    {"0VKN&1", 'F'},
    {"0VKN&F", 'F'},
    {"0VKN&N", 'F'},
    {"0VKN&S", 'F'},
    {"0VKN&V", 'F'},
    {"0VKN;", 'F'},
    {"0VKN;C", 'F'},
    {"0VKN;E", 'F'},
    {"0VKN;T", 'F'},
    {"0VKNB(", 'F'},
    {"0VKNB1", 'F'},
    {"0VKNBF", 'F'},
    {"0VKNBN", 'F'},
    {"0VKNBS", 'F'},
    {"0VKNBV", 'F'},
    {"0VKNC", 'F'},
    {"0VKNE(", 'F'},
    {"0VKNE1", 'F'},
    {"0VKNEF", 'F'},
    {"0VKNEN", 'F'},
    {"0VKNES", 'F'},
    {"0VKNEV", 'F'},
    {"0VKNU(", 'F'},
    {"0VKNUE", 'F'},
    {"0VKS", 'F'},
    {"0VKS&(", 'F'},
    {"0VKS&1", 'F'},
    {"0VKS&F", 'F'},
    {"0VKS&N", 'F'},
    {"0VKS&S", 'F'},
    {"0VKS&V", 'F'},
    {"0VKS;", 'F'},
    {"0VKS;C", 'F'},
    {"0VKS;E", 'F'},
    {"0VKS;T", 'F'},
    {"0VKSB(", 'F'},
    {"0VKSB1", 'F'},
    {"0VKSBF", 'F'},
    {"0VKSBN", 'F'},
    {"0VKSBS", 'F'},
    {"0VKSBV", 'F'},
    {"0VKSC", 'F'},
    {"0VKSE(", 'F'},
    {"0VKSE1", 'F'},
    {"0VKSEF", 'F'},
    {"0VKSEK", 'F'},
    {"0VKSEN", 'F'},
    {"0VKSES", 'F'},
    {"0VKSEV", 'F'},
    {"0VKSO(", 'F'},
    {"0VKSO1", 'F'},
    {"0VKSOF", 'F'},
    {"0VKSON", 'F'},
    {"0VKSOS", 'F'},
    {"0VKSOV", 'F'},
    {"0VKSU(", 'F'},
    {"0VKSUE", 'F'},
    {"0VKUE(", 'F'},
    {"0VKUE1", 'F'},
    {"0VKUEF", 'F'},
    {"0VKUEK", 'F'},
    {"0VKUEN", 'F'},
    {"0VKUES", 'F'},
    {"0VKUEV", 'F'},
    {"0VKV", 'F'},
    {"0VKV&(", 'F'},
    {"0VKV&1", 'F'},
    {"0VKV&F", 'F'},
    {"0VKV&N", 'F'},
    {"0VKV&S", 'F'},
    {"0VKV&V", 'F'},
    {"0VKV;", 'F'},
    {"0VKV;C", 'F'},
    {"0VKV;E", 'F'},
    {"0VKV;T", 'F'},
    {"0VKVB(", 'F'},
    {"0VKVB1", 'F'},
    {"0VKVBF", 'F'},
    {"0VKVBN", 'F'},
    {"0VKVBS", 'F'},
    {"0VKVBV", 'F'},
    {"0VKVC", 'F'},
    {"0VKVE(", 'F'},
    {"0VKVE1", 'F'},
    {"0VKVEF", 'F'},
    {"0VKVEK", 'F'},
    {"0VKVEN", 'F'},
    {"0VKVES", 'F'},
    {"0VKVEV", 'F'},
    {"0VKVO(", 'F'},
    {"0VKVOF", 'F'},
    {"0VKVOS", 'F'},
    {"0VKVU(", 'F'},
    {"0VKVUE", 'F'},
    {"0VO(((", 'F'},
    {"0VO((1", 'F'},
    {"0VO((E", 'F'},
    {"0VO((F", 'F'},
    {"0VO((N", 'F'},
    {"0VO((O", 'F'},
    {"0VO((S", 'F'},
    {"0VO((T", 'F'},
    {"0VO((V", 'F'},
    {"0VO(1&", 'F'},
    {"0VO(1)", 'F'},
    {"0VO(1,", 'F'},
    {"0VO(1O", 'F'},
    {"0VO(E(", 'F'},
    {"0VO(E1", 'F'},
    {"0VO(EE", 'F'},
    {"0VO(EF", 'F'},
    {"0VO(EK", 'F'},
    {"0VO(EN", 'F'},
    {"0VO(ES", 'F'},
    {"0VO(EV", 'F'},
    {"0VO(F(", 'F'},
    {"0VO(N&", 'F'},
    {"0VO(N)", 'F'},
    {"0VO(N,", 'F'},
    {"0VO(NO", 'F'},
    {"0VO(O(", 'F'},
    {"0VO(O1", 'F'},
    {"0VO(OF", 'F'},
    {"0VO(ON", 'F'},
    {"0VO(OS", 'F'},
    {"0VO(OV", 'F'},
    {"0VO(S&", 'F'},
    {"0VO(S)", 'F'},
    {"0VO(S,", 'F'},
    {"0VO(SO", 'F'},
    {"0VO(T(", 'F'},
    {"0VO(V&", 'F'},
    {"0VO(V)", 'F'},
    {"0VO(V,", 'F'},
    {"0VO(VO", 'F'},
    {"0VOF((", 'F'},
    {"0VOF()", 'F'},
    {"0VOF(1", 'F'},
    {"0VOF(E", 'F'},
    {"0VOF(F", 'F'},
    {"0VOF(N", 'F'},
    {"0VOF(S", 'F'},
    {"0VOF(V", 'F'},
    {"0VOK&(", 'F'},
    {"0VOK&1", 'F'},
    {"0VOK&F", 'F'},
    {"0VOK&N", 'F'},
    {"0VOK&S", 'F'},
    {"0VOK&V", 'F'},
    {"0VOK((", 'F'},
    {"0VOK(1", 'F'},
    {"0VOK(F", 'F'},
    {"0VOK(N", 'F'},
    {"0VOK(S", 'F'},
    {"0VOK(V", 'F'},
    {"0VOK1C", 'F'},
    {"0VOK1O", 'F'},
    {"0VOKF(", 'F'},
    {"0VOKNC", 'F'},
    {"0VOKO(", 'F'},
    {"0VOKO1", 'F'},
    {"0VOKOF", 'F'},
    {"0VOKON", 'F'},
    {"0VOKOS", 'F'},
    {"0VOKOV", 'F'},
    {"0VOKSC", 'F'},
    {"0VOKSO", 'F'},
    {"0VOKVC", 'F'},
    {"0VOKVO", 'F'},
    {"0VOS", 'F'},
    {"0VOS&(", 'F'},
    {"0VOS&1", 'F'},
    {"0VOS&E", 'F'},
    {"0VOS&F", 'F'},
    {"0VOS&K", 'F'},
    {"0VOS&N", 'F'},
    {"0VOS&S", 'F'},
    {"0VOS&U", 'F'},
    {"0VOS&V", 'F'},
    {"0VOS((", 'F'},
    {"0VOS(E", 'F'},
    {"0VOS(U", 'F'},
    {"0VOS)&", 'F'},
    {"0VOS))", 'F'},
    {"0VOS),", 'F'},
    {"0VOS);", 'F'},
    {"0VOS)B", 'F'},
    {"0VOS)E", 'F'},
    {"0VOS)K", 'F'},
    {"0VOS)O", 'F'},
    {"0VOS)U", 'F'},
    {"0VOS,(", 'F'},
    {"0VOS,F", 'F'},
    {"0VOS,V", 'F'},
    {"0VOS1(", 'F'},
    {"0VOS1F", 'F'},
    {"0VOS1N", 'F'},
    {"0VOS1O", 'F'},
    {"0VOS1S", 'F'},
    {"0VOS1U", 'F'},
    {"0VOS1V", 'F'},
    {"0VOS;", 'F'},
    {"0VOS;C", 'F'},
    {"0VOS;E", 'F'},
    {"0VOS;N", 'F'},
    {"0VOS;T", 'F'},
    {"0VOSA(", 'F'},
    {"0VOSAF", 'F'},
    {"0VOSAS", 'F'},
    {"0VOSAT", 'F'},
    {"0VOSAV", 'F'},
    {"0VOSB(", 'F'},
    {"0VOSB1", 'F'},
    {"0VOSBE", 'F'},
    {"0VOSBF", 'F'},
    {"0VOSBN", 'F'},
    {"0VOSBS", 'F'},
    {"0VOSBV", 'F'},
    {"0VOSC", 'F'},
    {"0VOSE(", 'F'},
    {"0VOSE1", 'F'},
    {"0VOSEF", 'F'},
    {"0VOSEK", 'F'},
    {"0VOSEN", 'F'},
    {"0VOSEO", 'F'},
    {"0VOSES", 'F'},
    {"0VOSEU", 'F'},
    {"0VOSEV", 'F'},
    {"0VOSF(", 'F'},
    {"0VOSK(", 'F'},
    {"0VOSK)", 'F'},
    {"0VOSK1", 'F'},
    {"0VOSKB", 'F'},
    {"0VOSKF", 'F'},
    {"0VOSKN", 'F'},
    {"0VOSKS", 'F'},
    {"0VOSKU", 'F'},
    {"0VOSKV", 'F'},
    {"0VOSO(", 'F'},
    {"0VOSO1", 'F'},
    {"0VOSOF", 'F'},
    {"0VOSOK", 'F'},
    {"0VOSON", 'F'},
    {"0VOSOS", 'F'},
    {"0VOSOT", 'F'},
    {"0VOSOU", 'F'},
    {"0VOSOV", 'F'},
    {"0VOSU", 'F'},
    {"0VOSU(", 'F'},
    {"0VOSU1", 'F'},
    {"0VOSU;", 'F'},
    {"0VOSUC", 'F'},
    {"0VOSUE", 'F'},
    {"0VOSUF", 'F'},
    {"0VOSUK", 'F'},
    {"0VOSUN", 'F'},
    {"0VOSUO", 'F'},
    {"0VOSUS", 'F'},
    {"0VOSUT", 'F'},
    {"0VOSUV", 'F'},
    {"0VOSV(", 'F'},
    {"0VOSVF", 'F'},
    {"0VOSVO", 'F'},
    {"0VOSVS", 'F'},
    {"0VOSVU", 'F'},
    {"0VOT((", 'F'},
    {"0VOT(1", 'F'},
    {"0VOT(F", 'F'},
    {"0VOT(N", 'F'},
    {"0VOT(S", 'F'},
    {"0VOT(V", 'F'},
    {"0VOU((", 'F'},
    {"0VOU(E", 'F'},
    {"0VOUEK", 'F'},
    {"0VOUEN", 'F'},
    {"0VU", 'F'},
    {"0VU(((", 'F'},
    {"0VU((1", 'F'},
    {"0VU((E", 'F'},
    {"0VU((F", 'F'},
    {"0VU((N", 'F'},
    {"0VU((S", 'F'},
    {"0VU((V", 'F'},
    {"0VU(1)", 'F'},
    {"0VU(1O", 'F'},
    {"0VU(E(", 'F'},
    {"0VU(E1", 'F'},
    {"0VU(EF", 'F'},
    {"0VU(EK", 'F'},
    {"0VU(EN", 'F'},
    {"0VU(ES", 'F'},
    {"0VU(EV", 'F'},
    {"0VU(F(", 'F'},
    {"0VU(N)", 'F'},
    {"0VU(NO", 'F'},
    {"0VU(S)", 'F'},
    {"0VU(SO", 'F'},
    {"0VU(V)", 'F'},
    {"0VU(VO", 'F'},
    {"0VU1,(", 'F'},
    {"0VU1,F", 'F'},
    {"0VU1,V", 'F'},
    {"0VU1C", 'F'},
    {"0VU1O(", 'F'},
    {"0VU1OF", 'F'},
    {"0VU1OS", 'F'},
    {"0VU1OV", 'F'},
    {"0VU;", 'F'},
    {"0VU;C", 'F'},
    {"0VUC", 'F'},
    {"0VUE", 'F'},
    {"0VUE((", 'F'},
    {"0VUE(1", 'F'},
    {"0VUE(E", 'F'},
    {"0VUE(F", 'F'},
    {"0VUE(N", 'F'},
    {"0VUE(O", 'F'},
    {"0VUE(S", 'F'},
    {"0VUE(V", 'F'},
    {"0VUE1", 'F'},
    {"0VUE1&", 'F'},
    {"0VUE1(", 'F'},
    {"0VUE1)", 'F'},
    {"0VUE1,", 'F'},
    {"0VUE1;", 'F'},
    {"0VUE1B", 'F'},
    {"0VUE1C", 'F'},
    {"0VUE1F", 'F'},
    {"0VUE1K", 'F'},
    {"0VUE1N", 'F'},
    {"0VUE1O", 'F'},
    {"0VUE1S", 'F'},
    {"0VUE1U", 'F'},
    {"0VUE1V", 'F'},
    {"0VUE;", 'F'},
    {"0VUE;C", 'F'},
    {"0VUEC", 'F'},
    {"0VUEF", 'F'},
    {"0VUEF(", 'F'},
    {"0VUEF,", 'F'},
    {"0VUEF;", 'F'},
    {"0VUEFC", 'F'},
    {"0VUEK", 'F'},
    {"0VUEK(", 'F'},
    {"0VUEK1", 'F'},
    {"0VUEK;", 'F'},
    {"0VUEKC", 'F'},
    {"0VUEKF", 'F'},
    {"0VUEKN", 'F'},
    {"0VUEKO", 'F'},
    {"0VUEKS", 'F'},
    {"0VUEKV", 'F'},
    {"0VUEN", 'F'},
    {"0VUEN&", 'F'},
    {"0VUEN(", 'F'},
    {"0VUEN)", 'F'},
    {"0VUEN,", 'F'},
    {"0VUEN1", 'F'},
    {"0VUEN;", 'F'},
    {"0VUENB", 'F'},
    {"0VUENC", 'F'},
    {"0VUENF", 'F'},
    {"0VUENK", 'F'},
    {"0VUENO", 'F'},
    {"0VUENS", 'F'},
    {"0VUENU", 'F'},
    {"0VUEOK", 'F'},
    {"0VUEON", 'F'},
    {"0VUEOO", 'F'},
    {"0VUES", 'F'},
    {"0VUES&", 'F'},
    {"0VUES(", 'F'},
    {"0VUES)", 'F'},
    {"0VUES,", 'F'},
    {"0VUES1", 'F'},
    {"0VUES;", 'F'},
    {"0VUESB", 'F'},
    {"0VUESC", 'F'},
    {"0VUESF", 'F'},
    {"0VUESK", 'F'},
    {"0VUESO", 'F'},
    {"0VUESU", 'F'},
    {"0VUESV", 'F'},
    {"0VUEV", 'F'},
    {"0VUEV&", 'F'},
    {"0VUEV(", 'F'},
    {"0VUEV)", 'F'},
    {"0VUEV,", 'F'},
    {"0VUEV;", 'F'},
    {"0VUEVB", 'F'},
    {"0VUEVC", 'F'},
    {"0VUEVF", 'F'},
    {"0VUEVK", 'F'},
    {"0VUEVN", 'F'},
    {"0VUEVO", 'F'},
    {"0VUEVS", 'F'},
    {"0VUEVU", 'F'},
    {"0VUF((", 'F'},
    {"0VUF()", 'F'},
    {"0VUF(1", 'F'},
    {"0VUF(F", 'F'},
    {"0VUF(N", 'F'},
    {"0VUF(S", 'F'},
    {"0VUF(V", 'F'},
    {"0VUK((", 'F'},
    {"0VUK(E", 'F'},
    {"0VUN((", 'F'},
    {"0VUN(1", 'F'},
    {"0VUN(F", 'F'},
    {"0VUN(S", 'F'},
    {"0VUN(V", 'F'},
    {"0VUN,(", 'F'},
    {"0VUN,F", 'F'},
    {"0VUN,V", 'F'},
    {"0VUN1(", 'F'},
    {"0VUN1,", 'F'},
    {"0VUN1O", 'F'},
    {"0VUNC", 'F'},
    {"0VUNE(", 'F'},
    {"0VUNE1", 'F'},
    {"0VUNEF", 'F'},
    {"0VUNEN", 'F'},
    {"0VUNES", 'F'},
    {"0VUNEV", 'F'},
    {"0VUNF(", 'F'},
    {"0VUNO(", 'F'},
    {"0VUNOF", 'F'},
    {"0VUNOS", 'F'},
    {"0VUNOV", 'F'},
    {"0VUNS(", 'F'},
    {"0VUNS,", 'F'},
    {"0VUNSO", 'F'},
    {"0VUO((", 'F'},
    {"0VUO(E", 'F'},
    {"0VUON(", 'F'},
    {"0VUON1", 'F'},
    {"0VUONF", 'F'},
    {"0VUONS", 'F'},
    {"0VUS,(", 'F'},
    {"0VUS,F", 'F'},
    {"0VUS,V", 'F'},
    {"0VUSC", 'F'},
    {"0VUSO(", 'F'},
    {"0VUSO1", 'F'},
    {"0VUSOF", 'F'},
    {"0VUSON", 'F'},
    {"0VUSOS", 'F'},
    {"0VUSOV", 'F'},
    {"0VUTN(", 'F'},
    {"0VUTN1", 'F'},
    {"0VUTNF", 'F'},
    {"0VUTNS", 'F'},
    {"0VUV,(", 'F'},
    {"0VUV,1", 'F'},
    {"0VUV,F", 'F'},
    {"0VUV,N", 'F'},
    {"0VUV,S", 'F'},
    {"0VUV,V", 'F'},
    {"0VUVC", 'F'},
    {"0VUVO(", 'F'},
    {"0VUVOF", 'F'},
    {"0VUVOS", 'F'},
    {"0X", 'F'},
    {"::", 'o'},
    {":=", 'o'},
    {"<<", 'o'},
    {"<=", 'o'},
    {"<>", 'o'},
    {"<@", 'o'},
    {">=", 'o'},
    {">>", 'o'},
    {"@>", 'o'},
    {"ABORT", 'k'},
    {"ABS", 'f'},
    {"ACCESSIBLE", 'k'},
    {"ACOS", 'f'},
    {"ADD", 'k'},
    {"ADDDATE", 'f'},
    {"ADDTIME", 'f'},
    {"AES_DECRYPT", 'f'},
    {"AES_ENCRYPT", 'f'},
    {"AGAINST", 'k'},
    {"AGE", 'f'},
    {"ALL_USERS", 'k'},
    {"ALTER", 'k'},
    {"ALTER DOMAIN", 'k'},
    {"ALTER TABLE", 'k'},
    {"ANALYZE", 'k'},
    {"AND", '&'},
    {"ANYARRAY", 't'},
    {"ANYELEMENT", 't'},
    {"ANYNONARRY", 't'},
    {"APPLOCK_MODE", 'f'},
    {"APPLOCK_TEST", 'f'},
    {"APP_NAME", 'f'},
    {"ARRAY_AGG", 'f'},
    {"ARRAY_CAT", 'f'},
    {"ARRAY_DIM", 'f'},
    {"ARRAY_FILL", 'f'},
    {"ARRAY_LENGTH", 'f'},
    {"ARRAY_LOWER", 'f'},
    {"ARRAY_NDIMS", 'f'},
    {"ARRAY_PREPEND", 'f'},
    {"ARRAY_TO_JSON", 'f'},
    {"ARRAY_TO_STRING", 'f'},
    {"ARRAY_UPPER", 'f'},
    {"AS", 'k'},
    {"ASC", 'k'},
    {"ASCII", 'f'},
    {"ASENSITIVE", 'k'},
    {"ASIN", 'f'},
    {"ASSEMBLYPROPERTY", 'f'},
    {"ASYMKEY_ID", 'f'},
    {"AT TIME", 'n'},
    {"AT TIME ZONE", 'k'},
    {"ATAN", 'f'},
    {"ATAN2", 'f'},
    {"AUTOINCREMENT", 'k'},
    {"AVG", 'f'},
    {"BEFORE", 'k'},
    {"BEGIN", 'T'},
    {"BENCHMARK", 'f'},
    {"BETWEEN", 'o'},
    {"BIGINT", 't'},
    {"BIGSERIAL", 't'},
    {"BIN", 'f'},
    {"BINARY", 't'},
    {"BINARY_DOUBLE_INFINITY", '1'},
    {"BINARY_DOUBLE_NAN", '1'},
    {"BINARY_FLOAT_INFINITY", '1'},
    {"BINARY_FLOAT_NAN", '1'},
    {"BINBINARY", 'f'},
    {"BIT_AND", 'f'},
    {"BIT_COUNT", 'f'},
    {"BIT_LENGTH", 'f'},
    {"BIT_OR", 'f'},
    {"BIT_XOR", 'f'},
    {"BLOB", 'k'},
    {"BOOLEAN", 't'},
    {"BOOL_AND", 'f'},
    {"BOOL_OR", 'f'},
    {"BOTH", 'k'},
    {"BTRIM", 'f'},
    {"BY", 'n'},
    {"BYTEA", 't'},
    {"CALL", 'T'},
    {"CASCADE", 'k'},
    {"CASE", 'E'},
    {"CAST", 'f'},
    {"CBOOL", 'f'},
    {"CBRT", 'f'},
    {"CBYTE", 'f'},
    {"CCUR", 'f'},
    {"CDATE", 'f'},
    {"CDBL", 'f'},
    {"CEIL", 'f'},
    {"CEILING", 'f'},
    {"CERTENCODED", 'f'},
    {"CERTPRIVATEKEY", 'f'},
    {"CERT_ID", 'f'},
    {"CERT_PROPERTY", 'f'},
    {"CHANGE", 'k'},
    {"CHANGES", 'f'},
    {"CHAR", 'f'},
    {"CHARACTER", 't'},
    {"CHARACTER VARYING", 't'},
    {"CHARACTER_LENGTH", 'f'},
    {"CHARINDEX", 'f'},
    {"CHARSET", 'f'},
    {"CHAR_LENGTH", 'f'},
    {"CHDIR", 'f'},
    {"CHDRIVE", 'f'},
    {"CHECK", 'k'},
    {"CHECKSUM_AGG", 'f'},
    {"CHOOSE", 'f'},
    {"CHR", 'f'},
    {"CINT", 'f'},
    {"CLNG", 'f'},
    {"CLOCK_TIMESTAMP", 'f'},
    {"COALESCE", 'f'},
    {"COERCIBILITY", 'f'},
    {"COLLATE", 'A'},
    {"COLLATION", 'f'},
    {"COLLATIONPROPERTY", 'f'},
    {"COLUMN", 'k'},
    {"COLUMNPROPERTY", 'f'},
    {"COLUMNS_UPDATED", 'f'},
    {"COL_LENGTH", 'f'},
    {"COL_NAME", 'f'},
    {"COMPRESS", 'f'},
    {"CONCAT", 'f'},
    {"CONCAT_WS", 'f'},
    {"CONDITION", 'k'},
    {"CONNECTION_ID", 'f'},
    {"CONSTRAINT", 'k'},
    {"CONTINUE", 'k'},
    {"CONV", 'f'},
    {"CONVERT", 'f'},
    {"CONVERT_FROM", 'f'},
    {"CONVERT_TO", 'f'},
    {"CONVERT_TZ", 'f'},
    {"COS", 'f'},
    {"COT", 'f'},
    {"COUNT", 'f'},
    {"COUNT_BIG", 'k'},
    {"CRC32", 'f'},
    {"CREATE", 'E'},
    {"CREATE OR", 'n'},
    {"CREATE OR REPLACE", 'T'},
    {"CROSS", 'n'},
    {"CROSS JOIN", 'k'},
    {"CSNG", 'f'},
    {"CSTRING", 't'},
    {"CTXSYS.DRITHSX.SN", 'f'},
    {"CUME_DIST", 'f'},
    {"CURDATE", 'f'},
    {"CURDIR", 'f'},
    {"CURRENT DATE", 'v'},
    {"CURRENT DEGREE", 'v'},
    {"CURRENT FUNCTION", 'v'},
    {"CURRENT FUNCTION PATH", 'v'},
    {"CURRENT PATH", 'v'},
    {"CURRENT SCHEMA", 'v'},
    {"CURRENT SERVER", 'v'},
    {"CURRENT TIME", 'v'},
    {"CURRENT TIMEZONE", 'v'},
    {"CURRENTUSER", 'f'},
    {"CURRENT_DATABASE", 'f'},
    {"CURRENT_DATE", 'v'},
    {"CURRENT_PATH", 'v'},
    {"CURRENT_QUERY", 'f'},
    {"CURRENT_SCHEMA", 'f'},
    {"CURRENT_SCHEMAS", 'f'},
    {"CURRENT_SERVER", 'v'},
    {"CURRENT_SETTING", 'f'},
    {"CURRENT_TIME", 'v'},
    {"CURRENT_TIMESTAMP", 'v'},
    {"CURRENT_TIMEZONE", 'v'},
    {"CURRENT_USER", 'v'},
    {"CURRVAL", 'f'},
    {"CURSOR", 'k'},
    {"CURSOR_STATUS", 'f'},
    {"CURTIME", 'f'},
    {"CVAR", 'f'},
    {"DATABASE", 'n'},
    {"DATABASEPROPERTYEX", 'f'},
    {"DATABASES", 'k'},
    {"DATABASE_PRINCIPAL_ID", 'f'},
    {"DATALENGTH", 'f'},
    {"DATE", 'f'},
    {"DATEADD", 'f'},
    {"DATEDIFF", 'f'},
    {"DATEFROMPARTS", 'f'},
    {"DATENAME", 'f'},
    {"DATEPART", 'f'},
    {"DATESERIAL", 'f'},
    {"DATETIME2FROMPARTS", 'f'},
    {"DATETIMEFROMPARTS", 'f'},
    {"DATETIMEOFFSETFROMPARTS", 'f'},
    {"DATEVALUE", 'f'},
    {"DATE_ADD", 'f'},
    {"DATE_FORMAT", 'f'},
    {"DATE_PART", 'f'},
    {"DATE_SUB", 'f'},
    {"DATE_TRUNC", 'f'},
    {"DAVG", 'f'},
    {"DAY", 'f'},
    {"DAYNAME", 'f'},
    {"DAYOFMONTH", 'f'},
    {"DAYOFWEEK", 'f'},
    {"DAYOFYEAR", 'f'},
    {"DAY_HOUR", 'k'},
    {"DAY_MICROSECOND", 'k'},
    {"DAY_MINUTE", 'k'},
    {"DAY_SECOND", 'k'},
    {"DBMS_LOCK.SLEEP", 'f'},
    {"DBMS_PIPE.RECEIVE_MESSAGE", 'f'},
    {"DB_ID", 'f'},
    {"DB_NAME", 'f'},
    {"DCOUNT", 'f'},
    {"DEC", 'k'},
    {"DECIMAL", 't'},
    {"DECLARE", 'T'},
    {"DECODE", 'f'},
    {"DECRYPTBYASMKEY", 'f'},
    {"DECRYPTBYCERT", 'f'},
    {"DECRYPTBYKEY", 'f'},
    {"DECRYPTBYKEYAUTOCERT", 'f'},
    {"DECRYPTBYPASSPHRASE", 'f'},
    {"DEFAULT", 'k'},
    {"DEGREES", 'f'},
    {"DELAY", 'k'},
    {"DELAYED", 'k'},
    {"DELETE", 'T'},
    {"DENSE_RANK", 'f'},
    {"DESC", 'k'},
    {"DESCRIBE", 'k'},
    {"DES_DECRYPT", 'f'},
    {"DES_ENCRYPT", 'f'},
    {"DETERMINISTIC", 'k'},
    {"DFIRST", 'f'},
    {"DIFFERENCE", 'f'},
    {"DISTINCT", 'k'},
    {"DISTINCTROW", 'k'},
    {"DIV", 'o'},
    {"DLAST", 'f'},
    {"DLOOKUP", 'f'},
    {"DMAX", 'f'},
    {"DMIN", 'f'},
    {"DO", 'n'},
    {"DOUBLE", 't'},
    {"DOUBLE PRECISION", 't'},
    {"DROP", 'T'},
    {"DSUM", 'f'},
    {"DUAL", 'n'},
    {"EACH", 'k'},
    {"ELSE", 'k'},
    {"ELSEIF", 'k'},
    {"ELT", 'f'},
    {"ENCLOSED", 'k'},
    {"ENCODE", 'f'},
    {"ENCRYPT", 'f'},
    {"ENCRYPTBYASMKEY", 'f'},
    {"ENCRYPTBYCERT", 'f'},
    {"ENCRYPTBYKEY", 'f'},
    {"ENCRYPTBYPASSPHRASE", 'f'},
    {"ENUM_FIRST", 'f'},
    {"ENUM_LAST", 'f'},
    {"ENUM_RANGE", 'f'},
    {"EOMONTH", 'f'},
    {"EQV", 'o'},
    {"ESCAPED", 'k'},
    {"EVENTDATA", 'f'},
    {"EXCEPT", 'U'},
    {"EXEC", 'T'},
    {"EXECUTE", 'T'},
    {"EXECUTE AS", 'E'},
    {"EXECUTE AS LOGIN", 'E'},
    {"EXISTS", 'f'},
    {"EXIT", 'k'},
    {"EXP", 'f'},
    {"EXPLAIN", 'k'},
    {"EXPORT_SET", 'f'},
    {"EXTRACT", 'f'},
    {"EXTRACTVALUE", 'f'},
    {"EXTRACT_VALUE", 'f'},
    {"FALSE", '1'},
    {"FETCH", 'k'},
    {"FIELD", 'f'},
    {"FILEDATETIME", 'f'},
    {"FILEGROUPPROPERTY", 'f'},
    {"FILEGROUP_ID", 'f'},
    {"FILEGROUP_NAME", 'f'},
    {"FILELEN", 'f'},
    {"FILEPROPERTY", 'f'},
    {"FILE_ID", 'f'},
    {"FILE_IDEX", 'f'},
    {"FILE_NAME", 'f'},
    {"FIND_IN_SET", 'f'},
    {"FIRST_VALUE", 'f'},
    {"FLOAT", 't'},
    {"FLOAT4", 't'},
    {"FLOAT8", 't'},
    {"FLOOR", 'f'},
    {"FN_VIRTUALFILESTATS", 'f'},
    {"FOR", 'n'},
    {"FOR UPDATE", 'k'},
    {"FOR UPDATE NOWAIT", 'k'},
    {"FOR UPDATE OF", 'k'},
    {"FOR UPDATE SKIP", 'k'},
    {"FOR UPDATE SKIP LOCKED", 'k'},
    {"FOR UPDATE WAIT", 'k'},
    {"FORCE", 'k'},
    {"FOREIGN", 'k'},
    {"FORMAT", 'f'},
    {"FOUND_ROWS", 'f'},
    {"FROM", 'k'},
    {"FROM_DAYS", 'f'},
    {"FROM_UNIXTIME", 'f'},
    {"FULL OUTER", 'k'},
    {"FULL OUTER JOIN", 'k'},
    {"FULLTEXT", 'k'},
    {"FULLTEXTCATALOGPROPERTY", 'f'},
    {"FULLTEXTSERVICEPROPERTY", 'f'},
    {"FUNCTION", 'k'},
    {"GENERATE_SERIES", 'f'},
    {"GENERATE_SUBSCRIPTS", 'f'},
    {"GETATTR", 'f'},
    {"GETDATE", 'f'},
    {"GETUTCDATE", 'f'},
    {"GET_BIT", 'f'},
    {"GET_BYTE", 'f'},
    {"GET_FORMAT", 'f'},
    {"GET_LOCK", 'f'},
    {"GO", 'T'},
    {"GOTO", 'T'},
    {"GRANT", 'k'},
    {"GREATEST", 'f'},
    {"GROUP", 'n'},
    {"GROUP BY", 'B'},
    {"GROUPING", 'f'},
    {"GROUPING_ID", 'f'},
    {"GROUP_CONCAT", 'f'},
    {"HANDLER", 'T'},
    {"HASHBYTES", 'f'},
    {"HAS_PERMS_BY_NAME", 'f'},
    {"HAVING", 'B'},
    {"HEX", 'f'},
    {"HIGH_PRIORITY", 'k'},
    {"HOST_NAME", 'f'},
    {"HOUR", 'f'},
    {"HOUR_MICROSECOND", 'k'},
    {"HOUR_MINUTE", 'k'},
    {"HOUR_SECOND", 'k'},
    {"IDENTIFY", 'f'},
    {"IDENT_CURRENT", 'f'},
    {"IDENT_INCR", 'f'},
    {"IDENT_SEED", 'f'},
    {"IF", 'f'},
    {"IF EXISTS", 'f'},
    {"IFF", 'f'},
    {"IFNULL", 'f'},
    {"IGNORE", 'k'},
    {"IIF", 'f'},
    {"IN", 'k'},
    {"IN BOOLEAN", 'n'},
    {"IN BOOLEAN MODE", 'k'},
    {"INDEX", 'k'},
    {"INDEXKEY_PROPERTY", 'f'},
    {"INDEXPROPERTY", 'f'},
    {"INDEX_COL", 'f'},
    {"INET_ATON", 'f'},
    {"INET_NTOA", 'f'},
    {"INFILE", 'k'},
    {"INITCAP", 'f'},
    {"INNER", 'k'},
    {"INNER JOIN", 'k'},
    {"INOUT", 'k'},
    {"INSENSITIVE", 'k'},
    {"INSERT", 'E'},
    {"INSERT DELAYED", 'E'},
    {"INSERT DELAYED INTO", 'T'},
    {"INSERT HIGH_PRIORITY", 'E'},
    {"INSERT HIGH_PRIORITY INTO", 'T'},
    {"INSERT IGNORE", 'E'},
    {"INSERT IGNORE INTO", 'T'},
    {"INSERT INTO", 'T'},
    {"INSERT LOW_PRIORITY", 'E'},
    {"INSERT LOW_PRIORITY INTO", 'T'},
    {"INSTR", 'f'},
    {"INSTRREV", 'f'},
    {"INT", 't'},
    {"INT1", 't'},
    {"INT2", 't'},
    {"INT3", 't'},
    {"INT4", 't'},
    {"INT8", 't'},
    {"INTEGER", 't'},
    {"INTERSECT", 'U'},
    {"INTERSECT ALL", 'U'},
    {"INTERVAL", 'k'},
    {"INTO", 'k'},
    {"INTO DUMPFILE", 'k'},
    {"INTO OUTFILE", 'k'},
    {"IS", 'o'},
    {"IS DISTINCT", 'n'},
    {"IS DISTINCT FROM", 'o'},
    {"IS NOT", 'o'},
    {"IS NOT DISTINCT", 'n'},
    {"IS NOT DISTINCT FROM", 'o'},
    {"ISDATE", 'f'},
    {"ISEMPTY", 'f'},
    {"ISFINITE", 'f'},
    {"ISNULL", 'f'},
    {"ISNUMERIC", 'f'},
    {"IS_FREE_LOCK", 'f'},
    {"IS_MEMBER", 'f'},
    {"IS_OBJECTSIGNED", 'f'},
    {"IS_ROLEMEMBER", 'f'},
    {"IS_SRVROLEMEMBER", 'f'},
    {"IS_USED_LOCK", 'f'},
    {"ITERATE", 'k'},
    {"JOIN", 'k'},
    {"JULIANDAY", 'f'},
    {"JUSTIFY_DAYS", 'f'},
    {"JUSTIFY_HOURS", 'f'},
    {"JUSTIFY_INTERVAL", 'f'},
    {"KEYS", 'k'},
    {"KEY_GUID", 'f'},
    {"KEY_ID", 'f'},
    {"KILL", 'k'},
    {"LAG", 'f'},
    {"LASTVAL", 'f'},
    {"LAST_INSERT_ID", 'f'},
    {"LAST_INSERT_ROWID", 'f'},
    {"LAST_VALUE", 'f'},
    {"LCASE", 'f'},
    {"LEAD", 'f'},
    {"LEADING", 'k'},
    {"LEAST", 'f'},
    {"LEAVE", 'k'},
    {"LEFT", 'n'},
    {"LEFT JOIN", 'k'},
    {"LEFT OUTER", 'k'},
    {"LEFT OUTER JOIN", 'k'},
    {"LENGTH", 'f'},
    {"LIKE", 'o'},
    {"LIMIT", 'B'},
    {"LINEAR", 'k'},
    {"LINES", 'k'},
    {"LN", 'f'},
    {"LOAD", 'k'},
    {"LOAD DATA", 'T'},
    {"LOAD XML", 'T'},
    {"LOAD_EXTENSION", 'f'},
    {"LOAD_FILE", 'f'},
    {"LOCALTIME", 'v'},
    {"LOCALTIMESTAMP", 'v'},
    {"LOCATE", 'f'},
    {"LOCK", 'n'},
    {"LOCK IN", 'n'},
    {"LOCK IN SHARE", 'n'},
    {"LOCK IN SHARE MODE", 'k'},
    {"LOCK TABLE", 'k'},
    {"LOCK TABLES", 'k'},
    {"LOG", 'f'},
    {"LOG10", 'f'},
    {"LOG2", 'f'},
    {"LONGBLOB", 'k'},
    {"LONGTEXT", 'k'},
    {"LOOP", 'k'},
    {"LOWER", 'f'},
    {"LOWER_INC", 'f'},
    {"LOWER_INF", 'f'},
    {"LOW_PRIORITY", 'k'},
    {"LPAD", 'f'},
    {"LTRIM", 'f'},
    {"MAKEDATE", 'f'},
    {"MAKE_SET", 'f'},
    {"MASKLEN", 'f'},
    {"MASTER_BIND", 'k'},
    {"MASTER_POS_WAIT", 'f'},
    {"MASTER_SSL_VERIFY_SERVER_CERT", 'k'},
    {"MATCH", 'k'},
    {"MAX", 'f'},
    {"MAXVALUE", 'k'},
    {"MD5", 'f'},
    {"MEDIUMBLOB", 'k'},
    {"MEDIUMINT", 'k'},
    {"MEDIUMTEXT", 'k'},
    {"MERGE", 'k'},
    {"MICROSECOND", 'f'},
    {"MID", 'f'},
    {"MIDDLEINT", 'k'},
    {"MIN", 'f'},
    {"MINUTE", 'f'},
    {"MINUTE_MICROSECOND", 'k'},
    {"MINUTE_SECOND", 'k'},
    {"MKDIR", 'f'},
    {"MOD", 'o'},
    {"MODE", 'n'},
    {"MODIFIES", 'k'},
    {"MONEY", 't'},
    {"MONTH", 'f'},
    {"MONTHNAME", 'f'},
    {"NAME_CONST", 'f'},
    {"NATURAL", 'n'},
    {"NATURAL FULL", 'k'},
    {"NATURAL INNER", 'k'},
    {"NATURAL JOIN", 'k'},
    {"NATURAL LEFT", 'k'},
    {"NATURAL LEFT OUTER", 'k'},
    {"NATURAL LEFT OUTER JOIN", 'k'},
    {"NATURAL OUTER", 'k'},
    {"NATURAL RIGHT", 'k'},
    {"NETMASK", 'f'},
    {"NEXT VALUE", 'n'},
    {"NEXT VALUE FOR", 'k'},
    {"NEXTVAL", 'f'},
    {"NOT", 'o'},
    {"NOT BETWEEN", 'o'},
    {"NOT IN", 'k'},
    {"NOT LIKE", 'o'},
    {"NOT REGEXP", 'o'},
    {"NOT RLIKE", 'o'},
    {"NOT SIMILAR", 'o'},
    {"NOT SIMILAR TO", 'o'},
    {"NOTNULL", 'k'},
    {"NOW", 'f'},
    {"NOWAIT", 'k'},
    {"NO_WRITE_TO_BINLOG", 'k'},
    {"NTH_VALUE", 'f'},
    {"NTILE", 'f'},
    {"NULL", 'v'},
    {"NULLIF", 'f'},
    {"NUMERIC", 't'},
    {"NZ", 'f'},
    {"OBJECTPROPERTY", 'f'},
    {"OBJECTPROPERTYEX", 'f'},
    {"OBJECT_DEFINITION", 'f'},
    {"OBJECT_ID", 'f'},
    {"OBJECT_NAME", 'f'},
    {"OBJECT_SCHEMA_NAME", 'f'},
    {"OCT", 'f'},
    {"OCTET_LENGTH", 'f'},
    {"OFFSET", 'k'},
    {"OID", 't'},
    {"OLD_PASSWORD", 'f'},
    {"ONE_SHOT", 'k'},
    {"OPEN", 'k'},
    {"OPENDATASOURCE", 'f'},
    {"OPENQUERY", 'f'},
    {"OPENROWSET", 'f'},
    {"OPENXML", 'f'},
    {"OPTIMIZE", 'k'},
    {"OPTION", 'k'},
    {"OPTIONALLY", 'k'},
    {"OR", '&'},
    {"ORD", 'f'},
    {"ORDER", 'n'},
    {"ORDER BY", 'B'},
    {"ORIGINAL_DB_NAME", 'f'},
    {"ORIGINAL_LOGIN", 'f'},
    {"OUT", 'k'},
    {"OUTER", 'n'},
    {"OUTFILE", 'k'},
    {"OVERLAPS", 'f'},
    {"OVERLAY", 'f'},
    {"OWN3D", 'k'},
    {"OWN3D BY", 'B'},
    {"PARSENAME", 'f'},
    {"PARTITION", 'k'},
    {"PARTITION BY", 'B'},
    {"PASSWORD", 'n'},
    {"PATHINDEX", 'f'},
    {"PATINDEX", 'f'},
    {"PERCENTILE_COUNT", 'f'},
    {"PERCENTILE_DISC", 'f'},
    {"PERCENTILE_RANK", 'f'},
    {"PERCENT_RANK", 'f'},
    {"PERIOD_ADD", 'f'},
    {"PERIOD_DIFF", 'f'},
    {"PERMISSIONS", 'f'},
    {"PG_ADVISORY_LOCK", 'f'},
    {"PG_BACKEND_PID", 'f'},
    {"PG_CANCEL_BACKEND", 'f'},
    {"PG_CLIENT_ENCODING", 'f'},
    {"PG_CONF_LOAD_TIME", 'f'},
    {"PG_CREATE_RESTORE_POINT", 'f'},
    {"PG_HAS_ROLE", 'f'},
    {"PG_IS_IN_RECOVERY", 'f'},
    {"PG_IS_OTHER_TEMP_SCHEMA", 'f'},
    {"PG_LISTENING_CHANNELS", 'f'},
    {"PG_LS_DIR", 'f'},
    {"PG_MY_TEMP_SCHEMA", 'f'},
    {"PG_POSTMASTER_START_TIME", 'f'},
    {"PG_READ_BINARY_FILE", 'f'},
    {"PG_READ_FILE", 'f'},
    {"PG_RELOAD_CONF", 'f'},
    {"PG_ROTATE_LOGFILE", 'f'},
    {"PG_SLEEP", 'f'},
    {"PG_START_BACKUP", 'f'},
    {"PG_STAT_FILE", 'f'},
    {"PG_STOP_BACKUP", 'f'},
    {"PG_SWITCH_XLOG", 'f'},
    {"PG_TERMINATE_BACKEND", 'f'},
    {"PG_TRIGGER_DEPTH", 'f'},
    {"PI", 'f'},
    {"POSITION", 'f'},
    {"POW", 'f'},
    {"POWER", 'f'},
    {"PRECISION", 'k'},
    {"PREVIOUS VALUE", 'n'},
    {"PREVIOUS VALUE FOR", 'k'},
    {"PRIMARY", 'k'},
    {"PRINT", 'T'},
    {"PROCEDURE", 'k'},
    {"PROCEDURE ANALYSE", 'f'},
    {"PUBLISHINGSERVERNAME", 'f'},
    {"PURGE", 'k'},
    {"PWDCOMPARE", 'f'},
    {"PWDENCRYPT", 'f'},
    {"QUARTER", 'f'},
    {"QUOTE", 'f'},
    {"QUOTENAME", 'f'},
    {"QUOTE_IDENT", 'f'},
    {"QUOTE_LITERAL", 'f'},
    {"QUOTE_NULLABLE", 'f'},
    {"RADIANS", 'f'},
    {"RAISEERROR", 'E'},
    {"RAND", 'f'},
    {"RANDOM", 'f'},
    {"RANDOMBLOB", 'f'},
    {"RANGE", 'k'},
    {"RANK", 'f'},
    {"READ", 'k'},
    {"READ WRITE", 'k'},
    {"READS", 'k'},
    {"READ_WRITE", 'k'},
    {"REAL", 't'},
    {"REFERENCES", 'k'},
    {"REGCLASS", 't'},
    {"REGCONFIG", 't'},
    {"REGDICTIONARY", 't'},
    {"REGEXP", 'o'},
    {"REGEXP_MATCHES", 'f'},
    {"REGEXP_REPLACE", 'f'},
    {"REGEXP_SPLIT_TO_ARRAY", 'f'},
    {"REGEXP_SPLIT_TO_TABLE", 'f'},
    {"REGOPER", 't'},
    {"REGOPERATOR", 't'},
    {"REGPROC", 't'},
    {"REGPROCEDURE", 't'},
    {"REGTYPE", 't'},
    {"RELEASE", 'k'},
    {"RELEASE_LOCK", 'f'},
    {"RENAME", 'k'},
    {"REPEAT", 'k'},
    {"REPLACE", 'k'},
    {"REPLICATE", 'f'},
    {"REQUIRE", 'k'},
    {"RESIGNAL", 'k'},
    {"RESTRICT", 'k'},
    {"RETURN", 'k'},
    {"REVERSE", 'f'},
    {"REVOKE", 'k'},
    {"RIGHT", 'n'},
    {"RIGHT JOIN", 'k'},
    {"RIGHT OUTER", 'k'},
    {"RIGHT OUTER JOIN", 'k'},
    {"RLIKE", 'o'},
    {"ROUND", 'f'},
    {"ROW", 'f'},
    {"ROW_COUNT", 'f'},
    {"ROW_NUMBER", 'f'},
    {"ROW_TO_JSON", 'f'},
    {"RPAD", 'f'},
    {"RTRIM", 'f'},
    {"SCHAMA_NAME", 'f'},
    {"SCHEMA", 'k'},
    {"SCHEMAS", 'k'},
    {"SCHEMA_ID", 'f'},
    {"SCOPE_IDENTITY", 'f'},
    {"SECOND_MICROSECOND", 'k'},
    {"SEC_TO_TIME", 'f'},
    {"SELECT", 'E'},
    {"SELECT ALL", 'E'},
    {"SELECT DISTINCT", 'E'},
    {"SENSITIVE", 'k'},
    {"SEPARATOR", 'k'},
    {"SERIAL", 't'},
    {"SERIAL2", 't'},
    {"SERIAL4", 't'},
    {"SERIAL8", 't'},
    {"SERVERPROPERTY", 'f'},
    {"SESSION_USER", 'f'},
    {"SET", 'E'},
    {"SETATTR", 'f'},
    {"SETSEED", 'f'},
    {"SETVAL", 'f'},
    {"SET_BIT", 'f'},
    {"SET_BYTE", 'f'},
    {"SET_CONFIG", 'f'},
    {"SET_MASKLEN", 'f'},
    {"SHA", 'f'},
    {"SHA1", 'f'},
    {"SHA2", 'f'},
    {"SHOW", 'n'},
    {"SHUTDOWN", 'T'},
    {"SIGN", 'f'},
    {"SIGNAL", 'k'},
    {"SIGNBYASMKEY", 'f'},
    {"SIGNBYCERT", 'f'},
    {"SIMILAR", 'k'},
    {"SIMILAR TO", 'o'},
    {"SIN", 'f'},
    {"SLEEP", 'f'},
    {"SMALLDATETIMEFROMPARTS", 'f'},
    {"SMALLINT", 't'},
    {"SMALLSERIAL", 't'},
    {"SOUNDEX", 'f'},
    {"SOUNDS", 'o'},
    {"SOUNDS LIKE", 'o'},
    {"SPACE", 'f'},
    {"SPATIAL", 'k'},
    {"SPECIFIC", 'k'},
    {"SPLIT_PART", 'f'},
    {"SQL", 'k'},
    {"SQLEXCEPTION", 'k'},
    {"SQLSTATE", 'k'},
    {"SQLWARNING", 'k'},
    {"SQL_BIG_RESULT", 'k'},
    {"SQL_BUFFER_RESULT", 'k'},
    {"SQL_CACHE", 'k'},
    {"SQL_CALC_FOUND_ROWS", 'k'},
    {"SQL_NO_CACHE", 'k'},
    {"SQL_SMALL_RESULT", 'k'},
    {"SQL_VARIANT_PROPERTY", 'f'},
    {"SQRT", 'f'},
    {"SSL", 'k'},
    {"STARTING", 'k'},
    {"STATEMENT_TIMESTAMP", 'f'},
    {"STATS_DATE", 'f'},
    {"STDDEV", 'f'},
    {"STDDEV_POP", 'f'},
    {"STDDEV_SAMP", 'f'},
    {"STRAIGHT_JOIN", 'k'},
    {"STRCMP", 'f'},
    {"STRCOMP", 'f'},
    {"STRCONV", 'f'},
    {"STRING_AGG", 'f'},
    {"STRING_TO_ARRAY", 'f'},
    {"STRPOS", 'f'},
    {"STR_TO_DATE", 'f'},
    {"STUFF", 'f'},
    {"SUBDATE", 'f'},
    {"SUBSTR", 'f'},
    {"SUBSTRING", 'f'},
    {"SUBSTRING_INDEX", 'f'},
    {"SUBTIME", 'f'},
    {"SUM", 'f'},
    {"SUSER_ID", 'f'},
    {"SUSER_NAME", 'f'},
    {"SUSER_SID", 'f'},
    {"SUSER_SNAME", 'f'},
    {"SWITCHOFFET", 'f'},
    {"SYS.DATABASE_NAME", 'n'},
    {"SYS.FN_BUILTIN_PERMISSIONS", 'f'},
    {"SYS.FN_GET_AUDIT_FILE", 'f'},
    {"SYS.FN_MY_PERMISSIONS", 'f'},
    {"SYS.STRAGG", 'f'},
    {"SYSCOLUMNS", 'k'},
    {"SYSDATE", 'f'},
    {"SYSDATETIME", 'f'},
    {"SYSDATETIMEOFFSET", 'f'},
    {"SYSOBJECTS", 'k'},
    {"SYSTEM_USER", 'f'},
    {"SYSUSERS", 'k'},
    {"SYSUTCDATETME", 'f'},
    {"TABLE", 'k'},
    {"TAN", 'f'},
    {"TERMINATED", 'k'},
    {"TERTIARY_WEIGHTS", 'f'},
    {"TEXT", 't'},
    {"TEXTPOS", 'f'},
    {"TEXTPTR", 'f'},
    {"TEXTVALID", 'f'},
    {"THEN", 'k'},
    {"TIME", 'k'},
    {"TIMEDIFF", 'f'},
    {"TIMEFROMPARTS", 'f'},
    {"TIMEOFDAY", 'f'},
    {"TIMESERIAL", 'f'},
    {"TIMESTAMP", 't'},
    {"TIMESTAMPADD", 'f'},
    {"TIMEVALUE", 'f'},
    {"TIME_FORMAT", 'f'},
    {"TIME_TO_SEC", 'f'},
    {"TINYBLOB", 'k'},
    {"TINYINT", 'k'},
    {"TINYTEXT", 'k'},
    {"TODATETIMEOFFSET", 'f'},
    {"TOP", 'k'},
    {"TOTAL", 'f'},
    {"TOTAL_CHANGES", 'f'},
    {"TO_ASCII", 'f'},
    {"TO_CHAR", 'f'},
    {"TO_DATE", 'f'},
    {"TO_DAYS", 'f'},
    {"TO_HEX", 'f'},
    {"TO_NUMBER", 'f'},
    {"TO_SECONDS", 'f'},
    {"TO_TIMESTAMP", 'f'},
    {"TRAILING", 'n'},
    {"TRANSACTION_TIMESTAMP", 'f'},
    {"TRANSLATE", 'f'},
    {"TRIGGER", 'k'},
    {"TRIGGER_NESTLEVEL", 'f'},
    {"TRIM", 'f'},
    {"TRUE", '1'},
    {"TRUNC", 'f'},
    {"TRUNCATE", 'f'},
    {"TRY_CAST", 'f'},
    {"TRY_CONVERT", 'f'},
    {"TRY_PARSE", 'f'},
    {"TYPEOF", 'f'},
    {"TYPEPROPERTY", 'f'},
    {"TYPE_ID", 'f'},
    {"TYPE_NAME", 'f'},
    {"UCASE", 'f'},
    {"UESCAPE", 'o'},
    {"UNCOMPRESS", 'f'},
    {"UNCOMPRESS_LENGTH", 'f'},
    {"UNDO", 'k'},
    {"UNHEX", 'f'},
    {"UNICODE", 'f'},
    {"UNION", 'U'},
    {"UNION ALL", 'U'},
    {"UNION ALL DISTINCT", 'U'},
    {"UNION DISTINCT", 'U'},
    {"UNION DISTINCT ALL", 'U'},
    {"UNIQUE", 'n'},
    {"UNIX_TIMESTAMP", 'f'},
    {"UNI_ON", 'U'},
    {"UNKNOWN", 'v'},
    {"UNLOCK", 'k'},
    {"UNNEST", 'f'},
    {"UNSIGNED", 'k'},
    {"UPDATE", 'E'},
    {"UPDATEXML", 'f'},
    {"UPPER", 'f'},
    {"UPPER_INC", 'f'},
    {"UPPER_INF", 'f'},
    {"USAGE", 'k'},
    {"USE", 'T'},
    {"USER", 'n'},
    {"USER_ID", 'n'},
    {"USER_LOCK.SLEEP", 'f'},
    {"USER_NAME", 'n'},
    {"USING", 'f'},
    {"UTC_DATE", 'k'},
    {"UTC_TIME", 'k'},
    {"UTC_TIMESTAMP", 'k'},
    {"UTL_HTTP.REQUEST", 'f'},
    {"UTL_INADDR.GET_HOST_ADDRESS", 'f'},
    {"UTL_INADDR.GET_HOST_NAME", 'f'},
    {"UUID", 'f'},
    {"UUID_SHORT", 'f'},
    {"VALUES", 'k'},
    {"VAR", 'f'},
    {"VARBINARY", 'k'},
    {"VARCHAR", 't'},
    {"VARCHARACTER", 'k'},
    {"VARIANCE", 'f'},
    {"VARP", 'f'},
    {"VARYING", 'k'},
    {"VAR_POP", 'f'},
    {"VAR_SAMP", 'f'},
    {"VERIFYSIGNEDBYASMKEY", 'f'},
    {"VERIFYSIGNEDBYCERT", 'f'},
    {"VERSION", 'f'},
    {"VOID", 't'},
    {"WAIT", 'k'},
    {"WAITFOR", 'n'},
    {"WAITFOR DELAY", 'E'},
    {"WAITFOR RECEIVE", 'E'},
    {"WAITFOR TIME", 'E'},
    {"WEEK", 'f'},
    {"WEEKDAY", 'f'},
    {"WEEKDAYNAME", 'f'},
    {"WEEKOFYEAR", 'f'},
    {"WHEN", 'k'},
    {"WHERE", 'k'},
    {"WHILE", 'T'},
    {"WIDTH_BUCKET", 'f'},
    {"WITH", 'n'},
    {"WITH ROLLUP", 'k'},
    {"XMLAGG", 'f'},
    {"XMLCOMMENT", 'f'},
    {"XMLCONCAT", 'f'},
    {"XMLELEMENT", 'f'},
    {"XMLEXISTS", 'f'},
    {"XMLFOREST", 'f'},
    {"XMLFORMAT", 'f'},
    {"XMLPI", 'f'},
    {"XMLROOT", 'f'},
    {"XMLTYPE", 'f'},
    {"XML_IS_WELL_FORMED", 'f'},
    {"XOR", '&'},
    {"XPATH", 'f'},
    {"XPATH_EXISTS", 'f'},
    {"XP_EXECRESULTSET", 'k'},
    {"YEAR", 'f'},
    {"YEARWEEK", 'f'},
    {"YEAR_MONTH", 'k'},
    {"ZEROBLOB", 'f'},
    {"ZEROFILL", 'k'},
    {"^=", 'o'},
    {"_ARMSCII8", 't'},
    {"_ASCII", 't'},
    {"_BIG5", 't'},
    {"_BINARY", 't'},
    {"_CP1250", 't'},
    {"_CP1251", 't'},
    {"_CP1257", 't'},
    {"_CP850", 't'},
    {"_CP852", 't'},
    {"_CP866", 't'},
    {"_CP932", 't'},
    {"_DEC8", 't'},
    {"_EUCJPMS", 't'},
    {"_EUCKR", 't'},
    {"_GB2312", 't'},
    {"_GBK", 't'},
    {"_GEOSTD8", 't'},
    {"_GREEK", 't'},
    {"_HEBREW", 't'},
    {"_HP8", 't'},
    {"_KEYBCS2", 't'},
    {"_KOI8R", 't'},
    {"_KOI8U", 't'},
    {"_LATIN1", 't'},
    {"_LATIN2", 't'},
    {"_LATIN5", 't'},
    {"_LATIN7", 't'},
    {"_MACCE", 't'},
    {"_MACROMAN", 't'},
    {"_SJIS", 't'},
    {"_SWE7", 't'},
    {"_TIS620", 't'},
    {"_UJIS", 't'},
    {"_USC2", 't'},
    {"_UTF8", 't'},
    {"|/", 'o'},
    {"|=", 'o'},
    {"||", '&'},
    {"~*", 'o'},
};
static const size_t sql_keywords_sz = 10057;
#endif
