#ifndef LIBBTPEER_TYPES_BTP_FILE_POOL_H
#define LIBBTPEER_TYPES_BTP_FILE_POOL_H

#include <apr.h>
#include <apr_file_io.h>
#include <apr_pools.h>
#include <apr_errno.h>
#include <stdint.h>

#include <libbtutil/types/bt_llist.h>

typedef bt_llist btp_file_pool;

#define btp_file_pool_create(p,max) bt_llist_new(p,max)
#define btp_file_pool_destroy(fp)   bt_llist_destroy(fp)

extern apr_status_t btp_file_pool_get(
    btp_file_pool* fp, const char* path, apr_file_t **fh
);

/* Everything below this point is private, but the symbols
 * are currently exposed to allow for unit testing.
 */
#ifdef BTP_FILE_POOL_PRIVATE

typedef struct btp_file_pool_file_s btp_file_pool_file;

struct btp_file_pool_file_s {
    char                        path[BT_PATH_LEN];
    apr_file_t                  *fh;
    bt_llist_e*                 e;
};

extern void btp_file_pool_use(btp_file_pool* fp, btp_file_pool_file* f);
extern void btp_file_pool_add_record(btp_file_pool* fp, btp_file_pool_file* f);
extern void btp_file_pool_del_record(btp_file_pool* fp, btp_file_pool_file* f);
extern apr_status_t btp_file_pool_add(
    btp_file_pool* fp, const char* path, apr_file_t **fh
);

#endif /* BTP_FILE_POOL_PRIVATE */

#endif /* LIBBTPEER_TYPES_BTP_FILE_POOL_H */
