#!/usr/bin/python -ttu
# vim: ai ts=4 sts=4 et sw=4

#    constant.py: This module contains variable definitions that can be used
#    across the code

#    Copyright (c) 2007, 2008 Intel Corporation
#
#    This program is free software; you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation; version 2 of the License
#
#    This program is distributed in the hope that it will be useful, but
#    WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
#    or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
#    for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc., 59
#    Temple Place - Suite 330, Boston, MA 02111-1307, USA.

# This has to be before we import gtk
import pygtk
pygtk.require("2.0")

import gettext
import gobject
import gtk
import os

_ = gettext.lgettext


MediaAppPath            = '/usr/share/moblin-media'
MediaConfigsDir         = '/usr/share/media-services'
MediaContentPath        = os.path.expanduser('~/media')
MediaThemePath          = '/usr/share/themes/mobilebasic'
MoblinGconfPath         = '/apps/moblin-media'
MoblinHomePath          = os.path.expanduser('~/.moblin-media')

MediaGladePath          = os.path.join(MediaAppPath, 'moblin_media.glade')
MediaImagePath          = os.path.join(MediaThemePath, 'images')
MediaPluginsDir         = os.path.join(MediaAppPath, 'plugins')
MediaSpecImagePath      = os.path.join(MediaAppPath, 'images')
MoblinAlbumCoverDir     = os.path.join(MoblinHomePath, 'album_covers')
MoblinGconfPath_Music   = os.path.join(MoblinGconfPath, 'audio', 'setting')
MoblinGconfPath_Photo   = os.path.join(MoblinGconfPath, 'photo', 'setting')
MoblinGconfPath_video   = os.path.join(MoblinGconfPath, 'video', 'setting')
MoblinMediaHistoryFile  = os.path.join(MoblinHomePath, 'media_history')
MoblinThumbnailsDir     = os.path.join(MoblinHomePath, 'thumbnails')
SampleMediaPath         = os.path.join(MediaAppPath, 'sample-media')

THUMBNAIL_DIR = os.path.expanduser("~/.moblin-media/thumbnails/largest")

MODE_PHOTO = 'photo'
MODE_AUDIO = 'audio'
MODE_VIDEO = 'video'

MediaState = {
    'audio': ['MS_AUDIO_BR_ALBUM','MS_AUDIO_BR_ART','MS_AUDIO_PLAYBACK','MS_AUDIO_BR_SONG','MS_AUDIO_DEFAULT'],
    'photo': ['MS_PHOTO_PLAYBACK', 'MS_PHOTO_THUMBNAIL', 'MS_PHOTO_SHARE', 'MS_PHOTO_DEFAULT'],
    'video': ['MS_VIDEO_PLAYBACK', 'MS_VIDEO_THUMBNAIL', 'MS_VIDEO_SHARE', 'MS_VIDEO_DEFAULT'],
}

def extensionListToShellGlob(extension_list):
    """Given a list of extensions (e.g. ['mp3'] ) convert it to a list of
    shell globs with upper and lowercase (e.g. [ '[mM][pP]3' ] )"""
    output_list = []
    for extension in sorted(extension_list):
        shell_glob = ""
        for letter in extension:
            if letter.upper() != letter.lower():
                shell_glob += "[%s%s]" % (letter.lower(), letter.upper())
            else:
                shell_glob += letter
        output_list.append(shell_glob)
    return output_list

MediaType = {
    'audio': ['mp3', 'wav', 'wma', 'aac', 'ac3', 'm4a', 'ram'],
    'photo': ['jpg', 'bmp',  'jpeg', 'png','gif','wbmp', 'svg' ],
    'video': ['mpg', 'mpeg', 'mp4', '3gp', 'ogg','rm', 'rmvb', 'wmv', 'mov', 'avi', 'gif', 'asf', 'rm', 'ogm'],
}

MediaPattern = {}
# Populate MediaPattern with the shell glob extensions that we need
for key, item in MediaType.iteritems():
    MediaPattern[key] = extensionListToShellGlob(item)

# playback video size mode
VSZ_FULL_WINDOW, VSZ_IDEAL_SIZE, VSZ_DOUBLE_SIZE, VSZ_FIT_WINDOW, VSZ_FIT_SCREEN, VSZ_FULL_SCREEN, VSZ_INVALID = range(7)
# call service Pump() interval
PUMP_INTERVAL = 50
# UpdatePos interval
UPDATE_POS_INTERVAL = 50
UPDATE_POS_COUNT = UPDATE_POS_INTERVAL/PUMP_INTERVAL

MediaUrlList = []

MediaColor = {
    'ctrl_box_bg':        gtk.gdk.Color(5000,5000,5000,0),
    'ctrl_ebox_focus':    gtk.gdk.Color(40000,40000,40000,0),
    'ctrl_ebox_unfocus':  gtk.gdk.Color(20000,20000,20000,0),
    'default_label_bg':   gtk.gdk.Color(30000,30000,30000,0),
    'mm_playback_bg':     gtk.gdk.Color(30000,30000,30000,0),
    'select_label_fg':    gtk.gdk.Color(60000,60000,60000,0),
    'select_window_bg':   gtk.gdk.Color(0,0,0,0),
    'toolbar_bg':         gtk.gdk.Color(20000,20000,20000,0),
    'toolbar_shadow':     gtk.gdk.Color(40000,40000,40000,0),
}

MediaString = {'open_dlg_title' : 'Choose A File'}

# Location constants:
# TNV: ThumbNail View ???
# FLV: Full Length View ???
# PLV: Photo ? ?  (Does not seem to be used)
# PBA: Play Back Audio
# PBV: Play Back Video
# PBP: Play Back Photo
# TRASH: Trash
TNV, FLV, PLV, PBA, PBV, PBP, TRASH = range(0,7)

BORDER = 3

# We cannot get the coordinates of a widget through an existing function, so
# x_min and x_max's coordinates of seekbars should be configured here
SeekBar_Pos = {
    'audio_x_max':  665,
    'audio_x_min':  0,
    'video_x_max': 563,
    'video_x_min':  0,
}

POPUP_TOOL_BAR_DURATION  = 3
POPUP_TOOL_BAR_INIT_TIME = 0.0
POPUP_TOOL_BAR_PRESSING  = -1

##############################################################################
# Translatable Strings

MSG_DELETE_PLAYING_SONG_ERROR = _("Can not delete playing song")
MSG_DELETE_PLAYING_VIDEO_ERROR = _("Can not delete playing video")
MSG_EDIT_PLAYING_VIDEO_ERROR = _("Can not edit playing video")
MSG_DOCKING_ERROR = _("Application is disabled while in docking mode")
MSG_OPEN_ERROR = _("Unable to open file")
MSG_PLAY_ERROR = _("Unable to play file")
MSG_CONFIRM_DELETE_TITLE = _("Delete Media")
MSG_CONFIRM_DELETE_QUESTION = _("Are you sure you want to delete \n\'%s\'?")
MSG_INFO_NO_ITEM_FOR_DELETE = _("Please select a song to delete.")
MSG_RENAME_ERROR_TITLE = _("Rename Conflict")
MSG_RENAME_QUESTION = _("The file \'%s\' already exists.  Do you want to replace it?")
MSG_EXTENSION_CHANGE_TITLE = _("Extension Changed")
MSG_EXTENSION_CHANGE_QUESTION = _("Are you sure you want to change the file extension from %s to %s?")
MSG_MUSIC_WINDOW_TITLE = _("Music")
MSG_VIDEO_WINDOW_TITLE = _("Video")
MSG_PHOTO_WINDOW_TITLE = _("Photos")
MSG_PROPERTIES_TITLE = _("Properties")
MSG_INFO_NO_ITEM_FOR_PROPS = _("Please select an item to see its propreties.")
MSG_EMPTY_STRING_ERROR = _("The name can not be empty")
MSG_ERROR_TITLE = _("Error")

MUSIC_TITLE = _("Title")
MUSIC_LENGTH = _("Length")
MUSIC_ARTIST = _("Artist")
MUSIC_ALBUM = _("Album")
MUSIC_URL = _("URL")

ONLINE_MUSIC_PLAYLIST_NAME = _('Online Music')
ALL_SONG_PLAYLIST_NAME = _('All Songs')

MENU_OPEN_LOCATION = _("Open Location...")
MENU_EDIT = _("Edit")
MENU_SORT = _("Sort by")
MENU_SETTINGS = _("Settings...")
MENU_ABOUT = _("About")
MENU_QUIT = _("Quit")
MENU_DELETE = _("Delete")
MENU_PROPERTIES = _("File Properties...")
MENU_ROTATE_CLOCKWISE = _("Rotate clockwise")
MENU_ROTATE_COUNTERCLOCKWISE = _("Rotate counter-clockwise")
MENU_NAME = _("Name")
MENU_SIZE = _("Size")

THUMB_SORT_FILENAME = 0
THUMB_SORT_DATE = 1
THUMB_SORT_SIZE = 2
