#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <glib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <sys/vfs.h>
#include <libosso.h>
#include <glib-object.h>
#include <gconf/gconf-client.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>

#include "capplet-util.h"
#include "gconf-property-editor.h"

#include <libgnome/libgnome.h>
#include <gconf/gconf-client.h>
#include <libgnomevfs/gnome-vfs-uri.h>

static int dialog_open = 0;
static gboolean blocking = FALSE;

static void
childwatch(GPid pid, gint status, gpointer data)
{
	g_spawn_close_pid(pid);
	dialog_open = 0;
	if(blocking) gtk_main_quit();
}

osso_return_t execute(osso_context_t* osso, gpointer data, gboolean desktop_activated)
{
  GError *error = NULL;
  const char *argv[] = { EXECUTABLE, NULL};
  GPid child_pid;

  /* only one instance allowed */
  if(dialog_open) return OSSO_OK;
  dialog_open = 1;
  blocking = !desktop_activated;

  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  if(g_spawn_async (
	/* Child's current working directory,
	   NULL to inherit parent's */
	NULL,
	/* Child's argument vector. [0] is the path of
	   the program to execute */
	argv,
	/* Child's environment, NULL to inherit parent's */
	NULL,
	/* Flags from GSpawnFlags */
	G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD,
	/* Function to run in the child just before exec() */
	NULL,
	/* User data for child_setup */
	NULL,
	/* Return location for child process ID */
	&child_pid,
	/* Return location for error */
	&error))
  {
	g_child_watch_add(child_pid, childwatch, NULL);
  } else {
	dialog_open = 0;
  }

  if(blocking) gtk_main();
  return OSSO_OK;
}
