#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>

#include <stdio.h>
#include <signal.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/time.h>
#include <glib.h>

#define DEVFILE "/dev/input/touchscreen"

static int evfd;

struct input_event {
        struct timeval time;
        unsigned short type;
        unsigned short code;
        int value;
};

/* event types */
#define EV_SYN                  0x00
#define EV_KEY                  0x01
#define EV_REL                  0x02
#define EV_ABS                  0x03

/* codes */
#define ABS_X                   0x00
#define ABS_Y                   0x01
#define ALT_ABS_X               0x02  //For samsung Q1 type touchscreens
#define ALT_ABS_Y               0x03  //For samsung Q1 type touchscreens
#define SYN_REPORT              0
#define BTN_LEFT                0x110
#define BTN_RIGHT               0x111
#define BTN_TOUCH               0x14a

static int show_all = 1;
static int capture = 0;
static int touch = 0;
static int x = -1;
static int y = -1;

static gboolean
get_events()
{
        struct input_event ev;

	if(!show_all&&!capture) return FALSE;

	if(!show_all) printf("SIGIO EVENT START\n");

        /* read till sync event */
        while (read(evfd, &ev, sizeof(ev)) != -1) {
                switch (ev.type) {
                case EV_ABS:
                        switch (ev.code) {
                        case ABS_X:
				if(x == -1) x = ev.value;
				printf("EV_ABS ABS_X [x = %d]\n",
					ev.value);
                                break;
                        case ABS_Y:
				if(y == -1) y = ev.value;
				printf("EV_ABS ABS_Y [y = %d]\n",
					ev.value);
                                break;
                        case ALT_ABS_X:
				if(x == -1) x = ev.value;
				printf("EV_ABS ALT_ABS_X [x = %d]\n",
					ev.value);
                                break;
                        case ALT_ABS_Y:
				if(y == -1) y = ev.value;
				printf("EV_ABS ALT_ABS_Y [y = %d]\n",
					ev.value);
                                break;
                        default:
				printf("EV_ABS %d [val = %d]\n",
					ev.code, ev.value);
                                break;
                        }
                        break;
                case EV_KEY:
                       switch (ev.code) {
                        case BTN_LEFT:
				printf("EV_KEY BTN_LEFT [val = %d]\n",
					ev.value);
				touch = 1;
				break;
                        case BTN_TOUCH:
				printf("EV_KEY BTN_TOUCH [val = %d]\n",
					ev.value);
				touch = 1;
				break;
                        default:
				printf("EV_KEY %d [val = %d]\n",
					ev.code, ev.value);
				break;
                        }
                        break;
                case EV_SYN:
			switch(ev.code) {
			case SYN_REPORT:
				printf("EV_SYN SYN_REPORT [val = %d]\n",
					ev.value);
				if(((x == -1)&&(y != -1))||
				   ((x != -1)&&(y == -1)))
				{
				    x = -1;
				    y = -1;
				}
				if (!show_all&&touch&&(x != -1)&&(y != -1))
				{
					printf("TOUCH POINT VALUE: X=%d, Y=%d\n",
						x, y);
					x = -1;
					y = -1;
					touch = 0;
					printf("SIGIO EVENT FINISH\n\n");
					capture = 0;
					return TRUE;
				}
				break;
			default:
				printf("EV_SYN %d [val = %d]\n",
					ev.code, ev.value);
			}
                        break;
                default:
			printf("%d %d [val = %d]\n",
				ev.type, ev.code, ev.value);
                }
        }

	if(!show_all) printf("SIGIO EVENT FINISH\n\n");
        return FALSE;
}

static void
sig_handler(int num)
{
	static int is_busy = 0;

	if(is_busy||(num != SIGIO))
		return;

	is_busy = 1;
	get_events();
        is_busy = 0;
}

int main(int argc, char *argv[])
{
char in[1000];

	evfd = open(DEVFILE, O_RDONLY | O_NONBLOCK);
	if (evfd == -1) {
		fprintf(stderr, "Cannot open device file: %s!\n",
			DEVFILE);
		return -1;
	}

	signal(SIGIO, sig_handler);
	fcntl(evfd, F_SETOWN, getpid());
	fcntl(evfd, F_SETFL, fcntl(evfd, F_GETFL) | FASYNC);

	printf("Dumping Touchscreen Data to stdout\n");
	printf("Type \"showall\" to show all the touchscreen data unfiltered\n");
	printf("Type \"cap\" to simulate the start of a CaptureTouch call\n");
	printf("Type \"quit\" to quit\n\n");

	if(show_all)
		printf("SHOW ALL MODE\n\n");
	else
		printf("CAPTURE TOUCH MODE\n\n");

	while(1) {
		scanf("%s", (char *)&in);
		if(!strcmp(in, "cap")) {
			if(show_all)
				printf("CAPTURE TOUCH MODE\n\n");
			show_all = 0;
			printf("CAPTURE START\n\n");
			capture = 1;
		} else if(!strcmp(in, "showall")) {
			if(!show_all)
				printf("SHOW ALL MODE\n\n");
			show_all = 1;
		} else if(!strcmp(in, "quit")) {
			break;
		} 
	}

	return 0;
}
