/* -*- mode: c; style: linux -*- */

/* brightness.h
 *
 * Written by Todd Brandt <todd.e.brandt@intel.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef __BRIGHTNESS_H__
#define __BRIGHTNESS_H__

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gtk/gtkbox.h>
#include <gdk/gdkkeysyms.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n.h>
#include <dbus/dbus-glib.h>

#define MAX_BRIGHTNESS_LEVEL 7
#define MIN_BRIGHTNESS_LEVEL 0

typedef struct _BrightnessControl {
        DBusGProxy *proxy;
        DBusGConnection *connection;
        gchar *udi;
        guint level;
	void (*brightness_changed_cb)(DBusGProxy*, guint, struct _BrightnessControl*);
} BrightnessControl;

int brightness_from_level(int level);
int level_from_brightness(int brightness);
gboolean get_brightness  (BrightnessControl *bc);
gboolean set_brightness  (BrightnessControl *bc);
gboolean brightness_dbus_connect    (BrightnessControl *bc);
gboolean brightness_dbus_disconnect (BrightnessControl *bc);

#endif /* __BRIGHTNESS_H__ */
