/* -*- mode: c; style: linux -*- */

/* keyboard-properties.c
 * Copyright (C) 2000-2001 Ximian, Inc.
 * Copyright (C) 2001 Jonathan Blandford
 *
 * Written by: Bradford Hovinen <hovinen@ximian.com>
 *             Rachel Hestilow <hestilow@ximian.com>
 *	       Jonathan Blandford <jrb@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>
#include <glade/glade.h>
#include <glade/glade-build.h>
#include <moko-finger-scroll.h>
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <stdarg.h>

#include "capplet-util.h"
#include "gconf-property-editor.h"
#include "capplet-stock-icons.h"

#include "keyboard-properties-xkb.h"

enum
{
	RESPONSE_APPLY = 1,
	RESPONSE_CLOSE
};

static GtkWidget *glade_moko_finger_scroll_new (GladeXML *xml, GType type,
                                                GladeWidgetInfo *info)
{
  return moko_finger_scroll_new ();
}

static GladeXML *
create_dialog (void)
{
	GladeXML *dialog;
	GtkSizeGroup *size_group;

	dialog = glade_xml_new (MA_GLADE_DIR "/keyboard-properties.glade", "keyboard_dialog", NULL);

	size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	gtk_size_group_add_widget (size_group, WID ("repeat_slow_label"));
	gtk_size_group_add_widget (size_group, WID ("delay_short_label"));
	gtk_size_group_add_widget (size_group, WID ("blink_slow_label"));
	g_object_unref (G_OBJECT (size_group));

	size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	gtk_size_group_add_widget (size_group, WID ("repeat_fast_label"));
	gtk_size_group_add_widget (size_group, WID ("delay_long_label"));
	gtk_size_group_add_widget (size_group, WID ("blink_fast_label"));
	g_object_unref (G_OBJECT (size_group));

	size_group = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
	gtk_size_group_add_widget (size_group, WID ("repeat_delay_scale"));
	gtk_size_group_add_widget (size_group, WID ("repeat_speed_scale"));
	gtk_size_group_add_widget (size_group, WID ("cursor_blink_time_scale"));
	g_object_unref (G_OBJECT (size_group));

	return dialog;
}

static GConfValue *
blink_from_widget (GConfPropertyEditor *peditor, const GConfValue *value)
{
	GConfValue *new_value;

	new_value = gconf_value_new (GCONF_VALUE_INT);
	gconf_value_set_int (new_value, 2600 - gconf_value_get_int (value));

	return new_value;
}

static GConfValue *
blink_to_widget (GConfPropertyEditor *peditor, const GConfValue *value)
{
	GConfValue *new_value;
	gint current_rate;

	current_rate = gconf_value_get_int (value);
	new_value = gconf_value_new (GCONF_VALUE_INT);
	gconf_value_set_int (new_value, CLAMP (2600 - current_rate, 100, 2500));

	return new_value;
}

static void
dialog_response (GtkWidget *widget,
		 gint       response_id,
		 GConfChangeSet *changeset)
{
	switch (response_id) {
	case GTK_RESPONSE_CLOSE:
	case GTK_RESPONSE_CANCEL:
	case GTK_RESPONSE_DELETE_EVENT:
		gtk_widget_hide(widget);
		gtk_main_quit();
		break;
	}
}

static void
setup_dialog (GladeXML       *dialog,
	      GConfChangeSet *changeset)
{
	GObject *peditor;
	/* load all the images */
	capplet_init_stock_icons ();
	
	peditor = gconf_peditor_new_boolean
		(changeset, "/desktop/gnome/peripherals/keyboard/repeat", WID ("repeat_toggle"), NULL);
	gconf_peditor_widget_set_guard (GCONF_PROPERTY_EDITOR (peditor), WID ("repeat_table"));

	gconf_peditor_new_numeric_range
		(changeset, "/desktop/gnome/peripherals/keyboard/delay", WID ("repeat_delay_scale"),
		 NULL);

	gconf_peditor_new_numeric_range
		(changeset, "/desktop/gnome/peripherals/keyboard/rate", WID ("repeat_speed_scale"),
		 NULL);

	peditor = gconf_peditor_new_boolean
		(changeset, "/desktop/gnome/interface/cursor_blink", WID ("cursor_toggle"), NULL);
	gconf_peditor_widget_set_guard (GCONF_PROPERTY_EDITOR (peditor), WID ("cursor_hbox"));
	gconf_peditor_new_numeric_range
		(changeset, "/desktop/gnome/interface/cursor_blink_time", WID ("cursor_blink_time_scale"),
		 "conv-to-widget-cb", blink_to_widget,
		 "conv-from-widget-cb", blink_from_widget,
		 NULL);

	g_signal_connect (G_OBJECT (WID ("keyboard_dialog")), "response", (GCallback) dialog_response, changeset);
	
        setup_xkb_tabs(dialog,changeset);
}

int main(int argc, char *argv[], char *env[])
{
	static GConfClient *client = NULL;
	static GladeXML *dialog = NULL;

	gtk_init(&argc, &argv);

	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	glade_register_widget (MOKO_TYPE_FINGER_SCROLL,
			       glade_moko_finger_scroll_new,
			       glade_standard_build_children,
			       NULL);

	if(client == NULL)
	{
	  client = gconf_client_get_default ();
	  gconf_client_add_dir (client, "/desktop/gnome/peripherals/keyboard", GCONF_CLIENT_PRELOAD_ONELEVEL, NULL);
	  gconf_client_add_dir (client, "/desktop/gnome/interface", GCONF_CLIENT_PRELOAD_ONELEVEL, NULL);
	}
	if(dialog == NULL)
	{
	  dialog = create_dialog ();
	  setup_dialog (dialog, NULL);
	  capplet_set_icon (WID ("keyboard_dialog"),
	  	"dev-keyboard");
	}
	gtk_widget_show (WID ("keyboard_dialog"));

#if 0
	/* reset all the globals for another run */
	cleanup_xkb_globals();
	cleanup_xkbsk_globals();
	cleanup_xkblt_globals();
	cleanup_xkbmc_globals();
	cleanup_xkbot_globals();

	g_object_unref (dialog);
	g_object_unref (client);
#endif
	gtk_main();
	return 0;
}
