///////////////////////////////////////////////////////////////////////////////
// $Id: editor.h,v 1.5 2004/04/04 19:03:41 krake Exp $
//
// Package:   MOAGG Edit - Level Editor for MOAGG
// Copyright: Kevin Krammer, 2003
//
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
///////////////////////////////////////////////////////////////////////////////

/*! \file    editor.h
    \author  Kevin Krammer, kevin.krammer@gmx.at
    \brief   Declaration of the editor base class
*/

#ifndef EDITOR_H
#define EDITOR_H

// forward declarations
class QString;

class Editor
{
public:
	virtual ~Editor() {};

	virtual bool newDocument() = 0;
	virtual bool openDocument(const QString& filename) = 0;
	virtual bool saveDocument() = 0;
	virtual bool saveDocumentAs(const QString& filename) = 0;

	virtual void selectAll() = 0;
	virtual void resize() = 0;

	virtual void cut() = 0;
	virtual void copy() = 0;
	virtual void paste() = 0;

	virtual QString fileName() const = 0;
	virtual QString fileFilter() const = 0;
	virtual bool isModified() const = 0;

	virtual void showGrid(bool show) = 0;
	virtual bool showsGrid() const = 0;
};

#endif

// End of file
