#ifndef SYSTEMCALLS_H
#define SYSTEMCALLS_H

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

//----------------------------------------------------------------------------
namespace SYSTEM_CALL
{
    //------------------------------------------------------------------------
    /**
     * Calls the system's stat() function.
     * @throw ISyscallException if the call to stat() failed.
     */
    void stat(const char *file, struct stat *buf);

    //------------------------------------------------------------------------
    /**
     * Calls the system's lstat() function.
     * @throw ISyscallException if the call to lstat() failed.
     */
    void lstat(const char *file, struct stat *buf);
}

#endif //SYSTEMCALLS_H
