#ifndef STRINGTOKENIZER_H
#define STRINGTOKENIZER_H

#include <string>

//----------------------------------------------------------------------------
class StringTokenizer
{
  public:
    //------------------------------------------------------------------------
    StringTokenizer(const std::string &str, const std::string &sep);
    ~StringTokenizer();

    //------------------------------------------------------------------------
    inline bool hasMoreTokens() const { return m_numTokens > 0; }
    inline size_t countTokens() const { return m_numTokens; }
    std::string &nextToken(std::string &token);

    inline const std::string &getTokenString() const { return m_string; }

  private:
    //------------------------------------------------------------------------
    std::string m_string;
    std::string m_sep;
    size_t m_numTokens;
};

#endif //STRINGTOKENIZER_H
