<?php
/*
 * $Horde: mnemo/memo.php,v 1.1.2.6 2005/01/03 11:25:59 jan Exp $
 *
 * Copyright 2002-2005 Chuck Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file LICENSE for license information (BSD). If you
 * did not receive this file, see http://www.horde.org/bsdl.php.
 */

define('MNEMO_BASE', dirname(__FILE__));
require_once MNEMO_BASE . '/lib/base.php';

/* Redirect to the memo list if no action has been requested. */
$actionID = Horde::getFormData('actionID');
if (is_null($actionID)) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Memo storage instance. */
require_once MNEMO_BASE . '/lib/Driver.php';
$storage = &Mnemo_driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                  $conf['storage']['params']);
$storage->retrieve();

/* Retrieve the memo list. */
$memos = Mnemo::listMemos($storage);

/* Set default title. */
$title = _("Adding A New Note");

/* Run through the action handlers. */
switch($actionID) {
case MNEMO_ADD_MEMO:

    /* Set up the memo attributes. */
    $memo_id = null;
    $memo_body = '';
    $memo_category = false;

    break;

case MNEMO_MODIFY_MEMO:
    $memo_id = Horde::getFormData('memo');

    if (!is_null($memo_id) && isset($memos[$memo_id])) {
        /* Set up the memo attributes. */
        $memo_body = $memos[$memo_id]['body'];
        $memo_category = $memos[$memo_id]['category'];
        $title = sprintf(_("Modifying %s"), $memos[$memo_id]['desc']);
    } else {
        $title = _("Unknown note");
    }
    break;

case MNEMO_SAVE_MEMO:
    /* Get the form values. */
    $memo_id = Horde::getFormData('memo');
    $memo_body = Horde::getFormData('memo_body');
    $memo_category = Horde::getFormData('memo_category');

    if ($memo_category == '*new*') {
        $new_category = Horde::getFormData('new_category');
        $memo_category = Mnemo::addCategory($new_category);
        if ($memo_category == 0) {
            $notification->push(sprintf(_("Unable to create the category: %s"), $new_category), 'horde.warning');
        }
    }

    /* If $memo_id is set, we're modifying an existing memo.
     * Otherwise, we're adding a new memo with the provided
     * attributes. */
    if (!is_null($memo_id) && isset($memos[$memo_id])) {
        $storage->modifyMemo($memo_id, 'body', $memo_body);
        $storage->modifyMemo($memo_id, 'category', $memo_category);
        $storage->setMemoDescription($memo_id);
    } else {
        $memo_id = $storage->addMemo($memo_body, $memo_category);
    }

    /* Store the changes. */
    $result = $storage->store();

    if (PEAR::isError($result)) {
        $notification->push($result->getMessage(), 'horde.error');
    } else {
        /* Return to the memo list. */
        header('Location: ' . Horde::applicationUrl("view.php?memo=$memo_id", true));
        exit;
    }

    break;

case MNEMO_DELETE_MEMOS:
    /* Delete the memo if we're provided with a valid memo ID to delete. */
    $memo_id = Horde::getFormData('memo');
    if (isset($memo_id) && isset($memos[$memo_id])) {
        if ($storage->deleteMemo($memo_id)) {
            $storage->store();
        }
    }

    /* Return to the memo list. */
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
    break;

default:
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}


require MNEMO_TEMPLATES . '/common-header.inc';
require MNEMO_BASE . '/menu.php';
$notification->notify();
require MNEMO_TEMPLATES . '/memo/begin.inc';
require MNEMO_TEMPLATES . '/memo/memo.inc';
require MNEMO_TEMPLATES . '/memo/end.inc';
require MNEMO_TEMPLATES . '/common-footer.inc';
