<?php
// $Horde: mnemo/lib/base.php,v 1.1 2002/04/22 18:39:27 chuck Exp $
/*
 * Mnemo base inclusion file.
 *
 * This file brings in all of the dependencies that every Mnemo
 * script will need and sets up objects that all scripts use.
 */

// Find the base file path of Horde
@define('HORDE_BASE', dirname(__FILE__) . '/../..');

// Find the base file path of Mnemo
@define('MNEMO_BASE', dirname(__FILE__) . '/..');

// Registry
require_once HORDE_BASE . '/lib/Registry.php';
$registry = &Registry::singleton();
$registry->pushApp('mnemo');
$conf = &$GLOBALS['conf'];
@define('MNEMO_TEMPLATES', $registry->getParam('templates'));

// Set the error reporting level in accordance with the config settings.
error_reporting($conf['debug_level']);

// Set the maximum execution time in accordance with the config settings.
set_time_limit($conf['max_exec_time']);

// set the umask according to config settings
if (isset($conf['umask'])) {
    umask($conf['umask']);
}

// Horde base libraries
require_once HORDE_BASE . '/lib/Horde.php';
require_once HORDE_BASE . '/lib/Auth.php';
require_once HORDE_BASE . '/lib/Text.php';
require_once HORDE_BASE . '/lib/Help.php';

// Mnemo base library
require_once MNEMO_BASE . '/lib/Mnemo.php';

// Browser detection library
require_once HORDE_BASE . '/lib/Browser.php';
$browser = new Browser();

// Notification sytem
require_once HORDE_BASE . '/lib/Notification.php';
$notification = &Notification::singleton();
$notification->attach('status');

// Redirect the user to the Horde login page if they haven't authenticated.
if (!Auth::getAuth()) {
    header('Location: ' . Horde::url($registry->getParam('webroot', 'horde') . '/login.php?url=' . urlencode(Horde::selfUrl()), true));
    exit;
}

?>
