//
// =========================================================================
//
//
//
//  10 September 2001
//
//
// =========================================================================
//

#ifndef  __PCUR_Funcs__
#define  __PCUR_Funcs__


#ifndef  __MMDB_Manager__
#include "mmdb_manager.h"
#endif


#define  END_OF_INPUT              111

#define  Err_RENCHAIN             -100
#define  Err_RENRESIDUE           -101
#define  Err_RENATOM              -102
#define  Err_RENELEMENT           -103
#define  Err_DELMODEL             -104
#define  Err_DELCHAIN             -105
#define  Err_DELRESIDUE           -106
#define  Err_DELATOM              -107
#define  Err_LVMODEL              -108
#define  Err_LVCHAIN              -109
#define  Err_LVRESIDUE            -110
#define  Err_LVATOM               -111
#define  Err_WRITE                -112
#define  Err_WRITE_TYPE           -113
#define  Err_SYMMETRY             -114
#define  Err_SYMMETRY_NOLIB       -115
#define  Err_SYMMETRY_SPGRP       -116
#define  Err_SYMMETRY_NOSYMOP     -117
#define  Err_GEOMETRY             -118
#define  Err_GEOMETRY_FORMAT      -119
#define  Err_GENUNIT_NOSYMOP      -120
#define  Err_GENUNIT_TRANSFORM    -121
#define  Err_GENUNIT_CELL         -122
#define  Err_SYMOP                -123
#define  Err_SYMCOMMIT_NOSYMOP    -124
#define  Err_SYMCOMMIT_TRANSFORM  -125
#define  Err_SYMCOMMIT_CELL       -126
#define  Err_SYMCOMMIT_UNKNOWN    -127
#define  Err_MKCHAINIDS           -128
#define  Err_ROTATE1              -129
#define  Err_ROTATE2              -130
#define  Err_ROTATE3              -131
#define  Err_ROTATE4              -132
#define  Err_VROTATE1             -133
#define  Err_VROTATE2             -134
#define  Err_VROTATE3             -135
#define  Err_VROTATE4             -136
#define  Err_VROTATE5             -137
#define  Err_KEYWORD              -200



// ------------------- input drivers  -------------------------

extern void renchain   ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void renresidue ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void renatom    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void renelement ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void delmodel   ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void delchain   ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void delresidue ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void delatom    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void lvmodel    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void lvchain    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void lvresidue  ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void lvatom     ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void genter     ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void sernum     ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void mvsolvent  ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void write      ( PARSERTOKEN * token, int ntok,
                         int & FType,  int & RC );

extern void symmetry   ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  pstr line, int & RC );

extern void geometry   ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void genunit    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void symop      ( PARSERTOKEN * token, int ntok,
                         RCGenSym   GenSym,   int & RC );

extern void symcommit  ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  RCGenSym GenSym, int & RC );

extern void mkchainids ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void rotate     ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );

extern void vrotate    ( PARSERTOKEN * token, int ntok,
                         RCMMDBManager MMDB,  int & RC );


// -----------------  action functions  -----------------------

extern int renameChain    ( RCMMDBManager MMDB, pstr oldName, pstr newName );
extern int renameResidue  ( RCMMDBManager MMDB, pstr oldName, pstr newName );
extern int renameAtom     ( RCMMDBManager MMDB, pstr oldName, pstr newName );
extern int renameElement  ( RCMMDBManager MMDB, pstr oldName, pstr newName );

extern int deleteModel    ( RCMMDBManager MMDB, pstr selection );
extern int deleteChain    ( RCMMDBManager MMDB, pstr selection );
extern int deleteResidue  ( RCMMDBManager MMDB, pstr selection );
extern int deleteAtom     ( RCMMDBManager MMDB, pstr selection );

extern int leaveModel     ( RCMMDBManager MMDB, pstr selection );
extern int leaveChain     ( RCMMDBManager MMDB, pstr selection );
extern int leaveResidue   ( RCMMDBManager MMDB, pstr selection );
extern int leaveAtom      ( RCMMDBManager MMDB, pstr selection );

extern int EulerRotation  ( RCMMDBManager MMDB, pstr selection,
                            realtype alpha, realtype beta, realtype gamma );
extern int EulerRotation  ( RCMMDBManager MMDB, pstr selection,
                            realtype alpha, realtype beta, realtype gamma,
                            realtype x0,    realtype y0,   realtype z0 );

extern int VectorRotation ( RCMMDBManager MMDB, pstr selection,
                            realtype alpha,
                            realtype vx, realtype vy, realtype vz,
                            realtype x,  realtype y,  realtype z );

extern int VectorRotation ( RCMMDBManager MMDB, pstr selection,
                            realtype alpha,
                            realtype vx, realtype vy, realtype vz );

extern int VectorRotation ( RCMMDBManager MMDB, pstr selection,
                            realtype alpha,
                            pstr atom1, pstr atom2 );

#endif
