//
// =========================================================================
//
//
//  21 September 2001
//
//
// =========================================================================
//

#ifndef  __STDLIB_H
#include <stdlib.h>
#endif

#ifndef  __STRING_H
#include <string.h>
#endif

#define __CPlusPlus

#ifndef  __CCPLib__
#include "ccplib.h"
#endif

#ifndef  __CParser__
#include "cparser.h"
#endif

#ifndef  __PCUR_Funcs__
#include "pcur_funcs.h"
#endif


// ------------------- input drivers  -------------------------

void renchain ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("RENCHAIN",token[0].word))  {
    if (ntok<3) {
      ccperror ( 1,"RENCHAIN: selection statement(s) not found" );
      RC = Err_RENCHAIN;
    } else
      RC = renameChain ( MMDB,token[1].fullstring,token[2].fullstring );
  }
}

void renresidue ( PARSERTOKEN * token, int ntok,
                  RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("RENRESIDUE",token[0].word))  {
    if (ntok<3) {
      ccperror ( 1,"RENRESIDUE: selection statement(s) not found" );
      RC = Err_RENRESIDUE;
    } else
      RC = renameResidue ( MMDB,token[1].fullstring,token[2].fullstring );
  }
}

void renatom ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("RENATOM",token[0].word))  {
    if (ntok<3) {
      ccperror ( 1,"RENATOM: selection statement(s) not found" );
      RC = Err_RENATOM;
    } else
      RC = renameAtom ( MMDB,token[1].fullstring,token[2].fullstring );
  }
}

void renelement ( PARSERTOKEN * token, int ntok,
                  RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("RENELEMENT",token[0].word))  {
    if (ntok<3) {
      ccperror ( 1,"RENELEMENT: selection statement(s) not found" );
      RC = Err_RENELEMENT;
    } else
      RC = renameElement ( MMDB,token[1].fullstring,token[2].fullstring );
  }
}

void delmodel ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("DELMODEL",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"DELMODEL: selection statement(s) not found" );
      RC = Err_DELMODEL;
    } else
      RC = deleteModel ( MMDB,token[1].fullstring );
  }
}

void delchain ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("DELCHAIN",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"DELCHAIN: selection statement(s) not found" );
      RC = Err_DELCHAIN;
    } else
      RC = deleteChain ( MMDB,token[1].fullstring );
  }
}

void delresidue ( PARSERTOKEN * token, int ntok,
                  RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("DELRESIDUE",token[0].word))  {
    if (ntok<2)  {
      ccperror ( 1,"DELRESIDUE: selection statement(s) not found" );
      RC = Err_DELRESIDUE;
    } else
      RC = deleteResidue ( MMDB,token[1].fullstring );
  }
}

void delatom ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("DELATOM",token[0].word))  {
    if (ntok<2)  {
      ccperror ( 1,"DELATOM: selection statement(s) not found" );
      RC = Err_DELATOM;
    } else
      RC = deleteAtom ( MMDB,token[1].fullstring );
  }
}

void lvmodel ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("LVMODEL",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"LVMODEL: selection statement(s) not found" );
      RC = Err_LVMODEL;
    } else
      RC = leaveModel ( MMDB,token[1].fullstring );
  }
}

void lvchain ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("LVCHAIN",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"LVCHAIN: selection statement(s) not found" );
      RC = Err_LVCHAIN;
    } else
      RC = leaveChain ( MMDB,token[1].fullstring );
  }
}

void lvresidue ( PARSERTOKEN * token, int ntok,
                 RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("LVRESIDUE",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"LVRESIDUE: selection statement(s) not found" );
      RC = Err_LVRESIDUE;
    } else
      RC = leaveResidue ( MMDB,token[1].fullstring );
  }
}

void lvatom ( PARSERTOKEN * token, int ntok,
              RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("LVATOM",token[0].word))  {
    if (ntok<2) {
      ccperror ( 1,"LVATOM: selection statement(s) not found" );
      RC = Err_LVATOM;
    } else
      RC = leaveAtom ( MMDB,token[1].fullstring );
  }
}

void genter ( PARSERTOKEN * token, int ntok,
              RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("GENTER",token[0].word))  {
    RC = MMDB.PDBCleanup ( PDBCLEAN_TER );
    if (!RC)
         printf ( "   PDB 'TER' cards have been generated\n" );
    else printf ( " ***** UNKNOWN 'ter' CARD ERROR; REPORT AS A BUG\n" );
  }
}

void sernum ( PARSERTOKEN * token, int ntok,
              RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("SERNUM",token[0].word))  {
    RC = MMDB.PDBCleanup ( PDBCLEAN_SERIAL );
    if (!RC)
         printf ( "   Atom serial numbers have been generated\n" );
    else printf ( " ***** UNKNOWN SERIAL NUMBER ERROR;"
                      " REPORT AS A BUG\n" );
  }
}

void mvsolvent ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("MVSOLVENT",token[0].word))  {
    RC = MMDB.PDBCleanup ( PDBCLEAN_SOLVENT );
    if (!RC)  printf ( "   Solvent chain(s) moved to the "
                       "end of model(s).\n" );
        else  printf ( " ***** UNKNOWN ERROR; REPORT AS A BUG\n" );
  }
}

void write ( PARSERTOKEN * token, int ntok,
             int & FType,  int & RC )  {
  if (keymatch("WRITE",token[0].word))  {
    RC = 0;
    if (ntok<2) {
      ccperror ( 1,"WRITE: Output file type is not found" );
      RC = Err_WRITE;
    } else if (!strcasecmp(token[1].fullstring,"PDB"))  {
      FType = MMDB_FILE_PDB;
      printf ( "   PDB output file type has been set.\n" );
    } else if (!strcasecmp(token[1].fullstring,"CIF"))  {
      FType = MMDB_FILE_CIF;
      printf ( "   mmCIF output file type has been set.\n" );
    } else if (!strcasecmp(token[1].fullstring,"BIN"))  {
      FType = MMDB_FILE_Binary;
      printf ( "   MMDB binary output file type has been set.\n" );
    } else  {
      RC = Err_WRITE_TYPE;
      ccperror ( 1,"Unknown file type" );
    }
  }
}

void symmetry ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  pstr line, int & RC )  {
int  n;
char symGroup[500];
  if (keymatch("SYMMETRY",token[0].word)) {
    RC = 0;
    if (ntok<2) {
      ccperror ( 1,"SYMMETRY requires argument, e.g. P 21 21 21" );
      RC = Err_SYMMETRY;
    } else {
      n = token[ntok-1].iend - token[1].ibeg + 1;
      strcpy_ncss ( symGroup,&line[token[1].ibeg],n );
      symGroup[n] = char(0);
      n = MMDB.SetSpaceGroup ( UpperCase(symGroup) );
      switch (n)  {
        case SYMOP_NoLibFile         : 
                ccperror ( 1,"symop.lib file not found" );
                RC = Err_SYMMETRY_NOLIB;
              break;
        case SYMOP_UnknownSpaceGroup :
                ccperror ( 1,"Unknown space symmetry group" );
                RC = Err_SYMMETRY_SPGRP;
              break;
        case SYMOP_NoSymOps          :
                ccperror ( 1,"no symmetry operations found found" );
                RC = Err_SYMMETRY_NOSYMOP;
              break;
        default : ;
      }
    }
  }
}

void geometry ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  int & RC )  {
int i;
  if (keymatch("GEOMETRY",token[0].word)) {
    RC = 0;
    if (ntok!= 7)  {
      ccperror ( 1,"GEOMETRY requires 6 parameters:"
                   " a b c alpha beta gamma" );
      RC = Err_GEOMETRY;
    } else  {
      i = 1;
      while ((i<ntok) && token[i].isnumber && (token[i].value>0.0)) i++;
      if (i<ntok) {
        printf ( "%ith GEOMETRY parameter is not numerical "
                 "or positive",i );
        RC = Err_GEOMETRY_FORMAT;
      } else
        MMDB.SetCell ( token[1].value,token[2].value,token[3].value,
                       token[4].value,token[5].value,token[6].value,0 );
    }
  }
}

void genunit ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("GENUNIT",token[0].word))  {
    RC = MMDB.GenerateSymMates();
    if (RC==1)  {
      ccperror ( 1,"No symmetry operations defined" );
      RC = Err_GENUNIT_NOSYMOP;
    } else if (RC==2)  {
      ccperror ( 1,"Fractionalization/Orthogonalization is not defined" );
      RC = Err_GENUNIT_TRANSFORM;
    } else if (RC==3)  {
      ccperror ( 1,"No cell parameters were set up" );
      RC = Err_GENUNIT_CELL;
    }
  }
}

void symop ( PARSERTOKEN * token, int ntok,
             RCGenSym   GenSym,   int & RC )  {
int  Nop,i;
char S[500];
  if (keymatch("SYMOP",token[0].word))  {
    RC = 0;
    if (ntok<4)  {
      ccperror ( 1,"SYMOP requires argument -"
                   " the symmetry operation X,Y,Z" );
      RC = Err_SYMOP;
    } else {
      sprintf ( S,"%s,%s,%s",token[1].fullstring,
                             token[2].fullstring,
                             token[3].fullstring );
      GenSym.AddSymOp ( S );
      Nop = GenSym.GetNofSymOps()-1;
      for (i=5;i<ntok;i+=2)
        GenSym.AddRenChain ( Nop,token[i-1].fullstring,
                                 token[i].fullstring );
    }
  }
}

void symcommit ( PARSERTOKEN * token, int ntok,
                RCMMDBManager MMDB,  RCGenSym GenSym, int & RC )  {
  if (keymatch("SYMCOMMIT",token[0].word))  {
    RC = MMDB.GenerateSymMates ( &GenSym );
    switch (RC)  {
      case 0 : printf ( " symmetry operations applied\n" );
             break;
      case 1 : ccperror ( 1,"SYMCOMMIT: No symmetry operations have been "
                            "declared with SYMOP" );
               RC = Err_SYMCOMMIT_NOSYMOP;
             break;
      case 2 : ccperror ( 1,"SYMCOMMIT: Fractionalization/Orthogonalization "
                            "is not defined" );
               RC = Err_SYMCOMMIT_TRANSFORM;
             break;
      case 3 : ccperror ( 1,"SYMCOMMIT: No cell parameters were set up" );
               RC = Err_SYMCOMMIT_CELL;
             break;
      default : ccperror ( 1,"SYMCOMMIT: unknown return\n" );
                RC = Err_SYMCOMMIT_UNKNOWN;
    } 
    GenSym.FreeMemory();
  }
}

void mkchainids ( PARSERTOKEN * token, int ntok,
                  RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("MKCHAINIDS",token[0].word))  {
    RC = MMDB.PDBCleanup ( PDBCLEAN_CHAIN );
    if (RC)  {
      ccperror ( 1,"MKCHAINIDS: too many chain generated" );
      RC = Err_MKCHAINIDS;
    }
  }
}

void rotate ( PARSERTOKEN * token, int ntok,
              RCMMDBManager MMDB,  int & RC )  {
  if (keymatch("ROTATE",token[0].word))  {
    if ((ntok!=8) && (ntok!=6))       RC = Err_ROTATE1;
    else if ((!token[2].isnumber) || (!token[3].isnumber) ||
             (!token[4].isnumber))    RC = Err_ROTATE2;
    else if (ntok==6)  {
      if (!keymatch("CENTER",token[5].word))
            RC = Err_ROTATE3;
      else  RC = EulerRotation ( MMDB,token[1].fullstring,
                                      token[2].value,token[3].value,
                                      token[4].value );
    } else  {
      if ((!token[5].isnumber) || (!token[6].isnumber) ||
          (!token[7].isnumber))
            RC = Err_ROTATE4;
      else  RC = EulerRotation ( MMDB,token[1].fullstring,
                                      token[2].value,token[3].value,
                                      token[4].value,token[5].value,
                                      token[6].value,token[7].value );
    }
    if ((RC>=Err_ROTATE4) && (RC<=Err_ROTATE1))
      ccperror ( 1,"ROTATE requires 5 or 7 parameters:\n"
                   " a) selection alpha beta gamma CENTER\n"
                   " b) selection alpha beta gamma x y z\n"
                   "where alpha, beta and gamma are angles in degrees" );
  }
}


void vrotate ( PARSERTOKEN * token, int ntok,
               RCMMDBManager MMDB,  int & RC )  {
int i;
  if (keymatch("VROTATE",token[0].word))  {
    if ((ntok!=9) && (ntok!=7) && (ntok!=5))  RC = Err_VROTATE1;
    else if (!token[2].isnumber)              RC = Err_VROTATE2;
    else if (ntok==9)  {
      i = 3;
      while ((i<ntok) && token[i].isnumber) i++;
      if (i<ntok)
            RC = Err_VROTATE3;
      else  RC = VectorRotation ( MMDB,token[1].fullstring,
                                       token[2].value,token[3].value,
                                       token[4].value,token[5].value,
                                       token[6].value,token[7].value,
                                       token[8].value );
    } else if (ntok==7)  {
      if ((!token[3].isnumber) || (!token[4].isnumber) ||
          (!token[5].isnumber))
            RC = Err_VROTATE4;
      else if (!keymatch("CENTER",token[6].word))
            RC = Err_VROTATE5;
      else  RC = VectorRotation ( MMDB,token[1].fullstring,
                                       token[2].value,token[3].value,
                                       token[4].value,token[5].value );
    } else
      RC = VectorRotation ( MMDB,token[1].fullstring,
                                 token[2].value,token[3].fullstring,
                                 token[4].fullstring );
    if ((RC>=Err_VROTATE5) && (RC<=Err_VROTATE1))
      ccperror ( 1,"VROTATE requires 4, 6 or 8 parameters:\n"
                   " a) selection alpha atom1 atom2\n"
                   " b) selection alpha vx vy vz CENTER\n"
                   " c) selection alpha vx vy vz x y z\n"
                   "where alpha is the rotation angle in degrees" );
  }
}

// -------------------  renameChain  --------------------------

int  renameChain ( RCMMDBManager MMDB, pstr oldName, pstr newName )  {
int      selHnd,nSelChains,i;
PPCChain selChain;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_CHAIN,oldName,SKEY_OR );
  MMDB.GetSelIndex ( selHnd,selChain,nSelChains );

  if (nSelChains>0)  {
    for (i=0;i<nSelChains;i++)
      selChain[i]->SetChainID ( newName );
    printf ( "    %i chain(s) were assigned the chain ID '%s'\n",
             nSelChains,newName );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO CHAINS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  renameResidue  ------------------------

int  renameResidue ( RCMMDBManager MMDB, pstr oldName, pstr newName )  {
int        selHnd,nSelResidues,i;
PPCResidue selResidue;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_RESIDUE,oldName,SKEY_OR );
  MMDB.GetSelIndex ( selHnd,selResidue,nSelResidues   );

  if (nSelResidues>0)  {
    for (i=0;i<nSelResidues;i++)
      selResidue[i]->SetResName ( newName );
    printf ( "    %i residues were assigned the residue name '%s'\n",
             nSelResidues,newName );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO RESIDUES SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  renameAtom  ------------------------

int  renameAtom ( RCMMDBManager MMDB, pstr oldName, pstr newName )  {
int     selHnd,nSelAtoms,i;
PPCAtom selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,oldName,SKEY_OR );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {
    for (i=0;i<nSelAtoms;i++)
      selAtom[i]->SetAtomName ( newName );
    printf ( "    %i atoms were assigned the atom name '%s'\n",
             nSelAtoms,newName );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  renameElement  ------------------------

int  renameElement ( RCMMDBManager MMDB, pstr oldName, pstr newName )  {
int     selHnd,nSelAtoms,i;
PPCAtom selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,oldName,SKEY_OR );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {
    for (i=0;i<nSelAtoms;i++)
      selAtom[i]->SetElementName ( newName );
    printf ( "    %i atoms were assigned the chemical element name '%s'\n",
             nSelAtoms,selAtom[0]->element );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  deleteModel  --------------------------

int  deleteModel ( RCMMDBManager MMDB, pstr selection )  {
int      selHnd,nSelModels,i;
PPCModel selModel;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_MODEL,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selModel,nSelModels );

  if (nSelModels>0)  {
    for (i=0;i<nSelModels;i++)  {
      delete selModel[i];
      selModel[i] = NULL;
    }
    printf ( "    %i model(s) were deleted.\n",nSelModels );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO MODELS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  deleteChain  --------------------------

int  deleteChain ( RCMMDBManager MMDB, pstr selection )  {
int      selHnd,nSelChains,i;
PPCChain selChain;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_CHAIN,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selChain,nSelChains );

  if (nSelChains>0)  {
    for (i=0;i<nSelChains;i++)  {
      delete selChain[i];
      selChain[i] = NULL;
    }
    printf ( "    %i chain(s) were deleted.\n",nSelChains );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO CHAINS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  deleteResidue  ------------------------

int  deleteResidue ( RCMMDBManager MMDB, pstr selection )  {
int        selHnd,nSelResidues,i;
PPCResidue selResidue;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_RESIDUE,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selResidue,nSelResidues   );

  if (nSelResidues>0)  {
    for (i=0;i<nSelResidues;i++)  {
      delete selResidue[i];
      selResidue[i] = NULL;
    }
    printf ( "    %i residues were deleted.\n",nSelResidues );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO RESIDUES SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  deleteAtom  ------------------------

int  deleteAtom ( RCMMDBManager MMDB, pstr selection )  {
int     selHnd,nSelAtoms,i;
PPCAtom selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {
    for (i=0;i<nSelAtoms;i++)  {
      delete selAtom[i];
      selAtom[i] = NULL;
    }
    printf ( "    %i atoms were deleted.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  leaveModel  --------------------------

int  leaveModel ( RCMMDBManager MMDB, pstr selection )  {
int      selHnd,nSelModels1,nSelModels,i;
PPCModel selModel;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_MODEL,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selModel,nSelModels1 );
  MMDB.Select      ( selHnd,STYPE_MODEL,"/*",SKEY_XOR );
  MMDB.GetSelIndex ( selHnd,selModel,nSelModels );

  if (nSelModels>0)  {
    for (i=0;i<nSelModels;i++)  {
      delete selModel[i];
      selModel[i] = NULL;
    }
    printf ( "    %i model(s) were deleted, %i left.\n",
             nSelModels,nSelModels1 );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO MODELS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  leaveChain  --------------------------

int  leaveChain ( RCMMDBManager MMDB, pstr selection )  {
int      selHnd,nSelChains1,nSelChains,i;
PPCChain selChain;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_CHAIN,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selChain,nSelChains1 );
  MMDB.Select      ( selHnd,STYPE_CHAIN,"/*/*",SKEY_XOR );
  MMDB.GetSelIndex ( selHnd,selChain,nSelChains );

  if (nSelChains>0)  {
    for (i=0;i<nSelChains;i++)  {
      delete selChain[i];
      selChain[i] = NULL;
    }
    printf ( "    %i chain(s) were deleted, %i left.\n",
             nSelChains,nSelChains1 );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO CHAINS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  leaveResidue  ------------------------

int  leaveResidue ( RCMMDBManager MMDB, pstr selection )  {
int        selHnd,nSelResidues,nSelResidues1,i;
PPCResidue selResidue;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_RESIDUE,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selResidue,nSelResidues1 );
  MMDB.Select      ( selHnd,STYPE_RESIDUE,"/*/*/*",SKEY_XOR );
  MMDB.GetSelIndex ( selHnd,selResidue,nSelResidues  );

  if (nSelResidues>0)  {
    for (i=0;i<nSelResidues;i++)  {
      delete selResidue[i];
      selResidue[i] = NULL;
    }
    printf ( "    %i residues were deleted, %i left.\n",
             nSelResidues,nSelResidues1 );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO RESIDUES SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


// -------------------  leaveAtom  ------------------------

int  leaveAtom ( RCMMDBManager MMDB, pstr selection )  {
int     selHnd,nSelAtoms,nSelAtoms1,i;
PPCAtom selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms1 );
  MMDB.Select      ( selHnd,STYPE_ATOM,"/*/*/*/*",SKEY_XOR );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {
    for (i=0;i<nSelAtoms;i++)  {
      delete selAtom[i];
      selAtom[i] = NULL;
    }
    printf ( "    %i atoms were deleted, %i left.\n",
             nSelAtoms,nSelAtoms1 );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}



// -------------------  EulerRotation  --------------------------

int  EulerRotation ( RCMMDBManager MMDB, pstr selection,
                     realtype alpha, realtype beta, realtype gamma )  {
realtype xmc,ymc,zmc, F;
int      selHnd,nSelAtoms;
PPCAtom  selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {

    GetMassCenter ( selAtom,nSelAtoms,xmc,ymc,zmc );
    F = Pi/180.0;
    EulerRotation ( selAtom,nSelAtoms,alpha*F,beta*F,gamma*F,
                    xmc,ymc,zmc );

    printf ( "    %i atom(s) rotated.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}

int  EulerRotation ( RCMMDBManager MMDB, pstr selection,
                     realtype alpha, realtype beta, realtype gamma,
                     realtype x0,    realtype y0,   realtype z0 )  {
realtype F;
int      selHnd,nSelAtoms;
PPCAtom  selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {

    F = Pi/180.0;
    EulerRotation ( selAtom,nSelAtoms,alpha*F,beta*F,gamma*F,
                    x0,y0,z0 );

    printf ( "    %i atom(s) rotated.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}


int  VectorRotation ( RCMMDBManager MMDB, pstr selection, realtype alpha,
                      realtype vx, realtype vy, realtype vz,
                      realtype x,  realtype y,  realtype z )  {
int      selHnd,nSelAtoms;
PPCAtom  selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {

    VectorRotation ( selAtom,nSelAtoms,alpha*Pi/180.0,
                     vx,vy,vz,x,y,z );

    printf ( "    %i atom(s) rotated.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}

int  VectorRotation ( RCMMDBManager MMDB, pstr selection, realtype alpha,
                      realtype vx, realtype vy, realtype vz )  {
realtype xmc,ymc,zmc;
int      selHnd,nSelAtoms;
PPCAtom  selAtom;

  selHnd = MMDB.NewSelection();
  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {

    GetMassCenter  ( selAtom,nSelAtoms,xmc,ymc,zmc );
    VectorRotation ( selAtom,nSelAtoms,alpha*Pi/180.0,
                     vx,vy,vz,xmc,ymc,zmc );

    printf ( "    %i atom(s) rotated.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  }

}

int  VectorRotation ( RCMMDBManager MMDB, pstr selection, realtype alpha,
                      pstr atom1, pstr atom2 )  {
realtype x1,y1,z1, x2,y2,z2;
int      selHnd,nSelAtoms;
PPCAtom  selAtom;

  selHnd = MMDB.NewSelection();

  MMDB.Select      ( selHnd,STYPE_ATOM,atom1,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );
  if (nSelAtoms==0)  {
    printf ( " ***** ATOM '%s' NOT FOUND.\n",atom1 );
    MMDB.DeleteSelection ( selHnd );
    return 1;
  } else if (nSelAtoms>1)  {
    printf ( " ***** '%s' GIVES MORE THAN ONE ATOM.\n",atom1 );
    MMDB.DeleteSelection ( selHnd );
    return 2;
  }
  x1 = selAtom[0]->x;
  y1 = selAtom[0]->y;
  z1 = selAtom[0]->z;

  MMDB.Select      ( selHnd,STYPE_ATOM,atom2,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );
  if (nSelAtoms==0)  {
    printf ( " ***** ATOM '%s' NOT FOUND.\n",atom2 );
    MMDB.DeleteSelection ( selHnd );
    return 3;
  } else if (nSelAtoms>1)  {
    printf ( " ***** '%s' GIVES MORE THAN ONE ATOM.\n",atom2 );
    MMDB.DeleteSelection ( selHnd );
    return 4;
  }
  x2 = selAtom[0]->x;
  y2 = selAtom[0]->y;
  z2 = selAtom[0]->z;

  MMDB.Select      ( selHnd,STYPE_ATOM,selection,SKEY_NEW );
  MMDB.GetSelIndex ( selHnd,selAtom,nSelAtoms );

  if (nSelAtoms>0)  {

    VectorRotation ( selAtom,nSelAtoms,alpha*Pi/180.0,
                     x2-x1,y2-y1,z2-z1,x1,y1,z1 );

    printf ( "    %i atom(s) rotated.\n",nSelAtoms );
    MMDB.DeleteSelection ( selHnd );
    return 0;
  } else  {
    printf ( " ***** NO ATOMS SELECTED.\n" );
    MMDB.DeleteSelection ( selHnd );
    return 5;
  }

}
