# -------------------------------------------------------------------------
#     Copyright (C) 2005-2011 Martin Strohalm <www.mmass.org>

#     This program is free software; you can redistribute it and/or modify
#     it under the terms of the GNU General Public License as published by
#     the Free Software Foundation; either version 3 of the License, or
#     (at your option) any later version.

#     This program is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#     GNU General Public License for more details.

#     Complete text of GNU GPL can be found in the file LICENSE.TXT in the
#     main directory of the program
# -------------------------------------------------------------------------

# load main config
from gui import config

# load libs
import sys
import mspy
import wx

# load modules
from gui import mwx
from gui.main_frame import mainFrame


class mMass(wx.App):
    """Run mMass run..."""
    
    def OnInit(self):
        """Init application."""
        
        # single instance checker
        # self.name = "mMass-%s" % wx.GetUserId()
        # self.instance = wx.SingleInstanceChecker(self.name)
        # if self.instance.IsAnotherRunning():
        #     wx.MessageBox("Another instance is running", "ERROR")
        #     return False
        
        # set some special wx params
        mwx.appInit()
        
        # init frame
        self.frame = mainFrame(None, -1, 'mMass')
        self.SetTopWindow(self.frame)
        try: wx.Yield()
        except: pass
        
        # open file from commandline
        if len(sys.argv) == 2:
            self.frame.onDocumentOpen(path=sys.argv[1])
        
        return True
    # ----
    
    
    def OnExit(self):
        """Exit application."""
        pass
        # delete instance lock file
        # del self.instance
    # ----
    
    
    def MacOpenFile(self, path):
        """"Enable drag/drop under Mac."""
        self.frame.onDocumentOpen(path=path)
    # ----
    
    
    def MacReopenApp(self):
        """Called when the doc icon is clicked."""
        
        try:
            self.GetTopWindow().Raise()
        except:
            pass
    # ----
    
    


if __name__ == '__main__':
    app = mMass(0)
    app.MainLoop()
